<?php

/**
 * Vietnamese language file
 *
 * PHP Version 5.5
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @category  phpMyFAQ
 * @author    Thorsten Rinne <thorsten@phpmyfaq.de>
 * @copyright 2004-2018 phpMyFAQ Team
 * @license   http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link      http://www.phpmyfaq.de
 * @since     2004-06-23
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "vi";
$PMF_LANG["language"] = "Vietnamese";
$PMF_LANG["dir"] = "ltr";
$PMF_LANG["nplurals"] = "1";

// Navigation
$PMF_LANG["msgCategory"] = "Mục";
$PMF_LANG["msgShowAllCategories"] = "Xem tất cả các mục";
$PMF_LANG["msgSearch"] = "Tìm kiếm";
$PMF_LANG["msgAddContent"] = "Thêm một nội dung mới";
$PMF_LANG["msgQuestion"] = "Đặt một câu hỏi";
$PMF_LANG["msgOpenQuestions"] = "Câu hỏi mở";
$PMF_LANG["msgHelp"] = "Trợ giúp";
$PMF_LANG["msgContact"] = "Liên lạc";
$PMF_LANG["msgHome"] = "Trang chủ";
$PMF_LANG["msgNews"] = "Câu hỏi thường gặp-Tin tức";
$PMF_LANG["msgUserOnline"] = " thành viên online";
$PMF_LANG["msgXMLExport"] = "Tập tin XML";
$PMF_LANG["msgBack2Home"] = "trở về trang chủ";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Các mục có nội dung";
$PMF_LANG["msgFullCategoriesIn"] = "Các mục có nội dung trong ";
$PMF_LANG["msgSubCategories"] = "Mục con";
$PMF_LANG["msgEntries"] = "nội dung";
$PMF_LANG["msgEntriesIn"] = "Hỗ trợ trực tuyến - ";
$PMF_LANG["msgViews"] = "xem";
$PMF_LANG["msgPage"] = "Trang ";
$PMF_LANG["msgPages"] = " Trang";
$PMF_LANG["msgPrevious"] = "trước";
$PMF_LANG["msgNext"] = "sau";
$PMF_LANG["msgCategoryUp"] = "mục ở ngay phía trên";
$PMF_LANG["msgLastUpdateArticle"] = "Cập nhật lần cuối: ";
$PMF_LANG["msgAuthor"] = "Tác giả: ";
$PMF_LANG["msgPrinterFriendly"] = "bản in được";
$PMF_LANG["msgPrintArticle"] = "In nội dung này";
$PMF_LANG["msgMakeXMLExport"] = "xuất ra tập tin XML";
$PMF_LANG["msgAverageVote"] = "Điểm trung bình:";
$PMF_LANG["msgVoteUseability"] = "Xin cho điểm nội dung này:";
$PMF_LANG["msgVoteFrom"] = "trên";
$PMF_LANG["msgVoteBad"] = "hoàn toàn vô ích";
$PMF_LANG["msgVoteGood"] = "rất cần thiết";
$PMF_LANG["msgVotings"] = "Bình chọn";
$PMF_LANG["msgVoteSubmit"] = "Bình chọn";
$PMF_LANG["msgVoteThanks"] = "Cảm ơn bạn đã bình chọn!";
$PMF_LANG["msgYouCan"] = "Bạn có thể ";
$PMF_LANG["msgWriteComment"] = "bình luận về bài này";
$PMF_LANG["msgShowCategory"] = "Xem nội dung: ";
$PMF_LANG["msgCommentBy"] = "bình luận bởi ";
$PMF_LANG["msgCommentHeader"] = "Bình luận về bài này ";
$PMF_LANG["msgYourComment"] = "Bình luận của bạn:";
$PMF_LANG["msgCommentThanks"] = "Cảm ơn bạn đã bình luận!";
$PMF_LANG["msgSeeXMLFile"] = "mở tập tin XML ";
$PMF_LANG["msgSend2Friend"] = "Gửi cho một người bạn ";
$PMF_LANG["msgS2FName"] = "Tên của bạn:";
$PMF_LANG["msgS2FEMail"] = "Địa chỉ email của bạn:";
$PMF_LANG["msgS2FFriends"] = "Bạn của bạn:";
$PMF_LANG["msgS2FEMails"] = ". địa chỉ email:";
$PMF_LANG["msgS2FText"] = "Nội dung sau sẽ được gửi đi:";
$PMF_LANG["msgS2FText2"] = "Bạn có thể nghe nội dung tại địa chỉ sau;:";
$PMF_LANG["msgS2FMessage"] = "Lời nhắn gửi kèm cho bạn của bạn:";
$PMF_LANG["msgS2FButton"] = "Gửi";
$PMF_LANG["msgS2FThx"] = "Cảm ơn bạn đã giới thiệu!";
$PMF_LANG["msgS2FMailSubject"] = "Giới thiệu của ";

// Search
$PMF_LANG["msgSearchWord"] = "Tìm kiếm";
$PMF_LANG["msgSearchFind"] = "kết quả tìm kiếm cho ";
$PMF_LANG["msgSearchAmount"] = " kết quả";
$PMF_LANG["msgSearchAmounts"] = " kết quả";
$PMF_LANG["msgSearchCategory"] = "Mục: ";
$PMF_LANG["msgSearchContent"] = "Nội dung: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "Đề nghị một nội dung mới";
$PMF_LANG["msgNewContentAddon"] = "Nội dung bạn đề nghị sẽ được đăng sau khi quản trị viên của chúng tôi đã duyệt. Những thông tin sau là bắt buộc <strong>tên của bạn</strong>, <strong>địa chỉ email của bạn</strong>, <strong>mục</strong>, <strong>chủ đề</strong> và <strong>nội dung bài</strong>. Xin chừa một khoảng cách sau mỗi từ khóa.";
$PMF_LANG["msgNewContentName"] = "Tên của bạn:";
$PMF_LANG["msgNewContentMail"] = "Địa chỉ email của bạn:";
$PMF_LANG["msgNewContentCategory"] = "Yêu cầu của bạn liên quan đến:";
$PMF_LANG["msgNewContentTheme"] = "Câu hỏi:";
$PMF_LANG["msgNewContentArticle"] = "Câu trả lời của bạn:";
$PMF_LANG["msgNewContentKeywords"] = "Từ khóa:";
$PMF_LANG["msgNewContentLink"] = "Đường dẫn đến nội dung này";
$PMF_LANG["msgNewContentSubmit"] = "Gửi";
$PMF_LANG["msgInfo"] = "Thêm thông tin: ";
$PMF_LANG["msgNewContentThanks"] = "Xin cảm ơn gợi ý của bạn!";
$PMF_LANG["msgNoQuestionsAvailable"] = "Hiện tại không có câu hỏi mới.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Trong trang này, bạn có thể nêu lên các câu hỏi của bạn.";
$PMF_LANG["msgAskCategory"] = "Yêu cầu của bạn liên quan đến:";
$PMF_LANG["msgAskYourQuestion"] = "Câu hỏi của bạn:";
$PMF_LANG["msgAskThx4Mail"] = "<h2>Xin cảm ơn câu hỏi của bạn!</h2>";
$PMF_LANG["msgDate_User"] = "Ngày / Thành viên";
$PMF_LANG["msgQuestion2"] = "Câu hỏi";
$PMF_LANG["msg2answer"] = "trả lời";
$PMF_LANG["msgQuestionText"] = "Tại đây, bạn có thể xem những câu hỏi do những thành viên khác nêu ra. Bạn có thể đề nghị một câu trả lời, câu trả lời của bạn có thể được sử dụng làm lời giải đáp trong phần Các câu hỏi thường gặp.";

// Help
$PMF_LANG["msgHelpText"] = "Cấu trúc của phần 'Các câu hỏi thường gặp' khá đơn giản. Bạn có thể tìm kiếm <strong><a href=\"?action=show\">thông qua các mục</a></strong> hay để cho <strong><a href=\"?action=search\">hệ thống</a></strong> tìm thông qua từ khóa.";

// Contact
$PMF_LANG["msgContactEMail"] = "Gửi email cho bộ phận hỗ trợ kỹ thuật của chúng tôi:";
$PMF_LANG["msgMessage"] = "Nội dung email:";

// Startseite
$PMF_LANG["msgNews"] = " Nội dung mới";
$PMF_LANG["msgTopTen"] = "Những câu hỏi phổ biến:";
$PMF_LANG["msgHomeThereAre"] = "Có ";
$PMF_LANG["msgHomeArticlesOnline"] = " những nội dung hiện có trực tuyến";
$PMF_LANG["msgNoNews"] = "Không có nội dung mới.";
$PMF_LANG["msgLatestArticles"] = "Năm nội dung mới nhất:";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "Cảm ơn đề nghị của bạn cho phần 'Các câu hỏi thường gặp'.";
$PMF_LANG["msgMailCheck"] = "Có một nội dung mới trong phần 'Các câu hỏi thường gặp'!Vui lòng kiểm tra bên quản trị!";
$PMF_LANG["msgMailContact"] = "Yêu cầu của bạn đã được chuyển cho bộ phận hỗ trợ kỹ thuật của chúng tôi!";
$PMF_LANG["msgMailContactBack"] = "Trở về trang chủ";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Không thiết lập được kết nối với cơ sở dữ liệu!";
$PMF_LANG["err_noHeaders"] = "Không tìm thấy mục này!";
$PMF_LANG["err_noArticles"] = "Không có kết quả nào.";
$PMF_LANG["err_badID"] = "Tên đăng nhập sai!";
$PMF_LANG["err_noTopTen"] = "Hiện không có TOP 10.";
$PMF_LANG["err_nothingFound"] = "Nội dung không tìm thấy.";
$PMF_LANG["err_SaveEntries"] = "Những nội dung sau là bắt buộc <strong>tên của bạn</strong>, <strong>email của bạn</strong>, <strong>mục</strong>, <strong>tựa đề</strong>, <strong>nội dung</strong> và, khi được yêu cầu, <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Xem thêm về Captcha trên Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!<br /><br /><a href=\"javascript:history.back();\">trở về trang trước</a><br /><br />";
$PMF_LANG["err_SaveComment"] = "Những nội dung sau là bắt buộc <strong>tên của bạn</strong>, <strong>email của bạn</strong>, <strong>bình luận của bạn</strong> và, khi được yêu cầu, <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Xem thêm về Captcha trên Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!<br /><br /><a href=\"javascript:history.back();\">trở về trang trước</a><br /><br />";
$PMF_LANG["err_VoteTooMuch"] = "Chúng tôi không tính trường hợp bình chọn hai lần.";
$PMF_LANG["err_noVote"] = "<strong>Bạn chưa bình chọn câu hỏi!</strong> <a href=\"javascript:history.back();\">Vui lòng nhấp vào đây</a>, để bình chọn.";
$PMF_LANG["err_noMailAdress"] = "Địa chỉ email của bạn không chính xác.<br /><a href=\"javascript:history.back();\">trở về</a>";
$PMF_LANG["err_sendMail"] = "Những nội dung sau là bắt buộc <strong>tên của bạn</strong>, <strong>email của bạn</strong>, <strong>câu hỏi của bạn</strong> và, khi được yêu cầu, <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Xem thêm về Captcha trên Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!<br /><br /><a href=\"javascript:history.back();\">trở về trang trước</a><br /><br />";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>Tìm kiếm cho nội dung:</strong><br />Với một nội dung như <strong style=\"color: Red;\">từ1 từ2</strong> bạn có thể tìm kiếm với độ chính xác giảm dần cho hai hoặc nhiều tiêu chí tìm kiếm.<strong>Chú ý:</strong> Tiêu chí tìm kiếm của bạn phải gồm ít nhất 4 chữ cái, nếu không yêu cầu của bạn sẽ bị từ chối.";

// Men�
$PMF_LANG["ad"] = "QUẢN TRỊ";
$PMF_LANG["ad_menu_user_administration"] = "Quản trị thành viên";
$PMF_LANG["ad_menu_entry_aprove"] = "Thông qua nội dung";
$PMF_LANG["ad_menu_entry_edit"] = "Chỉnh sửa nội dung";
$PMF_LANG["ad_menu_categ_add"] = "Thêm một mục mới";
$PMF_LANG["ad_menu_categ_edit"] = "Chỉnh sửa mục";
$PMF_LANG["ad_menu_news_add"] = "Thêm một nội dung mới";
$PMF_LANG["ad_menu_news_edit"] = "Chỉnh sửa nội dung mới";
$PMF_LANG["ad_menu_open"] = "Chỉnh sửa những câu hỏi mở";
$PMF_LANG["ad_menu_stat"] = "Thống kê";
$PMF_LANG["ad_menu_cookie"] = "Cookies";
$PMF_LANG["ad_menu_session"] = "Xem các phần";
$PMF_LANG["ad_menu_adminlog"] = "Xem Adminlog";
$PMF_LANG["ad_menu_passwd"] = "Đổi mật khẩu";
$PMF_LANG["ad_menu_logout"] = "Thoát";
$PMF_LANG["ad_menu_startpage"] = "Trang đầu";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Vui lòng đăng nhập.";
$PMF_LANG["ad_msg_passmatch"] = "Hai mật khẩu phải <strong>trùng khớp</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "Thông tin của";
$PMF_LANG["ad_msg_savedsuc_2"] = "đã được lưu.";
$PMF_LANG["ad_msg_mysqlerr"] = "Do lỗi <strong>cơ sở dữ liệu</strong> thông tin đã không được lưu.";
$PMF_LANG["ad_msg_noauth"] = "Bạn không có quyền thực hiện lệnh này.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Trang";
$PMF_LANG["ad_gen_of"] = "của";
$PMF_LANG["ad_gen_lastpage"] = "Trang trước";
$PMF_LANG["ad_gen_nextpage"] = "Trang sau";
$PMF_LANG["ad_gen_save"] = "Lưu";
$PMF_LANG["ad_gen_reset"] = "Thiết lập lại";
$PMF_LANG["ad_gen_yes"] = "Yes";
$PMF_LANG["ad_gen_no"] = "No";
$PMF_LANG["ad_gen_top"] = "Đầu trang";
$PMF_LANG["ad_gen_ncf"] = "Mục không tìm thấy!";
$PMF_LANG["ad_gen_delete"] = "Xóa";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Quản trị thành viên";
$PMF_LANG["ad_user_username"] = "Thành viên đăng ký";
$PMF_LANG["ad_user_rights"] = "Quyền của thành viên";
$PMF_LANG["ad_user_edit"] = "chỉnh sửa";
$PMF_LANG["ad_user_delete"] = "xóa";
$PMF_LANG["ad_user_add"] = "Thêm thành viên";
$PMF_LANG["ad_user_profou"] = "Thông tin về thành viên";
$PMF_LANG["ad_user_name"] = "Tên";
$PMF_LANG["ad_user_password"] = "Mật khẩu";
$PMF_LANG["ad_user_confirm"] = "Xác nhận";
$PMF_LANG["ad_user_rights"] = "Quyền";
$PMF_LANG["ad_user_del_1"] = "Thành viên";
$PMF_LANG["ad_user_del_2"] = "cần xóa?";
$PMF_LANG["ad_user_del_3"] = "Bạn có chắc không?";
$PMF_LANG["ad_user_deleted"] = "Thành viên đã được xóa.";
$PMF_LANG["ad_user_checkall"] = "Chọn tất cả";

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = "Quản trị nội dung";
$PMF_LANG["ad_entry_id"] = "Tên đăng nhập";
$PMF_LANG["ad_entry_topic"] = "Tiêu đề";
$PMF_LANG["ad_entry_action"] = "Hành động";
$PMF_LANG["ad_entry_edit_1"] = "Chỉnh sửa nội dung";
$PMF_LANG["ad_entry_edit_2"] = "Chỉnh sửa nội dung";
$PMF_LANG["ad_entry_theme"] = "Câu hỏi:";
$PMF_LANG["ad_entry_content"] = "Câu trả lời:";
$PMF_LANG["ad_entry_keywords"] = "Từ khóa:";
$PMF_LANG["ad_entry_author"] = "Tác giả:";
$PMF_LANG["ad_entry_category"] = "Mục:";
$PMF_LANG["ad_entry_active"] = "Kích hoạt?";
$PMF_LANG["ad_entry_date"] = "Ngày:";
$PMF_LANG["ad_entry_changed"] = "Bạn đã thay đổi những gì?";
$PMF_LANG["ad_entry_changelog"] = "Changelog:";
$PMF_LANG["ad_entry_commentby"] = "Bình luận bởi";
$PMF_LANG["ad_entry_comment"] = "Bình luận:";
$PMF_LANG["ad_entry_save"] = "Lưu";
$PMF_LANG["ad_entry_delete"] = "Xóa";
$PMF_LANG["ad_entry_delcom_1"] = "Bạn có chắc là bình luận này";
$PMF_LANG["ad_entry_delcom_2"] = "cần xóa?";
$PMF_LANG["ad_entry_commentdelsuc"] = "Bình luận <strong>đã được</strong> xóa.";
$PMF_LANG["ad_entry_back"] = "Trở lại nội dung bài";
$PMF_LANG["ad_entry_commentdelfail"] = "Bình luận <strong>chưa được</strong> xóa.";
$PMF_LANG["ad_entry_savedsuc"] = "Các thay đổi đã được lưu.";
$PMF_LANG["ad_entry_savedfail"] = "Có lỗi <strong>cơ sở dữ liệu</strong> xảy ra.";
$PMF_LANG["ad_entry_del_1"] = "Bạn có chắc rằng bài";
$PMF_LANG["ad_entry_del_2"] = "của ";
$PMF_LANG["ad_entry_del_3"] = "cần xóa?";
$PMF_LANG["ad_entry_delsuc"] = "Bài <strong>đã được</strong> xóa.";
$PMF_LANG["ad_entry_delfail"] = "Bài <strong>chưa được</strong> xóa!";
$PMF_LANG["ad_entry_back"] = "trở về";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Tiêu đề của Bài";
$PMF_LANG["ad_news_text"] = "Nội dung";
$PMF_LANG["ad_news_link_url"] = "Đường dẫn: (<strong>không để http://</strong>)!";
$PMF_LANG["ad_news_link_title"] = "Tên đường dẫn:";
$PMF_LANG["ad_news_link_target"] = "Đích của đường dẫn";
$PMF_LANG["ad_news_link_window"] = "Đường dẫn mở ra cửa sổ mới";
$PMF_LANG["ad_news_link_faq"] = "Đường dẫn ngoài phần 'Các câu hỏi thường gặp'";
$PMF_LANG["ad_news_add"] = "Thêm nội dung mới";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Tiêu đề";
$PMF_LANG["ad_news_date"] = "Ngày";
$PMF_LANG["ad_news_action"] = "Hành động";
$PMF_LANG["ad_news_update"] = "chỉnh sửa";
$PMF_LANG["ad_news_delete"] = "xóa";
$PMF_LANG["ad_news_nodata"] = "Dữ liệu không tìm thấy";
$PMF_LANG["ad_news_updatesuc"] = "Nội dung mới đã được lưu.";
$PMF_LANG["ad_news_del"] = "Bạn có chắc muốn xóa nội dung mới này?";
$PMF_LANG["ad_news_yesdelete"] = "đúng, xóa!";
$PMF_LANG["ad_news_nodelete"] = "không!";
$PMF_LANG["ad_news_delsuc"] = "Nội dung đã được xóa.";
$PMF_LANG["ad_news_updatenews"] = "Chỉnh sửa nội dung";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Thêm một mục mới";
$PMF_LANG["ad_categ_catnum"] = "Mục số:";
$PMF_LANG["ad_categ_subcatnum"] = "Tiểu mục số:";
$PMF_LANG["ad_categ_nya"] = "<em>chưa có!</em>";
$PMF_LANG["ad_categ_titel"] = "Tên của mục:";
$PMF_LANG["ad_categ_add"] = "Thêm mục";
$PMF_LANG["ad_categ_existing"] = "Những mục hiện có";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Mục";
$PMF_LANG["ad_categ_subcateg"] = "Tiểu mục";
$PMF_LANG["ad_categ_titel"] = "Tên của mục";
$PMF_LANG["ad_categ_action"] = "Hành động";
$PMF_LANG["ad_categ_update"] = "chỉnh sửa";
$PMF_LANG["ad_categ_delete"] = "xóa";
$PMF_LANG["ad_categ_updatecateg"] = "Chỉnh sửa mục";
$PMF_LANG["ad_categ_nodata"] = "Không tìm thấy";
$PMF_LANG["ad_categ_remark"] = "Chú ý, nếu bạn xóa mục này, các bài hiện có sẽ không xuất hiện nữa. Bạn cần tạo một mục mới cho các bài này, hoặc xóa chúng.";
$PMF_LANG["ad_categ_edit_1"] = "Chỉnh sửa";
$PMF_LANG["ad_categ_edit_2"] = "Mục";
$PMF_LANG["ad_categ_add"] = "Thêm một mục";
$PMF_LANG["ad_categ_added"] = "Mục đã được thêm.";
$PMF_LANG["ad_categ_updated"] = "Mục đã được chỉnh sửa.";
$PMF_LANG["ad_categ_del_yes"] = "đúng, xóa!";
$PMF_LANG["ad_categ_del_no"] = "không!";
$PMF_LANG["ad_categ_deletesure"] = "Bạn có chắc muốn xóa mục này?";
$PMF_LANG["ad_categ_deleted"] = "Mục đã được xóa.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "Cookie đã được viết <strong>thành công</strong>.";
$PMF_LANG["ad_cookie_already"] = "Hiện đã có một cookie. Bạn có các khả năng sau đây:";
$PMF_LANG["ad_cookie_again"] = "Sử dụng cookie này";
$PMF_LANG["ad_cookie_delete"] = "xóa cookie này";
$PMF_LANG["ad_cookie_no"] = "Không có cookie lưu. Với một cookie, bạn có thể lưu lại thông tin đăng nhập, và không cần phải đánh lại mật khẩu. Bạn có những khả năng sau:";
$PMF_LANG["ad_cookie_set"] = "Cài một cookie";
$PMF_LANG["ad_cookie_deleted"] = "Cookie đã bị xóa.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "AdminLog";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Thay đổi mật khẩu";
$PMF_LANG["ad_passwd_old"] = "Mật khẩu cũ:";
$PMF_LANG["ad_passwd_new"] = "Mật khẩu mới:";
$PMF_LANG["ad_passwd_con"] = "Xác nhận:";
$PMF_LANG["ad_passwd_change"] = "Thay đổi mật khẩu";
$PMF_LANG["ad_passwd_suc"] = "Mật khẩu đã được thay đổi.";
$PMF_LANG["ad_passwd_remark"] = "<strong>Chú ý:</strong><br />Cookie đã được thay thế!";
$PMF_LANG["ad_passwd_fail"] = "Mật khẩu cũ <strong>cần được</strong> nhập chính xác và hai mật khẩu mới cần phải <strong>trùng khớp</strong>.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Thêm thành viên";
$PMF_LANG["ad_adus_name"] = "Tên:";
$PMF_LANG["ad_adus_password"] = "Mật khẩu:";
$PMF_LANG["ad_adus_add"] = "Thêm thành viên";
$PMF_LANG["ad_adus_suc"] = "Thành viên <strong>đã được thêm</strong>.";
$PMF_LANG["ad_adus_edit"] = "Chỉnh sửa thông tin thành viên";
$PMF_LANG["ad_adus_dberr"] = "<strong>lỗi cơ sở dữ liệu</strong>";
$PMF_LANG["ad_adus_exerr"] = "Tên thành viên <strong>đã được đăng ký</strong>.";

// Sessions
$PMF_LANG["ad_sess_id"] = "Tên đăng nhập";
$PMF_LANG["ad_sess_sid"] = "Session ID";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Thời gian";
$PMF_LANG["ad_sess_pageviews"] = "Số trang xem";
$PMF_LANG["ad_sess_search"] = "Tìm kiếm";
$PMF_LANG["ad_sess_sfs"] = "Tìm kiếm session";
$PMF_LANG["ad_sess_s_ip"] = "IP:";
$PMF_LANG["ad_sess_s_minct"] = "Actions min.:";
$PMF_LANG["ad_sess_s_date"] = "Ngày";
$PMF_LANG["ad_sess_s_after"] = "sau";
$PMF_LANG["ad_sess_s_before"] = "trước";
$PMF_LANG["ad_sess_s_search"] = "Tìm kiếm";
$PMF_LANG["ad_sess_session"] = "Session";
$PMF_LANG["ad_sess_r"] = "Tìm kiếm kết quả cho";
$PMF_LANG["ad_sess_referer"] = "Tham chiếu:";
$PMF_LANG["ad_sess_browser"] = "Trình duyệt:";
$PMF_LANG["ad_sess_ai_rubrik"] = "Mục:";
$PMF_LANG["ad_sess_ai_artikel"] = "Bài:";
$PMF_LANG["ad_sess_ai_sb"] = "Từ khóa:";
$PMF_LANG["ad_sess_ai_sid"] = "Session ID:";
$PMF_LANG["ad_sess_back"] = "Trở về";

// Statistik
$PMF_LANG["ad_rs"] = "Thống kê";
$PMF_LANG["ad_rs_rating_1"] = "Xếp hạng của ";
$PMF_LANG["ad_rs_rating_2"] = "Thành viên nói:";
$PMF_LANG["ad_rs_red"] = "Đỏ";
$PMF_LANG["ad_rs_green"] = "Xanh";
$PMF_LANG["ad_rs_altt"] = "với trung bình nhỏ hơn 20%";
$PMF_LANG["ad_rs_ahtf"] = "với trung bình lớn hơn 80%";
$PMF_LANG["ad_rs_no"] = "Hiện tại chưa có xếp hạng";

// Auth
$PMF_LANG["ad_auth_insert"] = "Xin vui lòng nhập tên đăng nhập và mật khẩu.";
$PMF_LANG["ad_auth_user"] = "Thành viên:";
$PMF_LANG["ad_auth_passwd"] = "Mật khẩu:";
$PMF_LANG["ad_auth_ok"] = "OK";
$PMF_LANG["ad_auth_reset"] = "Thiết lập lại";
$PMF_LANG["ad_auth_fail"] = "Không tìm thấy kết quả.";
$PMF_LANG["ad_auth_sess"] = "Session ID đã bị quá hạn.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Chỉnh sửa cấu hình";
$PMF_LANG["ad_config_save"] = "Lưu cấu hình";
$PMF_LANG["ad_config_reset"] = "Thiết lập lại";
$PMF_LANG["ad_config_saved"] = "Cấu hình đã được lưu.";
$PMF_LANG["ad_menu_editconfig"] = "Chỉnh sửa cấu hình";
$PMF_LANG["ad_att_none"] = "Không có tập tin đính kèm";
$PMF_LANG["ad_att_att"] = "Tập tin đính kèm:";
$PMF_LANG["ad_att_add"] = "Đính kèm một tập tin";
$PMF_LANG["ad_entryins_suc"] = "Bài đã được lưu.";
$PMF_LANG["ad_entryins_fail"] = "Có lỗi xảy ra.";
$PMF_LANG["ad_att_del"] = "Xóa";
$PMF_LANG["ad_att_nope"] = "Chỉ có thể thêm tập tin đính kèm khi chỉnh sửa.";
$PMF_LANG["ad_att_delsuc"] = "Tập tin đính kèm đã được xóa.";
$PMF_LANG["ad_att_delfail"] = "Có lỗi xảy ra.";
$PMF_LANG["ad_entry_add"] = "Tạo bài";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "Bản lưu hay backup là một hình ảnh trọn vẹn của cơ sở dữ liệu.";
$PMF_LANG["ad_csv_link"] = "Tải bản lưu";
$PMF_LANG["ad_csv_head"] = "Thực hiện lưu một bản lưu";
$PMF_LANG["ad_att_addto"] = "Đính kèm một tập tin vào bài";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Tập tin:";
$PMF_LANG["ad_att_butt"] = "OK";
$PMF_LANG["ad_att_suc"] = "Tập tin đã được đính kèm.";
$PMF_LANG["ad_att_fail"] = "Có lỗi xảy ra.";
$PMF_LANG["ad_att_close"] = "Đóng cửa sổ";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "Với phiếu này, bạn có thể tái tạo lại nội dung của cơ sở dữ liệu, được lưu với phpmyfaq. Xin chú ý cơ sở dữ liệu hiện nay sẽ bị xóa.";
$PMF_LANG["ad_csv_file"] = "Tập tin";
$PMF_LANG["ad_csv_ok"] = "OK";
$PMF_LANG["ad_csv_linklog"] = "backup LOGs";
$PMF_LANG["ad_csv_linkdat"] = "backup data";
$PMF_LANG["ad_csv_head2"] = "Tái tạo";
$PMF_LANG["ad_csv_no"] = "Đây không có vẻ là một bản lưu phpmyfaq.";
$PMF_LANG["ad_csv_prepare"] = "Chuẩn bị cơ sở dữ liệu...";
$PMF_LANG["ad_csv_process"] = "gửi yêu cầu...";
$PMF_LANG["ad_csv_of"] = "của";
$PMF_LANG["ad_csv_suc"] = "đã thực hiện.";
$PMF_LANG["ad_csv_backup"] = "Bản lưu";
$PMF_LANG["ad_csv_rest"] = "Tái tạo bản lưu";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Bản lưu";
$PMF_LANG["ad_logout"] = "Session đã thực hiện thành công.";
$PMF_LANG["ad_news_add"] = "Thêm nội dung mới";
$PMF_LANG["ad_news_edit"] = "Chỉnh sửa nội dung mới";
$PMF_LANG["ad_cookie"] = "Cookie";
$PMF_LANG["ad_sess_head"] = "Xem các session";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = "Quản trị mục";
$PMF_LANG["ad_menu_stat"] = "Thống kê";
$PMF_LANG["ad_kateg_add"] = "Thêm mục";
$PMF_LANG["ad_kateg_rename"] = "Đổi tên";
$PMF_LANG["ad_adminlog_date"] = "Ngày";
$PMF_LANG["ad_adminlog_user"] = "Thành viên";
$PMF_LANG["ad_adminlog_ip"] = "Địa chỉ IP";
$PMF_LANG["ad_stat_sess"] = "Session";
$PMF_LANG["ad_stat_days"] = "Ngày";
$PMF_LANG["ad_stat_vis"] = "Session (Lượt thăm)";
$PMF_LANG["ad_stat_vpd"] = "Lượt thăm mỗi ngày";
$PMF_LANG["ad_stat_fien"] = "Log đầu tiên";
$PMF_LANG["ad_stat_laen"] = "Log cuối cùng";
$PMF_LANG["ad_stat_browse"] = "trình tự các Session";
$PMF_LANG["ad_stat_ok"] = "OK";
$PMF_LANG["ad_sess_time"] = "Thời gian";
$PMF_LANG["ad_sess_sid"] = "Session-Tên đăng nhập";
$PMF_LANG["ad_sess_ip"] = "Địa chỉ IP";
$PMF_LANG["ad_ques_take"] = "Chỉnh sửa";
$PMF_LANG["no_cats"] = "Mục không tìm thấy!";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Thành viên hoặc mật khẩu không hợp lệ.";
$PMF_LANG["ad_log_sess"] = "Session hết hạn.";
$PMF_LANG["ad_log_edit"] = "Bảng \"Chỉnh sửa thành viên\" đã được gọi: ";
$PMF_LANG["ad_log_crea"] = "Bảng \"Bài mới\" đã được gọi.";
$PMF_LANG["ad_log_crsa"] = "Có một nội dung mới được đăng.";
$PMF_LANG["ad_log_ussa"] = "Những thông tin của thành viên sau đã được thay đổi: ";
$PMF_LANG["ad_log_usde"] = "Thành viên sau đã bị xóa: ";
$PMF_LANG["ad_log_beed"] = "Bảng chỉnh sửa đã được thay đổi: ";
$PMF_LANG["ad_log_bede"] = "Bài sau đã bị xóa: ";
$PMF_LANG["ad_start_visits"] = "Lượt thăm";
$PMF_LANG["ad_start_articles"] = "Bài";
$PMF_LANG["ad_start_comments"] = "Bình luận";

// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "dán";
$PMF_LANG["ad_categ_cut"] = "cắt";
$PMF_LANG["ad_categ_copy"] = "chép";
$PMF_LANG["ad_categ_process"] = "Đang tiến hành với mục...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Bạn không được phép thực hiện điều này.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "trang trước";
$PMF_LANG["msgNextPage"] = "trang sau";
$PMF_LANG["msgPageDoublePoint"] = "Trang: ";
$PMF_LANG["msgMainCategory"] = "Mục";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Mật khẩu của bạn đã được thay đổi!";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "Cho xem dưới định dạng PDF";
$PMF_LANG["ad_xml_head"] = "XML-Backup";
$PMF_LANG["ad_xml_hint"] = "Lưu toàn bộ nội dung của phần Câu hỏi thường gặp trong một tập tin XML.";
$PMF_LANG["ad_xml_gen"] = "tạo tập tin XML";
$PMF_LANG["ad_entry_locale"] = "Ngôn ngữ";
$PMF_LANG["msgLanguageSubmit"] = "Thay đổi ngôn ngữ";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Xem trước";
$PMF_LANG["ad_attach_1"] = "Trước hết, vui lòng chọn một thư mục cho các tài liệu đính kèm trong định dạng.";
$PMF_LANG["ad_attach_2"] = "Trước hết, vui lòng chọn một thư mục cho đường dẫn trong định dạng.";
$PMF_LANG["ad_attach_3"] = "Tập tin attachment.php không thể mở nếu bạn chưa đăng nhập.";
$PMF_LANG["ad_attach_4"] = "Tài liệu đính kèm phải nhỏ hơn %s Bytes.";
$PMF_LANG["ad_menu_export"] = "Xuất nội dung Câu hỏi thường gặp";
$PMF_LANG["ad_export_1"] = "Tạo RSS-Feed kích hoạt";
$PMF_LANG["ad_export_2"] = ".";
$PMF_LANG["ad_export_file"] = "Lỗi: Không thể viết tập tin.";
$PMF_LANG["ad_export_news"] = "News RSS-Feed";
$PMF_LANG["ad_export_topten"] = "Top 10 RSS-Feed";
$PMF_LANG["ad_export_latest"] = "5 nội dung lưu RSS-Feed gần nhất";
$PMF_LANG["ad_export_pdf"] = "PDF-Xuất tất cả các nội dung";
$PMF_LANG["ad_export_generate"] = "Tạo RSS-Feed";
$PMF_LANG["rightsLanguage"]['adduser'] = "thêm thành viên";
$PMF_LANG["rightsLanguage"]['edituser'] = "chỉnh sửa thành viên";
$PMF_LANG["rightsLanguage"]['deluser'] = "xóa thành viên";
$PMF_LANG["rightsLanguage"]['addbt'] = "thêm nội dung";
$PMF_LANG["rightsLanguage"]['editbt'] = "chỉnh sửa nội dung";
$PMF_LANG["rightsLanguage"]['delbt'] = "xóa nội dung";
$PMF_LANG["rightsLanguage"]['viewlog'] = "xem log";
$PMF_LANG["rightsLanguage"]['adminlog'] = "xem admin log";
$PMF_LANG["rightsLanguage"]['delcomment'] = "xóa bình luận";
$PMF_LANG["rightsLanguage"]['addnews'] = "thêm nội dung mới";
$PMF_LANG["rightsLanguage"]['editnews'] = "chỉnh sửa nội dung mới";
$PMF_LANG["rightsLanguage"]['delnews'] = "xóa nội dung mới";
$PMF_LANG["rightsLanguage"]['addcateg'] = "thêm mục";
$PMF_LANG["rightsLanguage"]['editcateg'] = "chỉnh sửa mục";
$PMF_LANG["rightsLanguage"]['delcateg'] = "xóa mục";
$PMF_LANG["rightsLanguage"]['passwd'] = "thay đổi mật khẩu";
$PMF_LANG["rightsLanguage"]['editconfig'] = "chỉnh sửa cấu hình";
$PMF_LANG["rightsLanguage"]['addatt'] = "thêm tài liệu đính kèm";
$PMF_LANG["rightsLanguage"]['delatt'] = "xóa tài liệu đính kèm";
$PMF_LANG["rightsLanguage"]['backup'] = "tạo bản lưu";
$PMF_LANG["rightsLanguage"]['restore'] = "tái tạo bản lưu";
$PMF_LANG["rightsLanguage"]['delquestion'] = "xóa toàn bộ các câu hỏi mở";
$PMF_LANG["rightsLanguage"]['changebtrevs'] = "chỉnh sửa các thay đổi";
$PMF_LANG["msgAttachedFiles"] = "tài liệu đính kèm:";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "hành động";
$PMF_LANG["ad_entry_email"] = "địa chỉ email:";
$PMF_LANG["ad_entry_allowComments"] = "cho phép các bình luận";
$PMF_LANG["msgWriteNoComment"] = "Bạn không thể bình luận nội dung này";
$PMF_LANG["ad_user_realname"] = "Tên thực:";
$PMF_LANG["ad_export_generate_pdf"] = "tạo một tập tin PDF";
$PMF_LANG["ad_export_full_faq"] = "Nội dung Câu hỏi thường gặp dưới dạng PDF: ";
$PMF_LANG["err_bannedIP"] = "Địa chỉ IP của bạn không hợp lệ.";
$PMF_LANG["err_SaveQuestion"] = "Những thông tin sau là bắt buộc <strong>tên của bạn</strong>, <strong>email của bạn</strong>, <strong>câu hỏi của bạn</strong> và, khi được yêu cầu <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Xem thêm về Captcha trên Wikipedia\" target=\"_blank\">Captcha</a> code</strong>.<br /><br /><a href=\"javascript:history.back();\">trở về trang trước</a><br /><br />";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Màu chữ: ";
$PMF_LANG["ad_entry_fontsize"] = "Cỡ chữ: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array(0 => "select", 1 => "Ngôn ngữ tập tin");
$LANG_CONF["main.languageDetection"] = array(0 => "checkbox", 1 => "Kích hoạt tự động từ chối nội dung");
$LANG_CONF['main.titleFAQ'] = array(0 => "input", 1 => "Tiêu đề của phần Câu hỏi thường gặp");
$LANG_CONF['main.currentVersion'] = array(0 => "print", 1 => "Câu hỏi thường gặp Phiên bản ");
$LANG_CONF["main.metaDescription"] = array(0 => "input", 1 => "Mô tả trang");
$LANG_CONF["main.metaKeywords"] = array(0 => "input", 1 => "Từ khóa cho công cụ tìm kiếm");
$LANG_CONF["main.metaPublisher"] = array(0 => "input", 1 => "Tên của Publisher");
$LANG_CONF['main.administrationMail'] = array(0 => "input", 1 => "Địa chỉ email của Quản trị viên");
$LANG_CONF["main.contactInformations"] = array(0 => "area", 1 => "Thông tin liên lạc");
$LANG_CONF["main.send2friendText"] = array(0 => "area", 1 => "Nội dung của trang send2friend");
$LANG_CONF['records.maxAttachmentSize'] = array(0 => "input", 1 => "maximum cỡ tối đa cho tập tin đính kèm (max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array(0 => "checkbox", 1 => "Hiện đường dẫn đến tài liệu đính kèm ở cuối trang?");
$LANG_CONF["main.enableUserTracking"] = array(0 => "checkbox", 1 => "sử dụng Tracking?");
$LANG_CONF["main.enableAdminLog"] = array(0 => "checkbox", 1 => "sử dụng Adminlog?");
$LANG_CONF["security.ipCheck"] = array(0 => "checkbox", 1 => "Bạn có muốn kiểm tra IP khi xác nhận UINs trong admin.php?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array(0 => "input", 1 => "Số lượng nội dung hiện trên mỗi trang");
$LANG_CONF["records.numberOfShownNewsEntries"] = array(0 => "input", 1 => "Số lượng bài mới");
$LANG_CONF['security.bannedIPs'] = array(0 => "area", 1 => "Loại bỏ các IP này");
$LANG_CONF["main.enableRewriteRules"] = array(0 => "checkbox", 1 => "Kích hoạt hỗ trợ mod_rewrite? (mặc định: không kích hoạt)");
$LANG_CONF["security.ldapSupport"] = array(0 => "checkbox", 1 => "Bạn có muốn kích hoạt hỗ trợ LDAP? (mặc định: không kích hoạt)");
$LANG_CONF["main.referenceURL"] = array(0 => "input", 1 => "Tham chiếu URL để kiểm tra đường dẫn (vd.: http://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array(0 => "input", 1 => "Khoảng cách giữa các lần kiểm tra đường dẫn AJAX (tính bằng giây)");
$LANG_CONF["records.enableVisibilityQuestions"] = array(0 => "checkbox", 1 => "Không chọn chức năng cho xem các câu hỏi mới?");
$LANG_CONF['security.permLevel'] = array(0 => "select", 1 => "Permission level");

$PMF_LANG['ad_categ_new_main_cat'] = 'như mục chính';
$PMF_LANG["ad_categ_paste_error"] = "Không thể di chuyển mục này.";
$PMF_LANG["ad_categ_move"] = "di chuyển mục";
$PMF_LANG["ad_categ_lang"] = "Ngôn ngữ";
$PMF_LANG["ad_categ_desc"] = "Mô tả";
$PMF_LANG["ad_categ_change"] = "Thay đổi với";
$PMF_LANG["lostPassword"] = "Quên mật khẩu? Nhấp vào đây.";
$PMF_LANG["lostpwd_err_1"] = "Lỗi: Tên đăng nhập và địa chỉ email không tìm thấy.";
$PMF_LANG["lostpwd_err_2"] = "Lỗi: Giá trị không hợp lệ!";
$PMF_LANG["lostpwd_text_1"] = "Cảm ơn bạn đã yêu cầu thông tin tài khoản.";
$PMF_LANG["lostpwd_text_2"] = "Vui lòng thay đổi mật khẩu trong phần quản trị tài khoản của bạn.";
$PMF_LANG["lostpwd_mail_okay"] = "Email đã được gửi.";
$PMF_LANG["ad_xmlrpc_button"] = "Truy cập phiên bản mới nhất của phpMyFAQ";
$PMF_LANG['ad_xmlrpc_latest'] = 'Phiên bản mới nhất có tại';

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Chọn mục theo ngôn ngữ';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG["msgSitemap"] = 'Sơ đồ trang web';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'Bài này đang được hiệu đính, không thể xem.';
$PMF_LANG['msgArticleCategories'] = 'Bài này thuộc về các mục';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'ID của\bài';
$PMF_LANG['ad_entry_faq_record'] = 'Nội dung Câu hỏi thường gặp';
$PMF_LANG['ad_entry_new_revision'] = 'Tạo một hiệu đính mới ?';
$PMF_LANG['ad_entry_record_administration'] = 'Nội dung quản trị';
$PMF_LANG['ad_entry_changelog'] = 'Thay đổi';
$PMF_LANG['ad_entry_revision'] = 'Hiệu đính';
$PMF_LANG['ad_changerev'] = 'Chọn một hiệu đính';
$PMF_LANG['msgCaptcha'] = "Vui lòng đánh những ký tự dưới đây trong khung:";
$PMF_LANG['msgSelectCategories'] = 'Tìm kiếm trong';
$PMF_LANG['msgAllCategories'] = '... tất cả các mục';
$PMF_LANG['ad_you_should_update'] = 'Phiên bản phpMyFAQ của bạn đã cũ. Bạn cần phải cập nhật với phiên bản mới nhất.';
$PMF_LANG['msgAdvancedSearch'] = 'Tìm kiếu nâng cao';

// added v1.6.1 - 2006-04-25 by Matteo�and�Thorsten
$PMF_LANG["spamControlCenter"] = 'Trung tâm kiểm soát Spam';
$LANG_CONF["spam.enableSafeEmail"] = array(0 => "checkbox", 1 => "Xem email của thành viên dưới hình thức an toàn  (mặc định: kích hoạt).");
$LANG_CONF["spam.checkBannedWords"] = array(0 => "checkbox", 1 => "Kiểm tra nội dung các public form để tránh những từ cấm (mặc định: kích hoạt).");
$LANG_CONF["spam.enableCaptchaCode"] = array(0 => "checkbox", 1 => "Sử dụng mã catpcha để cho phép trình các public form (mặc định: kích hoạt).");

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Quản lý các Session';
$PMF_LANG['ad_stat_choose'] = 'Chọn tháng';
$PMF_LANG['ad_stat_delete'] = 'Xóa ngay các Session đã chọn';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'Thuật ngữ';
$PMF_LANG['ad_glossary_add'] = 'Thêm nội dung thuật ngữ';
$PMF_LANG['ad_glossary_edit'] = 'Chỉnh sửa nội dung thuật ngữ';
$PMF_LANG['ad_glossary_item'] = 'Item';
$PMF_LANG['ad_glossary_definition'] = 'Định nghĩa';
$PMF_LANG['ad_glossary_save'] = 'Lưu nội dung';
$PMF_LANG['ad_glossary_save_success'] = 'Nội dung thuật ngữ đã được lưu!';
$PMF_LANG['ad_glossary_save_error'] = 'Nội dung thuật ngữ không được lưu vì có lỗi xảy ra.';
$PMF_LANG['ad_glossary_update_success'] = 'Nội dung thuật ngữ đã được cập nhật thành công!';
$PMF_LANG['ad_glossary_update_error'] = 'Nội dung thuật ngữ không được cập nhật vì có lỗi xảy ra.';
$PMF_LANG['ad_glossary_delete'] = 'Xóa nội dung';
$PMF_LANG['ad_glossary_delete_success'] = 'Nội dung đã được xóa!';
$PMF_LANG['ad_glossary_delete_error'] = 'Nội dung không được xóa vì có lỗi xảy ra.';
$PMF_LANG['ad_linkcheck_noReferenceURL'] = 'Chức năng Tự động kiểm tra đường dẫn không được kích hoạt (tham chiếu URL để kiểm tra đường dẫn chưa được thiết lập)';
$PMF_LANG['ad_linkcheck_noAllowUrlOpen'] = 'Chức năng Tự động kiểm tra đường dẫn đã bị vô hiệu (PHP option allow_url_fopen không được kích hoạt)';
$PMF_LANG['ad_linkcheck_checkResult'] = 'Kết quả Tự động kiểm tra đường dẫn';
$PMF_LANG['ad_linkcheck_checkSuccess'] = 'OK';
$PMF_LANG['ad_linkcheck_checkFailed'] = 'Không thành công';
$PMF_LANG['ad_linkcheck_failReason'] = 'Lý do không thành công:';
$PMF_LANG['ad_linkcheck_noLinksFound'] = 'Không có URL tương thích.';
$PMF_LANG['ad_linkcheck_searchbadonly'] = 'Chỉ có các đường dẫn không hợp lệ';
$PMF_LANG['ad_linkcheck_infoReason'] = 'Thông tin bổ sung:';
$PMF_LANG['ad_linkcheck_openurl_infoprefix'] = 'Tìm thấy trong khi kiểm tra <strong>%s</strong>: ';
$PMF_LANG['ad_linkcheck_openurl_notready'] = 'LinkVerifier chưa sẵn sàng.';
$PMF_LANG['ad_linkcheck_openurl_maxredirect'] = 'Maximum redirect count <strong>%d</strong> exceeded.';
$PMF_LANG['ad_linkcheck_openurl_urlisblank'] = 'Resolved to blank URL.';
$PMF_LANG['ad_linkcheck_openurl_tooslow'] = 'Host <strong>%s</strong> is slow or not responding.';
$PMF_LANG['ad_linkcheck_openurl_nodns'] = 'DNS resolution of host <strong>%s</strong> is slow or is failed due to DNS issues, local or remote.';
$PMF_LANG['ad_linkcheck_openurl_redirected'] = 'URL was redirected to <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_ambiguous'] = 'Ambiguous HTTP status <strong>%s</strong> returned.';
$PMF_LANG['ad_linkcheck_openurl_not_allowed'] = 'The <em>HEAD</em> method is not supported by the host <strong>%s</strong>, allowed methods: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_found'] = 'This resource cannot be found at host <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_protocol_unsupported'] = '%s protocol unsupported by Automatic link verification.';
$PMF_LANG['msgNewQuestionVisible'] = 'The question have to be reviewed first before getting public.';
$PMF_LANG['msgQuestionsWaiting'] = 'Waiting for publishing by the administrators: ';
$PMF_LANG['ad_entry_visibility'] = 'Publish?';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] =  "Xin nhập mật khẩu. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] =  "Mật khẩu không trùng khớp. ";
$PMF_LANG['ad_user_error_loginInvalid'] =  "Tên đăng nhập không hợp lệ.";
$PMF_LANG['ad_user_error_noEmail'] =  "Xin nhập email hợp lệ. ";
$PMF_LANG['ad_user_error_noRealName'] =  "Xin nhập tên thật của bạn. ";
$PMF_LANG['ad_user_error_delete'] =  "Tài khoản thành viên không thể xóa. ";
$PMF_LANG['ad_user_error_noId'] =  "Không tìm thấy ID. ";
$PMF_LANG['ad_user_error_protectedAccount'] =  "Tài khoản thành viên được khóa. ";
$PMF_LANG['ad_user_deleteUser'] = "Xóa thành viên";
$PMF_LANG['ad_user_status'] = "Tình trạng:";
$PMF_LANG['ad_user_lastModified'] = "lần thay đổi mới nhất:";
$PMF_LANG['ad_gen_cancel'] = "Hủy";
$PMF_LANG["rightsLanguage"]['addglossary'] = "thêm nội dung thuật ngữ";
$PMF_LANG["rightsLanguage"]['editglossary'] = "chỉnh sửa nội dung thuật ngữ";
$PMF_LANG["rightsLanguage"]['delglossary'] = "xóa nội dung thuật ngữ";
$PMF_LANG["ad_menu_group_administration"] = "Nhóm";
$PMF_LANG['ad_user_loggedin'] = 'Bạn\'đang đăng nhập với tư cách ';
$PMF_LANG['ad_group_details'] = "Chi tiết về Nhóm";
$PMF_LANG['ad_group_add'] = "Thêm Nhóm";
$PMF_LANG['ad_group_add_link'] = "Thêm Nhóm";
$PMF_LANG['ad_group_name'] = "Tên:";
$PMF_LANG['ad_group_description'] = "Mô tả:";
$PMF_LANG['ad_group_autoJoin'] = "Auto-join:";
$PMF_LANG['ad_group_suc'] = "Nhóm được tạo <strong>thành công</strong>.";
$PMF_LANG['ad_group_error_noName'] = "Xin nhập tên nhóm. ";
$PMF_LANG['ad_group_error_delete'] = "Nhóm không thể xóa. ";
$PMF_LANG['ad_group_deleted'] = "Nhóm đã được xóa.";
$PMF_LANG['ad_group_deleteGroup'] = "Xóa nhóm";
$PMF_LANG['ad_group_deleteQuestion'] = "Bạn có chắc là nhóm này cần được xóa?";
$PMF_LANG['ad_user_uncheckall'] = "Không chọn Tất cả";
$PMF_LANG['ad_group_membership'] = "Thành viên Nhóm";
$PMF_LANG['ad_group_members'] = "Thành viên";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'Giới hạn nội dung Câu hỏi thường gặp cần xuất (tùy chọn)';
$PMF_LANG['ad_export_cat_downwards'] = 'Xuống?';
$PMF_LANG['ad_export_type'] = 'Định dạng của tập tin xuất';
$PMF_LANG['ad_export_type_choose'] = 'Chọn một trong những định dạng được hỗ trợ sau:';
$PMF_LANG['ad_export_download_view'] = 'Tải về hay xem in-line?';
$PMF_LANG['ad_export_download'] = 'tải về';
$PMF_LANG['ad_export_view'] = 'xem in-line';
$PMF_LANG['ad_export_gen_xhtml'] = 'Tạo tập tin XHTML';
$PMF_LANG['ad_export_gen_docbook'] = 'Tạo tập tin Docbook';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'Dữ liệu mới';
$PMF_LANG['ad_news_author_name'] = 'Tên tác giả:';
$PMF_LANG['ad_news_author_email'] = 'Email tác giả:';
$PMF_LANG['ad_news_set_active'] = 'Kích hoạt';
$PMF_LANG['ad_news_allowComments'] = 'Cho phép bình luận:';
$PMF_LANG['ad_news_expiration_window'] = 'Thời gian mở một cửa sổ nội dung (tùy chọn)';
$PMF_LANG['ad_news_from'] = 'Từ:';
$PMF_LANG['ad_news_to'] = 'Gửi đến:';
$PMF_LANG['ad_news_insertfail'] = 'Có lỗi xảy ra khi chèn nội dung vào cơ sở dữ liệu.';
$PMF_LANG['ad_news_updatefail'] = 'Có lỗi xảy ra khi cập nhật nội dung vào cơ sở dữ liệu.';
$PMF_LANG['newsShowCurrent'] = 'Xem những nội dung hiện có.';
$PMF_LANG['newsShowArchive'] = 'Xem những nội dung lưu.';
$PMF_LANG['newsArchive'] = ' Nội dung lưu';
$PMF_LANG['newsWriteComment'] = 'bình luận về nội dung này';
$PMF_LANG['newsCommentDate'] = 'Tạo vào ngày: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'Thời gian mở một cửa sổ nội dung (tùy chọn)';
$PMF_LANG['admin_mainmenu_home'] = 'Trang chủ';
$PMF_LANG['admin_mainmenu_users'] = 'Thành viên';
$PMF_LANG['admin_mainmenu_content'] = 'Nội dung';
$PMF_LANG['admin_mainmenu_statistics'] = 'Thống kê';
$PMF_LANG['admin_mainmenu_exports'] = 'Xuất';
$PMF_LANG['admin_mainmenu_backup'] = 'Bản lưu';
$PMF_LANG['admin_mainmenu_configuration'] = 'Cấu hình';
$PMF_LANG['admin_mainmenu_logout'] = 'Thoát';

// added v2.1.0 - 2008-06-06 by Paul
$PMF_LANG['ad_see_also_links']  = 'Xem cả đường dẫn';
$PMF_LANG['ad_unlinked_themes'] = 'Gợi ý chủ đề:';
$PMF_LANG['ad_linked_themes']   = 'Chủ đề liên kết:';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'Chủ nhân của mục';
$PMF_LANG['adminSection'] = 'Quản trị';
$PMF_LANG['err_expiredArticle'] = 'Nội dung này đã quá hạn và bạn không thể xem';
$PMF_LANG['err_expiredNews'] = 'Nội dung này đã quá hạn và bạn không thể xem';
$PMF_LANG['err_inactiveNews'] = 'Nội dung này đang được hiệu đính và bạn không thể xem';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Tìm kiếm trong tất cả các ngôn ngữ:';
$PMF_LANG['ad_entry_tags'] = 'Tag';
$PMF_LANG['msg_tags'] = 'Tag';

// added v2.0.0 - 2006-09-03 by Matteo
$PMF_LANG['ad_linkcheck_feedback_url-batch1'] = 'Đang kiểm tra...';
$PMF_LANG['ad_linkcheck_feedback_url-batch2'] = 'Đang kiểm tra...';
$PMF_LANG['ad_linkcheck_feedback_url-batch3'] = 'Đang kiểm tra...';
$PMF_LANG['ad_linkcheck_feedback_url-checking'] = 'Đang kiểm tra...';
$PMF_LANG['ad_linkcheck_feedback_url-disabled'] = 'Đã bị vô hiệu hóa';
$PMF_LANG['ad_linkcheck_feedback_url-linkbad'] = 'Đường dẫn KO';
$PMF_LANG['ad_linkcheck_feedback_url-linkok'] = 'Đường dẫn OK';
$PMF_LANG['ad_linkcheck_feedback_url-noaccess'] = 'Không có quyền truy cập';
$PMF_LANG['ad_linkcheck_feedback_url-noajax'] = 'Không AJAX';
$PMF_LANG['ad_linkcheck_feedback_url-nolinks'] = 'Không có đường dẫn';
$PMF_LANG['ad_linkcheck_feedback_url-noscript'] = 'Không có Script';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG["msg_related_articles"] = 'Những nội dung liên quan';
$LANG_CONF["records.numberOfRelatedArticles"] = array(0 => "input", 1 => "Số lượng nội dung liên quan");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'Dịch';
$PMF_LANG['ad_categ_trans_2'] = 'Mục';
$PMF_LANG['ad_categ_translatecateg'] = 'Dịch Mục';
$PMF_LANG['ad_categ_translate'] = 'Dịch';
$PMF_LANG['ad_categ_transalready'] = 'Đã được dịch qua tiếng: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Xóa trong mọi ngôn ngữ?';
$PMF_LANG["ad_categ_deletethislang"] = 'Chỉ xóa trong ngôn ngữ này?';
$PMF_LANG["ad_categ_translated"] = "Mục đã được dịch.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["ad_categ_show"] = "Tổng quan";
$PMF_LANG['ad_menu_categ_structure'] = "Xem tổng quan các Mục, kể cả các ngôn ngữ hiện có";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'Quyền của thành viên:';
$PMF_LANG['ad_entry_grouppermission'] = 'Quyền của nhóm:';
$PMF_LANG['ad_entry_all_users'] = 'Quyền truy cập cho mọi thành viên';
$PMF_LANG['ad_entry_restricted_users'] = 'Quyền truy cập chỉ dành cho';
$PMF_LANG['ad_entry_all_groups'] = 'Quyền truy cập cho mọi nhóm';
$PMF_LANG['ad_entry_restricted_groups'] = 'Quyền truy cập chỉ dành cho';
$PMF_LANG['ad_session_expiration'] = 'Session của bạn sẽ hết hạn trong';
$PMF_LANG['ad_user_active'] = 'kích hoạt';
$PMF_LANG['ad_user_blocked'] = 'khóa';
$PMF_LANG['ad_user_protected'] = 'được bảo vệ';

// added v2.1.0 - 2008-06-04 by Paul (cutomizing for GymGlish)
$PMF_LANG['gg_enable_contact'] = 'Cho phép đường dẫn liên hệ:';
$PMF_LANG['gg_contact_label']  = 'Nội dung của đường dẫn:';
$PMF_LANG['gg_contact_url']    = 'URL của đường dẫn:';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG["ad_entry_intlink"] = 'Chọn một nội dung trong Câu hỏi thường gặp để chèn đường dẫn...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Dán sau";
$PMF_LANG["ad_categ_remark_move"] = "Việc hoán đổi giữa 2 mục chỉ được cho phép nếu chúng ở cùng cấp độ.";
$PMF_LANG["ad_categ_remark_overview"] = "Thứ tự đúng của các mục sẽ hiện ra, nếu tất cả các mục đều hiện có trong ngôn ngữ này (cột đầu).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = '%d Khách và %d Thành viên';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Xóa ngay các nội dung lưu quá 30 ngày';
$PMF_LANG['ad_adminlog_delete_success'] = 'Các nội dung cũ đã được xóa.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'Không có nội dung nào được xóa: có lỗi xảy ra trong quá trình thực hiện lệnh.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['opensearch_plugin_install'] = 'thêm plugin tìm kiếm';
$PMF_LANG['ad_quicklinks'] = 'Quicklinks';
$PMF_LANG['ad_quick_category'] = 'Thêm mục mới';
$PMF_LANG['ad_quick_record'] = 'Thêm nội dung Câu hỏi thường gặp mới';
$PMF_LANG['ad_quick_user'] = 'Thêm thành viên mới';
$PMF_LANG['ad_quick_group'] = 'Thêm nhóm mới';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'Đề nghị dịch';
$PMF_LANG['msgNewTranslationAddon'] = 'Đề nghị của bạn sẽ được đăng sau khi quản trị viên của chúng tôi thông qua. Những thông tin sau là bắt buộc <strong>Tên của bạn</strong>, <strong>email của bạn</strong>, <strong>dịch tiêu đề</strong> and <strong>dịch nội dung Câu hỏi thường gặp</strong>. Vui lòng chỉ sử dụng khoảng cách để phân biệt giữa các từ khóa.';
$PMF_LANG['msgNewTransSourcePane'] = 'Nguyên bản ';
$PMF_LANG['msgNewTranslationPane'] = 'Bản dịch';
$PMF_LANG["msgNewTranslationName"] = "Your Name:";
$PMF_LANG["msgNewTranslationMail"] = "Your email address:";
$PMF_LANG["msgNewTranslationKeywords"] = "Keywords:";
$PMF_LANG['msgNewTranslationSubmit'] = 'Gửi đề nghị của bạn';
$PMF_LANG['msgTranslate'] = 'Đề nghị một bản dịch cho';
$PMF_LANG['msgTranslateSubmit'] = 'Bắt đầu dịch...';
$PMF_LANG['msgNewTranslationThanks'] = "Cảm ơn bản dịch bạn đã đề nghị!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG["rightsLanguage"]['addgroup'] = "thêm tài khoản nhóm";
$PMF_LANG["rightsLanguage"]['editgroup'] = "chỉnh sửa tài khoản nhóm";
$PMF_LANG["rightsLanguage"]['delgroup'] = "xóa tài khoản nhóm";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG["ad_news_link_parent"] = 'Đường dẫn mở ra ngay trên trang hiện hành';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'Bình luận';
$PMF_LANG['ad_comment_administration'] = 'Quản trị bình luận ';
$PMF_LANG['ad_comment_faqs'] = 'Bình luận trong nội dung Câu hỏi thường gặp:';
$PMF_LANG['ad_comment_news'] = 'Bình luận trong các nội dung mới:';
$PMF_LANG['ad_groups'] = 'Nhóm';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array(0 => 'select', 1 => 'Liệt kê nội dung theo thứ tự (tùy theo tính chất)');
$LANG_CONF['records.sortby'] = array(0 => 'select', 1 => 'Liệt kê nội dung theo thứ tự (tăng hoặc giảm)');
$PMF_LANG['ad_conf_order_id'] = 'ID (mặc định)';
$PMF_LANG['ad_conf_order_thema'] = 'Tiêu đề';
$PMF_LANG['ad_conf_order_visits'] = 'Số lượng khách thăm';
$PMF_LANG['ad_conf_order_updated'] = 'Ngày';
$PMF_LANG['ad_conf_order_author'] = 'Tác giả';
$PMF_LANG['ad_conf_desc'] = 'giảm dần';
$PMF_LANG['ad_conf_asc'] = 'tăng dần';
$PMF_LANG['mainControlCenter'] = 'Cấu hình chính';
$PMF_LANG['recordsControlCenter'] = 'Cấu hình nội dung Câu hỏi thường gặp';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array(0 => "checkbox", 1 => "Kích hoạt một nội dung mới (mặc định: không kích hoạt)");
$LANG_CONF['records.defaultAllowComments'] = array(0 => "checkbox", 1 => "Cho phép bình luận nội dung mới (mặc định: không cho phép)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'Nội dung trong mục này';
$PMF_LANG['msgTagSearch'] = 'Những nội dung được tag';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ Information';
$PMF_LANG['ad_online_info'] = 'Kiểm tra phiên bản trực tuyến';
$PMF_LANG['ad_system_info'] = 'Thông tin Hệ thống';

