<?php

/**
 * Turkish language file
 *
 * PHP Version 5.5
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @category  phpMyFAQ
 * @author    Zafer Gürsoy <zafergursoy@yahoo.com>
 * @author    Evren Yurtesen <yurtesen@ispro.net.tr>
 * @copyright 2004-2018 phpMyFAQ Team
 * @license   http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link      http://www.phpmyfaq.de
 * @since     2004
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "tr";
$PMF_LANG["language"] = "Turkish";
$PMF_LANG["dir"] = "ltr";
$PMF_LANG["nplurals"] = "1";

// Navigation
$PMF_LANG["msgCategory"] = "Kategoriler";
$PMF_LANG["msgShowAllCategories"] = "Tüm Kategorileri Göster";
$PMF_LANG["msgSearch"] = "Araştır";
$PMF_LANG["msgAddContent"] = "İçerik Ekle";
$PMF_LANG["msgQuestion"] = "Soru Sor";
$PMF_LANG["msgOpenQuestions"] = "Soruları Aç";
$PMF_LANG["msgHelp"] = "Yardım";
$PMF_LANG["msgContact"] = "İrtibat";
$PMF_LANG["msgHome"] = "AnaSayfa";
$PMF_LANG["msgNews"] = "SSS-Haberler";
$PMF_LANG["msgUserOnline"] = " Online Kullanıcı";
$PMF_LANG["msgBack2Home"] = "Ana Sayfaya Dön";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Tüm Kategoriler";
$PMF_LANG["msgFullCategoriesIn"] = ".. Altındaki Tüm Kategoriler ";
$PMF_LANG["msgSubCategories"] = "Alt Kategoriler";
$PMF_LANG["msgEntries"] = "Girdiler";
$PMF_LANG["msgEntriesIn"] = "Soru Kategorisi: ";
$PMF_LANG["msgViews"] = "Görünüm";
$PMF_LANG["msgPage"] = "Sayfa ";
$PMF_LANG["msgPages"] = " Sayfa";
$PMF_LANG["msgPrevious"] = "Önceki";
$PMF_LANG["msgNext"] = "Sonraki";
$PMF_LANG["msgCategoryUp"] = "Bir Kategori Üste";
$PMF_LANG["msgLastUpdateArticle"] = "Son Güncelleme: ";
$PMF_LANG["msgAuthor"] = "Yazar: ";
$PMF_LANG["msgPrinterFriendly"] = "Yazıcı-dostu sürüm";
$PMF_LANG["msgPrintArticle"] = "Bu Kaydı Yazdır";
$PMF_LANG["msgMakeXMLExport"] = "XML-Dosya olarak yayınla";
$PMF_LANG["msgAverageVote"] = "Ortalama puanı:";
$PMF_LANG["msgVoteUseability"] = "Lütfen bu girdiyi puanlayın:";
$PMF_LANG["msgVoteFrom"] = "Gönderen: ";
$PMF_LANG["msgVoteBad"] = "Tamamen faydasız";
$PMF_LANG["msgVoteGood"] = "Çok Değerli";
$PMF_LANG["msgVotings"] = "Oylar ";
$PMF_LANG["msgVoteSubmit"] = "Oy Ver";
$PMF_LANG["msgVoteThanks"] = "Oy verdiğiniz için çok teşekkürler!";
$PMF_LANG["msgYouCan"] = "* ";
$PMF_LANG["msgWriteComment"] = "Bu yazı hakkında yorumda bulunabilirsiniz.";
$PMF_LANG["msgShowCategory"] = "İçerik Listesi: ";
$PMF_LANG["msgCommentBy"] = "Yorumda Bulunan ";
$PMF_LANG["msgCommentHeader"] = "Bu konu hakkındaki yorum";
$PMF_LANG["msgYourComment "] = "Yorumunuz:";
$PMF_LANG["msgCommentThanks"] = "Yorumunuz için çok teşekkürler.";
$PMF_LANG["msgSeeXMLFile"] = "XML-Dosyayı aç";
$PMF_LANG["msgSend2Friend"] = "Arkadaşına yolla";
$PMF_LANG["msgS2FName"] = "ısminiz:";
$PMF_LANG["msgS2FEMail"] = "E-mail adresiniz:";
$PMF_LANG["msgS2FFriends"] = "Arkadaşınız:";
$PMF_LANG["msgS2FEMails"] = ". E-mail adresi:";
$PMF_LANG["msgS2FText"] = "Bu yazının gönderileceği :";
$PMF_LANG["msgS2FText2"] = "Bu kaydı bulabileceğiniz adres:";
$PMF_LANG["msgS2FMessage"] = "Arkadaşınıza ek mesaj:";
$PMF_LANG["msgS2FButton"] = "E-mail gönder";
$PMF_LANG["msgS2FThx"] = "Tavsiyeniz için teşekkürler!";
$PMF_LANG["msgS2FMailSubject"] = "Yorumda bulunan ";

// Search
$PMF_LANG["msgSearchWord"] = "Anahtar Sözcük";
$PMF_LANG["msgSearchFind"] = "Arama sonuçları: ";
$PMF_LANG["msgSearchAmount"] = " Arama sonucu";
$PMF_LANG["msgSearchAmounts"] = " Arama sonuçları";
$PMF_LANG["msgSearchCategory"] = "Kategori: ";
$PMF_LANG["msgSearchContent"] = "İçerik: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "SSS için öneri";
$PMF_LANG["msgNewContentAddon"] = "Öneriniz hemen yayınlanmayacak, ancak yönetici tarafından kontrol edildikten sonra yayınlanacaktır. Gerekli bölümler, <strong>adınız</strong>, <strong>e-posta adresiniz</strong>, <strong>başlık tercümeniz</strong> ve <strong>sss tercümesi</strong>. Anahtar kelimeleri sadece boşluk ile ayırınız.";
$PMF_LANG["msgNewContentName"] = "İsminiz:";
$PMF_LANG["msgNewContentMail"] = "E-posta adresiniz:";
$PMF_LANG["msgNewContentCategory"] = "Seçtiğiniz kategori?";
$PMF_LANG["msgNewContentTheme"] = "Başlık:";
$PMF_LANG["msgNewContentArticle"] = "SSS öneriniz:";
$PMF_LANG["msgNewContentKeywords"] = "Anahtar sözcükler:";
$PMF_LANG["msgNewContentLink"] = "Bu kayıt için link";
$PMF_LANG["msgNewContentSubmit"] = "Onay";
$PMF_LANG["msgInfo"] = "Daha fazla bilgi: ";
$PMF_LANG["msgNewContentThanks"] = "Öneriniz için teşekkürler!";
$PMF_LANG["msgNoQuestionsAvailable"] = "şu an hiç soru yok";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Sorunuzu aşağıya yazınız:";
$PMF_LANG["msgAskCategory"] = "Sorunuzla ilgili kategori";
$PMF_LANG["msgAskYourQuestion"] = "Sorunuz:";
$PMF_LANG["msgAskThx4Mail"] = "<h2>Sorunuz için teşekkürler!</h2>";
$PMF_LANG["msgDate_User"] = "Tarih / Kullanıcı";
$PMF_LANG["msgQuestion2"] = "Soru";
$PMF_LANG["msg2answer"] = "Cevap";
$PMF_LANG["msgQuestionText"] = "Burada diğer kullanıcıların sormuş olduğu soruları görebilirsiniz. Eğer bu soruyu cevaplayacaksanız, cevabınız SSS'da yerleştirilebilir.";

// Help
$PMF_LANG["msgHelpText"] = "SSS'ın yapısı (<strong>S</strong>ıkça <strong>S</strong>orulan <strong>S</strong>orular) oldukça basit. Ayrıca <strong><a href=\"?action=show\">Kategoriler</a></strong> içinde araştırma yapabilir, veya <strong><a href=\"?action=search\">SSS Arama Motoru</a></strong> ile anahtar sözcüklere göre arama yapabilirsiniz.";

// Contact
$PMF_LANG["msgContactEMail"] = "Webmaster 'a E-Mail:";
$PMF_LANG["msgMessage"] = "Mesajınız:";

// Startseite
$PMF_LANG["msgNews"] = " Haberler";
$PMF_LANG["msgTopTen"] = "İLK 10";
$PMF_LANG["msgHomeThereAre"] = "Burada ";
$PMF_LANG["msgHomeArticlesOnline"] = " kayıt mevcut";
$PMF_LANG["msgNoNews"] = "Şu an hiç haber yok.";
$PMF_LANG["msgLatestArticles"] = "Çok yakında gönderilmiş 5 soru:";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "SSS öneriniz için çok teşekkürler.";
$PMF_LANG["msgMailCheck"] = "SSS'da yeni bir girdi oluşturuldu!\nLütfen admin bölümünü kontrol edin!";
$PMF_LANG["msgMailContact"] = "Mesajınız yöneticiye yollandı.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Herhangi bir veritabanı bağlantısı yok.";
$PMF_LANG["err_noHeaders"] = "Herhangi bir kategori bulunamadı.";
$PMF_LANG["err_noArticles"] = "Herhangi bir girdi yok.";
$PMF_LANG["err_badID"] = "Yanlış ID.";
$PMF_LANG["err_noTopTen"] = "Henüz İlk On yok.";
$PMF_LANG["err_nothingFound"] = "Bir girdi bulunamadı.";
$PMF_LANG["err_SaveEntries"] = "Gerekli alanlar <strong>adınız</strong>, <strong>e-mail adresiniz</strong>, <strong>kategori</strong>, <strong>başlık</strong> ve <strong>yazınız</strong>!<br /><br />\n<a href=\"javascript:history.back();\">bir sayfa geri</a><br /><br />\n";
$PMF_LANG["err_SaveComment"] = "Gerekli alanlar <strong>your name</strong>, <strong>e-mail adresiniz</strong> ve <strong>yorumlarınız</strong>!<br /><br />\n<a href=\"javascript:history.back();\">bir sayfa geri</a><br /><br />\n";
$PMF_LANG["err_VoteTooMuch"] = "Mükerrer oylar sayılmamaktadır.";
$PMF_LANG["err_noVote"] = "<strong>Soruyu oylayamazsınız!</strong> <a href=\"javascript:history.back();\">Lütfen buraya tıklayın</a>, oy kullanmak için.";
$PMF_LANG["err_noMailAdress"] = "E-mail adresiniz yanlış.<br /><a href=\"javascript:history.back();\">geri</a>";
$PMF_LANG["err_sendMail"] = "Gerekli alanlar <strong>adınız</strong>, <strong>e-mail adresiniz</strong> ve <strong>sorunuz</strong>!";

// Yardım ve Arama
$PMF_LANG["help_search"] = "<strong>Yazı Ara:</strong><br />şu kelimelere benzeyen girdileri ara <strong style=\"color: Red;\">kelime1 kelime2</strong> ıki veya daha fazla kritere inen arama yapabilirsiniz.<strong>Dikkat:</strong> Arama kriteriniz en az 4 harf uzunluğunda olmalıdır, aksi halde istek reddedilir.";

// Menü
$PMF_LANG["ad"] = "ADMıN ALANI";
$PMF_LANG["ad_menu_user_administration"] = "Kullanıcı Yönetimi";
$PMF_LANG["ad_menu_entry_aprove"] = "Girdi Onayı";
$PMF_LANG["ad_menu_entry_edit"] = "Girdileri Düzenle";
$PMF_LANG["ad_menu_categ_add"] = "Kategori Ekle";
$PMF_LANG["ad_menu_categ_edit"] = "Kategori Düzenle";
$PMF_LANG["ad_menu_news_add"] = "Haber Ekle";
$PMF_LANG["ad_menu_news_edit"] = "Haberleri Düzenle";
$PMF_LANG["ad_menu_open"] = "Açık soruları düzenle";
$PMF_LANG["ad_menu_stat"] = "ıstatistikler";
$PMF_LANG["ad_menu_cookie"] = "Cookie'ler";
$PMF_LANG["ad_menu_session"] = "Oturumları Görüntüle";
$PMF_LANG["ad_menu_adminlog"] = "Yönetici Kütük Kayıtlarını Görüntüle";
$PMF_LANG["ad_menu_passwd"] = "Şifreyi Değiştir";
$PMF_LANG["ad_menu_logout"] = "Çıkış";
$PMF_LANG["ad_menu_startpage"] = "Başlangıç Sayfası";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Lütfen kendinizi tanıtınız.";
$PMF_LANG["ad_msg_passmatch"] = "ıki şifre mutlaka <strong>eşleşmeli</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "Profil";
$PMF_LANG["ad_msg_savedsuc_2"] = "başarılı bir şekilde kaydedildi.";
$PMF_LANG["ad_msg_mysqlerr"] = "<strong>Database hatası</strong>nedeniyle, profil kaydedilemedi.";
$PMF_LANG["ad_msg_noauth"] = "Onaylanmadınız.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Sayfa";
$PMF_LANG["ad_gen_of"] = "-";
$PMF_LANG["ad_gen_lastpage"] = "Önceki Sayfa";
$PMF_LANG["ad_gen_nextpage"] = "Sonraki Sayfa";
$PMF_LANG["ad_gen_save"] = "Kaydet";
$PMF_LANG["ad_gen_reset"] = "Temizle";
$PMF_LANG["ad_gen_yes"] = "Evet";
$PMF_LANG["ad_gen_no"] = "Hayır";
$PMF_LANG["ad_gen_top"] = "Sayfa Başı";
$PMF_LANG["ad_gen_ncf"] = "Kategori bulunamadı!";
$PMF_LANG["ad_gen_delete"] = "Sil";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Kullanıcı Yönetimi";
$PMF_LANG["ad_user_username"] = "Kayıtlı Kullanıcılar";
$PMF_LANG["ad_user_rights"] = "Kullanıcı Hakları";
$PMF_LANG["ad_user_edit"] = "Düzenle";
$PMF_LANG["ad_user_delete"] = "Sil";
$PMF_LANG["ad_user_add"] = "Kullanıcı Hakları";
$PMF_LANG["ad_user_profou"] = "Kullanıcı Profili";
$PMF_LANG["ad_user_name"] = "ısim";
$PMF_LANG["ad_user_password"] = "şifre";
$PMF_LANG["ad_user_confirm"] = "Onay";
$PMF_LANG["ad_user_rights"] = "Haklar";
$PMF_LANG["ad_user_del_1"] = "Kullanıcı";
$PMF_LANG["ad_user_del_2"] = "silinsin mi?";
$PMF_LANG["ad_user_del_3"] = "Emin misiniz?";
$PMF_LANG["ad_user_deleted"] = "Kullanıcı başarıyla silindi.";
$PMF_LANG["ad_user_checkall"] = "Hepsini seç";

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = "Kayıt Yönetimi";
$PMF_LANG["ad_entry_id"] = "Girdi ID'si";
$PMF_LANG["ad_entry_topic"] = "Konu";
$PMF_LANG["ad_entry_action"] = "Eylem";
$PMF_LANG["ad_entry_edit_1"] = "Kayıt Düzenle";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Soru:";
$PMF_LANG["ad_entry_content"] = "Cevap:";
$PMF_LANG["ad_entry_keywords"] = "Anahtar Sözcükler:";
$PMF_LANG["ad_entry_author"] = "Yazar:";
$PMF_LANG["ad_entry_category"] = "Kategori:";
$PMF_LANG["ad_entry_active"] = "Aktif?";
$PMF_LANG["ad_entry_date"] = "Tarih:";
$PMF_LANG["ad_entry_changed"] = "Değiştir?";
$PMF_LANG["ad_entry_changelog"] = "Log kaydını değiştir?:";
$PMF_LANG["ad_entry_commentby 	"] = "Yorumlayan";
$PMF_LANG["ad_entry_comment"] = "Yorumlar:";
$PMF_LANG["ad_entry_save"] = "Kaydet";
$PMF_LANG["ad_entry_delete"] = "Sil";
$PMF_LANG["ad_entry_delcom_1"] = "Kullanıcı ";
$PMF_LANG["ad_entry_delcom_2"] = " yorumunun silinmesine emin misiniz?";
$PMF_LANG["ad_entry_commentdelsuc"] = "Yorum <strong>başarıyla</strong> silindi.";
$PMF_LANG["ad_entry_back"] = "Makaleye geri dön";
$PMF_LANG["ad_entry_commentdelfail"] = "Yorum <strong>maalesef</strong> silinmedi.";
$PMF_LANG["ad_entry_savedsuc"] = "Değişiklikler <strong>başarıyla</strong> kaydedildi.";
$PMF_LANG["ad_entry_savedfail 	"] = "Maalesef, bir <strong>veritabanı hatası</strong> oluştu.";
$PMF_LANG["ad_entry_del_1"] = "Bu konunun";
$PMF_LANG["ad_entry_del_2"] = "silinmesine";
$PMF_LANG["ad_entry_del_3"] = "emin misiniz?";
$PMF_LANG["ad_entry_delsuc"] = "Yayın <strong>başarıyla</strong> silindi.";
$PMF_LANG["ad_entry_delfail"] = "Yayın <strong>silinemedi</strong>!";
$PMF_LANG["ad_entry_back"] = "Geri";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Makale Başlığı";
$PMF_LANG["ad_news_text"] = "Kayıt Metni";
$PMF_LANG["ad_news_link_url"] = "Link: (<strong>http:// içermeyen</strong>)!";
$PMF_LANG["ad_news_link_title"] = "Link Başlığı:";
$PMF_LANG["ad_news_link_target"] = "Link Hedefi";
$PMF_LANG["ad_news_link_window"] = "Bağlantıyı yeni pencerede aç";
$PMF_LANG["ad_news_link_faq"] = "SSS içinde link";
$PMF_LANG["ad_news_add"] = "Haber Ekle";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Başlık";
$PMF_LANG["ad_news_date"] = "Tarih";
$PMF_LANG["ad_news_action"] = "Eylem";
$PMF_LANG["ad_news_update"] = "güncelleme";
$PMF_LANG["ad_news_delete"] = "sil";
$PMF_LANG["ad_news_nodata"] = "Database'de data bulunamadı.";
$PMF_LANG["ad_news_updatesuc"] = "Haberler güncellendi.";
$PMF_LANG["ad_news_del"] = "Bu haber maddesini silmek istediğinize emin misiniz?";
$PMF_LANG["ad_news_yesdelete"] = "Evet, sil!";
$PMF_LANG["ad_news_nodelete"] = "Hayır!";
$PMF_LANG["ad_news_delsuc"] = "Haber maddesi silindi..";
$PMF_LANG["ad_news_updatenews"] = "Haberleri güncelle";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Yeni Kategori Ekle";
$PMF_LANG["ad_categ_catnum"] = "Kategori Numarası:";
$PMF_LANG["ad_categ_subcatnum"] = "Alt Kategori Numarası:";
$PMF_LANG["ad_categ_nya"] = "<em>henüz mevcut değil!</em>";
$PMF_LANG["ad_categ_titel"] = "Kategori Başlığı:";
$PMF_LANG["ad_categ_add"] = "Kategori Ekle";
$PMF_LANG["ad_categ_existing"] = "Mevcut Kategoriler";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Kategori";
$PMF_LANG["ad_categ_subcateg"] = "Alt Kategori";
$PMF_LANG["ad_categ_titel"] = "Kategori Başlığı";
$PMF_LANG["ad_categ_action"] = "Eylem";
$PMF_LANG["ad_categ_update"] = "Güncelle";
$PMF_LANG["ad_categ_delete"] = "Sil";
$PMF_LANG["ad_categ_updatecateg"] = "Kategori Güncelle";
$PMF_LANG["ad_categ_nodata"] = "Database'de data bulunamadı";
$PMF_LANG["ad_categ_remark"] = "Eğer kategoriyi silerseniz, kategoride mevcut olan makaleler görüntülenemez. Kategorisiz makaleler için yeni bir kategori tayin etmelisiniz veya bu makaleleri silmelisiniz.";
$PMF_LANG["ad_categ_edit_1"] = "Düzenle";
$PMF_LANG["ad_categ_edit_2"] = "Kategori";
$PMF_LANG["ad_categ_add"] = "Kategori Ekle";
$PMF_LANG["ad_categ_added"] = "Kategori eklendi.";
$PMF_LANG["ad_categ_updated"] = "Kategori güncellendi.";
$PMF_LANG["ad_categ_del_yes"] = "evet, sil!";
$PMF_LANG["ad_categ_del_no"] = "hayır!";
$PMF_LANG["ad_categ_deletesure"] = "Bu kategoriyi silmekte emin misiniz?";
$PMF_LANG["ad_categ_deleted"] = "Kategori silindi.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc 	"] = "Cookie <strong>başarıyla</strong> yerleştirildi.";
$PMF_LANG["ad_cookie_already"] = "Cookie zaten yerleştirilmişti. şimdi takip eden seçeneklere sahipsiniz:";
$PMF_LANG["ad_cookie_again"] = "Cookie'yi yeniden yerleştir.";
$PMF_LANG["ad_cookie_delete"] = "Cookie'yi sil";
$PMF_LANG["ad_cookie_no"] = "Henüz hiç cookie kaydedilmedi. Cookie ile girdiğiniz kod bloğunu kaydedebilirsiniz, bundan dolayı tekrar kodu hatırlamanız gerekmez. şimdi takip eden seçeneklere sahipsiniz:";
$PMF_LANG["ad_cookie_set"] = "Cookie'yi yerleştir";
$PMF_LANG["ad_cookie_deleted"] = "Cookie başarıyla silindi.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "Yönetici Kütük Kayıtları";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Şifreni Değiştir";
$PMF_LANG["ad_passwd_old"] = "Eski Şifre:";
$PMF_LANG["ad_passwd_new"] = "Yeni Şifre:";
$PMF_LANG["ad_passwd_con"] = "Tekrar Yeni Şifre:";
$PMF_LANG["ad_passwd_change"] = "Şifreyi Değiştir";
$PMF_LANG["ad_passwd_suc"] = "Şifre başarıyla değiştirildi.";
$PMF_LANG["ad_passwd_remark"] = "<strong>DİKKAT:</strong><br />Cookie tekrar yerleştirilmeli!";
$PMF_LANG["ad_passwd_fail"] = "Eski şifre <strong>doğru</strong> girilmeli ve yeni girilenler <strong>eşleşmeli</strong>.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Kullanıcı Ekle";
$PMF_LANG["ad_adus_name"] = "İsim:";
$PMF_LANG["ad_adus_password"] = "Şifre:";
$PMF_LANG["ad_adus_add"] = "Kullanıcıyı ekle";
$PMF_LANG["ad_adus_suc"] = "Kullanıcı <strong>başarıyla</strong> eklendi.";
$PMF_LANG["ad_adus_edit"] = "Profil Düzenle";
$PMF_LANG["ad_adus_dberr"] = "<strong>veritabanı hatası!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Kullanıcı Adı <strong>daha önce </strong> alınmış.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "Oturum ID";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Zaman";
$PMF_LANG["ad_sess_pageviews"] = "Sayfa Görünümleri";
$PMF_LANG["ad_sess_search"] = "Araştır";
$PMF_LANG["ad_sess_sfs"] = "Oturumlarda Araştır";
$PMF_LANG["ad_sess_s_ip"] = "IP:";
$PMF_LANG["ad_sess_s_minct"] = "min. eylemler:";
$PMF_LANG["ad_sess_s_date"] = "Tarih";
$PMF_LANG["ad_sess_s_after"] = "sonra";
$PMF_LANG["ad_sess_s_before"] = "önce";
$PMF_LANG["ad_sess_s_search"] = "Araştır";
$PMF_LANG["ad_sess_session"] = "Oturum";
$PMF_LANG["ad_sess_r"] = "Arama Sonuçları";
$PMF_LANG["ad_sess_referer"] = "İşaret Eden :";
$PMF_LANG["ad_sess_browser"] = "Tarayıcı:";
$PMF_LANG["ad_sess_ai_rubrik"] = "Kategori:";
$PMF_LANG["ad_sess_ai_artikel"] = "Kayıt:";
$PMF_LANG["ad_sess_ai_sb"] = "Arama-Dizileri:";
$PMF_LANG["ad_sess_ai_sid"] = "Oturum ID:";
$PMF_LANG["ad_sess_back"] = "Geri";

// Statistik
$PMF_LANG["ad_rs"] = "Değerlendirme ıstatistikleri";
$PMF_LANG["ad_rs_rating_1"] = "Değerlendirilen";
$PMF_LANG["ad_rs_rating_2"] = "kullanıcılar gösteriyor:";
$PMF_LANG["ad_rs_red"] = "Kırmızı";
$PMF_LANG["ad_rs_green"] = "Yeşil";
$PMF_LANG["ad_rs_altt"] = "ortalama 2'den düşük";
$PMF_LANG["ad_rs_ahtf"] = "ortalama 4'den yüksek";
$PMF_LANG["ad_rs_no"] = "Henüz bir değerlendirme yok";

// Auth
$PMF_LANG["ad_auth_insert"] = "Lütfen kullanıcı adı ve şifrenizi giriniz.";
$PMF_LANG["ad_auth_user"] = "Kullanıcı Adı:";
$PMF_LANG["ad_auth_passwd"] = "Şifre:";
$PMF_LANG["ad_auth_ok"] = "Tamam";
$PMF_LANG["ad_auth_reset"] = "Temizle";
$PMF_LANG["ad_auth_fail"] = "Kullanıcı veya şifre geçerli değil.";
$PMF_LANG["ad_auth_sess"] = "Oturum ID geçti.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Ayarları Düzenle";
$PMF_LANG["ad_config_save"] = "Ayarları Kaydet";
$PMF_LANG["ad_config_reset"] = "Temizle";
$PMF_LANG["ad_config_saved"] = "Ayalar başarıyla kaydedildi.";
$PMF_LANG["ad_menu_editconfig"] = "Ayarları düzenle";
$PMF_LANG["ad_att_none"] = "Hiçbir ek mevcut değil";
$PMF_LANG["ad_att_att"] = "Ekler:";
$PMF_LANG["ad_att_add"] = "Dosya Ekle";
$PMF_LANG["ad_entryins_suc"] = "Kayıt başarıyla kaydedildi.";
$PMF_LANG["ad_entryins_fail"] = "Bir hata oluştu.";
$PMF_LANG["ad_att_del"] = "Sil";
$PMF_LANG["ad_att_nope"] = "Sadece düzenleme esnasında ekleme yapılabilir.";
$PMF_LANG["ad_att_delsuc"] = "Ek başarıyla silindi.";
$PMF_LANG["ad_att_delfail"] = "Ek silinirken bir hata oluştu.";
$PMF_LANG["ad_entry_add"] = "Girdi Oluştur";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "Yedek, veritabanı içeriğinin tamamen bir kopyasıdır. Ayda en az bir kez yedek alınmalıdır. Yedeğin biçimi MySQL ve PhpMyAdmin kullanıcılarının araçlarla inidirebileceği şekilde bir MySQL dosyasıdır.";
$PMF_LANG["ad_csv_link"] = "Yedeği ındir";
$PMF_LANG["ad_csv_head"] = "Yedek Oluştur";
$PMF_LANG["ad_att_addto"] = "Yayına ekleme yap";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Dosya:";
$PMF_LANG["ad_att_butt"] = "Tamam";
$PMF_LANG["ad_att_suc"] = "Dosya başarıyla eklendi.";
$PMF_LANG["ad_att_fail"] = "Dosya eklenirken bir hata oluştu.";
$PMF_LANG["ad_att_close"] = "Pencereyi kapat";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "Bu form ile veritabanı içeriğini, phpmyfaq kullanılarak yapılmış yedeği kullanarak eski haline döndürebilirsiniz. Lütfen, yedeğin mevcut dataların üstüne yazılacağını unutmayın.";
$PMF_LANG["ad_csv_file"] = "Dosya";
$PMF_LANG["ad_csv_ok"] = "Tamam";
$PMF_LANG["ad_csv_linklog"] = "yedek LOG'ları";
$PMF_LANG["ad_csv_linkdat"] = "yedek data";
$PMF_LANG["ad_csv_head2"] = "Eski Haline Çevir";
$PMF_LANG["ad_csv_no"] = "Bu phpmyfaq yedeği gibi görünmüyor.";
$PMF_LANG["ad_csv_prepare"] = "Database sorgulamalarına hazırlanılıyor...";
$PMF_LANG["ad_csv_process"] = "Sorgulanıyor...";
$PMF_LANG["ad_csv_of"] = "-";
$PMF_LANG["ad_csv_suc"] = "başarılı.";
$PMF_LANG["ad_csv_backup"] = "Yedek";
$PMF_LANG["ad_csv_rest"] = "Bir yedeği eskiye çevir";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Yedek";
$PMF_LANG["ad_logout"] = "Oturum başarıyla bitirildi.";
$PMF_LANG["ad_news_add"] = "Haber Ekle";
$PMF_LANG["ad_news_edit"] = "Haberleri Düzenle";
$PMF_LANG["ad_cookie"] = "Cookie'ler";
$PMF_LANG["ad_sess_head"] = "Oturumları Görüntüle";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = "Kategori Yönetimi";
$PMF_LANG["ad_menu_stat"] = "Değerlendirme ıstatistikleri";
$PMF_LANG["ad_kateg_add"] = "Kategori Ekle";
$PMF_LANG["ad_kateg_rename"] = "Düzenle";
$PMF_LANG["ad_adminlog_date"] = "Tarih";
$PMF_LANG["ad_adminlog_user"] = "Kullanıcı";
$PMF_LANG["ad_adminlog_ip"] = "IP-Adresi";

$PMF_LANG["ad_stat_sess"] = "Oturumlar";
$PMF_LANG["ad_stat_days"] = "Günler";
$PMF_LANG["ad_stat_vis"] = "Oturumlar (ziyaretler)";
$PMF_LANG["ad_stat_vpd"] = "Gün başına düşen ziyaret";
$PMF_LANG["ad_stat_fien"] = "Birinci Log";
$PMF_LANG["ad_stat_laen"] = "Son Log";
$PMF_LANG["ad_stat_browse"] = "Oturumlara gözat";
$PMF_LANG["ad_stat_ok"] = "Tamam";

$PMF_LANG["ad_sess_time"] = "Zaman";
$PMF_LANG["ad_sess_sid"] = "Oturum-ID";
$PMF_LANG["ad_sess_ip"] = "IP-Adresi";

$PMF_LANG["ad_ques_take"] = "Soru al ve düzenle";
$PMF_LANG["no_cats"] = "Hiçbir kategori bulunamadı.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Geçersiz kullanıcı veya şifre.";
$PMF_LANG["ad_log_sess"] = "Oturum zaman aşımına uğradı.";
$PMF_LANG["ad_log_edit"] = "\"Kullanıcı Düzenle\"-Takip eden kullanıcı için form: ";
$PMF_LANG["ad_log_crea"] = "\"Yeni makale\" form.";
$PMF_LANG["ad_log_crsa"] = "Yeni girdi oluşturuldu.";
$PMF_LANG["ad_log_ussa"] = "Takip eden kullanıcı için data güncellendi: ";
$PMF_LANG["ad_log_usde"] = "Takip eden kullanıcı silindi: ";
$PMF_LANG["ad_log_beed"] = "Takip eden kullanıcı için formu düzenle: ";
$PMF_LANG["ad_log_bede"] = "Takip eden girdi silindi: ";

$PMF_LANG["ad_start_visits"] = "Ziyaretler";
$PMF_LANG["ad_start_articles"] = "Makaleler";
$PMF_LANG["ad_start_comments"] = "Yorumlar";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "Yapıştır";
$PMF_LANG["ad_categ_cut"] = "Kes";
$PMF_LANG["ad_categ_copy"] = "Kopyala";
$PMF_LANG["ad_categ_process"] = "Kategoriler işleniyor...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Onaylanmadınız.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "önceki sayfa";
$PMF_LANG["msgNextPage"] = "sonraki sayfa";
$PMF_LANG["msgPageDoublePoint"] = "Sayfa: ";
$PMF_LANG["msgMainCategory"] = "Ana kategori";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "şifreniz değiştirildi.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "PDF dosyası olarak göster";
$PMF_LANG["ad_xml_head"] = "XML-Yedek";
$PMF_LANG["ad_xml_hint"] = "SSS kayıtlarının hepsini bir XML dosyaya kaydet.";
$PMF_LANG["ad_xml_gen"] = "XML dosya oluştur";
$PMF_LANG["ad_entry_locale"] = "Dil";
$PMF_LANG["msgLanguageSubmit"] = "Dili değiştir";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Önizleme";
$PMF_LANG["ad_attach_1"] = "Eklerin ayarlamaları için önce bir yol seçin.";
$PMF_LANG["ad_attach_2"] = "Eklerin ayarlamaları için önce bir link seçin.";
$PMF_LANG["ad_attach_3"] = "Dosya eklendi.php uygun yetkilendirme olmadan açılamaz.";
$PMF_LANG["ad_attach_4"] = "Ek dosya %s Byte 'tan küçük olmalıdır.";
$PMF_LANG["ad_menu_export"] = "SSS'ınızı dışarı aktarın";
$PMF_LANG["ad_export_1"] = "RSS-Feed üzerine kur";
$PMF_LANG["ad_export_2"] = ".";
$PMF_LANG["ad_export_file"] = "Hata: Dsya yazılamıyor.";
$PMF_LANG["ad_export_news"] = "RSS-Feed haberler";
$PMF_LANG["ad_export_topten"] = "İlk On RSS-Feed";
$PMF_LANG["ad_export_latest"] = "Son 5 kayıt RSS-Feed";
$PMF_LANG["ad_export_pdf"] = "Tüm kayıtların PDF'sini ihrac et";
$PMF_LANG["ad_export_generate"] = "RSS-Feed kur";

$PMF_LANG["rightsLanguage"]['adduser'] = "Kullanıcı ekle";
$PMF_LANG["rightsLanguage"]['edituser'] = "Kullanıcı düzenle";
$PMF_LANG["rightsLanguage"]['deluser'] = "Kullanıcı sil";
$PMF_LANG["rightsLanguage"]['addbt'] = "Kayıt ekle";
$PMF_LANG["rightsLanguage"]['editbt'] = "Kayıt düzenle";
$PMF_LANG["rightsLanguage"]['delbt'] = "Kayıt sil";
$PMF_LANG["rightsLanguage"]['viewlog'] = "log görüntüle";
$PMF_LANG["rightsLanguage"]['adminlog'] = "admin log'larını görüntüle";
$PMF_LANG["rightsLanguage"]['delcomment'] = "yorum sil";
$PMF_LANG["rightsLanguage"]['addnews'] = "haber ekle";
$PMF_LANG["rightsLanguage"]['editnews'] = "haber düzenle";
$PMF_LANG["rightsLanguage"]['delnews'] = "haber sil";
$PMF_LANG["rightsLanguage"]['addcateg'] = "kategori ekle";
$PMF_LANG["rightsLanguage"]['editcateg'] = "kategori düzenle";
$PMF_LANG["rightsLanguage"]['delcateg'] = "kategori sil";
$PMF_LANG["rightsLanguage"]['passwd'] = "şifre değiştir";
$PMF_LANG["rightsLanguage"]['editconfig'] = "ayar düzenle";
$PMF_LANG["rightsLanguage"]['addatt'] = "ekleme yap";
$PMF_LANG["rightsLanguage"]['delatt'] = "ekleme sil";
$PMF_LANG["rightsLanguage"]['backup'] = "yedek oluştur";
$PMF_LANG["rightsLanguage"]['restore'] = "Yedeği kur";
$PMF_LANG["rightsLanguage"]['delquestion'] = "açık soruları sil";
$PMF_LANG["rightsLanguage"]['changebtrevs'] = "edit revisions";

$PMF_LANG["msgAttachedFiles"] = "eklenen dosyalar:";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "Eylem";
$PMF_LANG["ad_entry_email"] = "E-posta adresi:";
$PMF_LANG["ad_entry_allowComments"] = "yoruma izin ver";
$PMF_LANG["msgWriteNoComment"] = "Bu girdi hakkında yorumda bulunamazsınız";
$PMF_LANG["ad_user_realname"] = "Gerçek isim:";
$PMF_LANG["ad_export_generate_pdf"] = "PDF dosya oluştur";
$PMF_LANG["ad_export_full_faq"] = "SSS'nuz PDF dosya olarak: ";
$PMF_LANG["err_bannedIP"] = "IP adresiniz yasaklanmış.";
$PMF_LANG["err_SaveQuestion"] = "Gerekli alanlar <strong>isminiz</strong>, <strong>email adresiniz</strong> ve <strong>sorunuz</strong>.<br /><br /><a href=\"javascript:history.back();\">bir sayfa geri</a><br /><br />\n";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Font rengi: ";
$PMF_LANG["ad_entry_fontsize"] = "Font boyutu: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array(0 => "select", 1 => "Dil-Dosyası");
$LANG_CONF["main.languageDetection"] = array(0 => "checkbox", 1 => "Otomatik içerik anlaşmasını aktive et");
$LANG_CONF['main.titleFAQ'] = array(0 => "input", 1 => "SSS Başlığı");
$LANG_CONF['main.currentVersion'] = array(0 => "print", 1 => "SSS Sürümü");
$LANG_CONF["main.metaDescription"] = array(0 => "input", 1 => "Sayfa Açıklaması");
$LANG_CONF["main.metaKeywords"] = array(0 => "input", 1 => "Örümcekler içn Anahtar Kelimeler");
$LANG_CONF["main.metaPublisher"] = array(0 => "input", 1 => "Yayıncı Adı");
$LANG_CONF['main.administrationMail'] = array(0 => "input", 1 => "Yönetici E-posta Adresi");
$LANG_CONF["main.contactInformations"] = array(0 => "area", 1 => "İletişim Bilgisi");
$LANG_CONF["main.send2friendText"] = array(0 => "area", 1 => "Arkadaşa gönder sayfası için metin");
$LANG_CONF['records.maxAttachmentSize'] = array(0 => "input", 1 => "Maksimum ek boyutu bayt olarak (maks. %sByte)");
$LANG_CONF["records.disableAttachments"] = array(0 => "checkbox", 1 => "Ekleri girdilerin altına linkle?");
$LANG_CONF["main.enableUserTracking"] = array(0 => "checkbox", 1 => "İzleme kullan?");
$LANG_CONF["main.enableAdminLog"] = array(0 => "checkbox", 1 => "Yönetici kütüğü kullan?");
$LANG_CONF["security.ipCheck"] = array(0 => "checkbox", 1 => "admin.php'de UIN'leri kontrol ederken IP kontrolü de yapılmasını istiyor musunuz?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array(0 => "input", 1 => "Sayfa başına gösterilen konu sayısı");
$LANG_CONF["records.numberOfShownNewsEntries"] = array(0 => "input", 1 => "Haber yazılarının sayısı");
$LANG_CONF['security.bannedIPs'] = array(0 => "area", 1 => "Bu IP'leri karalistele");
$LANG_CONF["main.enableRewriteRules"] = array(0 => "checkbox", 1 => "mod_rewrite desteğini etkinleştir? (varsayılan: kapalı)");
$LANG_CONF["security.ldapSupport"] = array(0 => "checkbox", 1 => "LDAP desteğini etkinleştir? (varsayılan: kapalı)");
$LANG_CONF["main.referenceURL"] = array(0 => "input", 1 => "Link kontrolü için baz URL (örn.: http://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array(0 => "input", 1 => "AJAX link kontrolü zaman aralığı (saniye olarak)");
$LANG_CONF["records.enableVisibilityQuestions"] = array(0 => "checkbox", 1 => "Yeni soruların görünürlüğünü kapat?");
$LANG_CONF['security.permLevel'] = array(0 => "select", 1 => "İzin düzeyi");

$PMF_LANG["ad_categ_new_main_cat"] = "yeni ana kategori olarak";
$PMF_LANG["ad_categ_paste_error"] = "Bu kategori taşınamaz.";
$PMF_LANG["ad_categ_move"] = "Taşı";
$PMF_LANG["ad_categ_lang"] = "Dil";
$PMF_LANG["ad_categ_desc"] = "Açıklama";
$PMF_LANG["ad_categ_change"] = "Birlikte değiştir";

$PMF_LANG["lostPassword"] = "Şifrenizi unuttuysanız buraya tıklayın.";
$PMF_LANG["lostpwd_err_1"] = "Hata: Kullanıcı adı ve e-mail bulunamadı.";
$PMF_LANG["lostpwd_err_2"] = "Hata: Yanlış girdiler!";
$PMF_LANG["lostpwd_text_1"] = "Hesap bilginizi istediğiniz için teşekkürler.";
$PMF_LANG["lostpwd_text_2"] = "SSS'nuzun admin bölümünden yeni bir kişisel şifre oluşturunuz.";
$PMF_LANG["lostpwd_mail_okay"] = "E-Mail gönderildi.";

$PMF_LANG["ad_xmlrpc_button"] = "Web servisimden son phpMyFAQ versiyon numarasını al";
$PMF_LANG["ad_xmlrpc_latest"] = "Son versiyonu edinebileceğiniz yer";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Kategori dilini seç';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'Site haritası';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'Bu girdi güncellemede ve gösterilemez.';
$PMF_LANG['msgArticleCategories'] = 'Bu girdi için kategoriler';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'Özgün çözüm ID';
$PMF_LANG['ad_entry_faq_record'] = 'SSS kaydı';
$PMF_LANG['ad_entry_new_revision'] = 'Yeni sürüm yarat?';
$PMF_LANG['ad_entry_record_administration'] = 'Kayıt yönetimi';
$PMF_LANG['ad_entry_changelog'] = 'Değişiklik kütüğü';
$PMF_LANG['ad_entry_revision'] = 'Sürüm';
$PMF_LANG['ad_changerev'] = 'Sürüm seç';
$PMF_LANG['msgCaptcha'] = "Lütfen resimdeki karakterleri giriniz";
$PMF_LANG['msgSelectCategories'] = 'İçinde aranacak ...';
$PMF_LANG['msgAllCategories'] = '... bütün kategoriler';
$PMF_LANG['ad_you_should_update'] = 'phpMyFAQ kurulumuz eski. Mevcut en son sürüme güncellemelisiniz.';
$PMF_LANG['msgAdvancedSearch'] = 'Gelişmiş arama';

// added v1.6.1 - 2006-04-25 by Matteo and Thorsten
$PMF_LANG['spamControlCenter'] = 'Spam kontrol merkezi';
$LANG_CONF["spam.enableSafeEmail"] = array(0 => "checkbox", 1 => "Kullanıcı e-posta adresini güvenli şekilde göster (varsayılan: aktif).");
$LANG_CONF["spam.checkBannedWords"] = array(0 => "checkbox", 1 => "Form içeriğinde karalistelenmiş kelimeleri kontrol et (varsayılan: aktif).");
$LANG_CONF["spam.enableCaptchaCode"] = array(0 => "checkbox", 1 => "Form gönderimini doğrulama kodu (CAPTCHA) ile koru (varsayılan: aktif).");
$PMF_LANG['ad_session_expiring'] = 'Oturumunuz %d dakika sonra sona erecek: çalışmaya devam etmek istiyor musunuz?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Oturum yönetimi';
$PMF_LANG['ad_stat_choose'] = 'Ay seç';
$PMF_LANG['ad_stat_delete'] = 'Seçili oturumları hemen sil';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'Sözlük';
$PMF_LANG['ad_glossary_add'] = 'Sözlük girdisi ekle';
$PMF_LANG['ad_glossary_edit'] = 'Sözlük girdisini düzenle';
$PMF_LANG['ad_glossary_item'] = 'Girdi';
$PMF_LANG['ad_glossary_definition'] = 'Açıklama';
$PMF_LANG['ad_glossary_save'] = 'Girdiyi kaydet';
$PMF_LANG['ad_glossary_save_success'] = 'Sözlük girdisi başarı ile kaydedildi!';
$PMF_LANG['ad_glossary_save_error'] = 'Sözlük girdisi bir hatadan dolayı kaydedilemedi.';
$PMF_LANG['ad_glossary_update_success'] = 'Sözlük girdisi başarı ile güncellendi!';
$PMF_LANG['ad_glossary_update_error'] = 'Sözlük girdisi bir hatadan dolayı güncellenemedi.';
$PMF_LANG['ad_glossary_delete'] = 'Girdiyi sil';
$PMF_LANG['ad_glossary_delete_success'] = 'Sözlük girdisi başarı ile silindi!';
$PMF_LANG['ad_glossary_delete_error'] = 'Sözlük girdisi silinemedi çünkü bir hata oluştu.';
$PMF_LANG['ad_linkcheck_noReferenceURL'] = 'Otomatik link kontrolü kapatıldı (Link kontrolü baz URL\'si ayarlı değil)';
$PMF_LANG['ad_linkcheck_noAllowUrlOpen'] = 'Otomatik link kontrolü kapatıldı (PHP ayarı allow_url_fopen aktif değil)';
$PMF_LANG['ad_linkcheck_checkResult'] = 'Otomatik link kontrol sonucu';
$PMF_LANG['ad_linkcheck_checkSuccess'] = 'TAMAM';
$PMF_LANG['ad_linkcheck_checkFailed'] = 'Başarısız';
$PMF_LANG['ad_linkcheck_failReason'] = 'Başarısız olma neden(ler)i:';
$PMF_LANG['ad_linkcheck_noLinksFound'] = 'Link kontrol özelliği ile uyumlu URL bulunamadı.';
$PMF_LANG['ad_linkcheck_searchbadonly'] = 'Sadece kötü linkler';
$PMF_LANG['ad_linkcheck_infoReason'] = 'Ek Bilgi:';
$PMF_LANG['ad_linkcheck_openurl_infoprefix'] = '<strong>%s</strong> test edilirken bulundu: ';
$PMF_LANG['ad_linkcheck_openurl_notready'] = 'LinkKontrolEdici hazır değil.';
$PMF_LANG['ad_linkcheck_openurl_maxredirect'] = 'Maksimum yönlendirme sayısı <strong>%d</strong> aşıldı.';
$PMF_LANG['ad_linkcheck_openurl_urlisblank'] = 'Boş URL\'ye çözümlendi.';
$PMF_LANG['ad_linkcheck_openurl_tooslow'] = '<strong>%s</strong> sunucusu yavaş veya cevap vermiyor.';
$PMF_LANG['ad_linkcheck_openurl_nodns'] = '<strong>%s</strong> sunucusu DNS çözümlemesi slow veya lokal veya uzaktaki DNS sorunları nedeniyle başarısız.';
$PMF_LANG['ad_linkcheck_openurl_redirected'] = 'URL\'nin yönlendirildiği yer: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_ambiguous'] = 'HTTP <strong>%s</strong> durumu geri dönüldü.';
$PMF_LANG['ad_linkcheck_openurl_not_allowed'] = '<em>HEAD</em> metodu <strong>%s</strong> makine tarafından desteklenmiyor, izin verilen metodlar: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_found'] = 'Bu kaynak <strong>%s</strong> makinesinde bulunamıyor.';
$PMF_LANG['ad_linkcheck_protocol_unsupported'] = '%s protokolü otomatik link kontrolü tarafından desteklenmiyor.';
$PMF_LANG['msgNewQuestionVisible'] = 'Soru halka açık hale gelmeden önce incelenmelidir.';
$PMF_LANG['msgQuestionsWaiting'] = 'Yönetici tarafından yayınlama bekleniyor: ';
$PMF_LANG['ad_entry_visibility'] = 'Yayınla?';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] =  "Şifre giriniz. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] =  "Şifreler uyuşmuyor. ";
$PMF_LANG['ad_user_error_loginInvalid'] =  "Belirtilen kullanıcı adı geçersiz.";
$PMF_LANG['ad_user_error_noEmail'] =  "Geçerli bir e-posta adresi giriniz. ";
$PMF_LANG['ad_user_error_noRealName'] =  "Adınızı giriniz. ";
$PMF_LANG['ad_user_error_delete'] =  "Kullanıcı hesabı silinemedi. ";
$PMF_LANG['ad_user_error_noId'] =  "ID belirtilmedi. ";
$PMF_LANG['ad_user_error_protectedAccount'] =  "Kullanıcı hesabı korumalı. ";
$PMF_LANG['ad_user_deleteUser'] = "Kullanıcıyı Sil";
$PMF_LANG['ad_user_status'] = "Durum:";
$PMF_LANG['ad_user_lastModified'] = "Son değişiklik:";
$PMF_LANG['ad_gen_cancel'] = "İptal";
$PMF_LANG["rightsLanguage"]['addglossary'] = "sözlük girdisi ekle";
$PMF_LANG["rightsLanguage"]['editglossary'] = "sözlük girdisini düzenle";
$PMF_LANG["rightsLanguage"]['delglossary'] = "sözlük girdisini sil";
$PMF_LANG["ad_menu_group_administration"] = "Gruplar";
$PMF_LANG['ad_user_loggedin'] = 'Kullanıcı adınız ';

$PMF_LANG['ad_group_details'] = "Grup Detayları";
$PMF_LANG['ad_group_add'] = "Grup Ekle";
$PMF_LANG['ad_group_add_link'] = "Grup Ekle";
$PMF_LANG['ad_group_name'] = "Ad:";
$PMF_LANG['ad_group_description'] = "Açıklama:";
$PMF_LANG['ad_group_autoJoin'] = "Otomatik-birleştirme:";
$PMF_LANG['ad_group_suc'] = "Grup <strong>başarı ile</strong> eklendi.";
$PMF_LANG['ad_group_error_noName'] = "Bir grup adı girin. ";
$PMF_LANG['ad_group_error_delete'] = "Grup silinemiyor. ";
$PMF_LANG['ad_group_deleted'] = "The group was successfully deleted.";
$PMF_LANG['ad_group_deleteGroup'] = "Grubu Sil";
$PMF_LANG['ad_group_deleteQuestion'] = "Bu grubu silmek istediğinize emin misiniz??";
$PMF_LANG['ad_user_uncheckall'] = "Hiçbirini Seçme";
$PMF_LANG['ad_group_membership'] = "Grup Üyeliği";
$PMF_LANG['ad_group_members'] = "Üyeler";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'Dışarı aktarılacak SSS verisini limitle (opsiyonel)';
$PMF_LANG['ad_export_cat_downwards'] = 'Aşağı doğru?';
$PMF_LANG['ad_export_type'] = 'Dışarı aktarma biçimi';
$PMF_LANG['ad_export_type_choose'] = 'Desteklerden biçimlerden birini seçin:';
$PMF_LANG['ad_export_download_view'] = 'İndir veya iç sıralı göster?';
$PMF_LANG['ad_export_download'] = 'indir';
$PMF_LANG['ad_export_view'] = 'iç sıralı göster';
$PMF_LANG['ad_export_gen_xhtml'] = 'XHTML dosyası yap';
$PMF_LANG['ad_export_gen_docbook'] = 'Docbook dosyası yap';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'News data';
$PMF_LANG['ad_news_author_name'] = 'Yazar adı:';
$PMF_LANG['ad_news_author_email'] = 'Yazar e-postası:';
$PMF_LANG['ad_news_set_active'] = 'Aktifleştir';
$PMF_LANG['ad_news_allowComments'] = 'Yorumlara izin ver:';
$PMF_LANG['ad_news_expiration_window'] = 'Haber zaman aşımı penceresi (opsiyonel)';
$PMF_LANG['ad_news_from'] = 'Kimden:';
$PMF_LANG['ad_news_to'] = 'Kime:';
$PMF_LANG['ad_news_insertfail'] = 'Haber maddesi veritabanına eklenirken bir problem oluştu.';
$PMF_LANG['ad_news_updatefail'] = 'Haber maddesi veritabanında güncellenirken bir problem oluştu.';
$PMF_LANG['newsShowCurrent'] = 'Güncel haberleri göster.';
$PMF_LANG['newsShowArchive'] = 'Arşivlenmiş haberleri göster.';
$PMF_LANG['newsArchive'] = ' Haber arşivi';
$PMF_LANG['newsWriteComment'] = 'bu girdinin yorumu';
$PMF_LANG['newsCommentDate'] = 'Ekleme tarihi: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'Kayıt zaman aşımı penceresi (opsiyonel)';
$PMF_LANG['admin_mainmenu_home'] = 'Anasayfa';
$PMF_LANG['admin_mainmenu_users'] = 'Kullanıcılar';
$PMF_LANG['admin_mainmenu_content'] = 'İçerik';
$PMF_LANG['admin_mainmenu_statistics'] = 'İstatistikler';
$PMF_LANG['admin_mainmenu_exports'] = 'Dışarı aktar';
$PMF_LANG['admin_mainmenu_backup'] = 'Yedekle';
$PMF_LANG['admin_mainmenu_configuration'] = 'Ayarlar';
$PMF_LANG['admin_mainmenu_logout'] = 'Çıkış';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'Kategori sahibi';
$PMF_LANG['adminSection'] = 'Yönetim';
$PMF_LANG['err_expiredArticle'] = 'Bu girdi zaman aşımına uğradı ve gösterilemez';
$PMF_LANG['err_expiredNews'] = 'Bu haber zaman aşımına uğradı ve gösterilemez';
$PMF_LANG['err_inactiveNews'] = 'Bu haber güncellemede ve gösterilemez';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Bütün dillerde ara:';
$PMF_LANG['ad_entry_tags'] = 'Etiketler';
$PMF_LANG['msg_tags'] = 'Etiketler';

// added v2.0.0 - 2006-09-03 by Matteo
$PMF_LANG['ad_linkcheck_feedback_url-batch1'] = 'Kontrol ediliyor...';
$PMF_LANG['ad_linkcheck_feedback_url-batch2'] = 'Kontrol ediliyor...';
$PMF_LANG['ad_linkcheck_feedback_url-batch3'] = 'Kontrol ediliyor...';
$PMF_LANG['ad_linkcheck_feedback_url-checking'] = 'Kontrol ediliyor...';
$PMF_LANG['ad_linkcheck_feedback_url-disabled'] = 'Kapalı';
$PMF_LANG['ad_linkcheck_feedback_url-linkbad'] = 'Link KO';
$PMF_LANG['ad_linkcheck_feedback_url-linkok'] = 'Link OK';
$PMF_LANG['ad_linkcheck_feedback_url-noaccess'] = 'No access';
$PMF_LANG['ad_linkcheck_feedback_url-noajax'] = 'AJAX Yok';
$PMF_LANG['ad_linkcheck_feedback_url-nolinks'] = 'Link Yok';
$PMF_LANG['ad_linkcheck_feedback_url-noscript'] = 'Betik Yok';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = 'İlişkili girdiler';
$LANG_CONF['records.numberOfRelatedArticles'] = array(0 => "input", 1 => "İlişkili girdi sayısı");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'Tercüme';
$PMF_LANG['ad_categ_trans_2'] = 'Kategori';
$PMF_LANG['ad_categ_translatecateg'] = 'Kategori Tercümesi';
$PMF_LANG['ad_categ_translate'] = 'Tercüme';
$PMF_LANG['ad_categ_transalready'] = 'Zaten tercüme edildiği yer: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Bütün dillerde sil?';
$PMF_LANG["ad_categ_deletethislang"] = 'Sadece bu dilde sil?';
$PMF_LANG["ad_categ_translated"] = "Kategori tercüme edildi.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["ad_categ_show"] = "Tanıtım";
$PMF_LANG['ad_menu_categ_structure'] = "Kendi Dillerini İçeren Kategori Tanıtımı";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'Kullanıcı izinleri:';
$PMF_LANG['ad_entry_grouppermission'] = 'Grup izinleri:';
$PMF_LANG['ad_entry_all_users'] = 'Bütün kullanıcılara erişim';
$PMF_LANG['ad_entry_restricted_users'] = 'Kısıtlı erişim: ';
$PMF_LANG['ad_entry_all_groups'] = 'Bütün gruplara erişim';
$PMF_LANG['ad_entry_restricted_groups'] = 'Kısıtlı erişim: ';
$PMF_LANG['ad_session_expiration'] = 'Oturum bitiş zamanı';
$PMF_LANG['ad_user_active'] = 'aktif';
$PMF_LANG['ad_user_blocked'] = 'bloklanmış';
$PMF_LANG['ad_user_protected'] = 'korumalı';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = 'Link olarak koymak istediğiniz SSS kaydını seçin...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Bundan sonra yapıştır: ";
$PMF_LANG["ad_categ_remark_move"] = "2 kategorinin yer değiştirmesi sadece aynı hizada mümkündür.";
$PMF_LANG["ad_categ_remark_overview"] = "The correct order of categories will be shown, if all categories are defined for the actual language (first column).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = '%d Misafir ve %d Kayıtlı';
$PMF_LANG['ad_adminlog_del_older_30d'] = '30 günden eski kütükleri sil';
$PMF_LANG['ad_adminlog_delete_success'] = 'Eski kütükler başarı ile silindi.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'Kütükler silinmedi: istek işlenirken bir hata oluştu.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['opensearch_plugin_install'] = 'arama eklentisi ekle';
$PMF_LANG['ad_quicklinks'] = 'Hızlı Linkler';
$PMF_LANG['ad_quick_category'] = 'Yeni kategori ekle';
$PMF_LANG['ad_quick_record'] = 'Yeni SSS kaydı ekle';
$PMF_LANG['ad_quick_user'] = 'Yeni kullanıcı ekle';
$PMF_LANG['ad_quick_group'] = 'Yeni grup ekle';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'Tercüme önerisi';
$PMF_LANG['msgNewTranslationAddon'] = 'Öneriniz hemen yayınlanmayacak, ancak yönetici tarafından kontrol edildikten sonra yayınlanacaktır. Gerekli bölümler, <strong>adınız</strong>, <strong>e-posta adresiniz</strong>, <strong>başlık tercümeniz</strong> ve <strong>sss tercümesi</strong>. Anahtar kelimeleri sadece boşluk ile ayırınız.';
$PMF_LANG['msgNewTransSourcePane'] = 'Kaynak paneli';
$PMF_LANG['msgNewTranslationPane'] = 'Tercüme paneli';
$PMF_LANG['msgNewTranslationName'] = "Your Name:";
$PMF_LANG['msgNewTranslationMail'] = "Your email address:";
$PMF_LANG['msgNewTranslationKeywords'] = "Keywords:";
$PMF_LANG['msgNewTranslationSubmit'] = 'Önerinizi gönderin';
$PMF_LANG['msgTranslate'] = 'Tercüme öner:';
$PMF_LANG['msgTranslateSubmit'] = 'Tercümeye başla...';
$PMF_LANG['msgNewTranslationThanks'] = "Tercüme öneriniz için teşekkür ederiz!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG["rightsLanguage"]['addgroup'] = "grup hesapları ekle";
$PMF_LANG["rightsLanguage"]['editgroup'] = "grup hesaplarını düzenle";
$PMF_LANG["rightsLanguage"]['delgroup'] = "grup hesaplarını sil";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = 'Link ana pencerede açılır';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'Yorumlar';
$PMF_LANG['ad_comment_administration'] = 'Yorum yönetimi';
$PMF_LANG['ad_comment_faqs'] = 'SSS kayıtlarındaki yorumlar:';
$PMF_LANG['ad_comment_news'] = 'Yeni kayıtlardaki yorumlar:';
$PMF_LANG['ad_groups'] = 'Gruplar';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array(0 => 'select', 1 => 'Kayıt sıralama (özelliğe göre)');
$LANG_CONF['records.sortby'] = array(0 => 'select', 1 => 'Kayıt sıralama (büyükten küçüğe veya küçükten büyüğe)');
$PMF_LANG['ad_conf_order_id'] = 'ID (varsayılan)';
$PMF_LANG['ad_conf_order_thema'] = 'Başlık';
$PMF_LANG['ad_conf_order_visits'] = 'Ziyaretçi sayısı';
$PMF_LANG['ad_conf_order_updated'] = 'Tarih';
$PMF_LANG['ad_conf_order_author'] = 'Yazar';
$PMF_LANG['ad_conf_desc'] = 'büyükten küçüğe';
$PMF_LANG['ad_conf_asc'] = 'küçükten büyüğe';
$PMF_LANG['mainControlCenter'] = 'Ana ayarlar';
$PMF_LANG['recordsControlCenter'] = 'SSS kayıt ayarları';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array(0 => "checkbox", 1 => "Yeni kayıtları aktifleştir (varsayılan: kapalı)");
$LANG_CONF['records.defaultAllowComments'] = array(0 => "checkbox", 1 => "Yeni kayıtlar için yorumlara izin ver (varsayılan: yasak)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'Bu kategorideki kayıtlar';
$PMF_LANG['msgTagSearch'] = 'Etiketlenmiş girdiler';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ Bilgisi';
$PMF_LANG['ad_online_info'] = 'Online sürüm kontrolü';
$PMF_LANG['ad_system_info'] = 'Sistem Bilgisi';

// added 2.5.0-alpha - 2008-01-25 by Elger
$PMF_LANG['msgRegisterUser'] = 'Kayıt olmak istiyor musunuz?';
$PMF_LANG["ad_user_loginname"] = 'Kullanıcı adı:';
$PMF_LANG['errorRegistration'] = 'Bu bölümün doldurulması gerekli!';
$PMF_LANG['submitRegister'] = 'Kayıt ol';
$PMF_LANG['msgUserData'] = 'Kayıt için gerekli kullanıcı bilgileri	';
$PMF_LANG['captchaError'] = 'Lütfen doğrulama (CAPTCHA) kodunu giriniz!';
$PMF_LANG['msgRegError'] = 'Hatalar oluştu. Lütfen hataları düzeltin:';
$PMF_LANG['successMessage'] = 'Kayıt işleminiz başarılı oldu. Kısa bir süre içinde sisteme giriş bilgilerinizi içeren onay e-postası alacaksınız.!';
$PMF_LANG['msgRegThankYou'] = 'Thank you for your registration';
$PMF_LANG['emailRegSubject'] = '[%sitename%] Registration: new user';

// added 2.5.0-alpha2 - 2009-01-24 by Thorsten
$PMF_LANG['msgMostPopularSearches'] = 'En popüler aramalar:';
$LANG_CONF['main.enableWysiwygEditor'] = array(0 => "checkbox", 1 => "Enable bundled WYSIWYG editor (default: enabled)");

// added 2.5.0-beta - 2009-03-30 by Anatoliy
$PMF_LANG['ad_menu_searchstats'] = 'İstatistikleri Ara';
$PMF_LANG['ad_searchstats_search_term'] = 'Anahtar Kelime';
$PMF_LANG['ad_searchstats_search_term_count'] = 'Sayım';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'Dil';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'Yüzde';

// added 2.5.0-beta - 2009-03-31 by Anatoliy
$PMF_LANG['ad_record_sticky'] = 'Yapışkan';
$PMF_LANG['ad_entry_sticky'] = 'Yapışkan';
$PMF_LANG['stickyRecordsHeader'] = 'Yapışkan SSS\'lar';

// added 2.5.0-beta - 2009-04-01 by Anatoliy
$PMF_LANG['ad_menu_stopwordsconfig'] = 'Stop Words';
$PMF_LANG['ad_config_stopword_input'] = 'Add new stop word';

// added 2.5.0-beta - 2009-04-06 by Anatoliy
$PMF_LANG['msgSendMailDespiteEverything'] = 'Hayır, cevap mevcut değil (e-posta göndereceğim)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'İstenilen cevap yukarıdaki sonuçlarda mevcut mu?';

// added 2.5.0-RC - 2009-05-11 by Anatoliy & Thorsten
$PMF_LANG['msgChooseLanguageToTranslate'] = 'Lütfen tercüme için dil seçin';
$PMF_LANG['msgLangDirIsntWritable'] = 'Tercümeler dizine yazma hakkı yok';
$PMF_LANG['ad_menu_translations'] = 'Arayüz Tercümesi';
$PMF_LANG['ad_start_notactive'] = 'Aktivasyon bekleniyor';

// added 2.5.0-RC - 2009-05-20 by Anatoliy
$PMF_LANG['msgTransToolAddNewTranslation'] = 'Yeni tercüme ekle';
$PMF_LANG['msgTransToolLanguage'] = 'Dil';
$PMF_LANG['msgTransToolActions'] = 'İşlemler';
$PMF_LANG['msgTransToolWritable'] = 'Yazılabilir';
$PMF_LANG['msgEdit'] = 'Düzenle';
$PMF_LANG['msgDelete'] = 'Sil';
$PMF_LANG['msgYes'] = 'evet';
$PMF_LANG['msgNo'] = 'hayır';
$PMF_LANG['msgTransToolSureDeleteFile'] = 'Bu dil dosasını silmek istediğinize emin misiniz?';
$PMF_LANG['msgTransToolFileRemoved'] = 'Dil dosyası başarı ile kaldırıldı';
$PMF_LANG['msgTransToolErrorRemovingFile'] = 'Dil dosyası kaldırılamadı';
$PMF_LANG['msgVariable'] = 'Değişken';
$PMF_LANG['msgCancel'] = 'İptal';
$PMF_LANG['msgSave'] = 'Kaydet';
$PMF_LANG['msgSaving3Dots'] = 'kaydediliyor ...';
$PMF_LANG['msgRemoving3Dots'] = 'kaldırılıyor ...';
$PMF_LANG['msgTransToolFileSaved'] = 'Dil dosyası başarı ile kaydedildi';
$PMF_LANG['msgTransToolErrorSavingFile'] = 'Dil dosyasını kaydedilemedi';
$PMF_LANG['msgLanguage'] = 'Dil';
$PMF_LANG['msgTransToolLanguageCharset'] = 'Dil karakter seti';
$PMF_LANG['msgTransToolLanguageDir'] = 'Dil yönü';
$PMF_LANG['msgTransToolLanguageDesc'] = 'Dil açıklaması';
$PMF_LANG['msgAuthor'] = 'Yazar: ';
$PMF_LANG['msgTransToolAddAuthor'] = 'Yazar ekle';
$PMF_LANG['msgTransToolCreateTranslation'] = 'Tercüme Yarat';
$PMF_LANG['msgTransToolTransCreated'] = 'Yeni tercüme başarı ile yaratıldı';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'Yeni tercüme yaratılamadı';
$PMF_LANG['msgAdding3Dots'] = 'ekleniyor ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'phpMyFAQ takımına gönder';
$PMF_LANG['msgSending3Dots'] = 'gönderiliyor ...';
$PMF_LANG['msgTransToolFileSent'] = 'Dil dosyası başarı ile phpMyFAQ takımına gönderildi. Paylaştığınız için teşekkür ederiz.';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'Dil dosayası gönderilirken bir hata oluştu.';
$PMF_LANG['msgTransToolPercent'] = 'Yüzde';
