<?php

/**
 * Norwegian Bokmål language file
 *
 * PHP Version 5.5
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @category  phpMyFAQ
 * @author    Hans Fredrik Nordhaug <hans@nordhaug.priv.no>
 * @copyright 2005-2018 phpMyFAQ Team
 * @license   http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link      http://www.phpmyfaq.de
 * @since     2005-08-31
 */

$PMF_LANG['metaCharset'] = 'utf-8';
$PMF_LANG['metaLanguage'] = 'nb';
$PMF_LANG['language'] = 'Norsk bokmål';
$PMF_LANG['dir'] = 'ltr';
$PMF_LANG['nplurals'] = '2';
$PMF_LANG['msgCategory'] = 'Kategorier';
$PMF_LANG['msgShowAllCategories'] = 'Vis alle kategorier';
$PMF_LANG['msgSearch'] = 'Søk';
$PMF_LANG['msgAddContent'] = 'Legg inn Spørsmål+Svar(FAQ)';
$PMF_LANG['msgQuestion'] = 'Still spørsmål';
$PMF_LANG['msgOpenQuestions'] = 'Ubesvarte spørsmål';
$PMF_LANG['msgHelp'] = 'Hjelp';
$PMF_LANG['msgContact'] = 'Kontakt';
$PMF_LANG['msgHome'] = 'Til forsiden';
$PMF_LANG['msgNews'] = ' Nyheter';
$PMF_LANG['msgUserOnline'] = ' brukere online';
$PMF_LANG['msgBack2Home'] = 'tilbake til forsiden';
$PMF_LANG['msgFullCategories'] = 'Kategorier med innhold';
$PMF_LANG['msgFullCategoriesIn'] = 'kategorier med innhold i  ';
$PMF_LANG['msgSubCategories'] = 'underkategorier';
$PMF_LANG['msgEntries'] = 'Innlegg';
$PMF_LANG['msgEntriesIn'] = 'Innlegg i ';
$PMF_LANG['msgViews'] = 'visninger';
$PMF_LANG['msgPage'] = 'Side ';
$PMF_LANG['msgPages'] = 'Sider';
$PMF_LANG['msgPrevious'] = 'foregående';
$PMF_LANG['msgNext'] = 'neste';
$PMF_LANG['msgCategoryUp'] = 'en kategori opp';
$PMF_LANG['msgLastUpdateArticle'] = 'Siste oppdatering: ';
$PMF_LANG['msgAuthor'] = 'Forfatter: ';
$PMF_LANG['msgPrinterFriendly'] = 'Utskriftsvennligversjon';
$PMF_LANG['msgPrintArticle'] = 'Skriv ut dette svaret';
$PMF_LANG['msgMakeXMLExport'] = 'Eksporter som XML-fil';
$PMF_LANG['msgAverageVote'] = 'Gjennomsnittlig vurdering:';
$PMF_LANG['msgVoteUseability'] = 'Vurder dette innlegget:';
$PMF_LANG['msgVoteFrom'] = 'fra';
$PMF_LANG['msgVoteBad'] = 'fullstendig ubrukelig';
$PMF_LANG['msgVoteGood'] = 'meget nyttig';
$PMF_LANG['msgVotings'] = 'Stemmer ';
$PMF_LANG['msgVoteSubmit'] = 'Stem';
$PMF_LANG['msgVoteThanks'] = 'Mange takk for din stemme!';
$PMF_LANG['msgYouCan'] = 'Du kan ';
$PMF_LANG['msgWriteComment'] = 'kommentere dette svaret';
$PMF_LANG['msgShowCategory'] = 'Innholdsoversikt: ';
$PMF_LANG['msgCommentBy'] = 'Kommentar fra  ';
$PMF_LANG['msgCommentHeader'] = 'Kommentar til dette innlegget';
$PMF_LANG['msgYourComment'] = 'Dine kommentarer:';
$PMF_LANG['msgCommentThanks'] = 'Mange takk for din kommentar!';
$PMF_LANG['msgSeeXMLFile'] = 'Åpne XML-fil';
$PMF_LANG['msgSend2Friend'] = 'Send til en venn';
$PMF_LANG['msgS2FName'] = 'Ditt navn:';
$PMF_LANG['msgS2FEMail'] = 'Din e-postadresse:';
$PMF_LANG['msgS2FFriends'] = 'Dine venners:';
$PMF_LANG['msgS2FEMails'] = '. e-postadresser:';
$PMF_LANG['msgS2FText'] = 'Følgende tekst vil bli sendt:';
$PMF_LANG['msgS2FText2'] = 'Du vil finne innlegget på følgende adresse:';
$PMF_LANG['msgS2FMessage'] = 'Ytterligere informasjon til dine venner:';
$PMF_LANG['msgS2FButton'] = 'send e-post';
$PMF_LANG['msgS2FThx'] = 'Takk for din anbefaling!';
$PMF_LANG['msgS2FMailSubject'] = 'Anbefaling fra ';
$PMF_LANG['msgSearchWord'] = 'Søkeord';
$PMF_LANG['msgSearchFind'] = 'Søkeresultat for ';
$PMF_LANG['msgSearchAmount'] = ' søkeresultat';
$PMF_LANG['msgSearchAmounts'] = ' søkeresultater';
$PMF_LANG['msgSearchCategory'] = 'Kategori: ';
$PMF_LANG['msgSearchContent'] = 'innhold: ';
$PMF_LANG['msgNewContentHeader'] = 'Forslag til OSS';
$PMF_LANG['msgNewContentAddon'] = 'Innlegget ditt (OSSen) blir offenliggjort så snart det er gjennomlest av en administrator. <br />Nødvendige felt: <strong>ditt navn</strong>, <strong>din e-postadresse</strong>, <strong>kategori</strong>, <strong>overskrift</strong> og <strong>ditt forslag</strong>.<br />Skill nøkkelord med mellomrom (ikke bruk komma).';
$PMF_LANG['msgNewContentName'] = 'Ditt navn:';
$PMF_LANG['msgNewContentMail'] = 'Din e-postadresse';
$PMF_LANG['msgNewContentCategory'] = 'Velg kategori:';
$PMF_LANG['msgNewContentTheme'] = 'Ditt spørsmål:';
$PMF_LANG['msgNewContentArticle'] = 'Ditt svar:';
$PMF_LANG['msgNewContentKeywords'] = 'Nøkkelord:';
$PMF_LANG['msgNewContentLink'] = 'URL til dette innlegget:';
$PMF_LANG['msgNewContentSubmit'] = 'Send';
$PMF_LANG['msgInfo'] = 'Ytterligere informasjon: ';
$PMF_LANG['msgNewContentThanks'] = 'Takk for forslaget!';
$PMF_LANG['msgNoQuestionsAvailable'] = 'Der er for tiden ingen ubesvarte spørsmål.';
$PMF_LANG['msgNewQuestion'] = 'Still ditt spørsmål nedenfor:';
$PMF_LANG['msgAskCategory'] = 'Kategori:';
$PMF_LANG['msgAskYourQuestion'] = 'Ditt spørsmål:';
$PMF_LANG['msgAskThx4Mail'] = 'Takk for at du stilte spørsmålet!';
$PMF_LANG['msgDate_User'] = 'Dato / Bruker';
$PMF_LANG['msgQuestion2'] = 'Spørsmål';
$PMF_LANG['msg2answer'] = 'Svar';
$PMF_LANG['msgQuestionText'] = 'Her kan du se spørsmål stilt av andre brukere. Hvis du besvarer et spørsmål, blir kanskje nettopp ditt svar brukt i OSSen.';
$PMF_LANG['msgHelpText'] = 'Strukturen i denne OSS (<strong>O</strong>fte <strong>S</strong>tilte <strong>S</strong>pøsrmål) / FAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions) er virkelig enkel. Du kan enten søke i <strong><a href="?action=show">kategoriene</a></strong> eller etter <strong><a href="?action=search">nøkkelord</a></strong>.';
$PMF_LANG['msgContactEMail'] = 'Send e-post til webmaster:';
$PMF_LANG['msgMessage'] = 'Din melding:';
$PMF_LANG['msgTopTen'] = 'TOPP 10';
$PMF_LANG['msgHomeThereAre'] = 'Der er ';
$PMF_LANG['msgHomeArticlesOnline'] = ' aktive spørsmål';
$PMF_LANG['msgNoNews'] = 'Ingen nyheter er gode nyheter.';
$PMF_LANG['msgLatestArticles'] = 'De nyeste spørsmålene:';
$PMF_LANG['msgMailThanks'] = 'Tusen takk for ditt innlegg.';
$PMF_LANG['msgMailCheck'] = 'Det er et nytt innlegg i OSS! Kontroller administratorsiden!';
$PMF_LANG['msgMailContact'] = 'Din beskjed er sendt til administrator.';
$PMF_LANG['err_noDatabase'] = 'Ingen databaseforbindelse tilgjengelig.';
$PMF_LANG['err_noHeaders'] = 'Ingen kategori funnet.';
$PMF_LANG['err_noArticles'] = 'Ingen innlegg funnet.';
$PMF_LANG['err_badID'] = 'Feil ID.';
$PMF_LANG['err_noTopTen'] = 'Ikke nok innlegg til en Topp 10.';
$PMF_LANG['err_nothingFound'] = 'Ingen innlegg funnet.';
$PMF_LANG['err_SaveEntries'] = 'Påkrevde felt: <strong>ditt navn</strong>, <strong>din e-postadresse</strong>, <strong>kategori</strong>, <strong>overskrift</strong> og <strong>ditt innlegg</strong>!<br /><br /><br /><br />';
$PMF_LANG['err_SaveComment'] = 'Påkrevde felt: <strong>ditt navn</strong>, <strong>din e-postadresse</strong> og <strong>dine kommentarer</strong>!<br /><br /><br /><br />';
$PMF_LANG['err_VoteTooMuch'] = 'Vi teller ikke dobbeltstemmer.';
$PMF_LANG['err_noVote'] = 'Du vurderte ikke spørsmålet!';
$PMF_LANG['err_noMailAdress'] = 'Din e-postadresse stemmer ikke.';
$PMF_LANG['err_sendMail'] = 'Påkrevde felt: <strong>dit navn</strong>, <strong>din email addresse</strong> og <strong>dit spørsmål</strong>!';
$PMF_LANG['help_search'] = '<strong>Søk etter spørsmål/svar:</strong><br /> Med en søketekst som <strong style="color: Red;">ord1 ord2</strong> kan du gjøre et relevansesøk for to eller flere søkebetingelser.<strong>Merk:</strong> Din søkebetingelse må være minst 4 tegn langt hvis ikke vil søket ditt bli avvist.';
$PMF_LANG['ad'] = 'Administrasjonspanel';
$PMF_LANG['ad_menu_user_administration'] = 'Brukeradmin';
$PMF_LANG['ad_menu_entry_aprove'] = 'Godkjenn OSSer';
$PMF_LANG['ad_menu_entry_edit'] = 'Rediger OSSer';
$PMF_LANG['ad_menu_categ_add'] = 'Legg til kategori';
$PMF_LANG['ad_menu_categ_edit'] = 'OSS kategorier';
$PMF_LANG['ad_menu_news_add'] = 'Legg til nyheter';
$PMF_LANG['ad_menu_news_edit'] = 'Rediger nyheter';
$PMF_LANG['ad_menu_open'] = 'Rediger åpne spørsmål';
$PMF_LANG['ad_menu_stat'] = 'Rangeringsstatistikk';
$PMF_LANG['ad_menu_cookie'] = 'Cookies';
$PMF_LANG['ad_menu_session'] = 'Se økter';
$PMF_LANG['ad_menu_adminlog'] = 'Se adminlogg';
$PMF_LANG['ad_menu_passwd'] = 'Endre passord';
$PMF_LANG['ad_menu_logout'] = 'Logg av';
$PMF_LANG['ad_menu_startpage'] = 'Startside';
$PMF_LANG['ad_msg_identify'] = 'Vennligst identifiser deg.';
$PMF_LANG['ad_msg_passmatch'] = 'Begge passord skal være <strong>like</strong>!';
$PMF_LANG['ad_msg_savedsuc_1'] = 'Profilen til';
$PMF_LANG['ad_msg_savedsuc_2'] = 'ble lagret.';
$PMF_LANG['ad_msg_mysqlerr'] = 'På grunn av <strong>databasefeil</strong>, kunne profilen ikke lagres.';
$PMF_LANG['ad_msg_noauth'] = 'Du er ikke autoriseret.';
$PMF_LANG['ad_gen_page'] = 'Side';
$PMF_LANG['ad_gen_of'] = 'av';
$PMF_LANG['ad_gen_lastpage'] = 'Forrige side';
$PMF_LANG['ad_gen_nextpage'] = 'Neste side';
$PMF_LANG['ad_gen_save'] = 'Lagre';
$PMF_LANG['ad_gen_reset'] = 'Tøm';
$PMF_LANG['ad_gen_yes'] = 'Ja';
$PMF_LANG['ad_gen_no'] = 'Nei';
$PMF_LANG['ad_gen_top'] = 'Toppen av siden';
$PMF_LANG['ad_gen_ncf'] = 'Ingen kategori funnet!';
$PMF_LANG['ad_gen_delete'] = 'Slett';
$PMF_LANG['ad_user'] = 'Brukeradministrasjon';
$PMF_LANG['ad_user_username'] = 'Registrerede brukere';
$PMF_LANG['ad_user_rights'] = 'Rettigheter';
$PMF_LANG['ad_user_edit'] = 'Rediger';
$PMF_LANG['ad_user_delete'] = 'Slett';
$PMF_LANG['ad_user_add'] = 'Legg til bruker';
$PMF_LANG['ad_user_profou'] = 'Brukerprofil';
$PMF_LANG['ad_user_name'] = 'Navn';
$PMF_LANG['ad_user_password'] = 'Passord';
$PMF_LANG['ad_user_confirm'] = 'Godkjenn';
$PMF_LANG['ad_user_del_1'] = 'Brukeren';
$PMF_LANG['ad_user_del_2'] = 'skal slettes?';
$PMF_LANG['ad_user_del_3'] = 'Er du sikker?';
$PMF_LANG['ad_user_deleted'] = 'Brukeren er slettet.';
$PMF_LANG['ad_user_checkall'] = 'Merk alt';
$PMF_LANG['ad_entry_aor'] = 'Administrasjon av spørsmål/svar';
$PMF_LANG['ad_entry_id'] = 'ID ';
$PMF_LANG['ad_entry_topic'] = 'Emne';
$PMF_LANG['ad_entry_action'] = 'Handling';
$PMF_LANG['ad_entry_edit_1'] = 'Rediger OSS 1';
$PMF_LANG['ad_entry_edit_2'] = 'Rediger OSS 2';
$PMF_LANG['ad_entry_theme'] = 'Tema';
$PMF_LANG['ad_entry_content'] = 'Innhold:';
$PMF_LANG['ad_entry_keywords'] = 'Nøkkelord:';
$PMF_LANG['ad_entry_author'] = 'Forfatter:';
$PMF_LANG['ad_entry_category'] = 'Kategori:';
$PMF_LANG['ad_entry_active'] = 'Synlig:';
$PMF_LANG['ad_entry_date'] = 'Dato:';
$PMF_LANG['ad_entry_changed'] = 'Endret?';
$PMF_LANG['ad_entry_changelog'] = 'Historikk';
$PMF_LANG['ad_entry_commentby'] = 'Kommentar av';
$PMF_LANG['ad_entry_comment'] = 'Kommentarer:';
$PMF_LANG['ad_entry_save'] = 'Lagre';
$PMF_LANG['ad_entry_delete'] = 'Slett';
$PMF_LANG['ad_entry_delcom_1'] = 'Er du sikker på at bruker';
$PMF_LANG['ad_entry_delcom_2'] = 'sin kommentar skal slettes?';
$PMF_LANG['ad_entry_commentdelsuc'] = 'Kommentaren er <strong>slettet</strong>.';
$PMF_LANG['ad_entry_back'] = 'Tilbake';
$PMF_LANG['ad_entry_commentdelfail'] = 'Kommentaren ble <strong>ikke</strong> slettet.';
$PMF_LANG['ad_entry_savedsuc'] = 'Endringene ble <strong>lagret</strong>.';
$PMF_LANG['ad_entry_savedfail'] = 'Dessverre oppstod en <strong>databasefeil</strong>.';
$PMF_LANG['ad_entry_del_1'] = 'Er du sikker på at emnet';
$PMF_LANG['ad_entry_del_2'] = 'av';
$PMF_LANG['ad_entry_del_3'] = 'skal slettes?';
$PMF_LANG['ad_entry_delsuc'] = 'Er <strong>slettet</strong>.';
$PMF_LANG['ad_entry_delfail'] = 'Er <strong>ikke slettet</strong>!';
$PMF_LANG['ad_news_header'] = 'Artikkel-tittel:';
$PMF_LANG['ad_news_text'] = 'Spørsmålstekst:';
$PMF_LANG['ad_news_link_url'] = 'Lenke: (<strong>uten http://</strong>)!';
$PMF_LANG['ad_news_link_title'] = 'Tittel på lenke:';
$PMF_LANG['ad_news_link_target'] = 'Destinasjon for lenke:';
$PMF_LANG['ad_news_link_window'] = 'Lenke åpner nytt vindu';
$PMF_LANG['ad_news_link_faq'] = 'Lenke inne i FAQ';
$PMF_LANG['ad_news_add'] = 'Legg til nyhet';
$PMF_LANG['ad_news_id'] = '#';
$PMF_LANG['ad_news_headline'] = 'Tittel';
$PMF_LANG['ad_news_date'] = 'Dato';
$PMF_LANG['ad_news_action'] = 'Handling';
$PMF_LANG['ad_news_update'] = 'Oppdater';
$PMF_LANG['ad_news_delete'] = 'Slett';
$PMF_LANG['ad_news_nodata'] = 'Ingen data funnet i databasen';
$PMF_LANG['ad_news_updatesuc'] = 'Nyhetene er nå oppdatert.';
$PMF_LANG['ad_news_del'] = 'Er du sikker på at du vil slette dette?';
$PMF_LANG['ad_news_yesdelete'] = 'Ja, slett!';
$PMF_LANG['ad_news_nodelete'] = 'Nei!';
$PMF_LANG['ad_news_delsuc'] = 'Nyhet slettet.';
$PMF_LANG['ad_news_updatenews'] = 'Nyhet oppdatert.';
$PMF_LANG['ad_categ_new'] = 'Legg til ny kategori';
$PMF_LANG['ad_categ_catnum'] = 'Kategorinummer:';
$PMF_LANG['ad_categ_subcatnum'] = 'Underkategorinummer:';
$PMF_LANG['ad_categ_nya'] = '<em>Ikke tilgjengelig ennå!</em>';
$PMF_LANG['ad_categ_titel'] = 'Kategoritittel';
$PMF_LANG['ad_categ_add'] = 'Legg til kategori';
$PMF_LANG['ad_categ_existing'] = 'Eksisterende kategorier';
$PMF_LANG['ad_categ_id'] = '#';
$PMF_LANG['ad_categ_categ'] = 'Kategori';
$PMF_LANG['ad_categ_subcateg'] = 'Underkategori';
$PMF_LANG['ad_categ_action'] = 'Handling';
$PMF_LANG['ad_categ_update'] = 'oppdater';
$PMF_LANG['ad_categ_delete'] = 'slett';
$PMF_LANG['ad_categ_updatecateg'] = 'Oppdater kategori';
$PMF_LANG['ad_categ_nodata'] = 'Ingen data funnet i databasen';
$PMF_LANG['ad_categ_remark'] = 'Vær oppmerksom på at de eksisterende data ikke vil være tilgjengelige lenger, hvis du sletter en kategori. Du må tildele en ny katefori for artikkelen eller slette artikkelen.';
$PMF_LANG['ad_categ_edit_1'] = 'Rediger';
$PMF_LANG['ad_categ_edit_2'] = 'Kategori';
$PMF_LANG['ad_categ_added'] = 'Kategorien er lagt til.';
$PMF_LANG['ad_categ_updated'] = 'Kategorien er oppdatert.';
$PMF_LANG['ad_categ_del_yes'] = 'ja, slett!';
$PMF_LANG['ad_categ_del_no'] = 'nei!';
$PMF_LANG['ad_categ_deletesure'] = 'Er du sikker på at du vil slettet denne kategorien?';
$PMF_LANG['ad_categ_deleted'] = 'Kategori slettet.';
$PMF_LANG['ad_cookie_cookiesuc'] = 'En Cookie <strong>ble</strong> lagret.';
$PMF_LANG['ad_cookie_already'] = 'En cookie er sat i forvejen. Du har følgende muligheter:';
$PMF_LANG['ad_cookie_again'] = 'Lagre cookie igjen';
$PMF_LANG['ad_cookie_delete'] = 'slett cookie';
$PMF_LANG['ad_cookie_no'] = 'Ingen cookie er lagret enda. Med en cookie, kan du huske dine login-detaljer. Du har følgende muligheter:';
$PMF_LANG['ad_cookie_set'] = 'Lagre cookie';
$PMF_LANG['ad_cookie_deleted'] = 'Cookie slettet.';
$PMF_LANG['ad_adminlog'] = 'Adminlogg';
$PMF_LANG['ad_passwd_cop'] = 'Endre passord';
$PMF_LANG['ad_passwd_old'] = 'Gammelt passord:';
$PMF_LANG['ad_passwd_new'] = 'Nytt passord:';
$PMF_LANG['ad_passwd_con'] = 'Bekreft:';
$PMF_LANG['ad_passwd_change'] = 'Endre passord';
$PMF_LANG['ad_passwd_suc'] = 'Passord endret.';
$PMF_LANG['ad_passwd_remark'] = '<strong>SE HER:</strong><br />Cookie skal lagres igjen!';
$PMF_LANG['ad_passwd_fail'] = 'Det gamle passordet <strong>skal</strong> må oppgies korrekt og begge passord skal være <strong>like</strong>.';
$PMF_LANG['ad_adus_adduser'] = 'Legg til bruker';
$PMF_LANG['ad_adus_name'] = 'Brukernavn:';
$PMF_LANG['ad_adus_password'] = 'Passord:';
$PMF_LANG['ad_adus_add'] = 'Legg til bruker';
$PMF_LANG['ad_adus_suc'] = 'Bruker <strong>lagt til</strong>.';
$PMF_LANG['ad_adus_edit'] = 'Rediger profil';
$PMF_LANG['ad_adus_dberr'] = '<strong>databasefeil!</strong>';
$PMF_LANG['ad_adus_exerr'] = 'Brukernavn <strong>eksisterer</strong> allerede.';
$PMF_LANG['ad_sess_id'] = 'IDnummer';
$PMF_LANG['ad_sess_sid'] = 'Økt-ID';
$PMF_LANG['ad_sess_ip'] = 'IP-Adresse';
$PMF_LANG['ad_sess_time'] = 'Tidspunkt';
$PMF_LANG['ad_sess_pageviews'] = 'Sidevisninger';
$PMF_LANG['ad_sess_search'] = 'Søk';
$PMF_LANG['ad_sess_sfs'] = 'Søk etter økter';
$PMF_LANG['ad_sess_s_ip'] = 'IPnummer:';
$PMF_LANG['ad_sess_s_minct'] = 'min. aksjoner:';
$PMF_LANG['ad_sess_s_date'] = 'Dato';
$PMF_LANG['ad_sess_s_after'] = 'etter';
$PMF_LANG['ad_sess_s_before'] = 'før';
$PMF_LANG['ad_sess_s_search'] = 'Søk';
$PMF_LANG['ad_sess_session'] = 'Økt';
$PMF_LANG['ad_sess_r'] = 'Søkeresultater for';
$PMF_LANG['ad_sess_referer'] = 'Henviser:';
$PMF_LANG['ad_sess_browser'] = 'Nettleser:';
$PMF_LANG['ad_sess_ai_rubrik'] = 'Kategori:';
$PMF_LANG['ad_sess_ai_artikel'] = 'Felt:';
$PMF_LANG['ad_sess_ai_sb'] = 'Søketekst:';
$PMF_LANG['ad_sess_ai_sid'] = 'ID for økt:';
$PMF_LANG['ad_sess_back'] = 'Tilbake';
$PMF_LANG['ad_rs'] = 'Rating statistikk';
$PMF_LANG['ad_rs_rating_1'] = 'Rangering av';
$PMF_LANG['ad_rs_rating_2'] = 'brukere viser:';
$PMF_LANG['ad_rs_red'] = 'Rød';
$PMF_LANG['ad_rs_green'] = 'Grønn';
$PMF_LANG['ad_rs_altt'] = 'med et gjennomsnitt lavere enn 20%';
$PMF_LANG['ad_rs_ahtf'] = 'med et gjennomsnitt høyere enn 80%';
$PMF_LANG['ad_rs_no'] = 'Ingen rangering tilgjengelig';
$PMF_LANG['ad_auth_insert'] = 'Skriv inn brukernavn og passord.';
$PMF_LANG['ad_auth_user'] = 'Brukernavn';
$PMF_LANG['ad_auth_passwd'] = 'Passord';
$PMF_LANG['ad_auth_ok'] = 'Ok';
$PMF_LANG['ad_auth_reset'] = 'Tøm';
$PMF_LANG['ad_auth_fail'] = 'Brukernavn eller passord ikke korrekt.';
$PMF_LANG['ad_auth_sess'] = 'ID for økten er ok.';
$PMF_LANG['ad_config_edit'] = 'Rediger konfigurasjon';
$PMF_LANG['ad_config_save'] = 'Lagre konfigurasjon';
$PMF_LANG['ad_config_reset'] = 'Tøm';
$PMF_LANG['ad_config_saved'] = 'Konfigurasjon lagret.';
$PMF_LANG['ad_menu_editconfig'] = 'Rediger konfigurasjon';
$PMF_LANG['ad_att_none'] = 'Ingen vedlegg tilgjengelige';
$PMF_LANG['ad_att_att'] = 'Fil:';
$PMF_LANG['ad_att_add'] = 'Legg til vedlegg';
$PMF_LANG['ad_entryins_suc'] = 'Spørsmål/svar lagret.';
$PMF_LANG['ad_entryins_fail'] = 'En feil oppstod.';
$PMF_LANG['ad_att_del'] = 'Slett';
$PMF_LANG['ad_att_nope'] = 'Vedlegg kan kun legges til i redigeringsmodus.';
$PMF_LANG['ad_att_delsuc'] = 'Vedlegget er slettet.';
$PMF_LANG['ad_att_delfail'] = 'En feil oppstod under slettingen av vedlegget.';
$PMF_LANG['ad_entry_add'] = 'Opprett spørsmål/svar';
$PMF_LANG['ad_csv_make'] = 'En sikkerhetskopi er et komplett bilde av databasens innhold. En sikkerhetskopi burde foretaes minst 1 gang om måneden. Sikkerhetskopi-formatet en en MySQL transaksjonsfil, som kan importeres ved hjelp av verktøy som phpMyAdmin eller mysql kommadolinje-verktøyet.';
$PMF_LANG['ad_csv_link'] = 'Hent sikkerhetskopi';
$PMF_LANG['ad_csv_head'] = 'Opprett en sikkerhetskopi';
$PMF_LANG['ad_att_addto'] = 'Legg til et vedlegg til emnet';
$PMF_LANG['ad_att_addto_2'] = '';
$PMF_LANG['ad_att_butt'] = 'Ok';
$PMF_LANG['ad_att_suc'] = 'Filen er lagt til.';
$PMF_LANG['ad_att_fail'] = 'En feil oppstod ved tillegging av fil.';
$PMF_LANG['ad_att_close'] = 'Lukk dette vinduet';
$PMF_LANG['ad_csv_restore'] = 'Med dette skjemaet kan du gjenopprette innholdet i databasen, laget med phpMyFAQ. Vær oppmerksom på at eksisterende data vil bli overskrevet.';
$PMF_LANG['ad_csv_file'] = 'Fil';
$PMF_LANG['ad_csv_ok'] = 'Ok';
$PMF_LANG['ad_csv_linklog'] = 'sikkerhetskopier loggfiler';
$PMF_LANG['ad_csv_linkdat'] = 'sikkerhetskopier data';
$PMF_LANG['ad_csv_head2'] = 'Gjenopprett';
$PMF_LANG['ad_csv_no'] = 'Dette ser ikke ut til å være en phpMyFAQ sikkerhetskopi.';
$PMF_LANG['ad_csv_prepare'] = 'Forbereder databaseforespørsler...';
$PMF_LANG['ad_csv_process'] = 'Forespørsel..';
$PMF_LANG['ad_csv_of'] = 'av';
$PMF_LANG['ad_csv_suc'] = 'gjennomført.';
$PMF_LANG['ad_csv_backup'] = 'Sikkerhetskopi';
$PMF_LANG['ad_csv_rest'] = 'Gjenopprett fra sikkerhetskopi';
$PMF_LANG['ad_menu_backup'] = 'Sikkerhetskopi';
$PMF_LANG['ad_logout'] = 'Økt avsluttet.';
$PMF_LANG['ad_news_edit'] = 'Rediger nyhet';
$PMF_LANG['ad_cookie'] = 'Cookies ';
$PMF_LANG['ad_sess_head'] = 'Se økter';
$PMF_LANG['ad_kateg_add'] = 'Legg til kategori';
$PMF_LANG['ad_kateg_rename'] = 'Editer';
$PMF_LANG['ad_adminlog_date'] = 'Dato';
$PMF_LANG['ad_adminlog_user'] = 'Bruker';
$PMF_LANG['ad_adminlog_ip'] = 'IP-adresse';
$PMF_LANG['ad_stat_sess'] = 'Økter';
$PMF_LANG['ad_stat_days'] = 'Dager';
$PMF_LANG['ad_stat_vis'] = 'Økter (besøk)';
$PMF_LANG['ad_stat_vpd'] = 'Besøk per dag';
$PMF_LANG['ad_stat_fien'] = 'Første logg';
$PMF_LANG['ad_stat_laen'] = 'Siste logg';
$PMF_LANG['ad_stat_browse'] = 'Se gjennom økter';
$PMF_LANG['ad_stat_ok'] = 'OK ';
$PMF_LANG['ad_ques_take'] = 'Besvar spørsmålet';
$PMF_LANG['no_cats'] = 'Ingen kategorier funnet.';
$PMF_LANG['ad_log_lger'] = 'Feil brukernavn eller passord.';
$PMF_LANG['ad_log_sess'] = 'Økt utgått.';
$PMF_LANG['ad_log_edit'] = '"Rediger Bruker"-Skjema for følgende bruker: ';
$PMF_LANG['ad_log_crea'] = '"Ny artikkel" skjema.';
$PMF_LANG['ad_log_crsa'] = 'Ny registrering opprettet.';
$PMF_LANG['ad_log_ussa'] = 'Oppdater data for følgende bruker: ';
$PMF_LANG['ad_log_usde'] = 'Slettet følgende bruker: ';
$PMF_LANG['ad_log_beed'] = 'Redigeringsskjema for følgende bruker: ';
$PMF_LANG['ad_log_bede'] = 'Slettet følgende registrering: ';
$PMF_LANG['ad_start_visits'] = 'Besøk';
$PMF_LANG['ad_start_articles'] = 'Artikler';
$PMF_LANG['ad_start_comments'] = 'Kommentarer';
$PMF_LANG['ad_categ_paste'] = 'lim inn';
$PMF_LANG['ad_categ_cut'] = 'klipp ut';
$PMF_LANG['ad_categ_copy'] = 'kopier';
$PMF_LANG['ad_categ_process'] = 'Bearbeider kategorier...';
$PMF_LANG['err_NotAuth'] = '<strong>Du er ikke autorisert.</strong>';
$PMF_LANG['msgPreviusPage'] = 'foregående side';
$PMF_LANG['msgNextPage'] = 'neste side';
$PMF_LANG['msgPageDoublePoint'] = 'Side: ';
$PMF_LANG['msgMainCategory'] = 'Hovedkategori';
$PMF_LANG['ad_passwdsuc'] = 'Passordet ditt er endret.';
$PMF_LANG['ad_xml_gen'] = 'Opprett XML-fil';
$PMF_LANG['ad_entry_locale'] = 'Språk';
$PMF_LANG['msgLanguageSubmit'] = 'Endre språk';
$PMF_LANG['ad_attach_4'] = 'Den vedlagte filen må være mindre enn %s byte.';
$PMF_LANG['ad_menu_export'] = 'Eksporter dine OSS';
$PMF_LANG['rightsLanguage']['adduser'] = 'Legg til bruker';
$PMF_LANG['rightsLanguage']['edituser'] = 'Rediger bruker';
$PMF_LANG['rightsLanguage']['deluser'] = 'Slett bruker';
$PMF_LANG['rightsLanguage']['addbt'] = 'Legg til spørsmål/svar';
$PMF_LANG['rightsLanguage']['editbt'] = 'Rediger spørsmål/svar';
$PMF_LANG['msgPDF'] = 'Vis som PDF-fil';
$PMF_LANG['ad_xml_head'] = 'XML-sikkerhetskopi';
$PMF_LANG['ad_xml_hint'] = 'Gem alle spørsmål i FAQ i een XML-fil.';
$PMF_LANG['ad_entry_preview'] = 'Forhåndsvisning';
$PMF_LANG['ad_attach_1'] = 'Velg først et bibliotek for vedlegg i konfigurasjon.';
$PMF_LANG['ad_attach_2'] = 'Velg først en lenke til vedlegg.';
$PMF_LANG['ad_attach_3'] = 'Filen attachment.php kan ikke åpnes uten krevde rettigheter.';
$PMF_LANG['ad_export_1'] = 'Bygg RSS-strøm til';
$PMF_LANG['ad_export_2'] = '.';
$PMF_LANG['ad_export_file'] = 'Feil: Kan ikke skrive til fil.';
$PMF_LANG['ad_export_news'] = 'Nyheter RSS-strøm';
$PMF_LANG['ad_export_topten'] = 'Topp 10 RSS-strøm';
$PMF_LANG['ad_export_latest'] = '5 seneste spørsmål RSS-Feed';
$PMF_LANG['ad_export_pdf'] = 'PDF-Eksport av alle spørsmål';
$PMF_LANG['ad_export_generate'] = 'bygg RSS-Feed';
$PMF_LANG['rightsLanguage']['delbt'] = 'Slett spørsmål/svar';
$PMF_LANG['rightsLanguage']['viewlog'] = 'Vis logger';
$PMF_LANG['rightsLanguage']['adminlog'] = 'Vis adminlogg';
$PMF_LANG['rightsLanguage']['delcomment'] = 'Slett kommentar';
$PMF_LANG['rightsLanguage']['addnews'] = 'Legg til nyhet';
$PMF_LANG['rightsLanguage']['editnews'] = 'Rediger nyheter';
$PMF_LANG['rightsLanguage']['delnews'] = 'Slett nyhet';
$PMF_LANG['rightsLanguage']['addcateg'] = 'legg til kategori';
$PMF_LANG['rightsLanguage']['editcateg'] = 'Rediger kategori';
$PMF_LANG['rightsLanguage']['delcateg'] = 'Slett kategori';
$PMF_LANG['rightsLanguage']['passwd'] = 'Endre passord';
$PMF_LANG['rightsLanguage']['editconfig'] = 'Rediger konfigurasjon';
$PMF_LANG['rightsLanguage']['addatt'] = 'Legg til vedlegg';
$PMF_LANG['rightsLanguage']['delatt'] = 'Slett vedlegg';
$PMF_LANG['rightsLanguage']['backup'] = 'Opprett sikkerhetskopi';
$PMF_LANG['rightsLanguage']['restore'] = 'Gjennopprett sikkerhetskopi';
$PMF_LANG['rightsLanguage']['delquestion'] = 'Slett åpne spørsmål';
$PMF_LANG['rightsLanguage']['changebtrevs'] = 'Endre versjoner';
$PMF_LANG['rightsLanguage']['addglossary'] = 'legg til ord i ordliste';
$PMF_LANG['rightsLanguage']['editglossary'] = 'editer ord i ordliste';
$PMF_LANG['rightsLanguage']['delglossary'] = 'slett ord i ordliste';
$PMF_LANG['rightsLanguage']['addgroup'] = 'Legg til gruppekontoer';
$PMF_LANG['rightsLanguage']['editgroup'] = 'Rediger gruppekontoer';
$PMF_LANG['rightsLanguage']['delgroup'] = 'Slett gruppekontoer';
$PMF_LANG['msgAttachedFiles'] = 'Vedlagte filer:';
$PMF_LANG['ad_user_action'] = 'Handling';
$PMF_LANG['ad_entry_email'] = 'e-postadresse:';
$PMF_LANG['ad_entry_allowComments'] = 'Tillat kommentarer';
$PMF_LANG['msgWriteNoComment'] = 'Du kan ikke kommentere dette innlegget';
$PMF_LANG['ad_user_realname'] = 'Virkelig navn:';
$PMF_LANG['ad_export_generate_pdf'] = 'generer PDF-fil';
$PMF_LANG['ad_export_full_faq'] = 'Din FAQ som en PDF-fil: ';
$PMF_LANG['err_bannedIP'] = 'Din IP-address nektes adgang.';
$PMF_LANG['err_SaveQuestion'] = 'Nødvendige felter: <strong>ditt navn</strong>, <strong>din e-postadresse</strong> og <strong>ditt spørsmål</strong>.<br /><br />';
$PMF_LANG['ad_entry_fontcolor'] = 'Skrifttype farve: ';
$PMF_LANG['ad_entry_fontsize'] = 'Skrifttype størrelse: ';
$PMF_LANG['ad_categ_new_main_cat'] = 'som ny hovedkategori';
$PMF_LANG['ad_categ_paste_error'] = 'Flytting av denne kategorien er ikke mulig.';
$PMF_LANG['ad_categ_move'] = 'flytt kategori';
$PMF_LANG['ad_categ_lang'] = 'Språk';
$PMF_LANG['ad_categ_desc'] = 'Beskrivelse';
$PMF_LANG['ad_categ_change'] = 'Endre med';
$PMF_LANG['lostPassword'] = 'Glemt passord? Klikk her.';
$PMF_LANG['lostpwd_err_1'] = 'Feil: Brukernavn og passord ikke funnet.';
$PMF_LANG['lostpwd_err_2'] = 'Feil: Feil i oppføringer!';
$PMF_LANG['lostpwd_text_1'] = 'Takk for at du forespurte din kontoinformasjon.';
$PMF_LANG['lostpwd_text_2'] = 'Sett et nytt personlig passord på administratorsiden.';
$PMF_LANG['lostpwd_mail_okay'] = 'E-post er sendt.';
$PMF_LANG['ad_xmlrpc_button'] = 'Finn siste phpMyFAQ versjonsnummer ved hjelp av web service';
$PMF_LANG['ad_xmlrpc_latest'] = 'Siste versjon tilgjengelig på';
$PMF_LANG['ad_categ_select'] = 'Velg kategorispråk';
$PMF_LANG['msgSitemap'] = 'Sidekart';
$PMF_LANG['err_inactiveArticle'] = 'Dette innlegget revideres og kan ikke vises';
$PMF_LANG['msgArticleCategories'] = 'Kategori for dette innlegget';
$PMF_LANG['ad_entry_solution_id'] = 'Unik LøsningsID';
$PMF_LANG['ad_entry_faq_record'] = 'FAQ-oppføring';
$PMF_LANG['ad_entry_new_revision'] = 'Lage ny revisjon';
$PMF_LANG['ad_entry_record_administration'] = 'Revisjonsadministrasjon';
$PMF_LANG['ad_entry_revision'] = 'Revisjon';
$PMF_LANG['ad_changerev'] = 'Velg Revisjon';
$PMF_LANG['msgCaptcha'] = 'Vennligst skriv inn tegnene du ser i bildet';
$PMF_LANG['msgSelectCategories'] = 'Søk i ...';
$PMF_LANG['msgAllCategories'] = '... alle kategorier';
$PMF_LANG['ad_you_should_update'] = 'Din phpMyFAQ installasjon er utdatert. Du bør oppdatere.';
$PMF_LANG['msgAdvancedSearch'] = 'Avansert søk';
$LANG_CONF['spam.enableSafeEmail'] = array(0 => "checkbox", 1 => "Print bruker-e-post på en sikker måte (Standard: aktivert).");
$LANG_CONF['spam.checkBannedWords'] = array(0 => "checkbox", 1 => "Sjekk offentlig innhold i skjema mot bannlyste ord (Standard: aktivert).");
$LANG_CONF['spam.enableCaptchaCode'] = array(0 => "checkbox", 1 => "Bruk en captcha-kode for å tillate publikum å sende inn (Standard: aktivert).");
$PMF_LANG['spamControlCenter'] = 'Spam kontrollsenter';
$PMF_LANG['ad_session_expiring'] = 'Din sesjon utløper om %d minutter: Vil du fortsette å jobbe?';
$PMF_LANG['ad_stat_management'] = 'Sesjonsadministrasjon';
$PMF_LANG['ad_stat_choose'] = 'Velg måned';
$PMF_LANG['ad_stat_delete'] = 'Slett sesjonene umiddelbart';
$PMF_LANG['ad_menu_glossary'] = 'Ordliste';
$PMF_LANG['ad_glossary_add'] = 'Legg til ord i Ordlisten';
$PMF_LANG['ad_glossary_edit'] = 'Rediger ordlisten';
$PMF_LANG['ad_glossary_item'] = 'Element';
$PMF_LANG['ad_glossary_definition'] = 'Definisjon';
$PMF_LANG['ad_glossary_save'] = 'Lagre oppføring';
$PMF_LANG['ad_glossary_save_success'] = 'Ordlista lagret!';
$PMF_LANG['ad_glossary_save_error'] = 'Ordlisteoppføringen kunne ikke lagres fordi en feil oppstod.';
$PMF_LANG['ad_glossary_update_success'] = 'Ordlista oppdatert!';
$PMF_LANG['ad_glossary_update_error'] = 'Ordlisteoppføringen kunne ikke oppdateres fordi en feil oppstod.';
$PMF_LANG['ad_glossary_delete'] = 'Slett element';
$PMF_LANG['ad_glossary_delete_success'] = 'Ordlisteoppføringa ble slettet!';
$PMF_LANG['ad_glossary_delete_error'] = 'Ordlisteoppføringen kunne ikke slettes fordi en feil oppstod.';
$PMF_LANG['ad_linkcheck_noReferenceURL'] = 'Automatisk lenkeverifisering er deaktivert (basis URL for lenke ikke bekreftet)';
$PMF_LANG['ad_linkcheck_noAllowUrlOpen'] = 'Automatisk lenkeverifisering deaktivert (PHP-alternativet "allow_url_fopen" er ikke aktivert)';
$PMF_LANG['ad_linkcheck_checkResult'] = 'Resultat av lenkekontroll';
$PMF_LANG['ad_linkcheck_checkSuccess'] = 'Ok ';
$PMF_LANG['ad_linkcheck_checkFailed'] = 'Feilet';
$PMF_LANG['ad_linkcheck_failReason'] = 'Grunn til feil:';
$PMF_LANG['ad_linkcheck_noLinksFound'] = 'Ingen nettadresser er kompatibel med lenkekontrolløren funnet.';
$PMF_LANG['ad_linkcheck_searchbadonly'] = 'Kun dårlige lenker';
$PMF_LANG['ad_linkcheck_infoReason'] = 'Tilleggsinformasjon';
$PMF_LANG['ad_linkcheck_openurl_infoprefix'] = 'Funnet ved test <strong>%s</strong>: ';
$PMF_LANG['ad_linkcheck_openurl_notready'] = 'Lenkekontrolløren er ikke klar.';
$PMF_LANG['ad_linkcheck_openurl_maxredirect'] = 'Omdirigeringsteller <strong>%d</strong> overskredet.';
$PMF_LANG['ad_linkcheck_openurl_urlisblank'] = 'Løst til tom URL.';
$PMF_LANG['ad_linkcheck_openurl_tooslow'] = 'Verten: <strong>%s</strong> er treg eller responderer ikke';
$PMF_LANG['ad_linkcheck_openurl_nodns'] = 'DNS oppløsning på verten <strong>% s </strong> er treg eller mislyktes på grunn av DNS problemer, lokalt eller eksternt.';
$PMF_LANG['ad_linkcheck_openurl_redirected'] = 'URL ble omdirigert til <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_ambiguous'] = 'Tvetydig HTTP status <strong>% s </strong> returnert.';
$PMF_LANG['ad_linkcheck_openurl_not_allowed'] = 'Denne <em>HEAD</em> metoden er ikke støttet av <strong>%s</strong>, tillatte metoder: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_found'] = 'Denne resursen ble ikke funnet hos <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_protocol_unsupported'] = '%s protokoll ikke støttet av lenkekontrolløren.';
$PMF_LANG['msgNewQuestionVisible'] = 'Spørsmålet må være gjennomgått før offentliggjøring.';
$PMF_LANG['msgQuestionsWaiting'] = 'Venter på at administrasjonen skal publisere';
$PMF_LANG['ad_entry_visibility'] = 'Publisere?';
$PMF_LANG['ad_user_error_password'] = 'Vennligst oppgi et passord.';
$PMF_LANG['ad_user_error_passwordsDontMatch'] = 'Passordene samsvarer ikke.';
$PMF_LANG['ad_user_error_loginInvalid'] = 'Det angitte brukernavnet er ugyldig.';
$PMF_LANG['ad_user_error_noEmail'] = 'Vennligst skriv inn en gyldig e-postadresse.';
$PMF_LANG['ad_user_error_noRealName'] = 'Vennligst skriv inn ditt virkelige navn.';
$PMF_LANG['ad_user_error_delete'] = 'Brukerkonto kunne ikke slettes.';
$PMF_LANG['ad_user_error_noId'] = 'Ingen ID er angitt.';
$PMF_LANG['ad_user_error_protectedAccount'] = 'Brukerkontoen er beskyttet.';
$PMF_LANG['ad_user_deleteUser'] = 'Slett bruker';
$PMF_LANG['ad_user_status'] = 'Status: ';
$PMF_LANG['ad_user_lastModified'] = 'Sist endret:';
$PMF_LANG['ad_gen_cancel'] = 'Avbryt';
$PMF_LANG['ad_menu_group_administration'] = 'Grupper';
$PMF_LANG['ad_user_loggedin'] = 'Logget inn som ';
$PMF_LANG['ad_group_details'] = 'Gruppedetaljer';
$PMF_LANG['ad_group_add'] = 'Legg til gruppe';
$PMF_LANG['ad_group_add_link'] = 'Legg til gruppe';
$PMF_LANG['ad_group_name'] = 'Navn:';
$PMF_LANG['ad_group_description'] = 'Beskrivelse:';
$PMF_LANG['ad_group_autoJoin'] = 'Auto-join: ';
$PMF_LANG['ad_group_suc'] = 'Gruppe <strong>ble</strong> lagt til.';
$PMF_LANG['ad_group_error_noName'] = 'Vennligst skriv inn et gruppenavn.';
$PMF_LANG['ad_group_error_delete'] = 'Gruppen kunne ikke slettes.';
$PMF_LANG['ad_group_deleted'] = 'Gruppen ble slettet.';
$PMF_LANG['ad_group_deleteGroup'] = 'Slett gruppe';
$PMF_LANG['ad_group_deleteQuestion'] = 'Er du sikker på at denne gruppen skal slettes?';
$PMF_LANG['ad_user_uncheckall'] = 'Fjern all merking';
$PMF_LANG['ad_group_membership'] = 'Gruppemedlemsskap';
$PMF_LANG['ad_group_members'] = 'Medlemmer';
$PMF_LANG['ad_group_addMember'] = '+';
$PMF_LANG['ad_group_removeMember'] = '-';
$PMF_LANG['ad_export_which_cat'] = 'Begrens FAQ data som skal eksporteres (valgfritt)';
$PMF_LANG['ad_export_cat_downwards'] = 'Nedover?';
$PMF_LANG['ad_export_type'] = 'Eksportfilens format';
$PMF_LANG['ad_export_type_choose'] = 'Velg en av de støttede formatene';
$PMF_LANG['ad_export_download_view'] = 'Laste ned eller se in-line?';
$PMF_LANG['ad_export_download'] = 'last ned';
$PMF_LANG['ad_export_view'] = 'se in-line';
$PMF_LANG['ad_export_gen_xhtml'] = 'Lag en XHTML fil';
$PMF_LANG['ad_export_gen_docbook'] = 'Lag en Docbook fil';
$PMF_LANG['ad_news_data'] = 'Nyhetsdata';
$PMF_LANG['ad_news_author_name'] = 'Forfatter:';
$PMF_LANG['ad_news_author_email'] = 'Forfatterens e-post:';
$PMF_LANG['ad_news_set_active'] = 'Aktiver';
$PMF_LANG['ad_news_allowComments'] = 'Tillat kommentarer:';
$PMF_LANG['ad_news_expiration_window'] = '"Nyhet utløper"-tidsvindu (valgfritt)';
$PMF_LANG['ad_news_from'] = 'Fra:';
$PMF_LANG['ad_news_to'] = 'Til:';
$PMF_LANG['ad_news_insertfail'] = 'Det oppstod en feil ved innsetting av nyheten i databasen.';
$PMF_LANG['ad_news_updatefail'] = 'Det oppstod en feil ved oppdatering av nyheten i databasen.';
$PMF_LANG['newsShowCurrent'] = 'Vis nyheter.';
$PMF_LANG['newsShowArchive'] = 'Vis arkiverte nyheter.';
$PMF_LANG['newsArchive'] = ' Nyhetsarkiv';
$PMF_LANG['newsWriteComment'] = 'kommentere denne oppføringen';
$PMF_LANG['newsCommentDate'] = 'Lagt til: ';
$PMF_LANG['ad_record_expiration_window'] = '"Oppføring utløper"-tidsvindu (valgfritt)';
$PMF_LANG['admin_mainmenu_home'] = 'Dashbord';
$PMF_LANG['admin_mainmenu_users'] = 'Brukere';
$PMF_LANG['admin_mainmenu_content'] = 'Innhold';
$PMF_LANG['admin_mainmenu_statistics'] = 'Statistikk';
$PMF_LANG['admin_mainmenu_exports'] = 'Eksport';
$PMF_LANG['admin_mainmenu_backup'] = 'Backup ';
$PMF_LANG['admin_mainmenu_configuration'] = 'Konfigurasjon';
$PMF_LANG['admin_mainmenu_logout'] = 'Logg ut';
$PMF_LANG['ad_categ_owner'] = 'Kategorieier';
$PMF_LANG['adminSection'] = 'Administrasjon';
$PMF_LANG['err_expiredArticle'] = 'Denne oppføringen er utløpt, og kan ikke vises';
$PMF_LANG['err_expiredNews'] = 'Denne nyheten er utløpt, og kan ikke vises';
$PMF_LANG['err_inactiveNews'] = 'Denne nyheten er i revisjon og kan ikke vises';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Søk over alle språk:';
$PMF_LANG['ad_entry_tags'] = 'Tagger';
$PMF_LANG['msg_tags'] = 'Tagger';
$PMF_LANG['ad_linkcheck_feedback_url-batch1'] = 'Sjekker...';
$PMF_LANG['ad_linkcheck_feedback_url-batch2'] = 'Sjekker...';
$PMF_LANG['ad_linkcheck_feedback_url-batch3'] = 'Sjekker...';
$PMF_LANG['ad_linkcheck_feedback_url-checking'] = 'Sjekker...';
$PMF_LANG['ad_linkcheck_feedback_url-disabled'] = 'Deaktivert';
$PMF_LANG['ad_linkcheck_feedback_url-linkbad'] = 'Lenker KO';
$PMF_LANG['ad_linkcheck_feedback_url-linkok'] = 'Lenker OK';
$PMF_LANG['ad_linkcheck_feedback_url-noaccess'] = 'Ingen tilgang';
$PMF_LANG['ad_linkcheck_feedback_url-noajax'] = 'Ingen AJAX';
$PMF_LANG['ad_linkcheck_feedback_url-nolinks'] = 'Ingen Lenker';
$PMF_LANG['ad_linkcheck_feedback_url-noscript'] = 'Ingen Skript';
$PMF_LANG['msg_related_articles'] = 'Relaterte poster';
$PMF_LANG['ad_categ_trans_1'] = 'Oversett';
$PMF_LANG['ad_categ_trans_2'] = 'Kategori';
$PMF_LANG['ad_categ_translatecateg'] = 'Oversett kategori';
$PMF_LANG['ad_categ_translate'] = 'Oversett';
$PMF_LANG['ad_categ_transalready'] = 'Allerede oversatt på:';
$PMF_LANG['ad_categ_deletealllang'] = 'Slett på alle språk?';
$PMF_LANG['ad_categ_deletethislang'] = 'Slett bare på dette språket?';
$PMF_LANG['ad_categ_translated'] = 'Denne kategorien er blitt oversatt';
$PMF_LANG['ad_categ_show'] = 'Oversikt';
$PMF_LANG['ad_menu_categ_structure'] = 'Kategorioversikten inkluderer dette språket';
$PMF_LANG['ad_entry_userpermission'] = 'Brukertillatelser';
$PMF_LANG['ad_entry_grouppermission'] = 'Gruppetillatelser:';
$PMF_LANG['ad_entry_all_users'] = 'Tilgang for alle brukere';
$PMF_LANG['ad_entry_restricted_users'] = 'Begrenset tilgang til';
$PMF_LANG['ad_entry_all_groups'] = 'Tilgang for alle brukere';
$PMF_LANG['ad_entry_restricted_groups'] = 'Begrens tilgangen til';
$PMF_LANG['ad_session_expiration'] = 'Tid til utløp av sesjon';
$PMF_LANG['ad_user_active'] = 'aktiv';
$PMF_LANG['ad_user_blocked'] = 'blokkert';
$PMF_LANG['ad_user_protected'] = 'beskyttet';
$PMF_LANG['ad_entry_intlink'] = 'Velg en FAQ-oppføring for å legge den til som lenke';
$PMF_LANG['ad_categ_paste2'] = 'Lim inn etter';
$PMF_LANG['ad_categ_remark_move'] = 'Utvekslingen av to kategorier er bare mulig på samme nivå.';
$PMF_LANG['ad_categ_remark_overview'] = 'Den riktige rangeringen av kategorier som vises vil bli vist om alle kategorier er definert for selve språket (første kolonne).';
$PMF_LANG['msgUsersOnline'] = '%d Gjester og %d Registrerte';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Slett logger umiddelbart om de er over 30 dager';
$PMF_LANG['ad_adminlog_delete_success'] = 'Eldre logger er nå slettet';
$PMF_LANG['ad_adminlog_delete_failure'] = 'Ingen logger slettet: en feil oppsto under forespørselen.';
$PMF_LANG['opensearch_plugin_install'] = 'Legg til søketillegg';
$PMF_LANG['ad_quicklinks'] = 'Hurtiglinker';
$PMF_LANG['ad_quick_category'] = 'Legg til ny kategori';
$PMF_LANG['ad_quick_record'] = 'Legg til ny FAQ-oppføring';
$PMF_LANG['ad_quick_user'] = 'Legg til bruker';
$PMF_LANG['ad_quick_group'] = 'Legg til gruppe';
$PMF_LANG['msgNewTranslationHeader'] = 'Forslag til oversettelse';
$PMF_LANG['msgNewTranslationAddon'] = 'Forslaget vil ikke bli publisert umiddelbart, men vil bli utgitt av administrator ved mottak. Obligatoriske felt er <strong> ditt navn </strong>, <strong> din e-postadresse </strong>, <strong> overskriften til oversettelsen </strong> og <strong> din FAQ-oversettelse </strong>. Vennligst skill søkeordene med mellomrom.';
$PMF_LANG['msgNewTransSourcePane'] = 'Kildepanel';
$PMF_LANG['msgNewTranslationPane'] = 'Oversettelsespanel';
$PMF_LANG['msgNewTranslationName'] = 'Ditt navn:';
$PMF_LANG['msgNewTranslationMail'] = 'Din e-post:';
$PMF_LANG['msgNewTranslationKeywords'] = 'Stikkord:';
$PMF_LANG['msgNewTranslationSubmit'] = 'Send inn ditt forslag';
$PMF_LANG['msgTranslate'] = 'Foreslå en oversettelse';
$PMF_LANG['msgTranslateSubmit'] = 'Start oversettelse...';
$PMF_LANG['msgNewTranslationThanks'] = 'Takk for forslaget tiloversettelsen!';
$PMF_LANG['ad_news_link_parent'] = 'Lenke åpnes i overordnet vindu';
$PMF_LANG['ad_menu_comments'] = 'Kommentarer';
$PMF_LANG['ad_comment_administration'] = 'Administrer kommentarer';
$PMF_LANG['ad_comment_faqs'] = 'Komentarer i FAQ\'s';
$PMF_LANG['ad_comment_news'] = 'Kommentarer i nye oppføringer';
$PMF_LANG['ad_groups'] = 'Grupper';
$PMF_LANG['ad_conf_order_id'] = 'ID (standard)';
$PMF_LANG['ad_conf_order_thema'] = 'Tittel';
$PMF_LANG['ad_conf_order_visits'] = 'Antall besøkende';
$PMF_LANG['ad_conf_order_updated'] = 'Dato';
$PMF_LANG['ad_conf_order_author'] = 'Forfatter';
$PMF_LANG['ad_conf_desc'] = 'synkede';
$PMF_LANG['ad_conf_asc'] = 'stigende';
$PMF_LANG['mainControlCenter'] = 'Hovedkonfigurasjon';
$PMF_LANG['recordsControlCenter'] = 'FAQ oppføringskonfigurasjon';
$PMF_LANG['msgAllCatArticles'] = 'poster i denne kategorien';
$PMF_LANG['msgTagSearch'] = 'Merkede oppføringer';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ Informasjon';
$PMF_LANG['ad_online_info'] = 'Online versjonssjekk';
$PMF_LANG['ad_system_info'] = 'Systeminformasjon';
$PMF_LANG['msgRegisterUser'] = 'Vil du registrere deg?';
$PMF_LANG['ad_user_loginname'] = 'Brukernavn:';
$PMF_LANG['errorRegistration'] = 'Dette feltet er obligatorisk!';
$PMF_LANG['submitRegister'] = 'Registrer';
$PMF_LANG['msgUserData'] = 'Brukerinformasjon påkreves for registrering';
$PMF_LANG['captchaError'] = 'Vær vennlig å skrive inn korrekt captcha-kode!';
$PMF_LANG['msgRegError'] = 'Korriger følgende feil:';
$PMF_LANG['successMessage'] = 'Registreringen din var vellykket. Du vil snart motta en bekreftelsesmail med dine innloggingsdata!';
$PMF_LANG['msgRegThankYou'] = 'Takk for at du registrerte deg';
$PMF_LANG['emailRegSubject'] = '[%sitename%] - Registrering: ny bruker';
$PMF_LANG['msgMostPopularSearches'] = 'De mest populære søkene er:';
$PMF_LANG['ad_menu_searchstats'] = 'Søkestatistikk';
$PMF_LANG['ad_searchstats_search_term'] = 'Nøkkelord';
$PMF_LANG['ad_searchstats_search_term_count'] = 'Teller';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'Språk';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'Prosent';
$PMF_LANG['ad_record_sticky'] = 'Klistre';
$PMF_LANG['ad_entry_sticky'] = 'Klistre';
$PMF_LANG['stickyRecordsHeader'] = 'Klistre FAQs';
$PMF_LANG['ad_menu_stopwordsconfig'] = 'Stoppeord';
$PMF_LANG['ad_config_stopword_input'] = 'Legg til nytt stoppeord';
$PMF_LANG['msgSendMailDespiteEverything'] = 'Nei, er det fortsatt ingen tilstrekkelige svar (sender mail)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'Er ønsket svar oppført i resultatene ovenfor?';
$PMF_LANG['msgChooseLanguageToTranslate'] = 'Velg språk for oversettelse';
$PMF_LANG['msgLangDirIsntWritable'] = 'Mappen for oversettelser er ikke skrivbart';
$PMF_LANG['ad_menu_translations'] = 'Oversettelser av menyer';
$PMF_LANG['ad_start_notactive'] = 'Venter på aktivering';
$PMF_LANG['msgTransToolAddNewTranslation'] = 'Legg til ny oversettelse';
$PMF_LANG['msgTransToolLanguage'] = 'Språk';
$PMF_LANG['msgTransToolActions'] = 'Handlinger';
$PMF_LANG['msgTransToolWritable'] = 'Skrivbar';
$PMF_LANG['msgEdit'] = 'Rediger';
$PMF_LANG['msgDelete'] = 'Slett';
$PMF_LANG['msgYes'] = 'ja';
$PMF_LANG['msgNo'] = 'nei';
$PMF_LANG['msgTransToolSureDeleteFile'] = 'Er du sikker på at denne språkfilen må slettes?';
$PMF_LANG['msgTransToolFileRemoved'] = 'Språkfilen er nå slettet';
$PMF_LANG['msgTransToolErrorRemovingFile'] = 'Feil ved sletting av språkfil';
$PMF_LANG['msgVariable'] = 'Variabel';
$PMF_LANG['msgCancel'] = 'Avbryt';
$PMF_LANG['msgSave'] = 'Lagre';
$PMF_LANG['msgSaving3Dots'] = 'lagrer ...';
$PMF_LANG['msgRemoving3Dots'] = 'fjerner ...';
$PMF_LANG['msgTransToolFileSaved'] = 'Språkfilen ble lagret';
$PMF_LANG['msgTransToolErrorSavingFile'] = 'Feil under lagring av spåkfilen';
$PMF_LANG['msgLanguage'] = 'Språk';
$PMF_LANG['msgTransToolLanguageCharset'] = 'Tegnsett for språk';
$PMF_LANG['msgTransToolLanguageDir'] = 'Retning for språk';
$PMF_LANG['msgTransToolLanguageDesc'] = 'Forklaring på språket';
$PMF_LANG['msgTransToolAddAuthor'] = 'Legg til forfatter';
$PMF_LANG['msgTransToolCreateTranslation'] = 'Lag oversettelse';
$PMF_LANG['msgTransToolTransCreated'] = 'Ny oversettelse ble lagret';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'Kunne ikke lage en ny oversettelse';
$PMF_LANG['msgAdding3Dots'] = 'Legger til...';
$PMF_LANG['msgTransToolSendToTeam'] = 'Send til phpMyFAQ-teamet';
$PMF_LANG['msgSending3Dots'] = 'sender ...';
$PMF_LANG['msgTransToolFileSent'] = 'Språkfilen har blitt sendt til phpMyFAQ teamet. Tusen takk for at du deler med oss!';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'Det oppstod en feil under sending av språkfilen';
$PMF_LANG['msgTransToolPercent'] = 'Prosent';
$PMF_LANG['msgAttachmentNotFound'] = 'Fant ikke filen du prøver å laste ned på serveren';
$PMF_LANG['ad_sess_noentry'] = 'Ingen posteringer';
$LANG_CONF['main.language'] = array(0 => 'select', 1 => 'Språkfil');
$LANG_CONF['main.languageDetection'] = array(0 => 'checkbox', 1 => 'Aktiver automatisk detektering av tegnsett');
$LANG_CONF['main.titleFAQ'] = array(0 => 'input', 1 => 'Tittel for OSS/FAQ');
$LANG_CONF['main.currentVersion'] = array(0 => 'print', 1 => 'FAQ versjon');
$LANG_CONF['main.metaDescription'] = array(0 => 'input', 1 => 'Beskrivelse');
$LANG_CONF['main.metaKeywords'] = array(0 => 'input', 1 => 'Nøkler for søkemaskiner');
$LANG_CONF['main.metaPublisher'] = array(0 => 'input', 1 => 'Utgivernavn');
$LANG_CONF['main.administrationMail'] = array(0 => 'input', 1 => 'Administrators e-postadresse');
$LANG_CONF['main.contactInformations'] = array(0 => 'area', 1 => 'Kontaktinformasjon');
$LANG_CONF['main.send2friendText'] = array(0 => 'area', 1 => 'Tekst for send til venn-siden');
$LANG_CONF['records.maxAttachmentSize'] = array(0 => 'input', 1 => 'Maks størrelse for vedlegg i byte (maks. %sByte)');
$LANG_CONF['records.disableAttachments'] = array(0 => 'checkbox', 1 => 'Lenke til vedlegg under oppføringene?');
$LANG_CONF['main.enableUserTracking'] = array(0 => 'checkbox', 1 => 'Bruk Tracking?');
$LANG_CONF['main.enableAdminLog'] = array(0 => 'checkbox', 1 => 'Bruk adminlogg?');
$LANG_CONF['security.ipCheck'] = array(0 => 'checkbox', 1 => 'Vil du at IP-en skal sjekkes når man sjekket UIN-en i admin.php?');
$LANG_CONF['records.numberOfRecordsPerPage'] = array(0 => 'input', 1 => 'Antall oppføringer per side');
$LANG_CONF['records.numberOfShownNewsEntries'] = array(0 => 'input', 1 => 'Antall nyhetsartikler');
$LANG_CONF['security.bannedIPs'] = array(0 => 'area', 1 => 'Steng ute disse IP-ene');
$LANG_CONF['main.enableRewriteRules'] = array(0 => 'checkbox', 1 => 'Aktiver mod_rewrite støtte? (Standard: deaktivert)');
$LANG_CONF['security.ldapSupport'] = array(0 => 'checkbox', 1 => 'Vil du aktivere LDAP-støtte? (Standard: deaktivert)');
$LANG_CONF['main.referenceURL'] = array(0 => 'input', 1 => 'Basis url for verifikasjon av link (f.eks.: http://www.example.org/faq/)');
$LANG_CONF['main.urlValidateInterval'] = array(0 => 'input', 1 => 'Intervall for AJAX linksjekk (i sekunder)');
$LANG_CONF['records.enableVisibilityQuestions'] = array(0 => 'checkbox', 1 => 'Vise nye spørsmål automatisk?');
$LANG_CONF['security.permLevel'] = array(0 => 'select', 1 => 'Tilgangsnivå');
$LANG_CONF['records.numberOfRelatedArticles'] = array(0 => "input", 1 => "Antall relaterte poster");
$LANG_CONF['records.orderby'] = array(0 => 'select', 1 => 'Sortering av poster (ihht. eiendom)');
$LANG_CONF['records.sortby'] = array(0 => 'select', 1 => 'Postsortering (synkende eller stigende)');
$LANG_CONF['records.defaultActivation'] = array(0 => "checkbox", 1 => "Aktiver nye oppføringer automatisk (Standard: deaktivert)");
$LANG_CONF['records.defaultAllowComments'] = array(0 => "checkbox", 1 => "Tillat kommentarer til nye poster (Standard: ikke tillatt)");
$LANG_CONF['main.enableWysiwygEditor'] = array(0 => "checkbox", 1 => "Aktiver medfølgende WYSIWYG editor (Standard: aktivert)");
$LANG_CONF['records.attachmentsPath'] = array(0 => "input", 1 => "Sti til der vedleggene skal lagres.<br /><small>(Relativ sti fra phpMyFaq rot)</small>");
$PMF_LANG['msgTransToolNoteFileSaving'] = 'Vær oppmerksom på at ingen filer vil bli lagret før du klikker lagre knappen';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'Sidebuffer %d korrekt registrert';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'Sidebuffer %d registrert med feil';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'Sidebuffer %d lagres';
$PMF_LANG['ad_record_active'] = 'Aktiv';
$PMF_LANG['msgAttachmentInvalid'] = 'Vedlegget er ugyldig, vennligst informer admin';
$PMF_LANG['list_all_users'] = 'Se alle brukere';
$PMF_LANG['records.orderingPopularFaqs.visits'] = 'List opp de mest besøkte oppføringer';
$PMF_LANG['records.orderingPopularFaqs.voting'] = 'List opp oppføringer med flest stemmer';
$PMF_LANG['msgShowHelp'] = 'Vennligst skill ord med komma.';
$PMF_LANG['msgUpdateFaqDate'] = 'oppdater';
$PMF_LANG['msgKeepFaqDate'] = 'behold';
$PMF_LANG['msgEditFaqDat'] = 'endre';
$LANG_CONF['search.numberSearchTerms'] = array(0 => 'input', 1 => 'Antall søkeord vist');
$LANG_CONF['records.orderingPopularFaqs'] = array(0 => "select", 1 => "Sortering av topp-faq's");
$LANG_CONF['main.optionalMailAddress'] = array(0 => 'checkbox', 1 => 'e-post adresse som obligatorisk felt (standard: deaktivert)');
$LANG_CONF['records.orderingPopularFaqs'] = array(0 => 'select', 1 => 'Sortering av topp OSSer');
$LANG_CONF['main.optionalMailAddress'] = array(0 => 'checkbox', 1 => 'e-post adresse som obligatorisk felt (Standard: deaktivert)');
$PMF_LANG['msgTransToolRemove'] = 'Fjern';
$PMF_LANG['msgTransToolLanguageNumberOfPlurals'] = 'Antall flertallsformer';
$PMF_LANG['msgTransToolLanguageOnePlural'] = 'Dette språket har bare en flertallsform';
$PMF_LANG['msgTransToolLanguagePluralNotSet'] = 'Flertall støtte for språket %s er deaktivert ("nplurals" er ikke satt)';
$PMF_LANG['plmsgHomeArticlesOnline']['0'] = 'Det er %d FAQ/OSS online';
$PMF_LANG['plmsgHomeArticlesOnline']['1'] = 'Det er %d FAQs/OSSer online';
$PMF_LANG['plmsgViews']['0'] = '%d vis';
$PMF_LANG['plmsgViews']['1'] = '%d visninger';
$PMF_LANG['plmsgGuestOnline']['0'] = '%d Gjest';
$PMF_LANG['plmsgGuestOnline']['1'] = '%d Gjester';
$PMF_LANG['plmsgRegisteredOnline']['0'] = ' og %d Registrert';
$PMF_LANG['plmsgRegisteredOnline']['1'] = ' og %d Registrerte';
$PMF_LANG['plmsgSearchAmount']['0'] = '%d søkeresultat';
$PMF_LANG['plmsgSearchAmount']['1'] = '%d søkeresultater';
$PMF_LANG['plmsgPagesTotal']['0'] = ' %d Side';
$PMF_LANG['plmsgPagesTotal']['1'] = ' %d Sider';
$PMF_LANG['plmsgVotes']['0'] = '%d Stemme';
$PMF_LANG['plmsgVotes']['1'] = '%d Stemmer';
$PMF_LANG['plmsgEntries']['0'] = '%d FAQ ';
$PMF_LANG['plmsgEntries']['1'] = '%d FAQs';
$PMF_LANG['rightsLanguage']['addtranslation'] = 'legg til oversettelse';
$PMF_LANG['rightsLanguage']['edittranslation'] = 'rediger oversettelse';
$PMF_LANG['rightsLanguage']['deltranslation'] = 'slett oversettelse';
$PMF_LANG['rightsLanguage']['approverec'] = 'godkjenne poster';
$PMF_LANG['ad_menu_upgrade'] = 'Oppgrader';
$PMF_LANG['ad_you_shouldnt_update'] = 'Du har den siste versjonen av phpMyFAQ. Oppdatering er ikke nødvendig.';
$PMF_LANG['msgSecureSwitch'] = 'Bytt til sikker modus for å logge inn!';
$LANG_CONF['main.templateSet'] = array(0 => "select", 1 => "Mal i bruk");
$LANG_CONF['records.enableAttachmentEncryption'] = array(0 => "checkbox", 1 => "Aktiver vedleggsbeskyttelse <br><small>Ignoreres ved deaktivert vedleggsfunksjon</small>");
$LANG_CONF['records.defaultAttachmentEncKey'] = array(0 => "input", 1 => 'Standard krypteringsnøkkel for vedlegg <br><small>Ignoreres ved deaktivert vedleggskryptering</small><br><small><font color="red">ADVARSEL: IKKE endre denne etter at du har aktivert vedleggskryptering!!!</font></small>');
$LANG_CONF['security.useSslForLogins'] = array(0 => 'checkbox', 1 => "Bare tillat pålogginger over sikker tilkobling? (Standard: deaktivert)");
$PMF_LANG['plmsgUserOnline']['0'] = '%d bruker online';
$PMF_LANG['plmsgUserOnline']['1'] = '';
$PMF_LANG['msgShowMore'] = 'vis mer';
$PMF_LANG['msgQuestionAnswered'] = 'Spørsmål besvart';
$PMF_LANG['msgMessageQuestionAnswered'] = 'Ditt spørsmål den %s ble besvart. Vennligst sjekk svaret her:';
$PMF_LANG['ad_stopwords_desc'] = 'Vennligst velg et språk å legge til eller editer stop-ord.';
$PMF_LANG['ad_visits_per_day'] = 'Besøk per dag';
$PMF_LANG['ad_instance_add'] = 'Legg til en ny phpMyFAQ multi websted';
$PMF_LANG['ad_instance_error_notwritable'] = 'Kan ikke skrive til det eldre /multiwebsted.';
$PMF_LANG['ad_instance_url'] = 'Instans URL';
$PMF_LANG['ad_instance_path'] = 'Instans sti';
$PMF_LANG['ad_instance_name'] = 'Instans navn';
$PMF_LANG['ad_instance_email'] = 'Din admin epost';
$PMF_LANG['ad_instance_admin'] = 'Admin login navn';
$PMF_LANG['ad_instance_password'] = 'Admin passord';
$PMF_LANG['ad_instance_hint'] = 'Merk: Det vil ta noen sekunder å opprette en ny phpMyFAQ instans!';
$PMF_LANG['ad_instance_button'] = 'Lagre instans';
$PMF_LANG['ad_instance_error_cannotdelete'] = 'Kunne ikke slette instans ';
$PMF_LANG['ad_instance_config'] = 'Instanskonfigurasjon';
$PMF_LANG['msgAboutThisNews'] = 'Om denne nyheten';
$PMF_LANG['msgAccessDenied'] = 'Tilgang nektet.';
$PMF_LANG['msgSeeFAQinFrontend'] = 'Se OSS på forside';
$LANG_CONF['records.randomSort'] = array(0 => 'checkbox', 1 => 'Sorter OSSer vilkårlig (Standard: deaktivert)');
$LANG_CONF['main.enableWysiwygEditorFrontend'] = array(0 => 'checkbox', 1 => 'Aktiver WYSIWYG editor for brukere (Standard: deaktivert)');
$LANG_CONF['main.enableGravatarSupport'] = array(0 => 'checkbox', 1 => 'Gravatar Support (Standard: deaktivert)');
$PMF_LANG['securityControlCenter'] = 'Sikkerhetskonfigurasjon';
$PMF_LANG['ad_search_delsuc'] = 'Søkebegrepet ble slettet.';
$PMF_LANG['ad_search_delfail'] = 'Søkebegrepet ble ikke slettet.';
$PMF_LANG['msg_about_faq'] = 'Om denne OSSen';
$PMF_LANG['msgTableOfContent'] = 'Innholdsfortegnelse';
$PMF_LANG['msgExportAllFaqs'] = 'Skriv ut alt til PDF';
$PMF_LANG['ad_online_verification'] = 'Online verifiseringssjekk';
$PMF_LANG['ad_verification_button'] = 'Klikk for å verifisere din phpMyFAQ installasjon';
$PMF_LANG['ad_verification_notokay'] = 'Din versjon av phpMyFAQ har lokale endringer:';
$PMF_LANG['ad_verification_okay'] = 'Din versjon av phpMyFAQ ble vellykket verifisert.';
$PMF_LANG['cacheControlCenter'] = 'Cache konfigurasjon';
$PMF_LANG['ad_menu_searchfaqs'] = 'Søk etter OSSer';
$PMF_LANG['msg2answerFAQ'] = 'Besvart';
$PMF_LANG['headerUserControlPanel'] = 'Bruker Kontrollpanel';
$PMF_LANG['rememberMe'] = 'Husk meg';
$PMF_LANG['ad_menu_instances'] = 'FAQ Multi-websteder';
$PMF_LANG['ad_record_inactive'] = 'OSS offline';
$PMF_LANG['msgMode'] = 'modus';
$PMF_LANG['msgMaintenanceMode'] = 'OSS er i vedlikeholdsmodus';
$PMF_LANG['msgOnlineMode'] = 'OSS online';
$LANG_CONF['security.enableLoginOnly'] = array(0 => 'checkbox', 1 => 'Fullstendig sikret OSS (Standard: deaktivert)');
$LANG_CONF['security.useSslOnly'] = array(0 => 'checkbox', 1 => 'OSS kun ved SSL (Standard: deaktivert)');
$LANG_CONF['cache.varnishEnable'] = array(0 => 'checkbox', 1 => 'Aktiver Varnish >=3.0 support<br><small>Krever varnish PECL extension</small>');
$LANG_CONF['cache.varnishHost'] = array(0 => 'input', 1 => 'Varnish vert');
$LANG_CONF['cache.varnishPort'] = array(0 => 'input', 1 => 'Varnish ipport');
$LANG_CONF['cache.varnishSecret'] = array(0 => 'input', 1 => 'Varnish hemmeligkode');
$LANG_CONF['cache.varnishTimeout'] = array(0 => 'input', 1 => 'Varnish tidsabvbrudd');
$LANG_CONF['records.enableCloseQuestion'] = array(0 => 'checkbox', 1 => 'Lukke åpent spørsmål når det har blitt besvart?');
$LANG_CONF['records.enableDeleteQuestion'] = array(0 => 'checkbox', 1 => 'Slette åpent spørsmål når det har blitt besvart?');
$LANG_CONF['records.autosaveActive'] = array(0 => 'checkbox', 1 => 'Aktiver OSS autolagring');
$LANG_CONF['records.autosaveSecs'] = array(0 => 'input', 1 => 'Intervall for autolagring i sekunder, default 180');
$LANG_CONF['main.maintenanceMode'] = array(0 => 'checkbox', 1 => 'Sett OSS i vedlikeholdsmodus');
$PMF_LANG['ad_menu_attachments'] = 'OSS Vedlegg';
$PMF_LANG['ad_menu_attachment_admin'] = 'Administrasjon av vedlegg';
$PMF_LANG['msgAttachmentsFilename'] = 'Filenavn';
$PMF_LANG['msgAttachmentsFilesize'] = 'Filstørrelse';
$PMF_LANG['msgAttachmentsMimeType'] = 'MIME Typer';
$PMF_LANG['msgAttachmentsWannaDelete'] = 'Er du sikkert på at du vil slette dette vedlegget?';
$PMF_LANG['msgAttachmentsDeleted'] = 'Vedlegg <strong>slettet</strong> Ok.';
$PMF_LANG['ad_menu_reports'] = 'Rapporter';
$PMF_LANG['ad_stat_report_fields'] = 'Felt';
$PMF_LANG['ad_stat_report_category'] = 'Kategori';
$PMF_LANG['ad_stat_report_sub_category'] = 'Subkategori';
$PMF_LANG['ad_stat_report_translations'] = 'Oversetting';
$PMF_LANG['ad_stat_report_language'] = 'Språk';
$PMF_LANG['ad_stat_report_id'] = 'OSS ID';
$PMF_LANG['ad_stat_report_sticky'] = 'Sticky OSS';
$PMF_LANG['ad_stat_report_title'] = 'Spørsmål';
$PMF_LANG['ad_stat_report_creation_date'] = 'Dato';
$PMF_LANG['ad_stat_report_owner'] = 'Opprinnelig forfatter';
$PMF_LANG['ad_stat_report_last_modified_person'] = 'Siste forfatter';
$PMF_LANG['ad_stat_report_url'] = 'Adresse';
$PMF_LANG['ad_stat_report_visits'] = 'Besøk';
$PMF_LANG['ad_stat_report_make_report'] = 'Generer Rapport';
$PMF_LANG['ad_stat_report_make_csv'] = 'Eksporter til CSV';
$PMF_LANG['msgRegistration'] = 'Registrering';
$PMF_LANG['msgRegistrationCredentials'] = 'For å registrere deg, vennligst oppgi ditt navn, ønsket brukernavn og en gyldig epost adresse!';
$PMF_LANG['msgRegistrationNote'] = 'Etter en vellykket registrering vil du snarlig motta en epost med påloggingsdata. Dette skjer såsnart administrator har autorisert registreringen din.';
$PMF_LANG['ad_entry_changelog_history'] = 'Endringslogg historikk';
$LANG_CONF['socialnetworks.twitterAccessTokenSecret'] = array(0 => 'input', 1 => 'Twitter Hemmelig Token for aksess');
$LANG_CONF['socialnetworks.enableFacebookSupport'] = array(0 => 'checkbox', 1 => 'Facebook support (Standard: deaktivert)');
$LANG_CONF['security.ssoSupport'] = array(0 => 'checkbox', 1 => 'Single Sign On Support (Standard: deaktivert)');
$LANG_CONF['security.ssoLogoutRedirect'] = array(0 => 'input', 1 => 'Single Sign On utlogging videresendingsservice URL');
$LANG_CONF['main.dateFormat'] = array(0 => 'input', 1 => 'Dato format (Standard: Y-m-d H:i)');
$PMF_LANG['searchControlCenter'] = 'Søk';
$PMF_LANG['search.relevance.thema-content-keywords'] = 'Spørsmål - Svar - Nøkkelord';
$PMF_LANG['search.relevance.thema-keywords-content'] = 'Spørsmål - Nøkkelord - Svar';
$PMF_LANG['search.relevance.content-thema-keywords'] = 'Svar - Spørsmål - Nøkkelord';
$PMF_LANG['search.relevance.content-keywords-thema'] = 'Svar - Nøkkelord - Spørsmål';
$PMF_LANG['search.relevance.keywords-content-thema'] = 'Nøkkelord - Svar - Spørsmål';
$PMF_LANG['search.relevance.keywords-thema-content'] = 'Nøkkelord - Spørsmål - Svar';
$PMF_LANG['msgLoginUser'] = 'Logg inn';
$PMF_LANG['socialNetworksControlCenter'] = 'Sosiale nettverk konfigurasjon';
$LANG_CONF['search.relevance'] = array(0 => 'select', 1 => 'Sorter etter relevanse');
$LANG_CONF['search.enableRelevance'] = array(0 => 'checkbox', 1 => 'Aktiver support for relevanse? (Standard: deaktivert)');
$LANG_CONF['socialnetworks.enableTwitterSupport'] = array(0 => 'checkbox', 1 => 'Twitter support (Standard: deaktivert)');
$LANG_CONF['socialnetworks.twitterConsumerKey'] = array(0 => 'input', 1 => 'Twitter Forbruker Nøkkel');
$LANG_CONF['socialnetworks.twitterConsumerSecret'] = array(0 => 'input', 1 => 'Twitter Forbruker Hemmelig kode');
$LANG_CONF['socialnetworks.twitterAccessTokenKey'] = array(0 => 'input', 1 => 'Twitter Aksess Token nøkkel');