<?php

/**
 * The Hindi language file
 *
 * PHP Version 5.5
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @category  phpMyFAQ
 * @author    Sumeet Raj Aggarwal <sumeetrajaggarwal@shubhkriti.co.in>
 * @copyright 2009-2018 phpMyFAQ Team
 * @license   http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link      http://www.phpmyfaq.de
 * @since     2009-07-01
 */

$PMF_LANG["metaCharset"] = "utf-8";
$PMF_LANG["metaLanguage"] = "hi";
$PMF_LANG["language"] = "hindi ";
$PMF_LANG["dir"] = "ltr"; // ltr: left to right (e.g. English language); rtl: right to left (e.g. Arabic language)

$PMF_LANG["nplurals"] = "2";
/**
 * This parameter is used with the function 'plural' from inc/Language/Plurals.php
 * If this parameter and function are not in sync plural form support will be broken.
 */

// Navigation
$PMF_LANG["msgCategory"] = "वर्ग";
$PMF_LANG["msgShowAllCategories"] = "सभी वर्ग दिखाएं";
$PMF_LANG["msgSearch"] = "खोजें";
$PMF_LANG["msgAddContent"] = "विषय जोडें";
$PMF_LANG["msgQuestion"] = "प्रश्न पूछें";
$PMF_LANG["msgOpenQuestions"] = "अनसुलझे प्रश्न";
$PMF_LANG["msgHelp"] = "सहायता";
$PMF_LANG["msgContact"] = "संपर्क करें";
$PMF_LANG["msgHome"] = "घर";
$PMF_LANG["msgNews"] = "समाचार";
$PMF_LANG["msgUserOnline"] = " ऑनलाइन सदस्य";
$PMF_LANG["msgXMLExport"] = "XML-File";
$PMF_LANG["msgBack2Home"] = "प्रथम पृष्ठ पर जाएं";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Categories with entries";
$PMF_LANG["msgFullCategoriesIn"] = "Categories with entries in ";
$PMF_LANG["msgSubCategories"] = "उपवर्ग";
$PMF_LANG["msgEntries"] = "Entries";
$PMF_LANG["msgEntriesIn"] = "Questions in ";
$PMF_LANG["msgViews"] = "views";
$PMF_LANG["msgPage"] = "पृष्ट ";
$PMF_LANG["msgPages"] = " पृष्ट";
$PMF_LANG["msgPrevious"] = "पिछला";
$PMF_LANG["msgNext"] = "अगला";
$PMF_LANG["msgCategoryUp"] = "एक वर्ग आगे";
$PMF_LANG["msgLastUpdateArticle"] = "अंतिम अभीतकका: ";
$PMF_LANG["msgAuthor"] = "लेखक: ";
$PMF_LANG["msgPrinterFriendly"] = "छापने योग्य आवृत्ति";
$PMF_LANG["msgPrintArticle"] = "इसे छापें";
$PMF_LANG["msgMakeXMLExport"] = "XML-File में निर्यात";
$PMF_LANG["msgAverageVote"] = "औसत श्रेणीनर्धारण:";
$PMF_LANG["msgVoteUseability"] = "इसका श्रेणीनर्धारण करें:";
$PMF_LANG["msgVoteFrom"] = "में से";
$PMF_LANG["msgVoteBad"] = "एकदम बेकार";
$PMF_LANG["msgVoteGood"] = "अमूल्य";
$PMF_LANG["msgVotings"] = "मत ";
$PMF_LANG["msgVoteSubmit"] = "मत";
$PMF_LANG["msgVoteThanks"] = "आपके मत के लिए बहुत ही शुक्रिया!";
$PMF_LANG["msgYouCan"] = "You can ";
$PMF_LANG["msgWriteComment"] = "इस पर टीका-टिप्पणी करें";
$PMF_LANG["msgShowCategory"] = "विषय सिंहावलोकन: ";
$PMF_LANG["msgCommentBy"] = "टीका-टिप्पणी ";
$PMF_LANG["msgCommentHeader"] = "इस पर टीका-टिप्पणी";
$PMF_LANG["msgYourComment"] = "आपकी टीका-टिप्पणी:";
$PMF_LANG["msgCommentThanks"] = "आपके मत के लिए बहुत ही शुक्रिया!";
$PMF_LANG["msgSeeXMLFile"] = "XML-File खोलें";
$PMF_LANG["msgSend2Friend"] = "अपनी मित्र को भेजें";
$PMF_LANG["msgS2FName"] = "आपका नाम:";
$PMF_LANG["msgS2FEMail"] = "आपका ईमेल पता:";
$PMF_LANG["msgS2FFriends"] = "आपके मित्र:";
$PMF_LANG["msgS2FEMails"] = ". आपके मित्र:";
$PMF_LANG["msgS2FText"] = "निम्न सन्देश भेजा जाएगा:";
$PMF_LANG["msgS2FText2"] = "आप यह रिकॉर्ड इस पते पर पाएंगे:";
$PMF_LANG["msgS2FMessage"] = "आपके मित्र के लिए अतिरिक्त सन्देश:";
$PMF_LANG["msgS2FButton"] = "ईमेल भेजें";
$PMF_LANG["msgS2FThx"] = "प्रशंसा करने के लिए आपका धन्यवाद!";
$PMF_LANG["msgS2FMailSubject"] = "Recommendation from ";

// Search
$PMF_LANG["msgSearchWord"] = "कुंजी शब्द";
$PMF_LANG["msgSearchFind"] = "Search result for ";
$PMF_LANG["msgSearchAmount"] = " खोज के परिणाम";
$PMF_LANG["msgSearchAmounts"] = " खोज के परिणाम";
$PMF_LANG["msgSearchCategory"] = "वर्ग: ";
$PMF_LANG["msgSearchContent"] = "विषय: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "सहायता केंद्र के लिए प्रस्ताव";
$PMF_LANG["msgNewContentAddon"] = "आपका प्रस्ताव तुंरत छापा नहीं जाएगा, प्रशासनिक अधिकारी द्वारा जांच के बाद छापा जाएगा. आवश्यक जानकारी <strong>आपका नाम</strong>, <strong>आपका ईमेल पता</strong>, <strong>वर्ग</strong>, <strong>मुख्य वाक्य</strong> and <strong>आपका रिकॉर्ड</strong>. कृपया कुंजी शब्दों के मध्य में खाली जगह छोडें.";
$PMF_LANG["msgNewContentName"] = "आपका नाम:";
$PMF_LANG["msgNewContentMail"] = "आपका ईमेल पता:";
$PMF_LANG["msgNewContentCategory"] = "कौन सा वर्ग चुनना है?";
$PMF_LANG["msgNewContentTheme"] = "मुख्य वाक्य:";
$PMF_LANG["msgNewContentArticle"] = "आपका सहायता केंद्र रिकॉर्ड:";
$PMF_LANG["msgNewContentKeywords"] = "कुंजी शब्द:";
$PMF_LANG["msgNewContentLink"] = "इस रिकॉर्ड के लिए कडी";
$PMF_LANG["msgNewContentSubmit"] = "जमा करें";
$PMF_LANG["msgInfo"] = "अधिक जानकारी: ";
$PMF_LANG["msgNewContentThanks"] = "आपके सुझाव के लिए धन्यवाद!";
$PMF_LANG["msgNoQuestionsAvailable"] = "इस समय कोई भी विचाराधीन प्रश्न नहीं है.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "अपना प्रश्न निचे पूछें:";
$PMF_LANG["msgAskCategory"] = "वर्ग चुनें";
$PMF_LANG["msgAskYourQuestion"] = "आपका प्रश्न:";
$PMF_LANG["msgAskThx4Mail"] = "<h2>आपके प्रश्न के लिए धन्यवाद!</h2>";
$PMF_LANG["msgDate_User"] = "दिनांक / प्रयोगकर्त्ता";
$PMF_LANG["msgQuestion2"] = "प्रश्न";
$PMF_LANG["msg2answer"] = "ऊत्तर";
$PMF_LANG["msgQuestionText"] = "इस पृष्ट पर आप अन्य प्रयोगकर्त्ताओं द्वारा पुचा गया प्रश्न देख सकते हैं. यदि आप इन प्रश्नों का ऊत्तर देते हैं तो हो सकता है की आपका ऊत्तर सहायता केंद्र में जोड़ दिया जाए.";

// Help
$PMF_LANG["msgHelpText"] = "FAQ का संरचना (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions) बहुत ही आसान. या तो आप <strong><a href=\"?action=show\">वर्गों</a></strong> में खोज सकते हैं या फिर <strong><a href=\"?action=search\">सहायता केंद्र खोजक </a></strong> को कुंजी शब्दों के लिए खोजने दें .";

// Contact
$PMF_LANG["msgContactEMail"] = "प्रबंधक को सन्देश भेजें:";
$PMF_LANG["msgMessage"] = "आपका सन्देश:";

// Startseite
$PMF_LANG["msgNews"] = " समाचार";
$PMF_LANG["msgTopTen"] = "सर्वोत्तम 10";
$PMF_LANG["msgHomeThereAre"] = "यहाँ पर ";
$PMF_LANG["msgHomeArticlesOnline"] = " लेख उपलब्ध हैं";
$PMF_LANG["msgNoNews"] = "कोई समाचार उपलब्ध नहीं है.";
$PMF_LANG["msgLatestArticles"] = "नए लेख:";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "सहायता केंद्र में प्रस्ताव देने के लिए बहुत ही धन्यवाद.";
$PMF_LANG["msgMailCheck"] = "सहायता केंद्र में एक नया लेख है!\nकृपया प्रबंधन में जाकर जांच करें!";
$PMF_LANG["msgMailContact"] = "आपका सन्देश प्रबंधक को भेज दिया गया है.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "किसी भी डाटाबेस से संपर्क नहीं हो पा रहा है.";
$PMF_LANG["err_noHeaders"] = "कोई भी वर्ग उपलब्ध नहीं है.";
$PMF_LANG["err_noArticles"] = "कोई भी लेख उपलब्ध नहीं है.";
$PMF_LANG["err_badID"] = "क्षमा करें, गलत ID.";
$PMF_LANG["err_noTopTen"] = "अभी सर्वोत्तम १० उपलब्ध नहीं है.";
$PMF_LANG["err_nothingFound"] = "कोई भी लेख उपलब्ध नहीं है.";
$PMF_LANG["err_SaveEntries"] = "आवश्यक जानकारी <strong>आपका नाम</strong>, <strong>आपका ईमेल पता</strong>, <strong>वर्ग</strong>, <strong>मुख्य वाक्य</strong>, <strong>आपका रिकॉर्ड</strong> और, कब अनुरोध किया, <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Read more on Captcha at Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!<br /><br />\n<a href=\"javascript:history.back();\">एक पृष्ट पीछे</a><br /><br />\n";
$PMF_LANG["err_SaveComment"] = "आवश्यक जानकारी <strong>आपका नाम</strong>, <strong>आपका ईमेल पता</strong>, <strong>आपकी टिप्पणी</strong> और, कब अनुरोध किया, <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Read more on Captcha at Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!<br /><br />\n<a href=\"javascript:history.back();\">एक पृष्ट पीछे</a><br /><br />\n";
$PMF_LANG["err_VoteTooMuch"] = "हम दो बार दिए गए मत की गिनती नहीं करते हैं. पीछे जाने के लिए, क्लिक करें.";
$PMF_LANG["err_noVote"] = "<strong>आपने सवाल को मत नहीं दिया!</strong> मत देने के लिए यहाँ पर <a href=\"javascript:history.back();\">क्लिक करें</a>.";
$PMF_LANG["err_noMailAdress"] = "आपका ईमेल पता सही नहीं है.<br /><a href=\"javascript:history.back();\">पीछे</a>";
$PMF_LANG["err_sendMail"] = "आवश्यक जानकारियाँ <strong>आपका नाम</strong>, <strong>आपका ईमेल पता</strong>, <strong>आपका सवाल</strong> और, कब अनुरोध किया, <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Read more on Captcha at Wikipedia\" target=\"_blank\">Captcha</a> code</strong>!";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>लेख खोजें:</strong><br /><strong style=\"color: Red;\">शब्द1 शब्द2</strong> तरह से खोजे गए शब्दों से आप दो या दो से जयादा मानदण्डों पर घटते क्रम में उपयुक्त लेख खोज सकतें हैं.<strong>ध्यान दें:</strong> आपका खोजने का मानदण्ड कम से कम ४ अक्षरों का होना चाहिए, वरना उस खोज मानदण्ड को नकार दिया जाएगा.";

// Menü
$PMF_LANG["ad"] = "प्रबंधन क्षेत्र";
$PMF_LANG["ad_menu_user_administration"] = "प्रयोगकर्ता";
$PMF_LANG["ad_menu_entry_aprove"] = "लेख स्वीकार करें";
$PMF_LANG["ad_menu_entry_edit"] = "लेख का सम्पादन करें";
$PMF_LANG["ad_menu_categ_add"] = "वर्ग जोडें";
$PMF_LANG["ad_menu_categ_edit"] = "वर्ग का सम्पादन करें";
$PMF_LANG["ad_menu_news_add"] = "समाचार जोडें";
$PMF_LANG["ad_menu_news_edit"] = "समाचार का सम्पादन करें";
$PMF_LANG["ad_menu_open"] = "अनसुलझे प्रश्न";
$PMF_LANG["ad_menu_stat"] = "विश्लेषण";
$PMF_LANG["ad_menu_cookie"] = "कुकीस जोडें";
$PMF_LANG["ad_menu_session"] = "सेशन देखें";
$PMF_LANG["ad_menu_adminlog"] = "प्रबंधक लॉग देखें";
$PMF_LANG["ad_menu_passwd"] = "संकेत (Password) शब्द बदलें";
$PMF_LANG["ad_menu_logout"] = "सत्र समाप्त करें";
$PMF_LANG["ad_menu_startpage"] = "प्रथम पृष्ठ";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "अपनी पहचान करें.";
$PMF_LANG["ad_msg_passmatch"] = "दोनों संकेत शब्द एक ही हनी चाहिए!";
$PMF_LANG["ad_msg_savedsuc_1"] = "";
$PMF_LANG["ad_msg_savedsuc_2"] = " का पार्श्व चित्र सफलतापूर्वक संजो लिया गया है.";
$PMF_LANG["ad_msg_mysqlerr"] = "<strong>डाटाबेस से संपर्क नहीं हो पाने के कारण</strong>, पार्श्व चित्र संजोया नहीं गया है.";
$PMF_LANG["ad_msg_noauth"] = "आपके पास अधिकार नहीं है.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "पृष्ठ";
$PMF_LANG["ad_gen_of"] = "of";
$PMF_LANG["ad_gen_lastpage"] = "पिछला पृष्ठ";
$PMF_LANG["ad_gen_nextpage"] = "अगला पृष्ठ";
$PMF_LANG["ad_gen_save"] = "संजोयें";
$PMF_LANG["ad_gen_reset"] = "रिसेट करें";
$PMF_LANG["ad_gen_yes"] = "हाँ";
$PMF_LANG["ad_gen_no"] = "नहीं";
$PMF_LANG["ad_gen_top"] = "पृष्ठ के ऊपर";
$PMF_LANG["ad_gen_ncf"] = "कोई भी वर्ग नहीं मिला!";
$PMF_LANG["ad_gen_delete"] = "मिटा दें";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "प्रयोगकर्ता प्रबंधन";
$PMF_LANG["ad_user_username"] = "पंजीकृत प्रयोगकर्ता";
$PMF_LANG["ad_user_rights"] = "प्रयोगकर्ता के अधिकार";
$PMF_LANG["ad_user_edit"] = "सम्पादन करें";
$PMF_LANG["ad_user_delete"] = "मिटा दें";
$PMF_LANG["ad_user_add"] = "प्रयोगकर्ता जोडें";
$PMF_LANG["ad_user_profou"] = "प्रयोगकर्ता का पार्श्व चित्र";
$PMF_LANG["ad_user_name"] = "नाम";
$PMF_LANG["ad_user_password"] = "संकेत शब्द (Password)";
$PMF_LANG["ad_user_confirm"] = "पुष्टिकरण";
$PMF_LANG["ad_user_rights"] = "अधिकार";
$PMF_LANG["ad_user_del_1"] = "";
$PMF_LANG["ad_user_del_2"] = "प्रयोगकर्ता मिटा दिया जाये?";
$PMF_LANG["ad_user_del_3"] = "निश्चित रूप से?";
$PMF_LANG["ad_user_deleted"] = "प्रयोगकर्ता का खाता सफलतापूर्वक मिटा दिया गया है.";
$PMF_LANG["ad_user_checkall"] = "सभी चुनें";

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = "लेख प्रभंधन";
$PMF_LANG["ad_entry_id"] = "ID";
$PMF_LANG["ad_entry_topic"] = "विषय";
$PMF_LANG["ad_entry_action"] = "क्रिया";
$PMF_LANG["ad_entry_edit_1"] = "लेख सम्पादन";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "प्रश्न:";
$PMF_LANG["ad_entry_content"] = "ऊत्तर:";
$PMF_LANG["ad_entry_keywords"] = "कुंजी शब्द:";
$PMF_LANG["ad_entry_author"] = "लेखक:";
$PMF_LANG["ad_entry_category"] = "वर्ग:";
$PMF_LANG["ad_entry_active"] = "सक्रिय?";
$PMF_LANG["ad_entry_date"] = "दिनांक:";
$PMF_LANG["ad_entry_changed"] = "बदला गया?";
$PMF_LANG["ad_entry_changelog"] = "बदलाव का लॉग:";
$PMF_LANG["ad_entry_commentby"] = "के द्वारा टिका-टिप्पणी";
$PMF_LANG["ad_entry_comment"] = "टिका-टिप्पणी:";
$PMF_LANG["ad_entry_save"] = "संजोयें";
$PMF_LANG["ad_entry_delete"] = "मिटा दें";
$PMF_LANG["ad_entry_delcom_1"] = "क्या निश्चित रूप से प्रयोगकर्ता की टिप्पणी";
$PMF_LANG["ad_entry_delcom_2"] = "मिटा दी जाये?";
$PMF_LANG["ad_entry_commentdelsuc"] = "टिप्पणी <strong>सफलतापूर्वक</strong> मिटा दी गयी.";
$PMF_LANG["ad_entry_back"] = "लेख पर वापस जाएँ";
$PMF_LANG["ad_entry_commentdelfail"] = "टिप्पणी नहीं मिटाई गयी है.";
$PMF_LANG["ad_entry_savedsuc"] = "बदलाव <strong>सफलतापूर्वक</strong> संजो लिए गए हैं.";
$PMF_LANG["ad_entry_savedfail"] = "क्षमा करें, <strong>डाटाबेस में गडबडी</strong> हो गयी है.";
$PMF_LANG["ad_entry_del_1"] = "क्या निश्चित रूप से ";
$PMF_LANG["ad_entry_del_2"] = "लेख";
$PMF_LANG["ad_entry_del_3"] = "का मिटा दिया जाये?";
$PMF_LANG["ad_entry_delsuc"] = "<strong>सफलतापूर्वक</strong> मिटा दिया गया.";
$PMF_LANG["ad_entry_delfail"] = "विषय <strong>नहीं मिटाया गया</strong>!";
$PMF_LANG["ad_entry_back"] = "पीछे";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "लेख मुख्य:";
$PMF_LANG["ad_news_text"] = "लेख:";
$PMF_LANG["ad_news_link_url"] = "कड़ी (<strong>बिना http://</strong>):";
$PMF_LANG["ad_news_link_title"] = "कड़ी का विषय:";
$PMF_LANG["ad_news_link_target"] = "कड़ी का टार्गेट:";
$PMF_LANG["ad_news_link_window"] = "कड़ी नया विण्डो खोलती है";
$PMF_LANG["ad_news_link_faq"] = "सहायता केंद्र की कड़ी";
$PMF_LANG["ad_news_add"] = "समाचार जोडें";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "मुख्य समाचार";
$PMF_LANG["ad_news_date"] = "दिनांक";
$PMF_LANG["ad_news_action"] = "क्रिया";
$PMF_LANG["ad_news_update"] = "अभीतकका (Update)";
$PMF_LANG["ad_news_delete"] = "मिटा दें";
$PMF_LANG["ad_news_nodata"] = "डाटाबेस में कोई जानकारी उपलब्ध नहीं है";
$PMF_LANG["ad_news_updatesuc"] = "समाचार अपडेट हो गया.";
$PMF_LANG["ad_news_del"] = "क्या निश्चित रूप से इस समाचार को मिटा दिया जाए?";
$PMF_LANG["ad_news_yesdelete"] = "हाँ, मिटा दें!";
$PMF_LANG["ad_news_nodelete"] = "नहीं!";
$PMF_LANG["ad_news_delsuc"] = "समाचार मिटा दिया गया.";
$PMF_LANG["ad_news_updatenews"] = "समाचार अपडेट हो गया.";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "नया वर्ग जोडें";
$PMF_LANG["ad_categ_catnum"] = "वर्ग संख्या:";
$PMF_LANG["ad_categ_subcatnum"] = "उपवर्ग संख्या:";
$PMF_LANG["ad_categ_nya"] = "<em>अभी तक उपलब्ध नहीं है!</em>";
$PMF_LANG["ad_categ_titel"] = "वर्ग का विषय:";
$PMF_LANG["ad_categ_add"] = "वर्ग जोडें";
$PMF_LANG["ad_categ_existing"] = "मौजूद वर्ग";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "वर्ग";
$PMF_LANG["ad_categ_subcateg"] = "उपवर्ग";
$PMF_LANG["ad_categ_titel"] = "वर्ग का विषय";
$PMF_LANG["ad_categ_action"] = "क्रिया";
$PMF_LANG["ad_categ_update"] = "अभीतकका (update)";
$PMF_LANG["ad_categ_delete"] = "मिटा दें";
$PMF_LANG["ad_categ_updatecateg"] = "वर्ग अपडेट करें";
$PMF_LANG["ad_categ_nodata"] = "डाटाबेस में कोई जानकारी उपलब्ध नहीं है";
$PMF_LANG["ad_categ_remark"] = "कृपया ध्यान दें, यदि आप वर्ग को मिटा देते हैं तो मौजूदा लेख उपलब्ध नहीं होंगे. या तो आप लेख के लिए नया वर्ग चुन ले या फिर उसे मिटा दें.";
$PMF_LANG["ad_categ_edit_1"] = "सम्पादन";
$PMF_LANG["ad_categ_edit_2"] = "वर्ग";
$PMF_LANG["ad_categ_add"] = "वर्ग जोडें";
$PMF_LANG["ad_categ_added"] = "वर्ग जोड़ लिया गया है.";
$PMF_LANG["ad_categ_updated"] = "वर्ग को अपडेट कर दिया गया है.";
$PMF_LANG["ad_categ_del_yes"] = "हाँ, मिटा दें!";
$PMF_LANG["ad_categ_del_no"] = "नहीं!";
$PMF_LANG["ad_categ_deletesure"] = "क्या निश्चित रूप से इस वर्ग को मिटा दिया जाए?";
$PMF_LANG["ad_categ_deleted"] = "वर्ग मिटा दिया गया.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "कुकी को सफलतापूर्वक जोड़ दिया गया है.";
$PMF_LANG["ad_cookie_already"] = "एक कुकी पहले से ही मौजूद है. आपके पास निम्न विकल्प हैं:";
$PMF_LANG["ad_cookie_again"] = "कुकी पुनः जोड़े";
$PMF_LANG["ad_cookie_delete"] = "कुकी मिटा दें";
$PMF_LANG["ad_cookie_no"] = "अभी कोई कुकी मौजूद नहीं है. कुकी के साथ आप अपनी लॉगिन जानकारी संजो सकते हैं, यानी लॉगिन जानकारी याद रखने की जरूरत नहीं. अब आपके पास निम्न विकल्प हैं:";
$PMF_LANG["ad_cookie_set"] = "कुकी जोड़े";
$PMF_LANG["ad_cookie_deleted"] = "कुकी सफलतापूर्वक मिटा दी गयी है.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "प्रबंधन लॉग";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "अपना संकेतक शब्द (Password) बदलें";
$PMF_LANG["ad_passwd_old"] = "पुराना संकेतक शब्द:";
$PMF_LANG["ad_passwd_new"] = "नया संकेतक शब्द:";
$PMF_LANG["ad_passwd_con"] = "पुनः डालें:";
$PMF_LANG["ad_passwd_change"] = "संकेतक शब्द बदलें";
$PMF_LANG["ad_passwd_suc"] = "संकेतक शब्द सफलतापूर्वक बदल दिया गया.";
$PMF_LANG["ad_passwd_remark"] = "<strong>ध्यान दें:</strong><br />कुकी पुनः जोड़नी होगी!";
$PMF_LANG["ad_passwd_fail"] = "पुराना संकेतक शब्द सही होना चाहिए तथा दोनों नए संकेतक शब्द एक ही होने चाहिए.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "प्रयोगकर्ता जोडें";
$PMF_LANG["ad_adus_name"] = "नाम:";
$PMF_LANG["ad_adus_password"] = "संकेतक शब्द:";
$PMF_LANG["ad_adus_add"] = "प्रयोगकर्ता जोडें";
$PMF_LANG["ad_adus_suc"] = "प्रयोगकर्ता <strong>सफलतापूर्वक</strong> जोड़ दिया गया.";
$PMF_LANG["ad_adus_edit"] = "पार्श्व चित्र सम्पादन";
$PMF_LANG["ad_adus_dberr"] = "<strong>डाटाबेस एरर!</strong>";
$PMF_LANG["ad_adus_exerr"] = "प्रयोगकर्ता पहले से ही मौजूद है.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "Session ID";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "समय";
$PMF_LANG["ad_sess_pageviews"] = "पृष्ठदृश्य संख्या";
$PMF_LANG["ad_sess_search"] = "खोजें";
$PMF_LANG["ad_sess_sfs"] = "सत्र खोजें";
$PMF_LANG["ad_sess_s_ip"] = "IP:";
$PMF_LANG["ad_sess_s_minct"] = "min. सक्रियता:";
$PMF_LANG["ad_sess_s_date"] = "दिनांक";
$PMF_LANG["ad_sess_s_after"] = "के बाद";
$PMF_LANG["ad_sess_s_before"] = "पहला";
$PMF_LANG["ad_sess_s_search"] = "खोजें";
$PMF_LANG["ad_sess_session"] = "सत्र";
$PMF_LANG["ad_sess_r"] = "परिणाम खोजें";
$PMF_LANG["ad_sess_referer"] = "रेफरर:";
$PMF_LANG["ad_sess_browser"] = "ब्राउजर:";
$PMF_LANG["ad_sess_ai_rubrik"] = "वर्ग:";
$PMF_LANG["ad_sess_ai_artikel"] = "लेख:";
$PMF_LANG["ad_sess_ai_sb"] = "खोजा गया शब्द:";
$PMF_LANG["ad_sess_ai_sid"] = "सत्र ID:";
$PMF_LANG["ad_sess_back"] = "पीछे";

// Statistik
$PMF_LANG["ad_rs"] = "मत परिणाम";
$PMF_LANG["ad_rs_rating_1"] = "प्रयोगकर्ता";
$PMF_LANG["ad_rs_rating_2"] = "मत दर्शाता है:";
$PMF_LANG["ad_rs_red"] = "लाल";
$PMF_LANG["ad_rs_green"] = "हरा";
$PMF_LANG["ad_rs_altt"] = "२ से कम औसत";
$PMF_LANG["ad_rs_ahtf"] = "४ से अधिक औसत";
$PMF_LANG["ad_rs_no"] = "कोई मत उपलब्ध नहीं है";

// Auth
$PMF_LANG["ad_auth_insert"] = "अपना प्रयोगकर्ता नाम व संकेतक शब्द डालें.";
$PMF_LANG["ad_auth_user"] = "प्रयोगकर्ता नाम:";
$PMF_LANG["ad_auth_passwd"] = "संकेतक शब्द:";
$PMF_LANG["ad_auth_ok"] = "हाँ";
$PMF_LANG["ad_auth_reset"] = "पुनः सेट करें";
$PMF_LANG["ad_auth_fail"] = "प्रयोगकर्ता नाम या संकेतक शब्द सही नहीं है.";
$PMF_LANG["ad_auth_sess"] = "सत्र ID भेज दी गयी है.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "सरंचना सम्पादन";
$PMF_LANG["ad_config_save"] = "सरंचना संजोयें";
$PMF_LANG["ad_config_reset"] = "पुनः सेट करें";
$PMF_LANG["ad_config_saved"] = "सरंचना सफलतापूर्वक संजो ली गयी है.";
$PMF_LANG["ad_menu_editconfig"] = "सरंचना सम्पादन";
$PMF_LANG["ad_att_none"] = "कोई भी फाइल जुडी नहीं है";
$PMF_LANG["ad_att_att"] = "जुडी हुई फाइलें:";
$PMF_LANG["ad_att_add"] = "फाइल जोडें";
$PMF_LANG["ad_entryins_suc"] = "रिकॉर्ड सफलतापूर्वक लजोया गया है.";
$PMF_LANG["ad_entryins_fail"] = "क्षमा करें, कोई खरीबी हो गयी है.";
$PMF_LANG["ad_att_del"] = "मिटा दें";
$PMF_LANG["ad_att_nope"] = "फाइलें केवल सम्पादन के समय ही जोड़ी जा सकती हैं.";
$PMF_LANG["ad_att_delsuc"] = "जुडी हुई फाइल मिटा दी गयी है.";
$PMF_LANG["ad_att_delfail"] = "जुडी हुई फाइल को मिटाने में एरर हुई है.";
$PMF_LANG["ad_entry_add"] = "सहायता लेख जोडें";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "बेकप आपके डाटाबेस जानकारी का पूरा मानचित्र होता है. बेकप का फॉर्मेट SQL फाइल होता है, जो की आप phpmyAdmin या commandline sql client की मदद से इंपोर्ट कर सकते हैं. बेकप कम से कम एक माह में एक बार होना चाहिए.";
$PMF_LANG["ad_csv_link"] = "बेकप डाउनलोड करें";
$PMF_LANG["ad_csv_head"] = "बेकप बनाएं";
$PMF_LANG["ad_att_addto"] = "फाइल जोडें";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "फाइल:";
$PMF_LANG["ad_att_butt"] = "हाँ";
$PMF_LANG["ad_att_suc"] = "फाइल सफलतापूर्वक जोड़ दी गयी है.";
$PMF_LANG["ad_att_fail"] = "फाइल जोड़ते समय एरर हो गयी है.";
$PMF_LANG["ad_att_close"] = "इस विण्डो को बंद करें";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "इस फॉर्म की मदद से आप अपने डाटाबेस को पुनः रिस्टोर कर सकते हैं, जो की आपने phpmyfaq की मदद से बनाया था.कृपया ध्यान दें की मौजूदा जानकारी के ऊपर पुनः जानकारी लिखी जाएगी.";
$PMF_LANG["ad_csv_file"] = "फाइल";
$PMF_LANG["ad_csv_ok"] = "हाँ";
$PMF_LANG["ad_csv_linklog"] = "बेकप LOGs";
$PMF_LANG["ad_csv_linkdat"] = "बेकप जानकारी";
$PMF_LANG["ad_csv_head2"] = "रिस्टोर";
$PMF_LANG["ad_csv_no"] = "यह phpmyfaq का बेकप नहीं लगता.";
$PMF_LANG["ad_csv_prepare"] = "डाटाबेस क्वैरी तयार कर रहे है...";
$PMF_LANG["ad_csv_process"] = "क्वैरी कर रहे हैं...";
$PMF_LANG["ad_csv_of"] = "of";
$PMF_LANG["ad_csv_suc"] = "सफल.";
$PMF_LANG["ad_csv_backup"] = "बेकप";
$PMF_LANG["ad_csv_rest"] = "बेकप रिस्टोर करें";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "बेकप";
$PMF_LANG["ad_logout"] = "सत्र सफलतापूर्वक समाप्त कर दिया.";
$PMF_LANG["ad_news_add"] = "समाचार जोडें";
$PMF_LANG["ad_news_edit"] = "समाचार सम्पादन";
$PMF_LANG["ad_cookie"] = "कुकीस";
$PMF_LANG["ad_sess_head"] = "सत्र देखें";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = "वर्ग";
$PMF_LANG["ad_menu_stat"] = "मत परिणाम";
$PMF_LANG["ad_kateg_add"] = "मुख्य वर्ग जोडें";
$PMF_LANG["ad_kateg_rename"] = "पुनः नाम दें";
$PMF_LANG["ad_adminlog_date"] = "दिनांक";
$PMF_LANG["ad_adminlog_user"] = "प्रयोगकर्ता";
$PMF_LANG["ad_adminlog_ip"] = "IP-पता";

$PMF_LANG["ad_stat_sess"] = "सत्र";
$PMF_LANG["ad_stat_days"] = "दिन";
$PMF_LANG["ad_stat_vis"] = "सत्र (दर्शन)";
$PMF_LANG["ad_stat_vpd"] = "प्रतिदिन दर्शन";
$PMF_LANG["ad_stat_fien"] = "प्रथम Log";
$PMF_LANG["ad_stat_laen"] = "अंतिम Log";
$PMF_LANG["ad_stat_browse"] = "सत्र देखें";
$PMF_LANG["ad_stat_ok"] = "हाँ";

$PMF_LANG["ad_sess_time"] = "समय";
$PMF_LANG["ad_sess_sid"] = "सत्र-ID";
$PMF_LANG["ad_sess_ip"] = "IP-पता";

$PMF_LANG["ad_ques_take"] = "सवाल लें और उसका सम्पादन करें";
$PMF_LANG["no_cats"] = "कोई वर्ग नहीं मिला.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "गलत प्रयोगकर्ता नाम या संकेतक शब्द.";
$PMF_LANG["ad_log_sess"] = "सत्र समाप्त हो गया .";
$PMF_LANG["ad_log_edit"] = "निम्न प्रयोगकर्ता के लिए \"प्रयोगकर्ता सम्पादन\"-फॉर्म: ";
$PMF_LANG["ad_log_crea"] = "\"नए लेख\" के लिए फॉर्म.";
$PMF_LANG["ad_log_crsa"] = "नयी एंट्री बना दी गयी है.";
$PMF_LANG["ad_log_ussa"] = "निम्न प्रयोगकर्ता की जानकारी अपडेट करो: ";
$PMF_LANG["ad_log_usde"] = "निम्न प्रयोगकर्ता को मिटा दें: ";
$PMF_LANG["ad_log_beed"] = "निम्न प्रयोगकर्ता के लिए सम्पादन फॉर्म: ";
$PMF_LANG["ad_log_bede"] = "निम्न को मिटा दें: ";

$PMF_LANG["ad_start_visits"] = "दर्शन";
$PMF_LANG["ad_start_articles"] = "लेख";
$PMF_LANG["ad_start_comments"] = "टिका-टिप्पणी";

$PMF_LANG["ad_user_chpw"] = "आप केवल मौजूदा प्रयोगकर्ता का संकेतक शब्द बदल सकते हैं \"".$PMF_LANG["ad_menu_passwd"]."\".";

// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "चिपकाएँ (paste)";
$PMF_LANG["ad_categ_cut"] = "काटें (cut)";
$PMF_LANG["ad_categ_copy"] = "नक़ल करें (copy)";
$PMF_LANG["ad_categ_process"] = "वर्ग संसाधित हो रहा है...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>आपके पास अधिकार नहीं है.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "पिछला पृष्ठ";
$PMF_LANG["msgNextPage"] = "अगला पृष्ठ";
$PMF_LANG["msgPageDoublePoint"] = "पृष्ठ: ";
$PMF_LANG["msgMainCategory"] = "मुख्य वर्ग";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "आपका संकेतक शब्द बदल दिया गया है.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "इसे PDF फाइल की तरह दिखाएं";
$PMF_LANG["ad_xml_head"] = "XML-बेकप";
$PMF_LANG["ad_xml_hint"] = "अपने सारे रिकॉर्ड XML फाइल में संजोयें.";
$PMF_LANG["ad_xml_gen"] = "XML फाइल बनाएं";
$PMF_LANG["ad_entry_locale"] = "भाषा";
$PMF_LANG["msgLanguageSubmit"] = "भाषा बदलें";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "पूर्व दर्शन";
$PMF_LANG["ad_attach_1"] = "कृपया फाइलें जोड़ने के लिए पहले सरंचना (configuration) में डायरेक्टरी का चुनाव करें.";
$PMF_LANG["ad_attach_2"] = "कृपया फाइलें जोड़ने के लिए पहले सरंचना (configuration) में कड़ी का चुनाव करें.";
$PMF_LANG["ad_attach_3"] = "फाइल attachment.php को बिना पूर्ण अधिकार के नहीं खोला जा सकता.";
$PMF_LANG["ad_attach_4"] = "जोड़ी जाने वाली फाइल का साइज़ %s बिट्स से कम होना चाहिए.";
$PMF_LANG["ad_menu_export"] = "अपनी सहायता केंद्र को निर्यात करें";
$PMF_LANG["ad_export_1"] = "RSS-Feed बनाएं";
$PMF_LANG["ad_export_2"] = ".";
$PMF_LANG["ad_export_file"] = "एरर: फाइल नहीं लिखी जा सकी.";
$PMF_LANG["ad_export_news"] = "समाचार RSS-Feed";
$PMF_LANG["ad_export_topten"] = "सर्वोत्तम १० RSS-Feed";
$PMF_LANG["ad_export_latest"] = "५ नए  RSS-Feed";
$PMF_LANG["ad_export_pdf"] = "PDF-सभी रिकॉर्ड निर्यात करें";
$PMF_LANG["ad_export_generate"] = "RSS-Feed बनाएं";

$PMF_LANG["rightsLanguage"]['adduser'] = "प्रयोगकर्ता जोडें";
$PMF_LANG["rightsLanguage"]['edituser'] = "प्रयोगकर्ता का सम्पादन करेंr";
$PMF_LANG["rightsLanguage"]['deluser'] = "प्रयोगकर्ता को मिटायें";
$PMF_LANG["rightsLanguage"]['addbt'] = "नया रिकॉर्ड जोडें";
$PMF_LANG["rightsLanguage"]['editbt'] = "रिकॉर्ड का सम्पादन करें";
$PMF_LANG["rightsLanguage"]['delbt'] = "रिकॉर्ड को मिटा दें";
$PMF_LANG["rightsLanguage"]['viewlog'] = "लॉग देखें";
$PMF_LANG["rightsLanguage"]['adminlog'] = "प्रबंधक लॉग देखें";
$PMF_LANG["rightsLanguage"]['delcomment'] = "टिप्पणी मिटायें";
$PMF_LANG["rightsLanguage"]['addnews'] = "समाचार जोडें";
$PMF_LANG["rightsLanguage"]['editnews'] = "समाचार का सम्पादन करें";
$PMF_LANG["rightsLanguage"]['delnews'] = "समाचार मिटायें";
$PMF_LANG["rightsLanguage"]['addcateg'] = "वर्ग जोडें";
$PMF_LANG["rightsLanguage"]['editcateg'] = "वर्ग का सम्पादन करें";
$PMF_LANG["rightsLanguage"]['delcateg'] = "वर्ग को मिटा दें";
$PMF_LANG["rightsLanguage"]['passwd'] = "संकेतक शब्द बदलें";
$PMF_LANG["rightsLanguage"]['editconfig'] = "सरंचना (config) बदलें";
$PMF_LANG["rightsLanguage"]['addatt'] = "फाइल जोडें";
$PMF_LANG["rightsLanguage"]['delatt'] = "फाइल मिटायें";
$PMF_LANG["rightsLanguage"]['backup'] = "बेकप बनाएं";
$PMF_LANG["rightsLanguage"]['restore'] = "बेकप रेस्टोर करें ";
$PMF_LANG["rightsLanguage"]['delquestion'] = "अनसुलझे प्रश्न मिटायें";
$PMF_LANG["rightsLanguage"]['changebtrevs'] = "पुनवलोकन का सम्पादन करें";

$PMF_LANG["msgAttachedFiles"] = "जुडी हुई फाइलें:";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "क्रिया";
$PMF_LANG["ad_entry_email"] = "ईमेल पता:";
$PMF_LANG["ad_entry_allowComments"] = "टिप्पणी करने दें:";
$PMF_LANG["msgWriteNoComment"] = "आप इस विषय पर टिप्पणी नहीं कर सकते";
$PMF_LANG["ad_user_realname"] = "वास्तविक नाम:";
$PMF_LANG["ad_export_generate_pdf"] = "PDF फाइल बनाएं";
$PMF_LANG["ad_export_full_faq"] = "आपका FAQ PDF फाइल में: ";
$PMF_LANG["err_bannedIP"] = "आपके IP पते को प्रतिबंधित कर दिया गया है.";
$PMF_LANG["err_SaveQuestion"] = "आवश्यक जानकारियाँ <strong>आपका नाम</strong>, <strong>आपका ईमेल पता</strong>, <strong>आपका सवाल</strong> और, कण अनुरोध किया गया,  <strong><a href=\"http://en.wikipedia.org/wiki/Captcha\" title=\"Read more on Captcha at Wikipedia\" target=\"_blank\">Captcha</a> code</strong>.<br /><br /><a href=\"javascript:history.back();\">एक पृष्ठ पीछे</a><br /><br />\n";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "फॉण्ट का रंग: ";
$PMF_LANG["ad_entry_fontsize"] = "फॉण्ट का आकार: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array(0 => "select", 1 => "भाषा");
$LANG_CONF["main.languageDetection"] = array(0 => "checkbox", 1 => "विषय का मोलतोल स्वतः ही होने दें");
$LANG_CONF['main.titleFAQ'] = array(0 => "input", 1 => "FAQ का नाम");
$LANG_CONF['main.currentVersion'] = array(0 => "print", 1 => "FAQ का संस्करण");
$LANG_CONF["main.metaDescription"] = array(0 => "input", 1 => "पृष्ठ का वर्णन");
$LANG_CONF["main.metaKeywords"] = array(0 => "input", 1 => "वेब क्रॉलर के लिए कुंजी शब्द");
$LANG_CONF["main.metaPublisher"] = array(0 => "input", 1 => "प्रकाशक का नाम");
$LANG_CONF['main.administrationMail'] = array(0 => "input", 1 => "प्रबंधक का ईमेल पता");
$LANG_CONF["main.contactInformations"] = array(0 => "area", 1 => "संपर्क करने की जानकारी");
$LANG_CONF["main.send2friendText"] = array(0 => "area", 1 => "दोस्त को भेजने के लिए वाले पेज के लिए शब्द");
$LANG_CONF['records.maxAttachmentSize'] = array(0 => "input", 1 => "फाइल जोड़ने के लिए अधिकतम साइज़ (अधिकतम. ".ini_get("upload_max_filesize")."बाइट्स)");
$LANG_CONF["records.disableAttachments"] = array(0 => "checkbox", 1 => "फाइलों को एंट्री के निचे जोडें?");
$LANG_CONF["main.enableUserTracking"] = array(0 => "checkbox", 1 => "लेखा जोखा रखें?");
$LANG_CONF["main.enableAdminLog"] = array(0 => "checkbox", 1 => "प्रबंधक लॉग का प्रयोग करें?");
$LANG_CONF["security.ipCheck"] = array(0 => "checkbox", 1 => "admin.php में UINs देखते समय IP भी देखें?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array(0 => "input", 1 => "एक पृष्ठ पर कितने विषय दिखायें");
$LANG_CONF["records.numberOfShownNewsEntries"] = array(0 => "input", 1 => "समाचार लेखों की संख्या");
$LANG_CONF['security.bannedIPs'] = array(0 => "area", 1 => "इन IPs को प्रतिबंधित करें");
$LANG_CONF["main.enableRewriteRules"] = array(0 => "checkbox", 1 => "mod_rewrite को सक्रिय करें? (पूर्वनिर्धारित: असक्रिय)");
$LANG_CONF["security.ldapSupport"] = array(0 => "checkbox", 1 => "क्या आप LDAP को सक्रिय करना चाहते हैं? (पूर्वनिर्धारित: असक्रिय)");
$LANG_CONF["main.referenceURL"] = array(0 => "input", 1 => "कड़ी सत्यापन के लिए आधार URL (e.g.: http://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array(0 => "input", 1 => "AJAX कड़ी सत्यापन के मध्य समय अवधि (in seconds)");
$LANG_CONF["records.enableVisibilityQuestions"] = array(0 => "checkbox", 1 => "नए सवाल न दिखायें?");
$LANG_CONF['security.permLevel'] = array(0 => "input", 1 => "आज्ञा समतल");

$PMF_LANG["ad_categ_new_main_cat"] = "नए मुख्य वर्ग के रूप में";
$PMF_LANG["ad_categ_paste_error"] = "इस वर्ग को यहाँ से हटाना संभव नहीं है.";
$PMF_LANG["ad_categ_move"] = "वर्ग हटायें";
$PMF_LANG["ad_categ_lang"] = "भाषा";
$PMF_LANG["ad_categ_desc"] = "वर्णन";
$PMF_LANG["ad_categ_change"] = "इसके साथ बदलें";

$PMF_LANG["lostPassword"] = "संकेतक शब्द भूल गए? यहाँ क्लिक करें.";
$PMF_LANG["lostpwd_err_1"] = "ध्यान दें: प्रयोगकर्ता और ईमेल पता नहीं मिला.";
$PMF_LANG["lostpwd_err_2"] = "ध्यान दें: गलत एंट्री!";
$PMF_LANG["lostpwd_text_1"] = "अपनी खाते की जानकारी पूछने के लिए धन्यवाद.";
$PMF_LANG["lostpwd_text_2"] = "अपनी FAQ के प्रबंधक केंद्र मैं नया संकेतक शब्द दाल लें.";
$PMF_LANG["lostpwd_mail_okay"] = "ईमेल भेज दिया गया है.";

$PMF_LANG["ad_xmlrpc_button"] = "phpMyFaq का नया संस्करण पाएं";
$PMF_LANG["ad_xmlrpc_latest"] = "नया संस्करण उपलब्ध है";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'वर्ग की भाषा चुने';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'साईट मानचित्र';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'इस लेख का अभी पुनवलोकन हो रहा है इस लिए यह अभी उपलब्ध नहीं है.';
$PMF_LANG['msgArticleCategories'] = 'इसके लिए वर्ग';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'उत्तर के लिए अपूर्व ID';
$PMF_LANG['ad_entry_faq_record'] = 'FAQ रिकॉर्ड';
$PMF_LANG['ad_entry_new_revision'] = 'नया पुनवलोकन करें?';
$PMF_LANG['ad_entry_record_administration'] = 'रिकॉर्ड प्रबंधन';
$PMF_LANG['ad_entry_changelog'] = 'लॉग';
$PMF_LANG['ad_entry_revision'] = 'पुनवलोकन';
$PMF_LANG['ad_changerev'] = 'पुनवलोकन चुने';
$PMF_LANG['msgCaptcha'] = "चित्र में जो शब्द आपको दिख रहे हैं वो यहाँ लिखें";
$PMF_LANG['msgSelectCategories'] = 'इसमें खोजें ...';
$PMF_LANG['msgAllCategories'] = '... सभी वर्गों मैं';
$PMF_LANG['ad_you_should_update'] = 'आपके phpMyFaq  का प्रतिष्ठापन पुराना हो गया है. नया संस्करण अपडेट करें.';
$PMF_LANG['msgAdvancedSearch'] = 'आधुनिक खोज';

// added v1.6.1 - 2006-04-25 by Matteo and Thorsten
$PMF_LANG['spamControlCenter'] = 'अन्वान्चित क्रिया नियंत्रण केंद्र';
$LANG_CONF["spam.enableSafeEmail"] = array(0 => "checkbox", 1 => "प्रयोगकर्ताओं का ईमेल पता सुरक्षित तरीके से छापें (पूर्वनिर्धारित: सक्रिय).");
$LANG_CONF["spam.checkBannedWords"] = array(0 => "checkbox", 1 => "सार्वजनिक लेखों की जांच प्रतिबंधित शब्दों के साथ करें (पूर्वनिर्धारित: सक्रिय).");
$LANG_CONF["spam.enableCaptchaCode"] = array(0 => "checkbox", 1 => "सार्वजनिक फॉर्म को जमा करने के लिए Captcha code का प्रयोग करें (पूर्वनिर्धारित: सक्रिय).");
$PMF_LANG['ad_session_expiring'] = 'आपका सत्र %d minutes: में समाप्त हो जाएगा. क्या आप काम आगे जारी रखना चाहते हैं?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'सत्र प्रबंधन';
$PMF_LANG['ad_stat_choose'] = 'माह चुने';
$PMF_LANG['ad_stat_delete'] = 'चुने हुए सत्र को तुंरत मिटा दें';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'शब्दसंग्रह';
$PMF_LANG['ad_glossary_add'] = 'शब्दसंग्रह जोडें';
$PMF_LANG['ad_glossary_edit'] = 'शब्दसंग्रह का सम्पादन करें';
$PMF_LANG['ad_glossary_item'] = 'शब्द';
$PMF_LANG['ad_glossary_definition'] = 'मतलब';
$PMF_LANG['ad_glossary_save'] = 'संजोयें';
$PMF_LANG['ad_glossary_save_success'] = 'शब्दसंग्रह सफलतापूर्वक संजो लिया गया है!';
$PMF_LANG['ad_glossary_save_error'] = 'किसी खराबी की वज़ह से शब्दसंग्रह  संजोया नहीं गया है.';
$PMF_LANG['ad_glossary_update_success'] = 'शब्दसंग्रह सफलतापूर्वक अपडेट कर दिया गया है!';
$PMF_LANG['ad_glossary_update_error'] = 'किसी खराबी की वज़ह से शब्दसंग्रह अपडेट नहीं किया गया है.';
$PMF_LANG['ad_glossary_delete'] = 'इसे मिटा दें';
$PMF_LANG['ad_glossary_delete_success'] = 'शब्दसंग्रह सफलतापूर्वक मिटा दिया गया है!';
$PMF_LANG['ad_glossary_delete_error'] = 'किसी खराबी की वज़ह से शब्दसंग्रह नहीं मिट सका है.';
$PMF_LANG['ad_linkcheck_noReferenceURL'] = 'स्वतः कड़ी सत्यापन सक्रिय नहीं है (कड़ी सत्यापन के लिए आधार URL नहीं बताया गया है)';
$PMF_LANG['ad_linkcheck_noAllowUrlOpen'] = 'स्वतः कड़ी सत्यापन सक्रिय नहीं है (PHP का allow_url_fopen विकल्प सक्रिय नहीं है)';
$PMF_LANG['ad_linkcheck_checkResult'] = 'स्वतः कड़ी सत्यापन परिणाम';
$PMF_LANG['ad_linkcheck_checkSuccess'] = 'हाँ';
$PMF_LANG['ad_linkcheck_checkFailed'] = 'असफल';
$PMF_LANG['ad_linkcheck_failReason'] = 'असफलता के कारण:';
$PMF_LANG['ad_linkcheck_noLinksFound'] = 'कोई भी URL कड़ी सत्यापन सुविधा के अनुकूल नहीं पाया गया.';
$PMF_LANG['ad_linkcheck_searchbadonly'] = 'सिर्फ खराब कड़ियाँ ही मौजूद हैं';
$PMF_LANG['ad_linkcheck_infoReason'] = 'अतिरिक्त जानकारी:';
$PMF_LANG['ad_linkcheck_openurl_infoprefix'] = 'जांच के समय पायी गयी <strong>%s</strong>: ';
$PMF_LANG['ad_linkcheck_openurl_notready'] = 'कड़ी सत्यापन सुविधा तयार नहीं है.';
$PMF_LANG['ad_linkcheck_openurl_maxredirect'] = 'अधिकतम अनुप्रेषित करने की सीमा <strong>%d</strong> पार हो गयी है.';
$PMF_LANG['ad_linkcheck_openurl_urlisblank'] = 'कड़ी खाली है.';
$PMF_LANG['ad_linkcheck_openurl_tooslow'] = 'होस्ट <strong>%s</strong> या तो धीमा है या जवाब नहीं दे रहा है.';
$PMF_LANG['ad_linkcheck_openurl_nodns'] = 'होस्ट का DNS जवाब <strong>%s</strong> या तो धीमा है या DNS के विव्वाद के कारण असफल हो गया है , स्थानीय या दूरवर्ती.';
$PMF_LANG['ad_linkcheck_openurl_redirected'] = 'URL इस पर  <strong>%s</strong> अनुप्रेषित हुआ.';
$PMF_LANG['ad_linkcheck_openurl_ambiguous'] = 'द्वयार्थी HTTP स्टेटस <strong>%s</strong> मिला.';
$PMF_LANG['ad_linkcheck_openurl_not_allowed'] = 'होस्ट <strong>%s</strong> के द्वारा <em>HEAD</em> तरीके के प्रयोग के लिए अनुमति नहीं है , अनुमातिप्रदान तरीके: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_found'] = 'यह युक्ति होस्ट <strong>%s</strong> पर नहीं पाई गयी.';
$PMF_LANG['ad_linkcheck_protocol_unsupported'] = '%s प्रोटोकॉल को स्वतः कड़ी जांच सुविधा की अनुमति नहीं है.';
$PMF_LANG['msgNewQuestionVisible'] = 'सवाल को सार्वजनिक करने से पहले उसका अवलोकन करना जरूरी है.';
$PMF_LANG['msgQuestionsWaiting'] = 'छपने के लिए प्रबंधक की अनुमति का इंतज़ार हो रहा है: ';
$PMF_LANG['ad_entry_visibility'] = 'छापे?';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] =  "कृपया संकेतक शब्द भरे. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] =  "संकेतक शब्द सामान नहीं हैं. ";
$PMF_LANG['ad_user_error_loginInvalid'] =  "दिया गया प्रयोगकर्ता नाम अवैध है.";
$PMF_LANG['ad_user_error_noEmail'] =  "कृपया सही पता डालें. ";
$PMF_LANG['ad_user_error_noRealName'] =  "कृपया अपना वास्तविक नाम डालें. ";
$PMF_LANG['ad_user_error_delete'] =  "प्रयोगकर्ता खाता नहीं मिट सका. ";
$PMF_LANG['ad_user_error_noId'] =  "कोई भी ID नहीं दी गयी है. ";
$PMF_LANG['ad_user_error_protectedAccount'] =  "प्रयोगकर्ता खाता सुरक्षित है. ";
$PMF_LANG['ad_user_deleteUser'] = "प्रयोगकर्ता के खाते को मिटा दें";
$PMF_LANG['ad_user_status'] = "स्तिथि:";
$PMF_LANG['ad_user_lastModified'] = "आखिरी बार बदला गया:";
$PMF_LANG['ad_gen_cancel'] = "रद्द करें";
$PMF_LANG["rightsLanguage"]['addglossary'] = "शब्दसंग्रह जोड़े";
$PMF_LANG["rightsLanguage"]['editglossary'] = "शब्दसंग्रह सम्पादन";
$PMF_LANG["rightsLanguage"]['delglossary'] = "शब्दसंग्रह मिटाना";
$PMF_LANG["ad_menu_group_administration"] = "दल";
$PMF_LANG['ad_user_loggedin'] = 'आपका सत्र इस नाम से चल रहा है ';

$PMF_LANG['ad_group_details'] = "दल की जानकारी";
$PMF_LANG['ad_group_add'] = "दल जोड़े";
$PMF_LANG['ad_group_add_link'] = "दल जोड़े";
$PMF_LANG['ad_group_name'] = "नाम:";
$PMF_LANG['ad_group_description'] = "वर्णन:";
$PMF_LANG['ad_group_autoJoin'] = "स्वतः शामिल हो:";
$PMF_LANG['ad_group_suc'] = "दल सफलतापूर्वक जोड़ दिया गया है.";
$PMF_LANG['ad_group_error_noName'] = "कृपया दल का नाम डालें. ";
$PMF_LANG['ad_group_error_delete'] = "दल नहीं मिट सका. ";
$PMF_LANG['ad_group_deleted'] = "दल सफलतापूर्वक मिटा दिया गया है.";
$PMF_LANG['ad_group_deleteGroup'] = "दल को मिटायें";
$PMF_LANG['ad_group_deleteQuestion'] = "क्या निश्चित रूप से इस दल को मिटा दिया जाए?";
$PMF_LANG['ad_user_uncheckall'] = "किसी को भी न चुने";
$PMF_LANG['ad_group_membership'] = "दल सदस्यता";
$PMF_LANG['ad_group_members'] = "सदस्य";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'FAQ जानकारी को निर्यात करने की सीमा बांधे (वैकल्पिक)';
$PMF_LANG['ad_export_cat_downwards'] = 'नीचे?';
$PMF_LANG['ad_export_type'] = 'निर्यात करने का फॉर्मेट';
$PMF_LANG['ad_export_type_choose'] = 'फॉर्मेट चुने :';
$PMF_LANG['ad_export_download_view'] = 'डाउनलोड करें या इन लाइन देखें?';
$PMF_LANG['ad_export_download'] = 'डाउनलोड';
$PMF_LANG['ad_export_view'] = 'इन लाइन देखें';
$PMF_LANG['ad_export_gen_xhtml'] = 'XHTML फाइल बनाएं';
$PMF_LANG['ad_export_gen_docbook'] = 'Docbook फाइल बनाएं';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'समाचार';
$PMF_LANG['ad_news_author_name'] = 'लेखक का नाम:';
$PMF_LANG['ad_news_author_email'] = 'लेखक का पता:';
$PMF_LANG['ad_news_set_active'] = 'सक्रिया करे:';
$PMF_LANG['ad_news_allowComments'] = 'टिप्पणी करने दें:';
$PMF_LANG['ad_news_expiration_window'] = 'समाचार के अवधि समाप्त की विण्डो (वैकल्पिक)';
$PMF_LANG['ad_news_from'] = 'से:';
$PMF_LANG['ad_news_to'] = 'के लिए:';
$PMF_LANG['ad_news_insertfail'] = 'समाचार डाटाबेस में डालते समय गडबडी हो गयी.';
$PMF_LANG['ad_news_updatefail'] = 'समाचार अपडेट करते समय गडबडी हो गयी.';
$PMF_LANG['newsShowCurrent'] = 'वर्तमानकालिक समाचार दिखायें.';
$PMF_LANG['newsShowArchive'] = 'पिछले समाचार दिखायें.';
$PMF_LANG['newsArchive'] = ' पिछले समाचार';
$PMF_LANG['newsWriteComment'] = 'इस पर टिप्पणी';
$PMF_LANG['newsCommentDate'] = 'जोड़ा गया: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'रिकॉर्ड समाप्त हनी की अवधि की विण्डो (वैकल्पिक)';
$PMF_LANG['admin_mainmenu_home'] = 'घर';
$PMF_LANG['admin_mainmenu_users'] = 'प्रयोगकर्ता';
$PMF_LANG['admin_mainmenu_content'] = 'विषय';
$PMF_LANG['admin_mainmenu_statistics'] = 'लेखा जोखा';
$PMF_LANG['admin_mainmenu_exports'] = 'निर्यात';
$PMF_LANG['admin_mainmenu_backup'] = 'बेकअप';
$PMF_LANG['admin_mainmenu_configuration'] = 'सरंचना';
$PMF_LANG['admin_mainmenu_logout'] = 'सत्रांत';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'वर्ग मालिक';
$PMF_LANG['adminSection'] = 'प्रबंधन';
$PMF_LANG['err_expiredArticle'] = 'यह एंट्री समाप्त हो चुकी है, इसलिए दिखाई नहीं जा सकती';
$PMF_LANG['err_expiredNews'] = 'यह समाचार समाप्त हो चुका है, इसलिए दिखाया नहीं जा सकता';
$PMF_LANG['err_inactiveNews'] = 'इस समाचार का पुनवलोकन हो रहा है इसलिए दिखाया नहीं जा सकता';
$PMF_LANG['msgSearchOnAllLanguages'] = 'सभी भाषाओं में खोजें:';
$PMF_LANG['ad_entry_tags'] = 'टैग';
$PMF_LANG['msg_tags'] = 'टैग';

// added v2.0.0 - 2006-09-03 by Matteo
$PMF_LANG['ad_linkcheck_feedback_url-batch1'] = 'जांच हो रही है...';
$PMF_LANG['ad_linkcheck_feedback_url-batch2'] = 'जांच हो रही है...';
$PMF_LANG['ad_linkcheck_feedback_url-batch3'] = 'जांच हो रही है...';
$PMF_LANG['ad_linkcheck_feedback_url-checking'] = 'जांच हो रही है...';
$PMF_LANG['ad_linkcheck_feedback_url-disabled'] = 'असक्रिय';
$PMF_LANG['ad_linkcheck_feedback_url-linkbad'] = 'कड़ी KO';
$PMF_LANG['ad_linkcheck_feedback_url-linkok'] = 'कड़ी ठीक है';
$PMF_LANG['ad_linkcheck_feedback_url-noaccess'] = 'प्रवेश निषेध है';
$PMF_LANG['ad_linkcheck_feedback_url-noajax'] = 'AJAX नहीं है';
$PMF_LANG['ad_linkcheck_feedback_url-nolinks'] = 'कोई कड़ी नहीं है';
$PMF_LANG['ad_linkcheck_feedback_url-noscript'] = 'स्क्रिप्ट मौजूद नहीं है';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = 'सम्बंधित लेख';
$LANG_CONF['records.numberOfRelatedArticles'] = array(0 => "input", 1 => "सम्बंधित लेखों की संख्या");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'अनुवाद करें';
$PMF_LANG['ad_categ_trans_2'] = 'वर्ग';
$PMF_LANG['ad_categ_translatecateg'] = 'वर्ग का अनुवाद करें';
$PMF_LANG['ad_categ_translate'] = 'अनुवाद करें';
$PMF_LANG['ad_categ_transalready'] = 'इनमे पहले से ही अनुवादित है: ';
$PMF_LANG["ad_categ_deletealllang"] = 'सभी भाषाओं में मिटा दें?';
$PMF_LANG["ad_categ_deletethislang"] = 'केवल इसी भाषा में मिटाएं?';
$PMF_LANG["ad_categ_translated"] = "वर्ग का अनुवाद हो गया है.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["ad_categ_show"] = "सिंहावलोकन";
$PMF_LANG['ad_menu_categ_structure'] = "वर्ग का भाषाओं के साथ सिंहावलोकन";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'प्रयोगकर्ता के अधिकार:';
$PMF_LANG['ad_entry_grouppermission'] = 'दल के अधिकार:';
$PMF_LANG['ad_entry_all_users'] = 'सभी के लिए अभिगम्य';
$PMF_LANG['ad_entry_restricted_users'] = 'प्रवेश सिमित';
$PMF_LANG['ad_entry_all_groups'] = 'सभी दलों के लिए अभिगम्य';
$PMF_LANG['ad_entry_restricted_groups'] = 'प्रवेश सिमित';
$PMF_LANG['ad_session_expiration'] = 'आपके सत्र समाप्ति का समय';
$PMF_LANG['ad_user_active'] = 'सक्रिय';
$PMF_LANG['ad_user_blocked'] = 'प्रतिबंधित';
$PMF_LANG['ad_user_protected'] = 'सुरक्षित';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = 'किसी FAQ को कड़ी के तोर पर डालने के लिए चुनें...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "के बाद चिपकायें";
$PMF_LANG["ad_categ_remark_move"] = "दो वर्गों का आपस में बदलाव केवल समतल पर ही मुमकिन है.";
$PMF_LANG["ad_categ_remark_overview"] = "वर्गों का सही क्रम दिखाया जाएगा, यदि उस भाषा के लिए सभी वर्ग बताये गए हैं तो (पहला स्तम्भ).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = '%d अतिथि तथा %d पंजीकृत';
$PMF_LANG['ad_adminlog_del_older_30d'] = '३० दिन से अधिक पुराने लॉग तुंरत मिटा दें';
$PMF_LANG['ad_adminlog_delete_success'] = 'पुराने लॉग सफलतापूर्वक मिटा दिए गए हैं.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'कोई भी लॉग नहीं मिटाया गया.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['opensearch_plugin_install'] = 'खोज प्लगइन जोडें';
$PMF_LANG['ad_quicklinks'] = 'झटपट कड़ियाँ';
$PMF_LANG['ad_quick_category'] = 'नया वर्ग जोडें';
$PMF_LANG['ad_quick_record'] = 'नया FAQ जोडें';
$PMF_LANG['ad_quick_user'] = 'नया प्रयोगकर्ता जोडें';
$PMF_LANG['ad_quick_group'] = 'नया दल जोडें';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'अनुवाद के लिए प्रस्ताव';
$PMF_LANG['msgNewTranslationAddon'] = 'आपका प्रस्ताव तुंरत नहीं छापा जाएगा, प्रबंधन के जांच की बाद ही छापा जाएगा. आवश्यक जानकारियाँ <strong>आपका नाम</strong>, <strong>आपका ईमेल पता</strong>, <strong>अनुवाद का मुख्य वाक्य</strong> तथा <strong>आपका अनुवाद</strong>.कृपया कुंजी शब्दों को खाली जगह से ही अलग करें.';
$PMF_LANG['msgNewTransSourcePane'] = 'स्रोत';
$PMF_LANG['msgNewTranslationPane'] = 'अनुवाद';
$PMF_LANG['msgNewTranslationName'] = $PMF_LANG['msgNewContentName'];
$PMF_LANG['msgNewTranslationMail'] = $PMF_LANG['msgNewContentMail'];
$PMF_LANG['msgNewTranslationKeywords'] = $PMF_LANG['msgNewContentKeywords'];
$PMF_LANG['msgNewTranslationSubmit'] = 'अपना प्रस्ताव जमा करें';
$PMF_LANG['msgTranslate'] = 'इसके लिए अनुवाद का प्रस्ताव रखें';
$PMF_LANG['msgTranslateSubmit'] = 'अनुवाद आरम्भ करें...';
$PMF_LANG['msgNewTranslationThanks'] = "अनुवाद के प्रस्ताव के लिए आपका धन्यवाद!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG["rightsLanguage"]['addgroup'] = "दल का खाता जोडें";
$PMF_LANG["rightsLanguage"]['editgroup'] = "दल के खाते का सम्पादन करें";
$PMF_LANG["rightsLanguage"]['delgroup'] = "दल का खाता मिटा दें";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = 'कड़ी उसी विण्डो में खुलती है';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'टिप्पणी';
$PMF_LANG['ad_comment_administration'] = 'टिप्पणी प्रबंधन';
$PMF_LANG['ad_comment_faqs'] = 'FAQ में टिप्पणीयाँ :';
$PMF_LANG['ad_comment_news'] = 'नए लेखों में टिप्पणीयाँ:';
$PMF_LANG['ad_groups'] = 'दल';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array(0 => 'select', 1 => 'रिकॉर्ड छांटें (according to property)');
$LANG_CONF['records.sortby'] = array(0 => 'select', 1 => 'रिकॉर्ड छांटें (घटते या बढ़ते क्रम में)');
$PMF_LANG['ad_conf_order_id'] = 'ID (पूर्वनिर्धारित)';
$PMF_LANG['ad_conf_order_thema'] = 'शीर्षक';
$PMF_LANG['ad_conf_order_visits'] = 'दर्शनार्थियों की संख्या';
$PMF_LANG['ad_conf_order_updated'] = 'दिनांक';
$PMF_LANG['ad_conf_order_author'] = 'लेखक';
$PMF_LANG['ad_conf_desc'] = 'घटते क्रम में';
$PMF_LANG['ad_conf_asc'] = 'बढ़ते क्रम में';
$PMF_LANG['mainControlCenter'] = 'मुख्य सरंचना';
$PMF_LANG['recordsControlCenter'] = 'FAQ की सरंचना';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array(0 => "checkbox", 1 => "नया लेख सक्रिय करें (पूर्वनिर्धारित: असक्रिय)");
$LANG_CONF['records.defaultAllowComments'] = array(0 => "checkbox", 1 => "नए लेखों के लिए टिप्पणी करनें दें (पूर्वनिर्धारित: असक्रिय)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'इस वर्ग के लेख';
$PMF_LANG['msgTagSearch'] = 'टैग किये गए लेख';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ जानकारी';
$PMF_LANG['ad_online_info'] = 'संस्करण जांचें';
$PMF_LANG['ad_system_info'] = 'निकाय की जानकारी';
