<?php
/**
 * Serbian language file
 *
 * PHP Version 5.5
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @category  phpMyFAQ
 * @author    Alen Durmo <dual_ze@hotmail.com>
 * @copyright 2012-2018 phpMyFAQ Team
 * @license   http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link      http://www.phpmyfaq.de
 * @since     2012-05-25
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "ba";
$PMF_LANG["language"] = "Bosnian";
// ltr: left to right (e.g. English language); rtl: right to left (e.g. Arabic language)
$PMF_LANG["dir"] = "ltr";

$PMF_LANG["nplurals"] = "3";
/**
 * This parameter is used with the function 'plural' from inc/PMF_Language/Plurals.php
 * If this parameter and function are not in sync plural form support will be broken.
 */
// Navigation
$PMF_LANG["msgCategory"] = "Kategorije";
$PMF_LANG["msgShowAllCategories"] = "Prika&#382;i sve kategorije";
$PMF_LANG["msgSearch"] = "Pretraga";
$PMF_LANG["msgAddContent"] = "Dodaj sadr&#382;aj";
$PMF_LANG["msgQuestion"] = "Postavi pitanje";
$PMF_LANG["msgOpenQuestions"] = "Otvorena pitanja";
$PMF_LANG["msgHelp"] = "Pomo&#263;";
$PMF_LANG["msgContact"] = "Kontakt";
$PMF_LANG["msgHome"] = "Glavna stranica";
$PMF_LANG["msgNews"] = "FAQ-Novosti";
$PMF_LANG["msgUserOnline"] = " Korisnika online";
$PMF_LANG["msgXMLExport"] = "XML-File";
$PMF_LANG["msgBack2Home"] = "nazad na glavnu stranicu";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Kategorije sa unosima";
$PMF_LANG["msgFullCategoriesIn"] = "Kategorije sa unosima u ";
$PMF_LANG["msgSubCategories"] = "Podkategorije";
$PMF_LANG["msgEntries"] = "Unosa";
$PMF_LANG["msgEntriesIn"] = "Pitanja u ";
$PMF_LANG["msgViews"] = "pregleda";
$PMF_LANG["msgPage"] = "Stranica ";
$PMF_LANG["msgPages"] = "Stranice";
$PMF_LANG["msgPrevious"] = "prethodni";
$PMF_LANG["msgNext"] = "slede&#263;i";
$PMF_LANG["msgCategoryUp"] = "one category up";
$PMF_LANG["msgLastUpdateArticle"] = "Zadnji update: ";
$PMF_LANG["msgAuthor"] = "Autor: ";
$PMF_LANG["msgPrinterFriendly"] = "Printer-friendly verzija";
$PMF_LANG["msgPrintArticle"] = "&#352;tampaj ovaj &#269;lanak";
$PMF_LANG["msgMakeXMLExport"] = "exportuj kao XML-File";
$PMF_LANG["msgAverageVote"] = "Prose&#269;ni rejting:";
$PMF_LANG["msgVoteUseability"] = "Ocenite ovaj unos:";
$PMF_LANG["msgVoteFrom"] = "od";
$PMF_LANG["msgVoteBad"] = "apsolutno <br />beskorisno";
$PMF_LANG["msgVoteGood"] = "veoma<br />korisno";
$PMF_LANG["msgVotings"] = "Glasova ";
$PMF_LANG["msgVoteSubmit"] = "Glasaj";
$PMF_LANG["msgVoteThanks"] = "Hvala vam za va&#353; glas!";
$PMF_LANG["msgYouCan"] = "Mo&#382;ete ";
$PMF_LANG["msgWriteComment"] = "staviti komentar za ovaj &#269;lanak";
$PMF_LANG["msgShowCategory"] = "Pregled sadr&#382;aja: ";
$PMF_LANG["msgCommentBy"] = "Komentar postavio ";
$PMF_LANG["msgCommentHeader"] = "Komentar za ovaj unos";
$PMF_LANG["msgYourComment"] = "Va&#353 komentar:";
$PMF_LANG["msgCommentThanks"] = "Hvala vam za komentar!";
$PMF_LANG["msgSeeXMLFile"] = "Otvori XML-File";
$PMF_LANG["msgSend2Friend"] = "Po&#353;alji prijatelju";
$PMF_LANG["msgS2FName"] = "Va&#353;e ime:";
$PMF_LANG["msgS2FEMail"] = "Va&#353;a e-mail adresa:";
$PMF_LANG["msgS2FFriends"] = "Va&#353;i prijatelji:";
$PMF_LANG["msgS2FEMails"] = ". e-mail adresa:";
$PMF_LANG["msgS2FText"] = "Tekst koji &#263;e biti poslan:";
$PMF_LANG["msgS2FText2"] = "Naci ces interesantne informacije na:";
$PMF_LANG["msgS2FMessage"] = "Dodatna poruka za prijatelje:";
$PMF_LANG["msgS2FButton"] = "po&#353;alji e-mail";
$PMF_LANG["msgS2FThx"] = "Hvala za va&#353;u preporuku!";
$PMF_LANG["msgS2FMailSubject"] = "Preporuka od: ";

// Search
$PMF_LANG["msgSearchWord"] = "Kljucne reci";
$PMF_LANG["msgSearchFind"] = "Rezultati pretrage za ";
$PMF_LANG["msgSearchAmount"] = " pogodak";
$PMF_LANG["msgSearchAmounts"] = " pogotka";
$PMF_LANG["msgSearchCategory"] = "Kategorija: ";
$PMF_LANG["msgSearchContent"] = "Sadr&#382;aj: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "Predlog za FAQ";
$PMF_LANG["msgNewContentAddon"] = "Va&#353; predlog ne&#263;e biti une&#353;en odmah, ve&#263; &#263;e biti poslan na pregled administratoru. Obavezna polja (za popunjavanje) su <strong>va&#353;e ime</strong>, <strong>e-mail adresa</strong>, <strong>kategorija</strong> i <strong>unos</strong>. Molimo vas da razdvojite klju&#269;ne re&#269;i (keywords) sa razmakom.";
$PMF_LANG["msgNewContentName"] = "Va&#353;e Ime:";
$PMF_LANG["msgNewContentMail"] = "Va&#353;a e-mail adresa:";
$PMF_LANG["msgNewContentCategory"] = "Izbor kategorije?";
$PMF_LANG["msgNewContentTheme"] = "Naslov:";
$PMF_LANG["msgNewContentArticle"] = "Va&#353; FAQ Unos:";
$PMF_LANG["msgNewContentKeywords"] = "Klju&#269;ne re&#269;i (Keywords):";
$PMF_LANG["msgNewContentLink"] = "Link (URL) za ovaj unos";
$PMF_LANG["msgNewContentSubmit"] = "po&#353;alji";
$PMF_LANG["msgInfo"] = "Vi&#353;e informacija: ";
$PMF_LANG["msgNewContentThanks"] = "Hvala za va&#353; unos!";
$PMF_LANG["msgNoQuestionsAvailable"] = "Nema otvorenih pitanja.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Postavite va&#353;e pitanje:";
$PMF_LANG["msgAskCategory"] = "Pitanje je u vezi kategorije";
$PMF_LANG["msgAskYourQuestion"] = "Va&#353;e pitanje:";
$PMF_LANG["msgAskThx4Mail"] = "<h2>Hvala za va&#353;e pitanje!</h2>";
$PMF_LANG["msgDate_User"] = "Datum / Korisnik";
$PMF_LANG["msgQuestion2"] = "Pitanje";
$PMF_LANG["msg2answer"] = "odgovori";
$PMF_LANG["msgQuestionText"] = "Ovde mo&#382;ete videti pitanja postavljena od strane drugih korisnika. Ako odgovorite na neko od pitanja, va&#353 odgovor mo&#382;e biti dodan u FAQ.";

// Help
$PMF_LANG["msgHelpText"] = "<strong>Struktura FAQ-a je jednostavna. Mo&#382;ete pregledati <strong><a href=\"?action=show\">kategorije</a></strong>, ili iskoristiti <strong><a href=\"?action=search\">FAQ pretra&#382;iva&#269;</a></strong> da na&#273;ete odre&#269;ene re&#269;i";

// Contact
$PMF_LANG["msgContactEMail"] = "poÂaljite webmasteru:";
$PMF_LANG["msgMessage"] = "VaÂa poruka:";

// Startseite
$PMF_LANG["msgNews"] = " Novosti";
$PMF_LANG["msgTopTen"] = "TOP 10";
$PMF_LANG["msgHomeThereAre"] = "Postoji ";
$PMF_LANG["msgHomeArticlesOnline"] = " unosa u bazi";
$PMF_LANG["msgNoNews"] = "Nema novosti.";
$PMF_LANG["msgLatestArticles"] = "Zadnjih 5 unosa u bazu:";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "Hvala vam za vasu prepruku za FAQ.";
$PMF_LANG["msgMailCheck"] = "Postoji novi unos za FAQ!Proveri admin sekciju!";
$PMF_LANG["msgMailContact"] = "Vasa poruka je poslana administratoru.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Nije uspeo pristup bazi.";
$PMF_LANG["err_noHeaders"] = "Nema kategorija.";
$PMF_LANG["err_noArticles"] = "Nema unosa.";
$PMF_LANG["err_badID"] = "Pogre&#353;an ID.";
$PMF_LANG["err_noTopTen"] = "TOP10 jo&#353; ne postoji.";
$PMF_LANG["err_nothingFound"] = "Unos nije prona&#273;en.";
$PMF_LANG["err_SaveEntries"] = "Obavezna polja su <strong>va&#353;e ime</strong>, <strong>email adresa</strong>, <strong>kategorija</strong>, <strong>naslov</strong> i <strong>unos</strong>! <br /><br /><a href=\"javascript:history.back();\">nazad</a><br /><br />";
$PMF_LANG["err_SaveComment"] = "Obavezna polja su <strong>va&#353;e ime</strong>, <strong>email adresa</strong> i <strong>komentar</strong>! <br /><br /><a href=\"javascript:history.back();\">nazad</a><br /><br />";
$PMF_LANG["err_VoteTooMuch"] = "Ne ura&#269;unavamo dvostruko glasanje. Kliknite ovde, da se vratite na prethodnu stranicu.";
$PMF_LANG["err_noVote"] = "<strong>Niste vrednovali unos!</strong> <a href=\"javascript:history.back();\">Nazad</a>";
$PMF_LANG["err_noMailAdress"] = "Va&#353;a email adresa nije ispravna.<br /><a href=\"javascript:history.back();\">nazad</a>";
$PMF_LANG["err_sendMail"] = "Obavezna polja su <strong>va&#353;e ime</strong>, <strong>email adresa</strong> i <strong>pitanje</strong>!";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>Pretraga:</strong><br />";

// Men&uuml;
$PMF_LANG["ad"] = "ADMINISTRACIJA";
$PMF_LANG["ad_menu_user_administration"] = "Administracija Korisnika";
$PMF_LANG["ad_menu_entry_aprove"] = "Potvrdi Unose";
$PMF_LANG["ad_menu_entry_edit"] = "Izmeni Unose";
$PMF_LANG["ad_menu_categ_add"] = "Dodaj Kategoriju";
$PMF_LANG["ad_menu_categ_edit"] = "Izmeni Kategoriju";
$PMF_LANG["ad_menu_news_add"] = "Dodaj Novosti";
$PMF_LANG["ad_menu_news_edit"] = "Izmena Novosti";
$PMF_LANG["ad_menu_open"] = "Izmeni otvorena pitanja";
$PMF_LANG["ad_menu_stat"] = "Statistike";
$PMF_LANG["ad_menu_cookie"] = "Cookies";
$PMF_LANG["ad_menu_session"] = "Pregled Sesija";
$PMF_LANG["ad_menu_adminlog"] = "Pregled Admin loga";
$PMF_LANG["ad_menu_passwd"] = "Izmena &#352;ifre";
$PMF_LANG["ad_menu_logout"] = "Izlaz";
$PMF_LANG["ad_menu_startpage"] = "Po&#269;etna stranica";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Prijavite se!";
$PMF_LANG["ad_msg_passmatch"] = "Obe &#353;ifre moraju biti <strong>iste</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "Profil korisnika";
$PMF_LANG["ad_msg_savedsuc_2"] = "je snimljen uspe&#353;no.";
$PMF_LANG["ad_msg_mysqlerr"] = "Zbog gre&#353;ke sa bazom, profil nije mogao biti snimljen.";
$PMF_LANG["ad_msg_noauth"] = "Niste autorizovani.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Stranica";
$PMF_LANG["ad_gen_of"] = "od";
$PMF_LANG["ad_gen_lastpage"] = "Prethodna Strana";
$PMF_LANG["ad_gen_nextpage"] = "Slede&#263;a Strana";
$PMF_LANG["ad_gen_save"] = "Snimi";
$PMF_LANG["ad_gen_reset"] = "Reset";
$PMF_LANG["ad_gen_yes"] = "Da";
$PMF_LANG["ad_gen_no"] = "Ne";
$PMF_LANG["ad_gen_top"] = "Vrh strane";
$PMF_LANG["ad_gen_ncf"] = "Nema kategorija!";
$PMF_LANG["ad_gen_delete"] = "Obri&#353;i";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Administracija Korisnika";
$PMF_LANG["ad_user_username"] = "Registrovani korisnici";
$PMF_LANG["ad_user_rights"] = "Korisni&#269;ka Prava";
$PMF_LANG["ad_user_edit"] = "izmeni";
$PMF_LANG["ad_user_delete"] = "obri&#353;i";
$PMF_LANG["ad_user_add"] = "Dodaj Korisnika";
$PMF_LANG["ad_user_profou"] = "Profil korisnika";
$PMF_LANG["ad_user_name"] = "Ime";
$PMF_LANG["ad_user_password"] = "&#352;ifra";
$PMF_LANG["ad_user_confirm"] = "Potvrdi";
$PMF_LANG["ad_user_rights"] = "Prava";
$PMF_LANG["ad_user_del_1"] = "Korisnik";
$PMF_LANG["ad_user_del_2"] = "&#263;e biti obrisan?";
$PMF_LANG["ad_user_del_3"] = "Da li si siguran?";
$PMF_LANG["ad_user_deleted"] = "Korisnik je uspe&#353;no obrisan.";

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = "Administracija Unosa";
$PMF_LANG["ad_entry_id"] = "ID";
$PMF_LANG["ad_entry_topic"] = "Tema";
$PMF_LANG["ad_entry_action"] = "Akcija";
$PMF_LANG["ad_entry_edit_1"] = "Dodaj/Izmeni Unos";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Tema:";
$PMF_LANG["ad_entry_content"] = "Sadr&#382;aj:";
$PMF_LANG["ad_entry_keywords"] = "Klju&#269;ne re&#269;i:";
$PMF_LANG["ad_entry_author"] = "Autor:";
$PMF_LANG["ad_entry_category"] = "Kategorija:";
$PMF_LANG["ad_entry_active"] = "Aktivno?";
$PMF_LANG["ad_entry_date"] = "Datum:";
$PMF_LANG["ad_entry_changed"] = "Izmenjeno?";
$PMF_LANG["ad_entry_changelog"] = "Log izmena:";
$PMF_LANG["ad_entry_commentby"] = "Komentar korisnika";
$PMF_LANG["ad_entry_comment"] = "Komentari:";
$PMF_LANG["ad_entry_save"] = "Snimi";
$PMF_LANG["ad_entry_delete"] = "Obri&#353;i";
$PMF_LANG["ad_entry_delcom_1"] = "Da li ste sigurni da komentar od korisnika";
$PMF_LANG["ad_entry_delcom_2"] = "treba obrisati?";
$PMF_LANG["ad_entry_commentdelsuc"] = "Komentar je uspe&#353;no obrisan.";
$PMF_LANG["ad_entry_back"] = "Nazad na &#269;lanak";
$PMF_LANG["ad_entry_commentdelfail"] = "Komentar <strong>nije</strong> obrisan.";
$PMF_LANG["ad_entry_savedsuc"] = "Izmene su <strong>uspe&#353;no</strong> snimljene.";
$PMF_LANG["ad_entry_savedfail"] = "Na &#382;alost, desila se gre&#353;ka sa <strong>bazom</strong>.";
$PMF_LANG["ad_entry_del_1"] = "Da li ste sigurni da tema";
$PMF_LANG["ad_entry_del_2"] = "od korisnika";
$PMF_LANG["ad_entry_del_3"] = "treba biti obrisana?";
$PMF_LANG["ad_entry_delsuc"] = "Unos <strong>uspe&#353;no</strong> obrisan.";
$PMF_LANG["ad_entry_delfail"] = "Unos <strong>nije obrisan</strong>!";
$PMF_LANG["ad_entry_back"] = "Nazad";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Naslov";
$PMF_LANG["ad_news_text"] = "Tekst";
$PMF_LANG["ad_news_link_url"] = "Link: (<strong>bez http://</strong>)!";
$PMF_LANG["ad_news_link_title"] = "Ime za link (URL):";
$PMF_LANG["ad_news_link_target"] = "Otvaranje linka (URL-a)";
$PMF_LANG["ad_news_link_window"] = "Link se otvara u novom prozoru";
$PMF_LANG["ad_news_link_faq"] = "Link unutar FAQ-a";
$PMF_LANG["ad_news_add"] = "Dodaj Novosti";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Naslov";
$PMF_LANG["ad_news_date"] = "Datum";
$PMF_LANG["ad_news_action"] = "Akcija";
$PMF_LANG["ad_news_update"] = "izmeni";
$PMF_LANG["ad_news_delete"] = "obri&#353;i";
$PMF_LANG["ad_news_nodata"] = "Podaci nisu prona&#273;eni u bazi";
$PMF_LANG["ad_news_updatesuc"] = "Novosti nisu izmenjene.";
$PMF_LANG["ad_news_del"] = "Da li ste sigurni da &#382;elite obrisati ovu novost?";
$PMF_LANG["ad_news_yesdelete"] = "Da, obri&#353;i!";
$PMF_LANG["ad_news_nodelete"] = "Ne!";
$PMF_LANG["ad_news_delsuc"] = "Novost obrisana.";
$PMF_LANG["ad_news_updatenews"] = "Izmeni novost";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Dodaj novu kategoriju";
$PMF_LANG["ad_categ_catnum"] = "Broj kategorije:";
$PMF_LANG["ad_categ_subcatnum"] = "Broj podkategorije:";
$PMF_LANG["ad_categ_nya"] = "<em>nije dostupan!</em>";
$PMF_LANG["ad_categ_titel"] = "Ime Kategorije:";
$PMF_LANG["ad_categ_add"] = "Dodaj Kategoriju";
$PMF_LANG["ad_categ_existing"] = "Postoje&#263;e Kategorije";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Kategorija";
$PMF_LANG["ad_categ_subcateg"] = "Podkategorija";
$PMF_LANG["ad_categ_titel"] = "Ima Kategorije";
$PMF_LANG["ad_categ_action"] = "Akcija";
$PMF_LANG["ad_categ_update"] = "update";
$PMF_LANG["ad_categ_delete"] = "Obri&#353;i";
$PMF_LANG["ad_categ_updatecateg"] = "Izmeni Kategoriju";
$PMF_LANG["ad_categ_nodata"] = "Podaci nisu prona&#273;eni u bazi";
$PMF_LANG["ad_categ_remark"] = "Ako obri&#353;ete kategoriju, &#269;lanci u njoj vi&#353;e ne&#263;e biti dostupni. Mora&#263;ete dodeliti novu kategoriju, ili obrisati unose.";
$PMF_LANG["ad_categ_edit_1"] = "Izmeni";
$PMF_LANG["ad_categ_edit_2"] = "Kategorija";
$PMF_LANG["ad_categ_add"] = "Dodaj Kategoriju";
$PMF_LANG["ad_categ_added"] = "Kategorija je dodana.";
$PMF_LANG["ad_categ_updated"] = "Kategorija je izmenjena.";
$PMF_LANG["ad_categ_del_yes"] = "Da, obri&#353;i!";
$PMF_LANG["ad_categ_del_no"] = "Ne!";
$PMF_LANG["ad_categ_deletesure"] = "Da li zaista &#382;elite da obri&#353;ete ovu kategoriju?";
$PMF_LANG["ad_categ_deleted"] = "Kategorija obrisana.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "Cookie je <strong>uspe&#353;no</strong> poslan/postavljen.";
$PMF_LANG["ad_cookie_already"] = "Cookie ve&#263;e postoji. Imate slede&#263;e mogu&#263;nosti:";
$PMF_LANG["ad_cookie_again"] = "Po&#353;alji Cookie ponovo";
$PMF_LANG["ad_cookie_delete"] = "Obri&#353;i Cookie";
$PMF_LANG["ad_cookie_no"] = "Cookie jo&#353; ne postoji. Ako postavite Cookie (u va&#353; browser), mo&#263;i &#263;ete da automatski pristupite Admin sekciji, bez da unosite ime i &#353;ifru. Imate slede&#263;e mogu&#263;nosti:";
$PMF_LANG["ad_cookie_set"] = "Po&#353;alji Cookie";
$PMF_LANG["ad_cookie_deleted"] = "Cookie uspe&#353;no obrisan.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "Administrativni Log";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Izmena &#353;ifre";
$PMF_LANG["ad_passwd_old"] = "Stara &#353;ifra:";
$PMF_LANG["ad_passwd_new"] = "Nova &#353;ifra:";
$PMF_LANG["ad_passwd_con"] = "Potvrdi:";
$PMF_LANG["ad_passwd_change"] = "Promeni &#353;ifru";
$PMF_LANG["ad_passwd_suc"] = "&#352;ifra uspe&#353;no izmenjena.";
$PMF_LANG["ad_passwd_remark"] = "<strong>PA&#381;NJA:</strong><br />Cookie mora biti ponovo postavljen!";
$PMF_LANG["ad_passwd_fail"] = "Stara &#353;ifra <strong>mora</strong> biti ispravno une&#353;ena, i oba unosa nove &#353;ifre moraju <strong>biti ista</strong>.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Dodaj korisnika";
$PMF_LANG["ad_adus_name"] = "Ime:";
$PMF_LANG["ad_adus_password"] = "&#352;ifra:";
$PMF_LANG["ad_adus_add"] = "Dodaj korisnika";
$PMF_LANG["ad_adus_suc"] = "Korisnik <strong>uspe&#353;no</strong> dodan.";
$PMF_LANG["ad_adus_edit"] = "Izmeni profil";
$PMF_LANG["ad_adus_dberr"] = "<strong>Gre&#353;ka sa bazom!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Korisni&#269;ko ime ve&#263; <strong>postoji</strong>.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "Session ID";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Vreme";
$PMF_LANG["ad_sess_pageviews"] = "Pregleda Stranica";
$PMF_LANG["ad_sess_search"] = "Pretraga";
$PMF_LANG["ad_sess_sfs"] = "Pretraga sesija";
$PMF_LANG["ad_sess_s_ip"] = "IP:";
$PMF_LANG["ad_sess_s_minct"] = "min. akcija:";
$PMF_LANG["ad_sess_s_date"] = "Datum";
$PMF_LANG["ad_sess_s_after"] = "pre";
$PMF_LANG["ad_sess_s_before"] = "posle";
$PMF_LANG["ad_sess_s_search"] = "Pretraga";
$PMF_LANG["ad_sess_session"] = "Sesija";
$PMF_LANG["ad_sess_r"] = "Rezultati pretrage za";
$PMF_LANG["ad_sess_referer"] = "Referrer:";
$PMF_LANG["ad_sess_browser"] = "Browser:";
$PMF_LANG["ad_sess_ai_rubrik"] = "Kategorija:";
$PMF_LANG["ad_sess_ai_artikel"] = "Unos:";
$PMF_LANG["ad_sess_ai_sb"] = "Re&#269;i za pretragu:";
$PMF_LANG["ad_sess_ai_sid"] = "Session ID:";
$PMF_LANG["ad_sess_back"] = "Nazad";

// Statistik
$PMF_LANG["ad_rs"] = "Statistika (rejting)";
$PMF_LANG["ad_rs_rating_1"] = "Rejting";
$PMF_LANG["ad_rs_rating_2"] = "users shows:";
$PMF_LANG["ad_rs_red"] = "Crveno";
$PMF_LANG["ad_rs_green"] = "Zeleno";
$PMF_LANG["ad_rs_altt"] = "sa prose&#269;nom ocenom manjom od 20%";
$PMF_LANG["ad_rs_ahtf"] = "sa prose&#269;nom ocenom ve&#263;om od 80%";
$PMF_LANG["ad_rs_no"] = "Nema rejtinga";

// Auth
$PMF_LANG["ad_auth_insert"] = "Molimo Vas da unesete korisni&#269;ko ime i &#353;ifru.";
$PMF_LANG["ad_auth_user"] = "Ime:";
$PMF_LANG["ad_auth_passwd"] = "&#352;ifra:";
$PMF_LANG["ad_auth_ok"] = "OK";
$PMF_LANG["ad_auth_reset"] = "Reset";
$PMF_LANG["ad_auth_fail"] = "Ime ili &#353;ifra nisu ispravni.";
$PMF_LANG["ad_auth_sess"] = "Session ID je poslan.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Izmeni konfiguraciju";
$PMF_LANG["ad_config_save"] = "Snimi konfiguraciju";
$PMF_LANG["ad_config_reset"] = "Reset";
$PMF_LANG["ad_config_saved"] = "Konfiguracija je uspe&#353;no snimljena.";
$PMF_LANG["ad_menu_editconfig"] = "Izmeni konfiguraciju";
$PMF_LANG["ad_att_none"] = "Nema fajlova";
$PMF_LANG["ad_att_att"] = "Fajlovi (attachments):";
$PMF_LANG["ad_att_add"] = "Zaka&#269;i (attach) fajl";
$PMF_LANG["ad_entryins_suc"] = "Unos uspe&#353;no snimljen.";
$PMF_LANG["ad_entryins_fail"] = "Desila se gre&#353;ka.";
$PMF_LANG["ad_att_del"] = "Obri&#353;i";
$PMF_LANG["ad_att_nope"] = "Fajlovi mogu biti dodani samo kada se menja unos.";
$PMF_LANG["ad_att_delsuc"] = "Fajl je uspe&#353;no obrisan.";
$PMF_LANG["ad_att_delfail"] = "Gre&#353;ka prilikom brisanja fajla.";
$PMF_LANG["ad_entry_add"] = "Novi unos";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "Backup &#269;uva kompletnu bazu. Backup bi trebalo raditi barem jednom mese&#269;no. Format backupa je MySQL fajl koji se mo&#382;e unesti u bazu uz pomo&#263; alatki kao &#353;to su phpMyAdmin ili mysql (command line klijent)";
$PMF_LANG["ad_csv_link"] = "Download backup";
$PMF_LANG["ad_csv_head"] = "Napravi backup";
$PMF_LANG["ad_att_addto"] = "Dodaj fajl (attachment)";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Fajl:";
$PMF_LANG["ad_att_butt"] = "OK";
$PMF_LANG["ad_att_suc"] = "Fajl je zaka&#269;en uspe&#353;no.";
$PMF_LANG["ad_att_fail"] = "Gre&#353;ka se dogodila prilikom ka&#269;enja fajla.";
$PMF_LANG["ad_att_close"] = "Zatvori ovaj prozor";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "Uz pomo&#263; ove forme, mo&#382;ete u&#269;itati sadr&#382;aj backupa (napravljenog sa phpMyFAQ-om) u bazu. Postoje&#263;i podaci &#263;e biti obrisani.";
$PMF_LANG["ad_csv_file"] = "Fajl";
$PMF_LANG["ad_csv_ok"] = "OK";
$PMF_LANG["ad_csv_linklog"] = "backup LOGs";
$PMF_LANG["ad_csv_linkdat"] = "backup podatke";
$PMF_LANG["ad_csv_head2"] = "U&#269;itaj (Restore)";
$PMF_LANG["ad_csv_no"] = "Ovo ne izgleda kao phpMyFAQ backup.";
$PMF_LANG["ad_csv_prepare"] = "Pripremam database queries...";
$PMF_LANG["ad_csv_process"] = "U&#269;itavam...";
$PMF_LANG["ad_csv_of"] = "od";
$PMF_LANG["ad_csv_suc"] = "su bili uspe&#353;ni.";
$PMF_LANG["ad_csv_backup"] = "Backup";
$PMF_LANG["ad_csv_rest"] = "U&#269;itaj backup";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Backup";
$PMF_LANG["ad_logout"] = "Sesija uspe&#353;no terminisana.";
$PMF_LANG["ad_news_add"] = "Dodaj novost";
$PMF_LANG["ad_news_edit"] = "Izmeni novosti";
$PMF_LANG["ad_cookie"] = "Cookies";
$PMF_LANG["ad_sess_head"] = "Pregled sesija";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = "Administracija Kategorija";
$PMF_LANG["ad_menu_stat"] = "Statistike (rejting)";
$PMF_LANG["ad_kateg_add"] = "Dodaj Kategoriju";
$PMF_LANG["ad_kateg_rename"] = "Promeni Ime";
$PMF_LANG["ad_adminlog_date"] = "Datum";
$PMF_LANG["ad_adminlog_user"] = "Korisnik";
$PMF_LANG["ad_adminlog_ip"] = "IP Adresa";

$PMF_LANG["ad_stat_sess"] = "Sesije";
$PMF_LANG["ad_stat_days"] = "Dana";
$PMF_LANG["ad_stat_vis"] = "Sesija (Poseta)";
$PMF_LANG["ad_stat_vpd"] = "Poseta po danu";
$PMF_LANG["ad_stat_fien"] = "Prvi Log";
$PMF_LANG["ad_stat_laen"] = "Zadnji Log";
$PMF_LANG["ad_stat_browse"] = "Pregled Sesija";
$PMF_LANG["ad_stat_ok"] = "OK";

$PMF_LANG["ad_sess_time"] = "Vreme";
$PMF_LANG["ad_sess_sid"] = "Session-ID";
$PMF_LANG["ad_sess_ip"] = "IP Adresa";

$PMF_LANG["ad_ques_take"] = "Odgovori na (ili izmeni) pitanje";
$PMF_LANG["no_cats"] = "Nema kategorija.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Ime ili &#353;ifra nisu ispravni.";
$PMF_LANG["ad_log_sess"] = "Sesija je istekla.";
$PMF_LANG["ad_log_edit"] = "\"Izmeni Korisnika\"-Forma za korisnika: ";
$PMF_LANG["ad_log_crea"] = "\"Novi &#269;lanak\" forma.";
$PMF_LANG["ad_log_crsa"] = "Novi unos kreiran.";
$PMF_LANG["ad_log_ussa"] = "Izmeni podatke za korisnika: ";
$PMF_LANG["ad_log_usde"] = "Obrisan korisnik: ";
$PMF_LANG["ad_log_beed"] = "Edit forma za korisnika: ";
$PMF_LANG["ad_log_bede"] = "Obrisan unos: ";

$PMF_LANG["ad_start_visits"] = "Poseta";
$PMF_LANG["ad_start_articles"] = "&#268;lanaka";
$PMF_LANG["ad_start_comments"] = "Komentara";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "paste";
$PMF_LANG["ad_categ_cut"] = "cut";
$PMF_LANG["ad_categ_copy"] = "copy";
$PMF_LANG["ad_categ_process"] = "Procesiram kategorije...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Niste autorizovani.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "prethodna strana";
$PMF_LANG["msgNextPage"] = "slede&#263;a strana";
$PMF_LANG["msgPageDoublePoint"] = "Strana: ";
$PMF_LANG["msgMainCategory"] = "Glavna kategorija";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Va&#353;a &#353;ifra je promenjena.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF	"] = "Prika&#382;i kao PDF fajl";
$PMF_LANG["ad_xml_head"] = "XML-Backup";
$PMF_LANG["ad_xml_hint"] = "Snimi sve unose iz FAQ-a kao XML fajl.";
$PMF_LANG["ad_xml_gen"] = "napravi XML fajl";
$PMF_LANG["ad_entry_locale"] = "Jezik";
$PMF_LANG["msgLanguageSubmit"] = "promeni jezik";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Proba (Preview)";
$PMF_LANG["ad_attach_1"] = "Prvo izaberite direktorijum za fajlove (attachments)";
$PMF_LANG["ad_attach_2"] = "Prvo izaberite link za fajlove (attachments)";
$PMF_LANG["ad_attach_3"] = "Fajl attachment.php ne mo&#382;e biti otvoren bez autentikacije";
$PMF_LANG["ad_attach_4"] = "Zaka&#269;en fajl mora biti manji od %s bajtova";
$PMF_LANG["ad_menu_export"] = "Snimi (Export) FAQ";
$PMF_LANG["ad_export_1"] = "Napravi RSS-Feed za";
$PMF_LANG["ad_export_2"] = ".";
$PMF_LANG["ad_export_file"] = "Gre&#353;ka: Fajl nije mogao biti napravljen/snimljen.";
$PMF_LANG["ad_export_news"] = "Novosti RSS-Feed";
$PMF_LANG["ad_export_topten"] = "Top 10 RSS-Feed";
$PMF_LANG["ad_export_latest"] = "5 zadnjih unosa RSS-Feed";
$PMF_LANG["ad_export_pdf"] = "PDF-Export za sve unose";
$PMF_LANG["ad_export_generate"] = "kreiraj RSS-Feed";

$PMF_LANG["rightsLanguage"]['adduser'] = "dodavanja korisnika";
$PMF_LANG["rightsLanguage"]['edituser'] = "izmena korisnika";
$PMF_LANG["rightsLanguage"]['deluser'] = "brisanje korisnika";
$PMF_LANG["rightsLanguage"]['addbt'] = "dodavanje unosa";
$PMF_LANG["rightsLanguage"]['editbt'] = "izmena unosa";
$PMF_LANG["rightsLanguage"]['delbt'] = "brisanje unosa";
$PMF_LANG["rightsLanguage"]['viewlog'] = "pregled loga";
$PMF_LANG["rightsLanguage"]['adminlog'] = "pregled admin loga";
$PMF_LANG["rightsLanguage"]['delcomment'] = "brisanje komentara";
$PMF_LANG["rightsLanguage"]['addnews'] = "dodavanje novosti";
$PMF_LANG["rightsLanguage"]['editnews'] = "izmena novosti";
$PMF_LANG["rightsLanguage"]['delnews'] = "brisanje novosti";
$PMF_LANG["rightsLanguage"]['addcateg'] = "dodavanje kategorija";
$PMF_LANG["rightsLanguage"]['editcateg'] = "izmena kategorija";
$PMF_LANG["rightsLanguage"]['delcateg'] = "brisanje kategorija";
$PMF_LANG["rightsLanguage"]['passwd'] = "izmena &#353;ifre";
$PMF_LANG["rightsLanguage"]['editconfig'] = "izmena konfiguracije";
$PMF_LANG["rightsLanguage"]['addatt'] = "dodavanje fajlova (attachments)";
$PMF_LANG["rightsLanguage"]['delatt'] = "brisanje fajlova (attachments)";
$PMF_LANG["rightsLanguage"]['backup'] = "pravljenje backupa";
$PMF_LANG["rightsLanguage"]['restore'] = "u&#269;itavanje (restore) backupa";
$PMF_LANG["rightsLanguage"]['delquestion'] = "brisanje otvorenih pitanja";

$PMF_LANG["msgAttachedFiles"] = "zaka&#269;eni fajlovi:";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "akcija";
$PMF_LANG["ad_entry_email"] = "e-mail adresa:";
$PMF_LANG["ad_entry_allowComments"] = "dopusti komentarisanje";
$PMF_LANG["msgWriteNoComment"] = "Ne mo&#382;ete staviti komentar za ovaj unos";
$PMF_LANG["ad_user_realname"] = "Pravo ime:";
$PMF_LANG["ad_export_generate_pdf"] = "kreiraj PDF fajl";
$PMF_LANG["ad_export_full_faq"] = "Va&#353; FAQ kao PDF fajl: ";
$PMF_LANG["err_bannedIP"] = "Va&#353;a IP adresa je blokirana.";
$PMF_LANG["err_SaveQuestion"] = "Obavezna polja su <strong>va&#353;e ime</strong>, <strong>email adresa</strong> i <strong>pitanje</strong>.<br /><br /><a href=\"javascript:history.back();\">nazad</a><br /><br />";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Boja fonta: ";
$PMF_LANG["ad_entry_fontsize"] = "Veli&#269;ina fonta: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array(0 => "select", 1 => "Language-File");
$LANG_CONF["main.languageDetection"] = array(0 => "checkbox", 1 => "Automatsko tra&#382;enje odgovora");
$LANG_CONF['main.titleFAQ'] = array(0 => "input", 1 => "Naslov FAQ");
$LANG_CONF['main.currentVersion'] = array(0 => "print", 1 => "FAQ Verzija");
$LANG_CONF["main.metaDescription"] = array(0 => "input", 1 => "Opis Stranice");
$LANG_CONF["main.metaKeywords"] = array(0 => "input", 1 => "Klju&#269;ne re&#269;i za netpauke");
$LANG_CONF["main.metaPublisher"] = array(0 => "input", 1 => "Ime izdava&#269;a");
$LANG_CONF['main.administrationMail'] = array(0 => "input", 1 => "Admin email adresa");
$LANG_CONF["main.contactInformations"] = array(0 => "area", 1 => "Kontakt info");
$LANG_CONF["main.send2friendText"] = array(0 => "area", 1 => "Tekst za send2friend stranicu");
$LANG_CONF['records.maxAttachmentSize'] = array(0 => "input", 1 => "maximalna veli&#269;ina priloga u bajtovima (max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array(0 => "checkbox", 1 => "Linkuj priloge ispod unosa?");
$LANG_CONF["main.enableUserTracking"] = array(0 => "checkbox", 1 => "Koristi pra&#263;enje?");
$LANG_CONF["main.enableAdminLog"] = array(0 => "checkbox", 1 => "Koristi Adminlog?");
$LANG_CONF["security.ipCheck"] = array(0 => "checkbox", 1 => "Da li &#382;elite da se IP proverava kada se proverava UINs u admin.php?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array(0 => "input", 1 => "Broj prikazanih tema po stranici");
$LANG_CONF["records.numberOfShownNewsEntries"] = array(0 => "input", 1 => "Broj &#269;lanaka vesti");
$LANG_CONF['security.bannedIPs'] = array(0 => "area", 1 => "Banuj ove IP");
$LANG_CONF["main.enableRewriteRules"] = array(0 => "checkbox", 1 => "Uklju&#269;i mod_rewrite podr&#269;ku? (isklju&#269;eno)");
$LANG_CONF["security.ldapSupport"] = array(0 => "checkbox", 1 => "Da li &#382;elite LDAP podr&scaron;ku? (isklju&#269;eno)");

$PMF_LANG["ad_categ_new_main_cat"] = "kao nova glavna kategorija";
$PMF_LANG["ad_categ_paste_error"] = "Preme&scaron;tanje ove kategorije nije mogu&#263;e.";
$PMF_LANG["ad_categ_move"] = "premesti kategoriju";
$PMF_LANG["ad_categ_lang"] = "Jezik";
$PMF_LANG["ad_categ_desc"] = "Opis";
$PMF_LANG["ad_categ_change"] = "Zameni sa";

$PMF_LANG["lostPassword"] = "Zaboravljena lozinka? Kliknite ovde.";
$PMF_LANG["lostpwd_err_1"] = "Gre&scaron;ka: Korisni&#269;ko ime i email adresa nisu na&#273;eni.";
$PMF_LANG["lostpwd_err_2"] = "Gre&scaron;ka: Pogre&scaron;ni unosi!";
$PMF_LANG["lostpwd_text_1"] = "Zahtev za detaljima Va&scaron;eg naloga je primljen.";
$PMF_LANG["lostpwd_text_2"] = "Podesite novu lozinku u admin delu Va&scaron;eg FAQ.";
$PMF_LANG["lostpwd_mail_okay"] = "E-Mail je poslat.";

$PMF_LANG["ad_xmlrpc_button"] = "Pogledaj najnoviju phpMyFAQ verziju na internetu";
$PMF_LANG["ad_xmlrpc_latest"] = "Najnovija dostupna verzija je";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Izaberite jezik kategorije';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'Mapa sajta';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'Ovaj unos je u reviziji i ne mo&#382;e biti prikazan.';
$PMF_LANG['msgArticleCategories'] = 'Kategorije za ovaj unos';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'ID Jedinstvenog Re&scaron;enja';
$PMF_LANG['ad_entry_faq_record'] = 'FAQ unos';
$PMF_LANG['ad_entry_new_revision'] = 'Otvorite novu reviziju?';
$PMF_LANG['ad_entry_record_administration'] = 'Administracija unosa';
$PMF_LANG['ad_entry_changelog'] = 'Izmene';
$PMF_LANG['ad_entry_revision'] = 'Revizija';
$PMF_LANG['ad_changerev'] = 'Izaberite Reviziju';
$PMF_LANG['msgCaptcha'] = "Molimo Vas unesite znakove koje vidite na slici";
$PMF_LANG['msgSelectCategories'] = 'Tra&#382;i u ...';
$PMF_LANG['msgAllCategories'] = '... svim kategorijama';
$PMF_LANG['ad_you_should_update'] = 'Va&scaron;a phpMyFAQ instalacija je zastarela. Instalirajte novu verziju.';
$PMF_LANG['msgAdvancedSearch'] = 'Napredna pretraga';

// added v1.6.1 - 2006-04-25 by Matteo&nbsp;and&nbsp;Thorsten
$PMF_LANG['spamControlCenter'] = 'Spam kontrolni centar';
$LANG_CONF["spam.enableSafeEmail"] = array(0 => "checkbox", 1 => "Ispisuj korisni&#269;ke email adrese na siguran na&#269;in (uklju&#269;eno).");
$LANG_CONF["spam.checkBannedWords"] = array(0 => "checkbox", 1 => "Proveri javnu formu za zabranjene re&#269;i (uklju&#269;eno).");
$LANG_CONF["spam.enableCaptchaCode"] = array(0 => "checkbox", 1 => "Koristi catpcha slike za kori&scaron;&#263;enje javne forme (uklju&#269;eno).");
$PMF_LANG['ad_session_expiring'] = 'Va&scaron;a sesija &#263;e iste&#263;i za %d minuta: da li &#382;elite da nastavite sa radom?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Pode&scaron;avanje sesija';
$PMF_LANG['ad_stat_choose'] = 'Izaberite mesec';
$PMF_LANG['ad_stat_delete'] = 'Obri&scaron;i odmah odabrane sesije';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'Pojmovi';
$PMF_LANG['ad_glossary_add'] = 'Dodaj pojam';
$PMF_LANG['ad_glossary_edit'] = 'Izmeni pojam';
$PMF_LANG['ad_glossary_item'] = 'Unos';
$PMF_LANG['ad_glossary_definition'] = 'Definicija';
$PMF_LANG['ad_glossary_save'] = 'Sa&#269;uvaj unos';
$PMF_LANG['ad_glossary_save_success'] = 'Pojam uspe&scaron;no sa&#269;uvan!';
$PMF_LANG['ad_glossary_save_error'] = 'Pojam nije sa&#269;uvan zbog gre&scaron;ke.';
$PMF_LANG['ad_glossary_update_success'] = 'Pojam uspe&scaron;no izmenjen!';
$PMF_LANG['ad_glossary_update_error'] = 'Pojam nije sa&#269;uvan zbog gre&scaron;ke.';
$PMF_LANG['ad_glossary_delete'] = 'Obri&scaron;i unos';
$PMF_LANG['ad_glossary_delete_success'] = 'Pojam obrisan!';
$PMF_LANG['ad_glossary_delete_error'] = 'Pojam nije obrisan zbog gre&scaron;ke.';
$PMF_LANG['ad_linkcheck_noReferenceURL'] = 'Automatska provera linka isklju&#269;ena (URL za verifikaciju nije pode&scaron;en)';
$PMF_LANG['ad_linkcheck_noAllowUrlOpen'] = 'Automatska provera linka isklju&#269;ena (PHP opcija allow_url_fopen nije uklju&#269;ena)';
$PMF_LANG['ad_linkcheck_checkResult'] = 'Rezultat automatske provere linka';
$PMF_LANG['ad_linkcheck_checkSuccess'] = 'OK';
$PMF_LANG['ad_linkcheck_checkFailed'] = 'Neuspe&scaron;no';
$PMF_LANG['ad_linkcheck_failReason'] = 'Razlozi neuspeha:';
$PMF_LANG['ad_linkcheck_noLinksFound'] = 'Nema odgovaraju&#263;ih URLa za proveru.';
$PMF_LANG['ad_linkcheck_searchbadonly'] = 'Samo sa lo&scaron;im linkovima';
$PMF_LANG['ad_linkcheck_infoReason'] = 'Dodatne informacije:';
$PMF_LANG['ad_linkcheck_openurl_infoprefix'] = 'Nadjeno dok je testirano <strong>%s</strong>: ';
$PMF_LANG['ad_linkcheck_openurl_notready'] = 'Proverava&#269;Linkova nije spreman.';
$PMF_LANG['ad_linkcheck_openurl_maxredirect'] = 'Maksimalni broj preusmerenja <strong>%d</strong> pre&#273;en.';
$PMF_LANG['ad_linkcheck_openurl_urlisblank'] = 'Izgleda da je prazan URL.';
$PMF_LANG['ad_linkcheck_openurl_tooslow'] = 'Host <strong>%s</strong> je spor ili ne odgovara.';
$PMF_LANG['ad_linkcheck_openurl_nodns'] = 'DNS prevod hosta <strong>%s</strong> je spor ili onemogu&#263;en zbog DNS problema, lokalnih ili udaljenih.';
$PMF_LANG['ad_linkcheck_openurl_redirected'] = 'URL je preusmeren na <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_ambiguous'] = 'HTTP status <strong>%s</strong> vra&#263;en.';
$PMF_LANG['ad_linkcheck_openurl_not_allowed'] = '<em>HEAD</em> metod nije podr&#382;an od strane hosta <strong>%s</strong>, dozvoljeni metodi: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_found'] = 'Ne mo&#382;e biti na&#273;eno na hostu <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_protocol_unsupported'] = '%s protokol nije podr&#382;an verifikacijom linka.';
$PMF_LANG['msgNewQuestionVisible'] = 'Pitanje mora prvo da se proveri pre nego &scaron;to postane javno.';
$PMF_LANG['msgQuestionsWaiting'] = '&#268;eka na potvrdu administratora: ';
$PMF_LANG['ad_entry_visibility'] = 'Objavi?';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] =  "Molimo unesite lozinku. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] =  "Lozinke se ne poklapaju. ";
$PMF_LANG['ad_user_error_loginInvalid'] =  "Une&scaron;eno korisni&#269;ko ime nije na&#273;eno.";
$PMF_LANG['ad_user_error_noEmail'] =  "Unesite va&#382;e&#263;u email adresu. ";
$PMF_LANG['ad_user_error_noRealName'] =  "Unesite Va&scaron;e pravo ime. ";
$PMF_LANG['ad_user_error_delete'] =  "Korisni&#269;ki nalog ne mo&#382;e biti izbrisan. ";
$PMF_LANG['ad_user_error_noId'] =  "Nije prilo&#382;en ID. ";
$PMF_LANG['ad_user_error_protectedAccount'] =  "Korisni&#269;ki nalog je za&scaron;ti&#263;en. ";
$PMF_LANG['ad_user_deleteUser'] = "Obri&scaron;i korisnika";
$PMF_LANG['ad_user_status'] = "Status:";
$PMF_LANG['ad_user_lastModified'] = "zadnji put menjano:";
$PMF_LANG['ad_gen_cancel'] = "Odustani";
$PMF_LANG["rightsLanguage"]['addglossary'] = "dodaj pojam";
$PMF_LANG["rightsLanguage"]['editglossary'] = "izmeni pojam";
$PMF_LANG["rightsLanguage"]['delglossary'] = "obri&scaron;i pojam";
$PMF_LANG["ad_menu_group_administration"] = "Grupe";
$PMF_LANG['ad_user_loggedin'] = 'Prijavljeni ste kao ';

$PMF_LANG['ad_group_details'] = "Detalji Grupe";
$PMF_LANG['ad_group_add'] = "Dodaj Grupu";
$PMF_LANG['ad_group_add_link'] = "Dodaj Grupu";
$PMF_LANG['ad_group_name'] = "Ime:";
$PMF_LANG['ad_group_description'] = "Opis:";
$PMF_LANG['ad_group_autoJoin'] = "Auto-priklju&#269;enje:";
$PMF_LANG['ad_group_suc'] = "Grupa <strong>uspe&scaron;no</strong> dodata.";
$PMF_LANG['ad_group_error_noName'] = "Molimo unesite ime grupe. ";
$PMF_LANG['ad_group_error_delete'] = "Grupa NIJE obrisana. ";
$PMF_LANG['ad_group_deleted'] = "Grupa JE obrisana.";
$PMF_LANG['ad_group_deleteGroup'] = "Obri&scaron;i Grupu";
$PMF_LANG['ad_group_deleteQuestion'] = "Da li ste sigurni?";
$PMF_LANG['ad_user_uncheckall'] = "Odaberi ni&scaron;ta";
$PMF_LANG['ad_group_membership'] = "&#268;lanstvo Grupe";
$PMF_LANG['ad_group_members'] = "&#268;lanovi";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'Ograni&#269;i FAQ podatke za izvoz (opciono)';
$PMF_LANG['ad_export_cat_downwards'] = 'Unazad?';
$PMF_LANG['ad_export_type'] = 'Format izvoza';
$PMF_LANG['ad_export_type_choose'] = 'Izaberite jedan od formata:';
$PMF_LANG['ad_export_download_view'] = 'Preuzmite ili pogledajte in-line?';
$PMF_LANG['ad_export_download'] = 'preuzmi';
$PMF_LANG['ad_export_view'] = 'pogledaj in-line';
$PMF_LANG['ad_export_gen_xhtml'] = 'Napravi XHTML fajl';
$PMF_LANG['ad_export_gen_docbook'] = 'Napravi Docbook fajl';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'Podaci novosti';
$PMF_LANG['ad_news_author_name'] = 'Ime Autora:';
$PMF_LANG['ad_news_author_email'] = 'Email Autora:';
$PMF_LANG['ad_news_set_active'] = 'Uklju&#269;i';
$PMF_LANG['ad_news_allowComments'] = 'Dozvoli komentare:';
$PMF_LANG['ad_news_expiration_window'] = 'Pode&scaron;avanje trajanja vesti (opciono)';
$PMF_LANG['ad_news_from'] = 'Od:';
$PMF_LANG['ad_news_to'] = 'Za:';
$PMF_LANG['ad_news_insertfail'] = 'Vesti nisu une&scaron;ene u bazu.';
$PMF_LANG['ad_news_updatefail'] = 'Vesti nisu izmenjene u bazi.';
$PMF_LANG['newsShowCurrent'] = 'Prika&#382;i nove vesti.';
$PMF_LANG['newsShowArchive'] = 'Prika&#382;i arhivirane vesti.';
$PMF_LANG['newsArchive'] = ' Arhiva vesti';
$PMF_LANG['newsWriteComment'] = 'dodaj komentar';
$PMF_LANG['newsCommentDate'] = 'Dodato dana: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'Pode&scaron;avanje trajanja unosa (opciono)';
$PMF_LANG['admin_mainmenu_home'] = 'Home';
$PMF_LANG['admin_mainmenu_users'] = 'Korisnici';
$PMF_LANG['admin_mainmenu_content'] = 'Sadr&#382;aj';
$PMF_LANG['admin_mainmenu_statistics'] = 'Statistika';
$PMF_LANG['admin_mainmenu_exports'] = 'Izvoz';
$PMF_LANG['admin_mainmenu_backup'] = 'Backup';
$PMF_LANG['admin_mainmenu_configuration'] = 'Konfiguracija';
$PMF_LANG['admin_mainmenu_logout'] = 'Odjava';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'Vlasnik kategorije';
$PMF_LANG['adminSection'] = 'Administracija';
$PMF_LANG['err_expiredArticle'] = 'Ovaj unos je istekao i ne mo&#382;e biti prikazan';
$PMF_LANG['err_expiredNews'] = 'Ove vesti su istekle i ne mogu biti prikazane';
$PMF_LANG['err_inactiveNews'] = 'Ove vesti su u reviziji i ne mogu biti prikazane';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Tra&#382;i u svim jezicima:';
$PMF_LANG['ad_entry_tags'] = 'Oznake';
$PMF_LANG['msg_tags'] = 'Oznake';

// added v2.0.0 - 2006-09-03 by Matteo
$PMF_LANG['ad_linkcheck_feedback_url-batch1'] = 'Provera...';
$PMF_LANG['ad_linkcheck_feedback_url-batch2'] = 'Provera...';
$PMF_LANG['ad_linkcheck_feedback_url-batch3'] = 'Provera...';
$PMF_LANG['ad_linkcheck_feedback_url-checking'] = 'Provera...';
$PMF_LANG['ad_linkcheck_feedback_url-disabled'] = 'Isklju&#269;eno';
$PMF_LANG['ad_linkcheck_feedback_url-linkbad'] = 'Linkovi KO';
$PMF_LANG['ad_linkcheck_feedback_url-linkok'] = 'Linkovi OK';
$PMF_LANG['ad_linkcheck_feedback_url-noaccess'] = 'Nema pristupa';
$PMF_LANG['ad_linkcheck_feedback_url-noajax'] = 'Nema AJAX';
$PMF_LANG['ad_linkcheck_feedback_url-nolinks'] = 'Nema Linkova';
$PMF_LANG['ad_linkcheck_feedback_url-noscript'] = 'Nema Skripti';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = 'Srodne teme';
$LANG_CONF['records.numberOfRelatedArticles'] = array(0 => "input", 1 => "Broj srodnih temi");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'Prevedi';
$PMF_LANG['ad_categ_trans_2'] = 'Kategoriju';
$PMF_LANG['ad_categ_translatecateg'] = 'Prevedi Kategoriju';
$PMF_LANG['ad_categ_translate'] = 'Prevedi';
$PMF_LANG['ad_categ_transalready'] = 'Ve&#263; je prevedeno u: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Obri&scaron;i u svim jezicima?';
$PMF_LANG["ad_categ_deletethislang"] = 'Obri&scaron;i samo za ovaj jezik?';
$PMF_LANG["ad_categ_translated"] = "Kategorija je prevedena.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["ad_categ_show"] = "Pregled";
$PMF_LANG['ad_menu_categ_structure'] = "Pregled kategorije uklju&#269;uju&#263;i svoje jezike";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'Ovla&scaron;&#263;enja korisnika:';
$PMF_LANG['ad_entry_grouppermission'] = 'Grupna ovla&scaron;&#263;enja:';
$PMF_LANG['ad_entry_all_users'] = 'Pristup svim korisnicima';
$PMF_LANG['ad_entry_restricted_users'] = 'Zabranjen pristup za';
$PMF_LANG['ad_entry_all_groups'] = 'Pristup za sve grupe';
$PMF_LANG['ad_entry_restricted_groups'] = 'Zabranjen pristup za';
$PMF_LANG['ad_session_expiration'] = 'Vreme do isticanja sesije';
$PMF_LANG['ad_user_active'] = 'aktivno';
$PMF_LANG['ad_user_blocked'] = 'blokirano';
$PMF_LANG['ad_user_protected'] = 'za&scaron;ti&#263;eno';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = 'Izaberite FAQ unos da bi ste ga ubacili kao link...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Nalepi iza";
$PMF_LANG["ad_categ_remark_move"] = "Razmena 2 kategorije je mogu&#263;a samo na istom nivou.";
$PMF_LANG["ad_categ_remark_overview"] = "Ta&#269;an red kategorija &#269;e biti prikazan, ako su sve kategorije definisane za odre&#273;eni jezik (prva kolona).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = '%d Gostiju i %d Registrovanih';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'ObriÂi odmah logove starije od 30 dana';
$PMF_LANG['ad_adminlog_delete_success'] = 'Stariji logovi obrisani.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'Pojavila se greÂka.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['opensearch_plugin_install'] = 'Dodaj ovu pretragu u Firefox';
$PMF_LANG['ad_quicklinks'] = 'BrziLinkovi';
$PMF_LANG['ad_quick_category'] = 'Dodaj novu kategoriju';
$PMF_LANG['ad_quick_record'] = 'Dodaj novi FAQ unos';
$PMF_LANG['ad_quick_user'] = 'Dodaj novog korisnika';
$PMF_LANG['ad_quick_group'] = 'Dodaj novu grupu';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'Predlog prevoda';
$PMF_LANG['msgNewTranslationAddon'] = 'VaÂ prevod nece odmah biti objavljen, ali ce ga daministrator objaviti posle revizije. Zahtevana polja su <strong>VaÂe Ime</strong>, <strong>VaÂa email adresa</strong>, <strong>naslov prevoda</strong> i <strong>VaÂ faq prevod</strong>. Molimo odvojute kljucne reci samo razmakom.';
$PMF_LANG['msgNewTransSourcePane'] = 'Original';
$PMF_LANG['msgNewTranslationPane'] = 'Prevod';
$PMF_LANG['msgNewTranslationName'] = "Your Name:";
$PMF_LANG['msgNewTranslationMail'] = "Your email address:";
$PMF_LANG['msgNewTranslationKeywords'] = "Keywords:";
$PMF_LANG['msgNewTranslationSubmit'] = 'PoÂaljite predlog';
$PMF_LANG['msgTranslate'] = 'PredloÂite prevod za';
$PMF_LANG['msgTranslateSubmit'] = 'Krenite sa prevodenjem...';
$PMF_LANG['msgNewTranslationThanks'] = "Hvala Vam za VaÂ predloÂeni predlog!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG["rightsLanguage"]['addgroup'] = "dodajte grupne naloge";
$PMF_LANG["rightsLanguage"]['editgroup'] = "izmenite grupne naloge";
$PMF_LANG["rightsLanguage"]['delgroup'] = "obriÂite grupne naloge";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = 'Link se otvara u parent prozoru';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'Komentari';
$PMF_LANG['ad_comment_administration'] = 'Administracija komentara';
$PMF_LANG['ad_comment_faqs'] = 'Komentari u FAQ unosima:';
$PMF_LANG['ad_comment_news'] = 'Komentari u Vestima:';
$PMF_LANG['ad_groups'] = 'Grupe';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array(0 => 'select', 1 => 'Sortiranje unosa (po atributima)');
$LANG_CONF['records.sortby'] = array(0 => 'select', 1 => 'Sortiranje unosa (uzlazno ili silazno)');
$PMF_LANG['ad_conf_order_id'] = 'ID (default)';
$PMF_LANG['ad_conf_order_thema'] = 'Naslov';
$PMF_LANG['ad_conf_order_visits'] = 'Broj posetilaca';
$PMF_LANG['ad_conf_order_updated'] = 'Datum';
$PMF_LANG['ad_conf_order_author'] = 'Autor';
$PMF_LANG['ad_conf_desc'] = 'silazno';
$PMF_LANG['ad_conf_asc'] = 'uzlazno';
$PMF_LANG['mainControlCenter'] = 'Glavna konfiguracija';
$PMF_LANG['recordsControlCenter'] = 'FAQ konfiguracija unosa';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array(0 => "checkbox", 1 => "Ukljucite nove unose (iskljuceno)");
$LANG_CONF['records.defaultAllowComments'] = array(0 => "checkbox", 1 => "Dozvolite komentare na nove unose (nedozvoljeno)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'Unosi u ovoj kategoriji';
$PMF_LANG['msgTagSearch'] = 'Oznaceni unosi';
$PMF_LANG['ad_pmf_info'] = 'phpMyFAQ Informacije';
$PMF_LANG['ad_online_info'] = 'Provera Verzije';
$PMF_LANG['ad_system_info'] = 'Informacije Sistema';