<?php

/*
 * This file is part of Fork CMS.
 *
 * For the full copyright and license information, please view the license
 * file that was distributed with this source code.
 */

trigger_error(
    'This script is deprecated
     If you want to convert a spoon template to twig its better to take a look at
     https://github.com/Thijzer/ConverterCollection or http://spoon2twig.jessedobbelae.re/',
    E_USER_DEPRECATED
);
/**
 * The Spoon2Twig Convert is a command line file converter
 * to rebuild your old templates to new twig compatible templates
 *
 * @deprecated
 */
class spoon2twig
{
    private $iterationNumber = 0;
    private $previousTimeStamp = 0;
    private $start = "{# This file is generated by the Spoon2Twig Converter #}\n\n";
    private $webRoot;
    private $extension = '.html.twig';
    private $startTime;
    private $errors;
    private $type;

    public function __construct()
    {
        $this->startTime = microtime(true);
        $this->webRoot = __DIR__ . '/../';
    }

    /**
     * Start Converter
     *
     * @param array $arguments A list of arguments from php command line
     */
    public function start(array $arguments)
    {
        // OUR INPUT AND REPLACE CODE
        if (!isset($arguments[1])) {
            $this->error('no arguments given');

            return;
        }

        // bool
        $force = (isset($arguments[2]) && $arguments[2] === '-f');
        $this->type['module'] = (isset($arguments[2]) && $arguments[2] === '-m');
        $this->type['theme'] = (isset($arguments[2]) && $arguments[2] === '-t');
        $this->type['backend'] = (isset($arguments[2]) && $arguments[2] === '-b');
        $input = (string) $arguments[1];
        $source = $this->getCorrectSourceVersion();

        $path['templates'] = array('/Layout/Templates', '/Layout/Widgets', '/Layout/Templates/Mails');

        if ($input === '-all') {
            $path['base'] = array('Frontend/Themes', 'Backend/Modules', 'Frontend/Modules', 'Frontend');
            $this->convertAllFiles($force, $path);

            return;
        }

        if ($input === '-backend') {
            $path['base'] = array('Backend/Modules');
            $this->convertAllFiles($force, $path, $input);

            return;
        }

        if ($this->type['module']) {
            $input = ucfirst($input);
            $path['base'] = array('Backend/Modules', 'Frontend/Modules');
            if (!is_dir($this->webRoot . $source . 'Frontend/Modules/' . $input)) {
                $this->error('unknown module folder ' . $input);

                return;
            }
            $this->convertAllFiles($force, $path, $input);

            return;
        }

        if ($this->type['theme']) {
            $input = strtolower($input);
            $path['base'] = array('Frontend/Themes');
            if (!is_dir($this->webRoot . $source . 'Frontend/Themes/' . $input)) {
                $this->error('unknown theme folder ' . $input);

                return;
            }
            $this->convertAllFiles($force, $path, $input);

            $themeInfoXmlPath = $source . 'Frontend/Themes/' . $input . '/info.xml';
            $infoXml = $this->getFile($themeInfoXmlPath);
            $infoXml = preg_replace(
                '|<minimum_version>(\d)+\..*<\/minimum_version>|',
                '<minimum_version>4.0.0</minimum_version>',
                $infoXml
            );
            $infoXml = preg_replace('|(path=.+)\.tpl|', '$1.html.twig', $infoXml);
            // prevent invalid xml
            $this->start = '';
            $this->write($themeInfoXmlPath, $infoXml);

            return;
        }

        if ($this->isFile($input) && $force === true) {
            $this->write($input, $this->ruleParser($this->getFile($input)));

            return;
        }

        if (!file_exists(str_replace('.html.twig', $this->extension, $input))) {
            $this->write($input, $this->ruleParser($this->getFile($input)));

            return;
        }

        $this->error('twig version of ' . $input . ' exists, use the "-f" parameter to overwrite');
    }

    /**
     * Error or notice collector
     *
     * @param string $message
     */
    public function error($message)
    {
        $this->errors[] = $message;
    }

    /**
     * Displays all Errors or notices
     */
    public function displayErrors()
    {
        if ($this->errors) {
            foreach ($this->errors as $error) {
                echo $error . PHP_EOL;
            }
        }
    }

    /**
     * Stamps the time it takes from start to finnish
     *
     * @param int $int how precise you wish to measure
     *
     * @return float
     */
    public function timestamp($int = null)
    {
        return (float) substr(microtime(true) - $this->startTime, 0, (int) $int + 5) * 1000;
    }

    /**
     * Project file converter
     * Will locate ever file in the project and convert in automagicly
     *
     * @param bool $force allow forced overwrite
     * @param array $path
     * @param string|null $input
     */
    public function convertAllFiles($force, $path, $input = null)
    {
        foreach ($path['base'] as $BPath) {
            $templatePaths = $this->findFiles($BPath, $path, $input);

            if (!empty($templatePaths)) {
                $this->buildFiles($templatePaths, $force);
            }
        }
    }

    /**
     * @param string $basePath
     * @param array $path
     * @param string $theme
     *
     * @return array
     */
    private function findThemeFiles($basePath, array $path, $theme)
    {
        $source = $this->getCorrectSourceVersion();
        $excludes = array('.', '..', '.DS_Store');
        $themePath = $source . $basePath . '/' . $theme;
        $templates = array();

        if (!is_dir($this->webRoot . $themePath)) {
            return array();
        }

        $directories = array_map(
            function ($directory) {
                return '/Modules/' . $directory;
            },
            array_diff(scandir($themePath . '/Modules'), $excludes)
        );
        $directories[] = '/Core';

        foreach ($directories as $directory) {
            foreach ($path['templates'] as $templateDirectory) {
                $possibleTemplateDirectory = $themePath . $directory . $templateDirectory;

                if (!is_dir($possibleTemplateDirectory)) {
                    continue;
                }

                $foundTemplates = array_diff(scandir($possibleTemplateDirectory), $excludes);

                if (empty($foundTemplates)) {
                    continue;
                }

                // make sure we only have spoon templates
                $foundTemplates = array_filter(
                    $foundTemplates,
                    function ($template) {
                        return strpos($template, '.tpl');
                    }
                );

                foreach ($foundTemplates as $template) {
                    $templates[] = $possibleTemplateDirectory . '/' . $template;
                }
            }
        }

        return $templates;
    }

    /**
     * Find files in given paths
     *
     * @param string $basePath pas
     * @param array $path base & theme template paths
     * @param string $input argument
     *
     * @return array found files
     */
    private function findFiles($basePath, array $path, $input = null)
    {
        // themes work differently so we fetch their files in a separate method
        if ($basePath === 'Frontend/Themes') {
            return $this->findThemeFiles($basePath, $path, $input);
        }

        $templatePaths = array();
        $source = $this->getCorrectSourceVersion();
        $excludes = array('.', '..', '.DS_Store');
        $possiblePath = $source . $basePath;

        if (is_dir($this->webRoot . $possiblePath)) {
            // single module or theme?
            if ($this->type['theme'] || $this->type['module']) {
                $templates[] = $input;
            } else {
                $templates = array_diff(scandir($this->webRoot . $possiblePath), $excludes);
            }

            // core tpl
            $coreTplPath = $this->webRoot . $possiblePath . '/../Core/Layout/Templates';
            if (is_dir($coreTplPath)) {
                $coreTemplates = array_diff(scandir($coreTplPath), $excludes);
                if (!empty($coreTemplates)) {
                    // append full path
                    foreach ($coreTemplates as $coreTpl) {
                        if (strpos($coreTpl, '.html.twig') !== false) {
                            $templatePaths[] = $possiblePath . '/../Core/Layout/Templates/' . $coreTpl;
                        }
                    }
                }
            }

            foreach ($templates as $tpl) {
                foreach ($path['templates'] as $template) {
                    $possibleTemplate = $possiblePath . '/' . $tpl . $template;
                    if (is_dir($this->webRoot . $possibleTemplate)) {
                        $foundTemplates = array_diff(scandir($this->webRoot . $possibleTemplate), $excludes);
                        if (!empty($foundTemplates)) {
                            // append full path
                            foreach ($foundTemplates as $foundTemplate) {
                                if (strpos($foundTemplate, '.html.twig') !== false) {
                                    $templatePaths[] = $possibleTemplate . '/' . $foundTemplate;
                                }
                            }
                        }
                    } else {
                        var_dump($this->webRoot . $possibleTemplate);
                    }
                }
            }

            return $templatePaths;
        }
    }

    /**
     * Builds new Files from a paths array
     *
     * @param array $templatePaths paths array
     * @param bool $force forced
     */
    private function buildFiles(array $templatePaths, $force = false)
    {
        $excluded = array();
        foreach ($templatePaths as $templatePath) {
            if ($force === true) {
                $this->write($templatePath, $this->ruleParser($this->getFile($templatePath)));
            } else {
                if (!file_exists(str_replace('.tpl', $this->extension, $templatePath))) {
                    $this->write($templatePath, $this->ruleParser($this->getFile($templatePath)));
                } else {
                    $excluded[] = $templatePath;
                }
            }
        }
        if (!empty($excluded)) {
            $this->error('not all files are converted, use "-f" to overwrite');
        }
    }

    /**
     * Get Correct version looks a the project version
     * to find and return it's source directory
     *
     * @return string returns the correct source dir
     */
    public function getCorrectSourceVersion()
    {
        // checking what version
        $version = $this->getFile('VERSION.md');
        switch (true) {
            case (strpos($version, '3.9.') !== false):
                $source = 'src/';
                break;

            case (strpos($version, '3.8.') !== false):
                $source = 'src/';
                break;

            default:
                $source = 'src/';
                break;
        }

        return $source;
    }

    /**
     * Write saves to content to a new file
     *
     * @param string $input file full path
     * @param string $fileData file content
     */
    public function write($input, $fileData)
    {
        if (empty($this->errors)) {
            // OUR OUTPUT CODE
            $input = str_replace('.tpl', $this->extension, $input);
            $file = $this->webRoot . $input;
            $inputPath = pathinfo($input);

            file_put_contents($file, $this->start . $fileData);
            $time = $this->timestamp(2) - $this->previousTimeStamp;
            $this->previousTimeStamp = $this->timestamp(2);
            echo $inputPath['basename'] . ' done in ' . $time . ' milliseconds' . PHP_EOL;
        }
    }

    /**
     * Return the file content of a given file
     *
     * @param string $input file full path
     *
     * @return string file content
     */
    public function getFile($input)
    {
        if ($this->isFile($input)) {
            // grab file from command line parameter
            $file = $this->webRoot . $input;
            $stream = fopen($file, 'r');
            $fileData = stream_get_contents($stream);
            fclose($stream);

            return $fileData;
        }
    }

    /**
     * File checker
     *
     * @param string $file file full path
     *
     * @return bool
     */
    public function isFile($file)
    {
        if (file_exists($file)) {
            return true;
        }
        $this->error('Could not open input file: ' . $this->webRoot . $file);

        return false;
    }

    /**
     * preg_replace sprint_f
     * Combines 2 function into one that's more ideal for parsing
     * as it string replaces any found matches with a new given value
     *
     * @param string $regex the regex
     * @param string $format the replace value
     * @param string $fileData file content
     *
     * @return string if successful returns file content with replaced data
     */
    public function pregReplaceSprintf($regex, $format, $fileData, $extra = null)
    {
        preg_match_all($regex, $fileData, $match);

        if (count($match)) {
            $values = array();
            foreach ($match[1] as $value) {
                if ($extra === 'snakeCase') {
                    $value = $this->fromCamelToSnake($value);
                } elseif ($extra === 'comma') {
                    $value = $this->comma($value);
                }
                $values[] = sprintf($format, $value);
            }

            return str_replace($match[0], $values, $fileData);
        }
        $this->error('no match found on the ' . $regex . ' line');
    }

    /**
     * Converts a noun until it's ready
     *
     * @param string $noun a noun
     *
     * @return string converted noun
     */
    public function dePluralize($noun)
    {
        $nouns = array(
            'modules' => 'module',
        );

        // shorten
        $newPlural = pathinfo($noun);
        if (isset($newPlural['extension'])) {
            $noun = $newPlural['extension'];
        }

        if (in_array($noun, array_keys($nouns))) {
            $noun = $nouns[$noun];
        } elseif (substr($noun, -2) == 'es') {
            $noun = substr($noun, 0, -2);
        } elseif (substr($noun, -1) == 's') {
            $noun = substr($noun, 0, -1);
        } else {
            $noun = '_itr_' . $this->iterationNumber;
            ++$this->iterationNumber;
        }

        return $noun;
    }

    /**
     * @param string $input
     *
     * @return string
     */
    public function fromCamelToSnake($input)
    {
        preg_match_all('!([A-Z][A-Z0-9]*(?=$|[A-Z][a-z0-9])|[A-Za-z][a-z0-9]+)!', $input, $matches);
        $ret = $matches[0];
        foreach ($ret as &$match) {
            $match = $match == strtoupper($match) ? strtolower($match) : lcfirst($match);
        }

        return implode('_', $ret);
    }

    /**
     * @param string $input
     *
     * @return string
     */
    public function comma($input)
    {
        return str_replace(':', ',', $input);
    }

    /**
     * Iteration Converter
     *
     * @param string $fileData file to convert
     *
     * @return string file in converted form
     */
    public function pregReplaceIterations($fileData)
    {
        preg_match_all('/{iteration:(.*?)}(.*){\/iteration:(.*?)}/si', $fileData, $match);

        if ($match[1]) {
            foreach ($match[1] as $value) {
                $new_val = $this->dePluralize($value);

                $prev_match = $match[0];
                $match[0] = str_replace(
                    '{iteration:' . $value . '}',
                    '{% for ' . $new_val . ' in ' . $value . '_ %}',
                    $match[0]
                );
                $match[0] = str_replace('{/iteration:' . $value . '}', '{% endfor %}', $match[0]);
                $match[0] = str_replace($value, $new_val, $match[0]);
                $match[0] = str_replace($new_val . '_', $value, $match[0]);
                $fileData = str_replace($prev_match, $match[0], $fileData);

                return $this->pregReplaceIterations($fileData);
            }
        }

        return $fileData;
    }

    /**
     * The actual conversion
     *
     * @param string $fileData
     *
     * @return string
     */
    public function ruleParser($fileData)
    {
        // Exceptions
        $fileData = $this->pregReplaceSprintf('/:{\$(.*?)}/ism', ':%s', $fileData);

        // iterations
        $fileData = $this->pregReplaceIterations($fileData);

        // variables
        $fileData = $this->pregReplaceSprintf('/{\$(.*?)\)}/', '{{ %s ) }}', $fileData);
        $fileData = $this->pregReplaceSprintf('/{\$(.*?)}/ism', '{{ %s }}', $fileData);

        // filters
        $fileData = $this->pregReplaceSprintf('/\|date:(.*?)}/', '|spoondate(%s) }', $fileData, 'comma');
        $fileData = $this->pregReplaceSprintf('/\|date:(.*?)}/', '|date(%s) }', $fileData);
        $fileData = $this->pregReplaceSprintf('/\|substring:(.*?)}/', '|slice(%s) }', $fileData, 'comma');
        $fileData = $this->pregReplaceSprintf('/\|sprintf:(.*?)}/', '|format(%s)|raw }', $fileData);
        $fileData = $this->pregReplaceSprintf('/\|usersetting:(.*?)}/', '|usersetting(%s) }', $fileData);
        $fileData = $this->pregReplaceSprintf(
            '/var\|geturlforblock:(.*?)}/',
            'geturlforblock(%s) }',
            $fileData,
            'comma'
        );
        $fileData = $this->pregReplaceSprintf(
            '/var\|getnavigation:(.*?)}/',
            'getnavigation(%s)|raw }',
            $fileData,
            'comma'
        );
        $fileData = $this->pregReplaceSprintf(
            '/var\|getsubnavigation:(.*?)}/',
            'getsubnavigation(%s)|raw }',
            $fileData,
            'comma'
        );
        $fileData = str_replace('/\|getmainnavigation}/', '|getmainnavigation|raw }', $fileData);
        $fileData = $this->pregReplaceSprintf('/\|truncate:(.*?)}/', '|truncate(%s) }', $fileData);
        $fileData = $this->pregReplaceSprintf('/\|geturl:(.*?)}/', '|geturl(%s) }', $fileData, 'comma');
        $fileData = $this->pregReplaceSprintf('/\|geturl:(.*?)}/', '|geturl(%s) }', $fileData);
        $fileData = str_replace('/Grid}/', 'Grid|raw }', $fileData);

        // string replacers
        $fileData = str_replace('*}', '#}', $fileData); // comments
        $fileData = str_replace('{*', '{#', $fileData); // comments
        $fileData = str_replace('.tpl', $this->extension, $fileData);

        // replace deprecated stuff for the positions
        $fileData = str_replace('BlockIsHTML', 'BlockIsEditor', $fileData);
        $fileData = str_replace('.blockContent', '.html|raw', $fileData);

        // raw converter
        $fileData = str_replace('siteHTMLHeader', 'siteHTMLHeader|raw', $fileData);
        $fileData = str_replace('siteHTMLFooter', 'siteHTMLFooter|raw', $fileData);
        $fileData = str_replace(' metaCustom ', ' metaCustom|raw ', $fileData);
        $fileData = str_replace(' meta ', ' meta|raw ', $fileData);
        $fileData = str_replace('blockContent', 'blockContent|raw', $fileData);

        // includes
        $fileData = $this->pregReplaceSprintf('/{include:(.*?)}/i', '{%% include "%s" %%}', $fileData); // for includes

        // operators
        $fileData = $this->pregReplaceSprintf('/{option:!(.*?)}/i', '{%% if not %s %%}', $fileData);
        $fileData = $this->pregReplaceSprintf(
            '/{\/option:(.*?)}/i',
            '{%% endif %%}',
            $fileData
        ); // for {option: variable }
        $fileData = $this->pregReplaceSprintf('/{option:(.*?)}/i', '{%% if %s %%}', $fileData);

        //form values values are lowercase
        $fileData = $this->pregReplaceSprintf('/{\/form:(.*?)}/i', '{%% endform %%}', $fileData); // for {form:add}
        $fileData = $this->pregReplaceSprintf('/{form:(.*?)}/i', '{%% form %s %%}', $fileData);
        $fileData = $this->pregReplaceSprintf('/{{ txt(.*?) }}/i', '{%% form_field %s %%}', $fileData, 'snakeCase');
        $fileData = $this->pregReplaceSprintf('/{{ file(.*?) }}/i', '{%% form_field %s %%}', $fileData, 'snakeCase');
        $fileData = $this->pregReplaceSprintf('/{{ ddm(.*?) }}/i', '{%% form_field %s %%}', $fileData, 'snakeCase');
        $fileData = $this->pregReplaceSprintf('/{{ chk(.*?) }}/i', '{%% form_field %s %%}', $fileData, 'snakeCase');
        $fileData = $this->pregReplaceSprintf('/form_field (.*?)_error/i', 'form_field_error %s', $fileData);

        // caching // disabled
        $fileData = $this->pregReplaceSprintf('/{\/cache:(.*?)}/i', '{# endcache #}', $fileData);
        $fileData = $this->pregReplaceSprintf('/{cache:(.*?)}/i', '{# cache(%s) #}', $fileData);

        // labels
        $fileData = $this->pregReplaceSprintf('/lbl(.*?)[!^|]/i', "'lbl.%s'|trans|", $fileData);
        $fileData = $this->pregReplaceSprintf('/msg(.*?)[!^|]/i', "'msg.%s'|trans|", $fileData);
        $fileData = $this->pregReplaceSprintf('/err(.*?)[!^|]/i', "'err.%s'|trans|", $fileData);
        $fileData = $this->pregReplaceSprintf('/act(.*?)[!^|]/i', "'act.%s'|trans|", $fileData);

        $fileData = $this->pregReplaceSprintf('/{{ lbl([\w]+) }}/i', "{{ 'lbl.%s'|trans }}", $fileData);
        $fileData = $this->pregReplaceSprintf('/{{ act([\w]+) }}/i', "{{ 'act.%s'|trans }}", $fileData);
        $fileData = $this->pregReplaceSprintf('/{{ msg([\w]+) }}/i', "{{ 'msg.%s'|trans }}", $fileData);
        $fileData = $this->pregReplaceSprintf('/{{ err([\w]+) }}/i', "{{ 'err.%s'|trans }}", $fileData);

        // tabs spaces
        $fileData = str_replace("\t", "    ", $fileData);
        $fileData = str_replace("    ", "  ", $fileData);

        return $fileData;
    }
}

$converter = new spoon2twig();
$converter->start($argv);
$converter->displayErrors();
