<?php

namespace Backend\Modules\Location\Ajax;

/*
 * This file is part of Fork CMS.
 *
 * For the full copyright and license information, please view the license
 * file that was distributed with this source code.
 */

use Backend\Core\Engine\Base\AjaxAction as BackendBaseAJAXAction;
use Backend\Core\Language\Language as BL;
use Backend\Modules\Location\Engine\Model as BackendLocationModel;

/**
 * This is an ajax handler that will set a new position for a certain map
 */
class SaveLiveLocation extends BackendBaseAJAXAction
{
    /**
     * Execute the action
     */
    public function execute()
    {
        parent::execute();

        $generalSettings = $this->get('fork.settings')->getForModule('Location');

        // get parameters
        $itemId = \SpoonFilter::getPostValue('id', null, null, 'int');
        $zoomLevel = trim(\SpoonFilter::getPostValue('zoom', null, 'auto'));
        $mapType = strtoupper(trim(\SpoonFilter::getPostValue(
            'type',
            array(
                'roadmap',
                'satellite',
                'hybrid',
                'terrain',
                'street_view'
            ),
            'roadmap'
        )));
        $mapStyle = trim(\SpoonFilter::getPostValue('style', array('standard', 'custom', 'gray', 'blue'), 'standard'));
        $centerLat = \SpoonFilter::getPostValue('centerLat', null, 1, 'float');
        $centerlng = \SpoonFilter::getPostValue('centerLng', null, 1, 'float');
        $height = \SpoonFilter::getPostValue('height', null, $generalSettings['height'], 'int');
        $width = \SpoonFilter::getPostValue('width', null, $generalSettings['width'], 'int');
        $showLink = \SpoonFilter::getPostValue('link', array('true', 'false'), 'false', 'string');
        $showDirections = \SpoonFilter::getPostValue('directions', array('true', 'false'), 'false', 'string');
        $showOverview = \SpoonFilter::getPostValue('showOverview', array('true', 'false'), 'true', 'string');

        // reformat
        $center = array('lat' => $centerLat, 'lng' => $centerlng);
        $showLink = ($showLink == 'true');
        $showDirections = ($showDirections == 'true');
        $showOverview = ($showOverview == 'true');

        // standard dimensions
        if ($width > 800) {
            $width = 800;
        }
        if ($width < 300) {
            $width = $generalSettings['width'];
        }
        if ($height < 150) {
            $height = $generalSettings['height'];
        }

        // no id given, this means we should update the main map
        BackendLocationModel::setMapSetting($itemId, 'zoom_level', (string) $zoomLevel);
        BackendLocationModel::setMapSetting($itemId, 'map_type', (string) $mapType);
        BackendLocationModel::setMapSetting($itemId, 'map_style', (string) $mapStyle);
        BackendLocationModel::setMapSetting($itemId, 'center', (array) $center);
        BackendLocationModel::setMapSetting($itemId, 'height', (int) $height);
        BackendLocationModel::setMapSetting($itemId, 'width', (int) $width);
        BackendLocationModel::setMapSetting($itemId, 'directions', $showDirections);
        BackendLocationModel::setMapSetting($itemId, 'full_url', $showLink);

        $item = array(
            'id' => $itemId,
            'language' => BL::getWorkingLanguage(),
            'show_overview' => ($showOverview) ? 'Y' : 'N',
        );
        BackendLocationModel::update($item);

        // output
        $this->output(self::OK, null, BL::msg('Success'));
    }
}
