<?php
class Lorem { 
    const WORD = 1;
    const CHAR = 2;
    const PARAGRAPH = 3;
    const EN = 'en';
    const FA = 'fa';
    static private $en = 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.  ';
    static private $fa = 'لورم ایپسوم متنی است که ساختگی برای طراحی و چاپ آن مورد است. صنعت چاپ زمانی لازم بود شرایطی شما باید فکر ثبت نام و طراحی، لازمه خروج می باشد. در ضمن قاعده همفکری ها جوابگوی سئوالات زیاد شاید باشد، آنچنان که لازم بود طراحی گرافیکی خوب بود. کتابهای زیادی شرایط سخت ، دشوار و کمی در سالهای دور لازم است. هدف از این نسخه فرهنگ پس از آن و دستاوردهای خوب شاید باشد. حروفچینی لازم در شرایط فعلی لازمه تکنولوژی بود که گذشته، حال و آینده را شامل گردد. سی و پنج درصد از طراحان در قرن پانزدهم میبایست پرینتر در ستون و سطر حروف لازم است، بلکه شناخت این ابزار گاه اساسا بدون هدف بود و سئوالهای زیادی در گذشته بوجود می آید، تنها لازمه آن بود.  ';

    static function create($lang = self::FA, $count = 10, $type = self::WORD, $end = '...') {
        $out = '';

        if ($lang == self::FA)
            $lorem = self::$fa;
        else
            $lorem = self::$en;

        switch ($type) {
            case self::WORD :
                $words = explode(' ', $lorem);
                $i = 0;
                foreach ($words as $word) {
                    if ($i == $count)
                        break;
                    $out .= ' ' . $word;
                    $i++;
                }
                break;
            case self::CHAR :
                for ($i = 0; $i <= $count; $i++) {
                    $out .= $lorem[$i];
                }
                break;
            case self::PARAGRAPH:
                for ($i = 0; $i < $count; $i++) {
                    $out .= '<p>' . $lorem . '</p>';
                }
                break;
        }

        return $out . $end;
    }
}
