<?php
//----------------------------------------------------------------------|
/***********************************************************************|
 * Project:      Creative Gallery Manager                               |
 * File:        mega.display.php                                        |
//----------------------------------------------------------------------|
 * @link http://megatpl.com/                                            |
 * @copyright 2014.                                                     |
 * @author Eng Hossam Hamed <megatpl@gmail.com> <eng.h.hamed@gmail.com> |
 * @package Creative Gallery Manager                                    |
 * @version 2.0                                                         |
//----------------------------------------------------------------------|
************************************************************************/
//----------------------------------------------------------------------|
if (!defined('IN_MEGATPL')){exit;}                                    //|
//----------------------------------------------------------------------|

       
class display
{
    /*--------------------------------------------------------------------------------------------*/
    public function global_temp()
    {
        global $template, $db, $config;
        //--------
        $bannedip = $db->sql_numrows("SELECT * FROM ".BANNED_TABLE." WHERE `ip`='".GET_IP."'");
        if($bannedip)
        {
            @header("Location:banned.html");
            exit;
        }
        $db->sql_freeresult($bannedip);
        //--------
        $this->web_language("SELECT * FROM ".LANG_TABLE."",'LANG_');
        //--------
        $resultsocial = $db->sql_query("SELECT * FROM ".SOCIAL_TABLE." WHERE `status`='1' ORDER BY `orders` ASC");
        while ($row = $db->sql_fetchrow($resultsocial)) 
        {  
            $template->assign_block_vars('social', array(   
                'NAME'     => $row['name'], 
                'URL'      => $row['url'], 
            ));   
        } 
        $db->sql_freeresult($resultsocial);
        //--------
        $result     = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE status='1' ORDER BY id ASC");
        while ($row = $db->sql_fetchrow($result)) 
        {    
            $template->assign_block_vars('loop_category', array( 
                'NAME'        => $row['name'], 
                'ID'           => $row['id'],
                'PERMA_LINK'   => $this->permalink('cate',$row['id']),
            )); 
        }
        
        $this->recent_latest('15','','loop_footer');
        $text_text = str_ireplace('\"','"',$config['widget_text_text']);
        $text_text = str_ireplace("\'","'",$text_text);
        
        $copyright_en = 'Copyright &copy;'.date('Y').' , All Rights Reserved <br /><a href="http://codecanyon.net/item/creative-gallery-manager/7888458" target="_blank">Creative Gallery Manager version: 2.0</a>';
        $copyright_ar = 'جميع الحقوق محفوظة &copy;'.date('Y').'<br /><a href="http://codecanyon.net/item/creative-gallery-manager/7888458" target="_blank">معرض الإبداع الإصدار 2.0</a>';
        
        
        $template->assign_vars(array(
            'SOCIAL_HEADER'         => $config['socials_header'],
            'SOCIAL_WIDGET'         => $config['socials_widget'],
            'SOCIAL_FOOTER'         => $config['socials_footer'],
            'WID_CATE'              => $config['widget_categories'],
            'WID_CATE_TITLE'        => $config['widget_categories_title'],
            'WID_PIC'               => $config['widget_pictures'],
            'WID_PIC_TITLE'         => $config['widget_pictures_title'],
            'WID_FVIDEOY'           => $config['widget_fvideoy'],
            'WID_FVIDEOY_ID'        => $config['widget_fvideoy_id'],
            'WID_FVIDEOV'           => $config['widget_fvideov'],
            'WID_FVIDEOV_ID'        => $config['widget_fvideov_id'],
            'WID_TEXT'              => $config['widget_text'],
            'WID_TEXT_TITLE'        => $config['widget_text_title'],
            'WID_TEXT_TEXT'         => $text_text,
            'WID_FACEBOOK'          => $config['widget_facebook'],
            'WID_FACEBOOK_TITLE'    => $config['widget_facebook_title'],
            'WID_FACEBOOK_URL'      => $config['widget_facebook_url'],
            'WID_TWIITER'           => $config['widget_twitter'],
            'WID_TWIITER_TITLE'     => $config['widget_twitter_title'],
            'WID_TWIITER_ID'        => $config['widget_twitter_id'],
            'WID_GOOGLE'            => $config['widget_google'],
            'WID_GOOGLE_TITLE'      => $config['widget_google_title'],
            'WID_GOOGLE_URL'        => $config['widget_google_url'],
            'WID_FLICKR'            => $config['widget_flickr'],
            'WID_FLICKR_TITLE'      => $config['widget_flickr_title'],
            'WID_FLICKR_ID'         => $config['widget_flickr_id'],
            'COPYRIGHT'             => ($this->get_web_language('dir') == 'rtl') ? $copyright_ar : $copyright_en,
        ));
        
        
        
        $this->recent_latest($config['widget_pictures_number']+1,'');
        
        
        $this->get_style();
        $this->get_favicon();
        $this->get_logo();
        
        
    
        

    }
    /*--------------------------------------------------------------------------------------------*/
    public function index_home()
    {
        global $template, $db, $config;
        $page         = (int) (!isset($_GET["page"]) ? 1 : $_GET["page"]);
    	$limit        = $config['per_page'];
    	$startpoint   = ($page * $limit) - $limit;
        $sql          = "SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and status='1' ORDER BY id DESC";
        $result       = $db->sql_query_limit($sql,$limit,$startpoint);
        $total        = $db->sql_numrows($sql);
        $lastpage     = ceil($total/$limit);
        if($total > $limit){$showpagination = true;}else{$showpagination = false;}
        while ($row = $db->sql_fetchrow($result)) 
        {    
            $resultcat = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE `id`='".$row['idcat']."'");
            $rowcat    = $db->sql_fetchrow($resultcat);
            
            $lowercase = strtolower($this->get_user('email',$row['iduser']));
            $imageavatar     = md5( $lowercase );
            //'AVATAR'         => $imageavatar,
            if($rowcat['status'])
            {
                $template->assign_block_vars('loop_gallery', array( 
                    'TITLE'          => $row['title'], 
                    'AVATAR'         => $imageavatar,
                    'THUMBIMAGE'     => $row['thumbimage'], 
                    'SOUNDURL'       => $row['sound'], 
                    'VIDEOYOUTUBE'   => $row['videoy'], 
                    'VIDEOVIEMO'     => $row['videov'], 
                    'CONTENT'        => $row['content'],
                    'GTYPE'          => $row['gallery_type'], 
                    'ID'             => $row['id'], 
                    'CATID'          => $rowcat['id'],
                    'VIEWS'          => $row['views'], 
                    'LIKES'          => $row['likes'], 
                    'COMMENTES'      => $this->get_total_comment($row['id']),
                    'MODIFIED'       => date($config['dateformat'],strtotime($row['modified'])), 
                    'USERNAME'       => $this->get_user('username',$row['iduser']),
                    'NAMECATN'       => $rowcat['name'],
                    'GRAVATAR'       => $this->get_gravatar($this->get_user('email',$row['iduser'])),
                    'PERMA_LINK'     => $this->permalink('post',$row['id']),
                    'CAT_PERMA_LINK' => $this->permalink('cate',$rowcat['id']),
                )); 
            }
                
        }
        $template->assign_vars(array(
            'ALL'               => true,
            'SHOW_PAGINATION'   => $showpagination,
            'PAGINATION'        => $this->pagination(POST_TABLE."  WHERE `post_type`='gallery' and status='1' ORDER BY id DESC",$limit,$page,'index.php?'),
            'THISPAGE'          => $page,
            'OFPAGES'           => $lastpage,
            'IDCAT'             => '0',
            'BREADCRUMB'        => '<li class="active home">Home</li>',
            'LOADMORE'          => 'ajax',
        ));
        page_header('Home');
        $template->set_filename('index_body.html');
        page_footer();
    }
    /*--------------------------------------------------------------------------------------------*/
    public function index_cate($id = '')
    {
        global $template, $db, $config;
        if(!$id)
        {
            $id = intval($_GET['cate']);
        }
        
        $resultcat = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE `id`='".$id."'");
        $rowcat    = $db->sql_fetchrow($resultcat);
        
        if($rowcat['status'])
        {
        
            $page         = (int) (!isset($_GET["page"]) ? 1 : $_GET["page"]);
        	$limit        = $config['per_page'];
        	$startpoint   = ($page * $limit) - $limit;
            $sql          = "SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and status='1' and `idcat`='".$db->sql_escape($id)."' ORDER BY id DESC";
            $result       = $db->sql_query_limit($sql,$limit,$startpoint);
            $total        = $db->sql_numrows($sql);
            $lastpage     = ceil($total/$limit);
            
            
            if($total > $limit){$showpagination = true;}else{$showpagination = false;}
            while ($row = $db->sql_fetchrow($result)) 
            {    
                $resultcat = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE `id`='".$row['idcat']."'");
                $rowcat    = $db->sql_fetchrow($resultcat);
                $lowercase = strtolower($this->get_user('email',$row['iduser']));
                $imageavatar     = md5( $lowercase );
                //'AVATAR'         => $imageavatar,
            
                if($rowcat['status'])
                {
                    $template->assign_block_vars('loop_gallery', array( 
                        'TITLE'          => $row['title'], 
                        'AVATAR'         => $imageavatar,
                        'THUMBIMAGE'     => $row['thumbimage'], 
                        'SOUNDURL'       => $row['sound'], 
                        'VIDEOYOUTUBE'   => $row['videoy'], 
                        'VIDEOVIEMO'     => $row['videov'], 
                        'CONTENT'        => $row['content'],
                        'GTYPE'          => $row['gallery_type'], 
                        'ID'             => $row['id'], 
                        'CATID'          => $rowcat['id'],
                        'VIEWS'          => $row['views'], 
                        'LIKES'          => $row['likes'], 
                        'COMMENTES'      => $this->get_total_comment($row['id']),
                        'MODIFIED'       => date($config['dateformat'],strtotime($row['modified'])), 
                        'USERNAME'       => $this->get_user('username',$row['iduser']),
                        'NAMECATN'       => $rowcat['name'],
                        'GRAVATAR'       => $this->get_gravatar($this->get_user('email',$row['iduser'])),
                        'PERMA_LINK'     => $this->permalink('post',$row['id']),
                        'CAT_PERMA_LINK' => $this->permalink('cate',$rowcat['id']),
                    ));
                } 
            }
            $template->assign_vars(array(
                'ALL'               => false,
                'SHOW_PAGINATION'   => $showpagination,
                'PAGINATION'        => $this->pagination(POST_TABLE."  WHERE `post_type`='gallery' and status='1' and `idcat`='".$db->sql_escape($id)."' ORDER BY id DESC",$limit,$page,'index.php?cate='.$id.'&'),
                'THISPAGE'          => $page,
                'OFPAGES'           => $lastpage,
                'IDCAT'             => $id,
                'BREADCRUMB'        => '
                      <li class="home"><a href="index.php">Home</a></li>
                      <li class="active">'.$rowcat['name'].'</li>
                        ',
                'LOADMORE'          => 'ajax',
                
            ));
            page_header($rowcat['name']);
            $template->set_filename('index_body.html');
            page_footer();
        }
        else
        {
            $template->assign_vars(array(
                'BREADCRUMB'        => '
                      <li class="home"><a href="index.php">Home</a></li>
                      <li class="active">404 Not Found</li>
                        ',
            ));
            page_header('404 Not Found');
            $template->set_filename('index_404.html');
            page_footer();
        }
            
    }
    /*--------------------------------------------------------------------------------------------*/
    public function autoload()
    {
        global $template, $db, $config;
        $cate        = filter_var($_POST["cate"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH);
        $page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH);
        if(!is_numeric($page_number)){
        header('HTTP/1.1 500 Invalid number!');exit();}
        $limit        = $config['per_page'];
        $position     = ($page_number * $limit) + $limit;
        if($cate)
        {
            $sql      = "SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and status='1' and `idcat`='".$db->sql_escape($cate)."' ORDER BY id DESC";
        }
        else
        {
            $sql      = "SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and status='1' ORDER BY id DESC";
        }
        $result   = $db->sql_query_limit($sql,$limit,$position);
        if ($result) { 
            while ($row = $db->sql_fetchrow($result)) {
                
                $resultcat = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE `id`='".$row['idcat']."'");
                $rowcat    = $db->sql_fetchrow($resultcat);
                if($rowcat['status'])
                {
                    $lowercase = strtolower($this->get_user('email',$row['iduser']));
                    $imageavatar     = md5( $lowercase );
                    //'AVATAR'         => $imageavatar,
                    $template->assign_block_vars('loop_gallery_more', array( 
                        'TITLE'          => $row['title'], 
                        'AVATAR'         => $imageavatar,
                        'THUMBIMAGE'     => $row['thumbimage'], 
                        'SOUNDURL'       => $row['sound'], 
                        'VIDEOYOUTUBE'   => $row['videoy'], 
                        'VIDEOVIEMO'     => $row['videov'], 
                        'CONTENT'        => $row['content'],
                        'GTYPE'          => $row['gallery_type'], 
                        'ID'             => $row['id'], 
                        'CATID'          => $rowcat['id'],
                        'VIEWS'          => $row['views'], 
                        'LIKES'          => $row['likes'], 
                        'COMMENTES'      => $this->get_total_comment($row['id']),
                        'MODIFIED'       => date($config['dateformat'],strtotime($row['modified'])), 
                        'USERNAME'       => $this->get_user('username',$row['iduser']),
                        'NAMECATN'       => $rowcat['name'],
                        'GRAVATAR'       => $this->get_gravatar($this->get_user('email',$row['iduser'])),
                        'PERMA_LINK'     => $this->permalink('post',$row['id']),
                        'CAT_PERMA_LINK' => $this->permalink('cate',$rowcat['id']),
                    )); 
                }
            }
            page_header('');
            $template->set_filename('index_body_more.html');
            page_footer();
            
        }
    }
    /*--------------------------------------------------------------------------------------------*/
    public function index_post($id)
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and status='1' and `id`='".$db->sql_escape($id)."' ");
        $row = $db->sql_fetchrow($result);
        
        $resultcat = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE `id`='".$row['idcat']."'");
        $rowcat    = $db->sql_fetchrow($resultcat);
        
        if($rowcat['status'])
        {
            $argid = explode(',',$row['gid']);
            if($row['gid'])
            {
                $number = count($argid)+1;
            }
            else
            {
                $number = 1;
            }
            if($row['gallery_type']=='sound')
            {
                $media = $row['sound'];
            }
            elseif($row['gallery_type']=='videov')
            {
                $media = $row['videov'];
            }
            elseif($row['gallery_type']=='videoy')
            {
                $media = $row['videoy'];
            }
            else
            {
                $media = $row['thumbimage'];
            }
            
            $lowercase = strtolower($this->get_user('email',$row['iduser']));
            $imageavatar     = md5( $lowercase );
            //'AVATAR'         => $imageavatar,
                    
            $template->assign_vars( array( 
                'ALL'               => false,
                'MEDIA'             => $media,
                'TITLE'             => $row['title'], 
                'AVATAR'            => $imageavatar,
                'SOUNDURL'          => $row['sound'], 
                'VIDEOYOUTUBE'      => $row['videoy'], 
                'VIDEOVIEMO'        => $row['videov'], 
                'GTYPE'             => $row['gallery_type'], 
                'CONTENT'           => $row['content'], 
                'THUMBIMAGE'        => $row['thumbimage'], 
                'ID'                => $row['id'], 
                'LIKES'             => $row['likes'],
                'VIEWS'             => $row['views'], 
                'COMMENTES'         => $this->get_total_comment($row['id']),
                'MODIFIED'          => date($config['dateformat'],strtotime($row['modified'])), 
                'USERNAME'          => $this->get_user('username',$row['iduser']),
                'NAMECATN'          => $rowcat['name'],
                'IDCAT'             => $row['idcat'],
                'GID'               => $row['gid'],
                'SHARE_PERMA_LINK'  => $this->permalink('post',$row['id']),
                'PERMA_LINK'        => $this->permalink('screenshots',$row['id']),
                'CAT_PERMA_LINK'    => $this->permalink('cate',$rowcat['id']),
                'COMMENT_PERMA_LINK'=> $config['siteurl'].'ajax.php?action=addcomment',
                'NUMPHOTOS'         => $number,
                'BREADCRUMB'        => '
                      <li class="home"><a href="index.php">Home</a></li>
                      <li><a href="index.php?cate='.$rowcat['id'].'">'.$rowcat['name'].'</a></li>
                      <li class="active">'.$row['title'].'</li>
                        ',
            )); 
            
            if($row['gid'] and is_array($argid))
            {
                $this->get_gallery($row['gid']);
            }
            
            $this->get_comments($row['id']);
            
            
            $this->recent_photo('12',$row['idcat'],$row['id']);
            
            $result = $db->sql_query("UPDATE " . POST_TABLE . " SET `views`=views+1 WHERE `id`='".$db->sql_escape($id)."'");
            $db->sql_freeresult($result);
            page_header($row['title']);
            $template->set_filename('index_post.html');
            page_footer();
        }
        else
        {
            $template->assign_vars(array(
                'BREADCRUMB'        => '
                      <li class="home"><a href="index.php">Home</a></li>
                      <li class="active">404 Not Found</li>
                        ',
            ));
            page_header('404 Not Found');
            $template->set_filename('index_404.html');
            page_footer();
        }
        
    }
    /*--------------------------------------------------------------------------------------------*/
    public function index_screenshots($id)
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and status='1' and `id`='".$db->sql_escape($id)."' ");
        $row = $db->sql_fetchrow($result);
        
        $resultcat = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE `id`='".$row['idcat']."'");
        $rowcat    = $db->sql_fetchrow($resultcat);
        
        if($rowcat['status'])
        {
            $argid = explode(',',$row['gid']);
            if($row['gid'])
            {
                $number = count($argid)+1;
            }
            else
            {
                $number = 1;
            }
            $template->assign_vars( array( 
                'TITLE'      => $row['title'], 
                'THUMBIMAGE' => $row['thumbimage'], 
                'ID'         => $row['id'], 
                'MODIFIED'   => date($config['dateformat'],strtotime($row['modified'])), 
                'USERNAME'   => $this->get_user('username',$row['iduser']),
                'NAMECATN'   => $rowcat['name'],
                'IDCAT'      => $row['idcat'],
                'GID'        => $row['gid'],
                'PERMA_LINK'   => $this->permalink('post',$row['id']),
            )); 
            
            if($row['gid'] and is_array($argid))
            {
                $this->get_gallery($row['gid']);
            }
            page_header($row['title']);
            $template->set_filename('screenshots.html');
            page_footer();
        }
        else
        {
            $template->assign_vars(array(
                'BREADCRUMB'        => '
                      <li class="home"><a href="index.php">Home</a></li>
                      <li class="active">404 Not Found</li>
                        ',
            ));
            page_header('404 Not Found');
            $template->set_filename('index_404.html');
            page_footer();
        }
        
    }
    /*--------------------------------------------------------------------------------------------*/
    public function get_gallery($ids = 0)
    {
        global $template, $db, $config;
        $ids = explode(',',$ids);
        $result     = $db->sql_query("SELECT * FROM ".ATTACHMENT_TABLE."");
        $row = $db->sql_fetchrow($result);
        $x = 1;
        while ($row = $db->sql_fetchrow($result)) 
        {    
            if(in_array($row['id'],$ids))
            {
                $x++;
                $template->assign_block_vars('loop_gallery', array( 
                    'TITLE'        => $row['title'], 
                    'URL'          => $row['url'],  
                    'ID'           => $row['id'],
                    'IX'           => $x,
                )); 
            }
                
        }
        $db->sql_freeresult($result);
    }
    
    /*--------------------------------------------------------------------------------------------*/
    public function recent_latest($limit,$iditem,$nameloop = 'loop_latest')
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and `gallery_type`='photo' and status='1' ORDER BY id DESC LIMIT ".$limit." ");
        $row = $db->sql_fetchrow($result);
        
        while ($row = $db->sql_fetchrow($result)) 
        {    
            $resultcat = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE `id`='".$row['idcat']."'");
            $rowcat    = $db->sql_fetchrow($resultcat);
            if($row['id'] == $iditem){}
            else
            {
                if($rowcat['status'])
                {
                    $template->assign_block_vars($nameloop, array( 
                        'TITLE'        => $row['title'], 
                        'THUMBIMAGE'   => $row['thumbimage'], 
                        'CONTENT'      => $row['content'], 
                        'ID'           => $row['id'], 
                        'MODIFIED'     => date($config['dateformat'],strtotime($row['modified'])), 
                        'PERMA_LINK'    => $this->permalink('post',$row['id']),
                    )); 
                }
                    
            }
                    
            
        }
    }
    /*--------------------------------------------------------------------------------------------*/
    public function recent_photo($limit,$idcat,$id)
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and `gallery_type`='photo' and status='1' and `idcat`='".$db->sql_escape($idcat)."' ORDER BY id DESC LIMIT ".$limit." ");
        $row = $db->sql_fetchrow($result);
        
        while ($row = $db->sql_fetchrow($result)) 
        {    
            if($row['id'] != $id)
            {
                $template->assign_block_vars('loop_recent', array( 
                    'TITLE'        => $row['title'], 
                    'THUMBIMAGE'   => $row['thumbimage'], 
                    'CONTENT'      => $row['content'], 
                    'ID'           => $row['id'], 
                    'MODIFIED'     => date($config['dateformat'],strtotime($row['modified'])), 
                    'PERMA_LINK'    => $this->permalink('post',$row['id']),
                ));
            }
                 
        }
    }

    /*--------------------------------------------------------------------------------------------*/
    public function get_user($filed,$id)
    {
        global $db;
        $result = $db->sql_query("SELECT * FROM ".USERS_TABLE." WHERE `id`='".$id."'");
        $user   = $db->sql_fetchrow($result);
        $db->sql_freeresult($result);
        return $user[$filed];
    }
    /*--------------------------------------------------------------------------------------------*/
    public function get_session(){
        global $db,$template,$config;
        $ip = $_SERVER['REMOTE_ADDR'];
        $pc = $_SERVER['HTTP_USER_AGENT'];
        $time = time() + $config['lastactivity'];
        $countsession = $db->sql_numrows(
            "SELECT * FROM ".SESSION_TABLE." WHERE 
            `sessionhash`='".@$_SESSION['sessionhash']."' and `host`='".$ip."' and `useragent`='".$pc."' and `lastactivity` > '".time()."'
        ");
        if($countsession == true)
        {
            $db->sql_query("
                UPDATE ".SESSION_TABLE." SET `lastactivity`='".$time."' WHERE 
                `sessionhash` = '".$_SESSION['sessionhash']."' and `host`='".$ip."' and `useragent`='".$pc."'
            ");
            $template->assign_vars(array(
                'ADMIN' => true,
            ));
            $this->get_account();
        }
        else
        {
            $template->assign_vars(array(
                'ADMIN' => false,
            ));
        }

    }
    /*--------------------------------------------------------------------------------------------*/
    public function get_account(){
        global $db,$template,$config;
        $ip      = $_SERVER['REMOTE_ADDR'];
        $pc      = $_SERVER['HTTP_USER_AGENT'];
        $result  = $db->sql_query("SELECT * FROM ".SESSION_TABLE." WHERE 
        `sessionhash`='".$_SESSION['sessionhash']."' and `host`='".$ip."' and `useragent`='".$pc."'");
        $row     = $db->sql_fetchrow($result);
        $id      = $row['userid'];
        $result2 = $db->sql_query("SELECT * FROM ".USERS_TABLE." WHERE `id`='".$id."'");
        $account = $db->sql_fetchrow($result2);
        $db->sql_freeresult($result);
        $db->sql_freeresult($result2);
        $template->assign_vars(array(
                'ADMINUSERNAME' => $account['username'],
                'CPURL'         => $config['siteurl'].$config['folderadmin']
            ));
    }
    /*--------------------------------------------------------------------------------------------*/
    public function get_gravatar( $email, $s = 80, $d = 'identicon', $r = 'g', $img = false, $atts = array() ) {
    	$url = 'http://www.gravatar.com/avatar/';
    	$url .= md5( strtolower( trim( $email ) ) );
    	$url .= "?s=$s&d=$d&r=$r";
    	if ( $img ) {
    		$url = '<img src="' . $url . '"';
    		foreach ( $atts as $key => $val )
    			$url .= ' ' . $key . '="' . $val . '"';
    		$url .= ' />';
    	}
    	return $url;
    } 
    /*--------------------------------------------------------------------------------------------*/
    public function pagination($query, $per_page = 10,$page = 1, $url = '?'){
        global $db;
    	$query = "SELECT COUNT(*) as `num` FROM {$query}";
    	$row   = mysql_fetch_array(mysql_query($query));
    	$total = $row['num'];
        $adjacents = "2"; 
    	$page = ($page == 0 ? 1 : $page);  
    	$start = ($page - 1) * $per_page;								
    	$prev = $page - 1;							
    	$next = $page + 1;
        $lastpage = ceil($total/$per_page);
    	$lpm1 = $lastpage - 1;
    	$pagination = "";
    	if($lastpage > 1)
    	{	
    		if ($lastpage < 7 + ($adjacents * 2))
    		{	
    			for ($counter = 1; $counter <= $lastpage; $counter++)
    			{
    				if ($counter == $page)
    					$pagination.= "<li class='active'><a href='#'>$counter</a></li>";
    				else
    					$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
    			}
    		}
    		elseif($lastpage > 5 + ($adjacents * 2))
    		{
    			if($page < 1 + ($adjacents * 2))		
    			{
    				for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
    				{
    					if ($counter == $page)
    						$pagination.= "<li><a class='active'>$counter</a></li>";
    					else
    						$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
    				}
    				$pagination.= "<li class='dot'><a href='#' class='active'>...</a></li>";
    				$pagination.= "<li><a href='{$url}page=$lpm1'>$lpm1</a></li>";
    				$pagination.= "<li><a href='{$url}page=$lastpage'>$lastpage</a></li>";		
    			}
    			elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
    			{
    				$pagination.= "<li><a href='{$url}page=1'>1</a></li>";
    				$pagination.= "<li><a href='{$url}page=2'>2</a></li>";
    				$pagination.= "<li class='dot'><a href='#' class='active'>...</a></li>";
    				for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
    				{
    					if ($counter == $page)
    						$pagination.= "<li><a class='active'>$counter</a></li>";
    					else
    						$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
    				}
    				$pagination.= "<li><a href='{$url}page=$lpm1'>$lpm1</a></li>";
    				$pagination.= "<li><a href='{$url}page=$lastpage'>$lastpage</a></li>";		
    			}
    			else
    			{
    				$pagination.= "<li><a href='{$url}page=1'>1</a></li>";
    				$pagination.= "<li><a href='{$url}page=2'>2</a></li>";
    				$pagination.= "<li class='dot'><a href='#' class='active'>...</a></li>";
    				for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
    				{
    					if ($counter == $page)
    						$pagination.= "<li><a class='active'>$counter</a></li>";
    					else
    						$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
    				}
    			}
    		}		
    	}
        return $pagination;
    }

    public function permalink($type, $id)
    {
        global $config;
        if($config['permalink'] == 'numeric')
        {
            return $config['siteurl'].$type.'/'.$id;
        }
        else
        {
            return $config['siteurl'].'index.php?'.$type.'='.$id;
        }
    }
    
    
    public function post_like($id)
    {
        global $db,$template,$config;
        
        $result_like = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `id`='".$id."'");
        $row = $db->sql_fetchrow($result_like);
        $likes = $row['likes']+1;
        $result = $db->sql_query("UPDATE " . POST_TABLE . " SET `likes`='".$likes."' WHERE `id`='".$db->sql_escape($id)."'");
        $db->sql_freeresult($result);
       
        echo $likes;
    }
    
    
    public function post_add_comment()
    {
        global $db,$template,$config;
        
        $comment  = $_POST['comment'];
        $username = $_POST['username'];
        $email    = $_POST['email'];
        
        
        $sql_ins = array(
            'id'            => (int)'',
            'pid'           => $_POST['post_id'],
            'username'      => $username,
            'email'         => $email,
            'comment'       => $comment,
            'ip'            => GET_IP,
            'modified'      => (int)time(),
            'pc'            => GET_PC,
            'modifiedact'   => (int)'0',
            'status'        => (int)'0'
        );
        $sql     = 'INSERT INTO ' . COMMENTS_TABLE . ' ' . $db->sql_build_array('INSERT', $sql_ins, true);
        $result  = $db->sql_query($sql);
        $db->sql_freeresult($result);
        echo true;
    }
    
    public function get_total_comment($id)
    {
        global $db,$template,$config;
        $total  = $db->sql_numrows("SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$id."' and `status`='1'");
        return $total;
    }
    
    
    public function get_comments($id,$num = '')
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$id."' and `status`='1' ORDER BY `modified` ASC");
        
        while ($row = $db->sql_fetchrow($result)) 
        {    
            $lowercase     = strtolower($row['email']);
            $imageavatar  = md5( $lowercase );
            //
            $template->assign_block_vars('loop_comments', array( 
                'ID'              => $row['id'],
                'USERNAME'        => $row['username'], 
                'EMAIL'           => $row['email'],  
                'MODIFIED'        => date($config['dateformat'],$row['modified']), 
                'COMMENT'         => str_replace("\n","<br />",$row['comment']),
                'AVATAR'         => $imageavatar,
            ));   
        }
        $db->sql_freeresult($result);
    }
    
    
    public function cleanMe($data)
    {
        /*$invalid_characters = array("$", "%", "#", "<", ">", "|");
        $data = @preg_quote($data);
        $data = @htmlspecialchars($data);
        $data = @escapeshellarg($data);
        $data = @escapeshellcmd($data);
        $data = @str_replace($invalid_characters, "", $data);
        $data = @strip_tags($data);
        $data = @stripslashes($data);
        $data = @mysql_real_escape_string($data);*/
        return $data;
    }
    
    public function get_style()
    {
        global $config, $template;
        $html = '<style type="text/css">';
        
        
        if($config['bg_color'] and $config['bg_pattern']!='0')
        {
            $html .= '
            body {
            	background-color: '.$config['bg_color'].' !important;
            	background-image: none;
            }
            ';
        }
        
        
        if($config['bg_image'] and !$config['bg_pattern'])
        {
            $html .= '
            body {
            	background-image: url('.$config['bg_image'].') !important;
            	background-repeat: no-repeat;
            	background-position: center top;
            	background-attachment: fixed;
            }
            ';
        }
        elseif($config['bg_pattern'])
        {
            $html .= '
            body {
                background-image: url('.$config['siteurl'].'assets/images/pattern/'.$config['bg_pattern'].') !important;
            }
            ';
        }

        $html .= '
        </style>
        ';
        
        $template->assign_var('GET_STYLE',$html);
    }
    
    
    public function get_favicon()
    {
        global $config, $template;
        if($config['bg_favicon'])
        {
            $html = '<link rel="shortcut icon" href="'.$config['bg_favicon'].'" />';
        }
        else
        {
            $html = '<link rel="shortcut icon" href="'.$config['siteurl'].'assets/images/favicon.png" />';
        }
        
        $template->assign_var('GET_FAVICON',$html);
        
    }
    
    public function get_logo()
    {
        global $config, $template;
        if($config['bg_logo'])
        {
            $html = '<a href="'.$config['siteurl'].'" class="bg_logo"><img src="'.$config['bg_logo'].'" /></a>';
        }
        else
        {
            $html = '<a href="'.$config['siteurl'].'" class="logo"></a>';
        }
        
        $template->assign_var('GET_LOGO',$html);
        
    }
    
    
    public function web_language($sql, $keyvar)
    {
        global $template, $db, $config;
        $result   = $db->sql_query($sql);
        while($row = $db->sql_fetchrow($result))
        {
            $template->assign_var(strtoupper($keyvar.$row['phrase']),$row[$config['sitetlang']]);
        }
        $db->sql_freeresult($result);
    }
    
    public function get_web_language($phrase = '')
    {
        global $db,$template,$config;
        if($phrase)
        {
            $sql    = "SELECT * FROM ".LANG_TABLE." WHERE `phrase`='".$phrase."'";
            $result = $db->sql_query($sql);
            $row    = $db->sql_fetchrow($result);
            
            return $row[$config['sitetlang']];
        }
        else
        {
            return false;
        }
    }

}






    







?>