<?php
//----------------------------------------------------------------------|
/***********************************************************************|
 * Project:      Creative Gallery Manager                               |
//----------------------------------------------------------------------|
 * @link http://megatpl.com/                                            |
 * @copyright 2014.                                                     |
 * @author Eng Hossam Hamed <megatpl@gmail.com> <eng.h.hamed@gmail.com> |
 * @package Creative Gallery Manager                                    |
 * @version 2.0                                                         |
 * Link : http://codecanyon.net/item/creative-gallery-manager/7888458   |
//----------------------------------------------------------------------|
************************************************************************/
//----------------------------------------------------------------------|
if (!defined('IN_MEGATPL_CP') and !defined('IN_MEGATPL'))
{
	exit;
}

class admin_settings
{
    /*---------------------------------------------------------------------------*/
    /* index.php                                                                 */
    /*---------------------------------------------------------------------------*/
    // General
    public function index_general()
    {
        global $template, $db, $config;
        
        
        if(isset($_POST['query']) and $_POST['query'] == 'savesetting')
        {

            set_config('sitename',@$_POST['sitename']);
            set_config('description',@$_POST['description']);
            set_config('siteurl',@$_POST['siteurl']);
            set_config('sitemail',@$_POST['sitemail']);
            set_config('defaultcat',@$_POST['defaultcat']);
            set_config('per_page',@$_POST['per_page']);
            set_config('charset',@$_POST['charset']);
            set_config('sitekey',@$_POST['sitekey']);
            set_config('sitedesc',@$_POST['sitedesc']);
            set_config('dateformat',@$_POST['dateformat']);
            set_config('sitetlang',@$_POST['sitetlang']);
            set_config('folderadmin',@$_POST['folderadmin']);
            set_config('watermark',$this->get_form_status(@$_POST['watermark']));
            set_config('gzip_compress',$this->get_form_status(@$_POST['gzip_compress']));
            header("Location:settings.php?mode=general&save=1");
        }
        
        
        $template->assign_vars(array(
            'ADMIN_SAVE'            => (intval(@$_GET['save'])) ? true : false ,
            'ADMIN_SITE_NAME'       => $config['sitename'],
            'ADMIN_SITE_TAGLINE'    => $config['description'],
            'ADMIN_SITE_URL'        => $config['siteurl'],
            'ADMIN_SITE_EMAIL'      => $config['sitemail'],
            'ADMIN_DEFAULTCAT'      => $this->defaultcat($config['defaultcat']),
            'ADMIN_PER_PAGE'        => $config['per_page'],
            'ADMIN_CHARSET'         => $config['charset'],
            'ADMIN_SITEKEY'         => $config['sitekey'],
            'ADMIN_SITEDESC'        => $config['sitedesc'],
            'ADMIN_DATEFORMAT'      => $config['dateformat'],
            'ADMIN_EX_DATEFORMAT'   => date($config['dateformat']),
            'ADMIN_FOLDERADMIN'     => $config['folderadmin'],
            'ADMIN_WATERMARK'       => $config['watermark'],
            'ADMIN_GZIP_COMPRESS'   => $config['gzip_compress'],
            'ADMIN_SITE_LANG'       => $this->get_lang_config($config['sitetlang']),
            
        ));
        
        $template->assign_vars(array(
            'CLASS_SETTING'  => ' class="active"',
            'CLASS_SETTINGG' => ' class="active"',
        ));
        
        page_header(get_admin_language('sidebar_gs'));
        $template->set_filename('settings-general.html');
        page_footer();
    }
    
    // Socials
    public function index_socials()
    {
        global $template, $db, $config;
        if(isset($_POST['query']) and $_POST['query'] == 'savesetting')
        {
            set_config('socials_header',@$_POST['socials_header']);
            set_config('socials_widget',@$_POST['socials_widget']);
            set_config('socials_footer',@$_POST['socials_footer']);
            $idx    = $_POST['idx'];
            $order  = $_POST['order'];
            $number = count($idx);
            for($i=0;$i<$number;$i++){
                $id     = $idx[$i];
                $orders = $order[$i];   
                $status = $this->get_form_status(@$_POST['status_'.$id]); 
                $result = $db->sql_query("UPDATE " . SOCIAL_TABLE . " SET 
                    `url`      = '".$_POST['url_'.$id]."', 
                    `status`   = '".$status."', 
                    `orders`   = '".$orders."' 
                    WHERE `id` = '".$db->sql_escape($id)."'
                ");
            }
            $db->sql_freeresult($result);
            header("Location:settings.php?mode=socials&save=1");
        }
        $template->assign_vars(array(
            'ADMIN_SAVE'          => (intval(@$_GET['save'])) ? true : false ,
            'ADMIN_SOCIAL_HEADER' => $config['socials_header'],
            'ADMIN_SOCIAL_FOOTER' => $config['socials_footer'],
            'ADMIN_SOCIAL_WIDGET' => $config['socials_widget'],
        ));
        
        $result     = $db->sql_query("SELECT * FROM ".SOCIAL_TABLE." ORDER BY orders ASC");
        while ($row = $db->sql_fetchrow($result)) 
        {
            $template->assign_block_vars('admin_loop_socials', array( 
                'ID'       => $row['id'],
                'UNAME'    => ucfirst($row['name']), 
                'NAME'     => $row['name'], 
                'URL'      => $row['url'],
                'ORDERS'   => $row['orders'], 
                'STATUS'   => $row['status'], 
            )); 
        }
        $template->assign_vars(array(
            'CLASS_SETTING'  => ' class="active"',
            'CLASS_SETTINGS' => ' class="active"',
        ));
        page_header(get_admin_language('sidebar_ss'));
        $template->set_filename('settings-socials.html');
        page_footer();
    }
    
    // Banned IP Setting
    public function index_ban_ip()
    {
        global $template, $db, $config, $admin_display, $acp_session;
        
        
        if(isset($_REQUEST['action']))
        {
            if($_REQUEST['action'] == 'delete')
            {
                if($_REQUEST['token'] == $_SESSION['securitytoken'])
                {
                    $id = intval($_GET['id']);
                    $result = $db->sql_query("SELECT * FROM " . BANNED_TABLE . "  WHERE `id`='".$db->sql_escape($id)."'");
                    $row = $db->sql_fetchrow($result);
                    $result = $db->sql_query("DELETE FROM " . BANNED_TABLE . "  WHERE `id`='".$db->sql_escape($id)."'");
                    $db->sql_freeresult($result);
                    header("Location:settings.php?mode=ban_ip&delete=1");
                }
                else
                {
                    header("Location:settings.php?mode=ban_ip");
                }
            }
        }
        if(isset($_POST['query']))
        {
            if($_POST['query'] == 'banadd')
            {
                $bannedby = $acp_session->get_account('username');
                $sql_ins = array(
	            'id'             => (int)'',
               	'ip'             => $_POST['ip'],
                'bannedby'       =>  $bannedby
                );
                $sql     = 'INSERT INTO ' . BANNED_TABLE . ' ' . $db->sql_build_array('INSERT', $sql_ins, true);
                $result  = $db->sql_query($sql);
                $db->sql_freeresult($result);
                header("Location:settings.php?mode=ban_ip&add=1");
            }
        }
        
        $template->assign_vars(array(
            'ADMIN_BAN_ADD'     => (intval(@$_GET['add'])) ? true : false ,
            'ADMIN_BAN_DELETE'  => (intval(@$_GET['delete'])) ? true : false ,
        ));
        $result     = $db->sql_query("SELECT * FROM ".BANNED_TABLE." ORDER BY id ASC");
        while ($row = $db->sql_fetchrow($result)) 
        {
            $template->assign_block_vars('admin_loop_banned', array( 
                'ID'       => $row['id'],
                'IP'       => $row['ip'], 
                'BY'      => $row['bannedby'],
            )); 
        }
        $template->assign_vars(array(
            'CLASS_SETTING'  => ' class="active"',
            'CLASS_SETTINGB' => ' class="active"',
        ));
        page_header(get_admin_language('sidebar_bips'));
        $template->set_filename('settings-bannedip.html');
        page_footer();
    }
    // 
    public function index_permalink()
    {
        global $template, $db, $config;
        
        if(isset($_POST['query']) and $_POST['query'] == 'savesetting')
        {
            set_config('permalink',$_POST['permalink']);
            header("Location:settings.php?mode=permalink&save=1");
        }
        
        
        $_SERVER['HTTP_HOST'];

         
        
        if($config['permalink'] == 'numeric')
        {
$htaccess = 'RewriteEngine On
RewriteBase /Script Folder/
RewriteRule ^index\.php$ - [L]
RewriteRule ^cate/(.*)$ index.php?cate=$1
RewriteRule ^post/(.*)$ index.php?photo=$1
RewriteRule ^screenshots/(.*)$ index.php?screenshots=$1
RewriteRule ^ajax/(.*)$ ajax.php?action=$1
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule . /Script Folder/index.php [L]';
        }
        else
        {
            $htaccess = '';
        }
        
        $template->assign_vars(array(
            'ADMIN_SAVE'        => (intval(@$_GET['save'])) ? true : false ,
            'ADMIN_SITEURL'     => $config['siteurl'],
            'ADMIN_PERMALINK'   => $config['permalink'],
            'ADMIN_HTACCESS'    => $htaccess
        ));
        $template->assign_vars(array(
            'CLASS_SETTING'  => ' class="active"',
            'CLASS_SETTINGP' => ' class="active"',
        ));
        page_header(get_admin_language('sidebar_ps'));
        $template->set_filename('settings-permalink.html');
        page_footer();
    }
    
    
    public function get_form_status($status)
    {
        if($status)
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
    
    public function getTemplates($dir, $site)
    {
      $getDir = dir($dir);
      $html = '';
      while (false !== ($templDir = $getDir->read())) {
          if ($templDir != "." && $templDir != ".." && $templDir != "index.php") {
              $selected = ($site == $templDir) ? " selected=\"selected\"" : "";
              $html .= "<option value=\"{$templDir}\"{$selected}>{$templDir}</option>\n";
          }
      }
      return $html;
      $getDir->close();
    }
    

    public function getlang($dir, $site)
    {
        $ldir = opendir($dir);
        $html = '';
        $x = 0;
        while($lan=readdir($ldir))
        {
            $lan1 = explode("-lan.php",$lan);
            
            if($lan1[0] == $site)
            {
            $html .= "<option value='$lan1[0]' selected>$lan1[0]</option>\n";
            }
            elseif($lan1[0] != "." && $lan1[0] != ".." && eregi("-lan.php","$lan"))
            {
            $html .= "<option value='$lan1[0]'>$lan1[0]</option>\n";
            }
        }
        return $html;
        closedir($ldir);
    }
    
    public function defaultcat($id = '')
    {
        global $db;
        $result = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." ORDER BY id ASC");
        $html  = '';
        if ($id == false)
        {
            $html .= '<option value="0" selected="selected">none</option>';
        }
        else
        {
            $html .= '<option value="0" >none</option>';
        }   
        while( $row = $db->sql_fetchrow($result) )
        {   
            if (!is_null($id) && $row['id'] == $id)
            {
                $sel = ' selected="selected" ';
            }
            else{
                $sel = '';
            }
    		$html .= '<option  value="'.$row['id'].'" '.$sel.'>'.$row['name'].'</option>';
        }
        return $html;
    }

    
    
    
    
    
    
    
    
    public function get_themes($dir, $site)
    {
      global $config,$token;
      $getDir = dir($dir);
      $html = '';
      while (false !== ($templDir = $getDir->read())) {
          if ($templDir != "." && $templDir != ".." && $templDir != "index.php") {
              $selected = ($site == $templDir) ?  1 : 0 ;
              $name = str_replace("_"," ",$templDir);
              $name = str_replace("-"," ",$name);
              
              $html .= '<li>';
              $html .= '<img src="'.$config['siteurl'].'themes/'.$templDir.'/screenshot.png" class="" title="'.$name.'">';
              if($selected)
              {
                $html .= '
                <div class="theme-actions activate">
            		<strong>'.get_admin_language('setts_activate').'</strong>: '.$name.'
            	</div>
                ';
              }
              else
              {
                $html .= '
                <div class="theme-actions ">
            		<a class="btn btn-primary btn-small activate" href="settings.php?mode=themes&action=activate&themes='.$templDir.'&token='.$token.'">'.get_admin_language('setts_activate2').'</a>
                    <p>'.$name.'</p>
            	</div>
                ';
              }
              $html .= '</li>';
          }
      }
      return $html;
      $getDir->close();
    }
    
    
    
    public function index_themes()
    {
        global $template, $db, $config;
        
        
        if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'activate' && isset($_REQUEST['themes']))
        {
            if($_REQUEST['token'] == $_SESSION['securitytoken'])
            {
                set_config('sitethemes',trim($_REQUEST['themes']));
                header("Location:settings.php?mode=themes&save=1");
            }
            
        }
        
        $text_text = str_ireplace('\"','"',$config['widget_text_text']);
        $text_text = str_ireplace("\'","'",$text_text);
        $template->assign_vars(array(
            'ADMIN_SAVE'            => (intval(@$_GET['save'])) ? true : false ,
            'THEMENAME'             => $config['sitethemes'],
            'WID_CATE'              => $config['widget_categories'],
            'WID_CATE_TITLE'        => $config['widget_categories_title'],
            'WID_PIC'               => $config['widget_pictures'],
            'WID_PIC_TITLE'         => $config['widget_pictures_title'],
            'WID_PIC_NUM'           => $config['widget_pictures_number'],
            'WID_FVIDEOY'           => $config['widget_fvideoy'],
            'WID_FVIDEOY_ID'        => $config['widget_fvideoy_id'],
            'WID_FVIDEOV'           => $config['widget_fvideov'],
            'WID_FVIDEOV_ID'        => $config['widget_fvideov_id'],
            'WID_TEXT'              => $config['widget_text'],
            'WID_TEXT_TITLE'        => $config['widget_text_title'],
            'WID_TEXT_TEXT'         => $text_text,
            'WID_FACEBOOK'          => $config['widget_facebook'],
            'WID_FACEBOOK_TITLE'    => $config['widget_facebook_title'],
            'WID_FACEBOOK_URL'      => $config['widget_facebook_url'],
            'WID_TWIITER'           => $config['widget_twitter'],
            'WID_TWIITER_TITLE'     => $config['widget_twitter_title'],
            'WID_TWIITER_ID'        => $config['widget_twitter_id'],
            'WID_GOOGLE'            => $config['widget_google'],
            'WID_GOOGLE_TITLE'      => $config['widget_google_title'],
            'WID_GOOGLE_URL'        => $config['widget_google_url'],
            'WID_FLICKR'            => $config['widget_flickr'],
            'WID_FLICKR_TITLE'      => $config['widget_flickr_title'],
            'WID_FLICKR_ID'         => $config['widget_flickr_id'],
            'ADMIN_SITE_THEME'      => $this->get_themes('../themes/',$config['sitethemes']),
        ));
        
        $template->assign_vars(array(
            'CLASS_SETTING'  => ' class="active"',
            'CLASS_SETTINGT' => ' class="active"',
        ));
        page_header(get_admin_language('sidebar_ts'));
        $template->set_filename('settings-themes.html');
        page_footer();
    }
    
    public function get_tabs($tab = '',$name)
    {
        global $template, $db, $config;
        
        
        $aryya_other = array(
            'last_all'         => 'Last All',
            'last_post_photo'  => 'Last Photo',
            'last_post_sound'  => 'Last Sound',
            'last_post_video'  => 'Last video',
            'top_comments'     => 'Top Comments',
            'top_views'        => 'Top Views',
            'top_like'         => 'Top Likes',
        );
        
        $result = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." ORDER BY id ASC");
        $html  = '<select name="widget_tabs_'.$name.'" id="widget_tabs_'.$name.'" style="width:100%">
        <optgroup label="Posts">';
        
        foreach($aryya_other as $key => $value)
        {
            if (!is_null($key) && $tab == $key){$sel = ' selected="selected" ';}
            else{$sel = '';}
			$html .= '<option  value="'.$key.'" '.$sel.'>'.$value.'</option>';
        }
        
        
        $html .= '</optgroup><optgroup label="Categories">';
          
        while( $row = $db->sql_fetchrow($result) )
        {   
            if (!is_null($tab) && $row['id'] == $tab){$sel = ' selected="selected" ';}
            else{$sel = '';}
			$html .= '<option  value="'.$row['id'].'" '.$sel.'>'.$row['name'].'</option>';
        }
        $html .= '</optgroup></select>';
        
        
        return $html;
        
    }
    
    public function get_pattern($dir, $pattern)
    {
      global $config,$token;
      $getDir = dir($dir);
      $html = '';
      while (false !== ($templDir = $getDir->read())) {
            $type  = strrchr(strtolower($templDir) ,'.');
    		$fileext  = str_replace(".","",$type);
    		$fileext  =  strtolower($fileext);
            $imgtype = array('png','jpg','gif');
            
          if ($templDir != "." && $templDir != ".." && $templDir != "index.php" && in_array($fileext,$imgtype)) {
              $checked  = ($pattern == $templDir) ? 'checked="checked"' : '';
              $selected = ($pattern == $templDir) ? 'selectd' : '';
              //selectd
              $html .= '<li class="'.$selected.'">';
              $html .= '<a href="#"><img src="../assets/images/pattern/'.$templDir.'" class="" >';
              $html .= '<input type="radio" name="bg_pattern" value="'.$templDir.'" style="display: none;" '.$checked.'  />';
              $html .= '</a></li>';
          }
      }
      return $html;
      $getDir->close();
    }
    
    public function index_style()
    {
        global $template, $db, $config;
        
        
        if(isset($_POST['query']) and $_POST['query'] == 'savesetting')
        {
            (!@$_POST['bg_pattern'])? $pat = '0' : $pat = @$_POST['bg_pattern'] ;
            set_config('bg_color',@$_POST['bg_color']);
            set_config('bg_image',@$_POST['bg_image']);
            set_config('bg_pattern',$pat);
            set_config('bg_logo',@$_POST['bg_logo']);
            set_config('bg_favicon',@$_POST['bg_favicon']);
            header("Location:settings.php?mode=style&save=1");
        }
        
        
        $template->assign_vars(array(
            'ADMIN_SAVE'            => (intval(@$_GET['save'])) ? true : false ,
            'ADMIN_BG_COLOR'        => $config['bg_color'],
            'ADMIN_BG_IMAGE'        => $config['bg_image'],
            'ADMIN_BG_PATTERN'      => $config['bg_pattern'],
            'ADMIN_BGPATTERN'       => $this->get_pattern('../assets/images/pattern/',$config['bg_pattern']),
            'ADMIN_BG_LOGO'         => $config['bg_logo'],
            'ADMIN_BG_FAVICON'      => $config['bg_favicon'],
        ));
        $template->assign_vars(array(
            'CLASS_SETTING'  => ' class="active"',
            'CLASS_SETTINGST' => ' class="active"',
        ));
        page_header(get_admin_language('sidebar_sts'));
        $template->set_filename('settings-style.html');
        page_footer();
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function get_lang_config($lang = 'en')
    {
        $s_lang = array('en' => 'English', 'ar' => 'العربية - Arabic');
        
        $html = '';
        
        foreach($s_lang as $key => $value)
        {
            if($key == $lang)
            {
                $sel = ' selected="selected" ';
            }
            else
            {
                $sel = '';
            }
            $html .= '<option  value="'.$key.'" '.$sel.'>'.$value.'</option>';
        }
        
        $html .= '';
        
        return $html;
        
    }
    
    
}    






?>