<?php
//----------------------------------------------------------------------|
/***********************************************************************|
 * Project:      Creative Gallery Manager                               |
//----------------------------------------------------------------------|
 * @link http://megatpl.com/                                            |
 * @copyright 2014.                                                     |
 * @author Eng Hossam Hamed <megatpl@gmail.com> <eng.h.hamed@gmail.com> |
 * @package Creative Gallery Manager                                    |
 * @version 2.0                                                         |
 * Link : http://codecanyon.net/item/creative-gallery-manager/7888458   |
//----------------------------------------------------------------------|
************************************************************************/
//----------------------------------------------------------------------|
if (!defined('IN_MEGATPL_CP') and !defined('IN_MEGATPL'))
{
	exit;
}

class admin_gallery
{
    /*---------------------------------------------------------------------------*/
    /* gallery.php                                                             */
    /*---------------------------------------------------------------------------*/
    // gallery
    public function index_gallery()
    {
        global $template, $db, $config, $token;
        
        
        $page         = (int) (!isset($_GET["page"]) ? 1 : $_GET["page"]);
    	$limit        = 10;
    	$startpoint   = ($page * $limit) - $limit;
        $sql          = "SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' ORDER BY modified DESC";
        $result       = $db->sql_query_limit($sql,$limit,$startpoint);
        $total        = $db->sql_numrows($sql);
        $lastpage     = ceil($total/$limit);
        if($total > $limit){$showpagination = true;}else{$showpagination = false;}
        
        
        while ($row = $db->sql_fetchrow($result)) 
        {

            $gid = explode(',',$row['gid']);
            $numphotos = count($gid);
            $template->assign_block_vars('admin_loop_gallery', array( 
                'ID'            => $row['id'],
                'THUMBIMAGE'    => $row['thumbimage'],
                'TITLE'         => $row['title'], 
                'ORDERS'        => $row['orders'], 
                'STATUS'        => $row['status'], 
                'STATUSCOMMENT' => $row['statuscomment'], 
                'CATID'         => $row['idcat'],
                'VIEWS'         => $row['views'],
                'LIKE'          => $row['likes'],
                'COMMENTSALL'   => $this->get_total_comment($row['id'],'all'),
                'COMMENTSAPP'   => $this->get_total_comment($row['id'],'1'),//approved
                'COMMENTSUNA'   => $this->get_total_comment($row['id'],'0'),
                'GTYPE'         => $row['gallery_type'],
                'BY'            => get_user('username',$row['iduser']),
                'MODIFIED'      => date('Y/m/d',strtotime($row['modified'])),
                'CATENAME'      => $this->get_catname($row['idcat']),
                'NUMPHOTOS'     => $numphotos,
                'PHOTOS'        => $this->get_gallery($gid),
            ));
            
        }
        $template->assign_vars(array(
            'CLASS_GALLERY'     => ' class="active"',
            'CLASS_GALLERYI'    => ' class="active"',
            'SHOW_PAGINATION'   => $showpagination,
            'PAGINATION'        => pagination(POST_TABLE."  WHERE `post_type`='gallery' and status='1' ORDER BY id DESC",$limit,$page,'gallery.php?'),
        ));
        page_header(get_admin_language('sidebar_gallery'));
        $template->set_filename('gallery.html');
        page_footer();
        
    }
    // form gallery
    public function form_gallery($type = 'new')
    {
        global $template, $db, $config;
        if($type == 'edit')
        {
            $id      = intval($_GET['id']);
            $result  = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `id`='".$db->sql_escape($id)."'");
            $row     = $db->sql_fetchrow($result);
            $template->assign_vars(array( 
                'ID'            => $row['id'],
                'GID'           => $row['gid'],
                'VIDEOY'        => $row['videoy'],
                'VIDEOV'        => $row['videov'],
                'SOUND'         => $row['sound'],
                'ADS'           => $row['ads'],
                'LINK'          => $row['link'],
                'THUMBIMAGE'    => $row['thumbimage'],
                'TITLE'         => $row['title'], 
                'CONTENT'       => $row['content'],
                'ORDERS'        => $row['orders'], 
                'STATUS'        => $row['status'], 
                'STATUSCOMMENT' => $row['statuscomment'], 
                'CATE'          => $this->get_cat($row['idcat']),
                'GTYPE'         => $row['gallery_type'],
                'QUERY'         => 'edit',
            )); 
            $title_page = get_admin_language('gn_edit').' `'.$row['title'].'` Photos';
            $template->assign_vars(array(
                'CLASS_GALLERY' => ' class="active"',
                'CLASS_GALLERYI' => ' class="active"',
            ));
        }
        else
        {
            $orders = $db->sql_numrows("SELECT * FROM ".POST_TABLE."") + 1;
            $template->assign_vars(array( 
                'ID'            => 0,
                'STATUS'        => true,
                'STATUSCOMMENT' => true, 
                'ORDERS'        => $orders,
                'CATE'          => $this->get_cat($config['defaultcat']),
                'GTYPE'         => 'photo',
                'QUERY'         => 'addnew',
                'GIDA'          => true,
                'GID'           => false,
                'THUMBIMAGE'    => '',
            ));
            $title_page = get_admin_language('post_add');
            $template->assign_vars(array(
                'CLASS_GALLERY' => ' class="active"',
                'CLASS_GALLERYA' => ' class="active"',
            ));
        }
        page_header($title_page);
        $template->set_filename('form-gallery.html');
        page_footer();
    }
    // active gallery
    public function active_gallery()
    {
        global $template, $db, $config;
        $get_status = $_REQUEST['status'];
        $id     = intval($_GET['id']);
        if($get_status == 'disable'){$status = 0;$_SESSION['action_token'] = get_admin_language('cat_disable');}
        elseif($get_status == 'enable'){$status = 1;$_SESSION['action_token'] = get_admin_language('cat_enable');}
        else {$get_status = 1;$_SESSION['action_token'] = 'none';}
        $result = $db->sql_query("UPDATE " . POST_TABLE . " SET `status`='".$status."' WHERE `id`='".$db->sql_escape($id)."'");
        $db->sql_freeresult($result);
        @header("Location:".THIS_SCRIPT);
    }
    // delete gallery
    public function delete_gallery()
    {
        global $template, $db, $config;
        $id     = intval($_GET['id']);
        if($_REQUEST['token'] == $_SESSION['securitytoken'])
        {
            $result = $db->sql_query("DELETE FROM " . POST_TABLE . "  WHERE `id`='".$db->sql_escape($id)."'");
            $db->sql_freeresult($result);
            $_SESSION['action_token'] = get_admin_language('cat_delete');
        }
        else
        {
            
        }
        header("Location:".THIS_SCRIPT."");
    }
    /*---------------------------------------------------------------------------*/
    /* .php                                                             */
    /*---------------------------------------------------------------------------*/
    
    
    
    
    public function get_gallery($ids = 0)
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".ATTACHMENT_TABLE."");
        $row        = $db->sql_fetchrow($result);
        $html       = '';
        while ($row = $db->sql_fetchrow($result)) 
        {    
            if(in_array($row['id'],$ids))
            {
                $html .= '<img src="'.$row['url'].'" class="" /> ';
            }
                
        }
        $db->sql_freeresult($result);
        return $html;
    }
    
    
    
    
    public function get_cat($id = '')
    {
        global $db;
        $result = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." ORDER BY id ASC");
        $html  = '<select name="idcat" style="width:100%">';
        
        if ($id == false)
        {
            $html .= '<option value="0" selected="selected">none</option>';
        }
        else
        {
            $html .= '<option value="0" >none</option>';
        }   
        while( $row = $db->sql_fetchrow($result) )
        {   
            if (!is_null($id) && $row['id'] == $id)
            {
                $sel = ' selected="selected" ';
            }
            else{
                $sel = '';
            }
			$html .= '<option  value="'.$row['id'].'" '.$sel.'>'.$row['name'].'</option>';
        }
        $html .= '</select>';
        return $html;
    }
    
    
    
    public function gallery_type($id = '')
    {
        global $db;
        $type = array('photo' => 'Gallery Image','videoy' => 'Video Youtube','videov' => 'Video Vimeo','sound' => 'Sound soundcloud');
        $html  = '<select name="gallery_type" style="width:100%" id="gallery_type">';
        
          
        foreach($type as $k => $v)
        {
            if ($id == false && $k == 'photo' )
            {
                $sel = ' selected="selected" ';
            }
            elseif (!is_null($id) && $k == $id)
            {
                $sel = ' selected="selected" ';
            }
            else{
                $sel = '';
            }
			$html .= '<option  value="'.$k.'" '.$sel.' id="'.$k.'">'.$v.'</option>';
        }
        $html .= '</select>';
        return $html;
    }
    
    
    public function get_catname($id = '')
    {
        global $db;
        $result = $db->sql_query("SELECT * FROM ".CATEGORIES_TABLE." WHERE id='".$id."'");
        $row = $db->sql_fetchrow($result);
        return $row['name'];
    }
    
    
    public function get_form_status($status)
    {
        if($status)
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
    
    
    
    
    
    
    public function get_total_comment($id,$status = 1)
    {
        global $db,$template,$config;
        if($status == 'all')
        {
            $total  = $db->sql_numrows("SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$id."'");
        }
        else
        {
            $total  = $db->sql_numrows("SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$id."' and `status`='".$status."'");
        }
        
        return $total;
    }
    
    
    public function get_comments($id,$num = '')
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$id."' and `status`='1'");
        
        while ($row = $db->sql_fetchrow($result)) 
        {    
            $lowercase     = strtolower($row['email']);
            $imageavatar  = md5( $lowercase );
            //
            $template->assign_block_vars('loop_comments', array( 
                'ID'              => $row['id'],
                'USERNAME'        => $row['username'], 
                'EMAIL'           => $row['email'],  
                'MODIFIED'        => date($config['dateformat'],$row['modified']), 
                'COMMENT'         => $row['comment'],
                'AVATAR'         => $imageavatar,
            ));   
        }
        $db->sql_freeresult($result);
    }
    
    
    
}    






?>