<?php
//----------------------------------------------------------------------|
/***********************************************************************|
 * Project:      Creative Gallery Manager                               |
//----------------------------------------------------------------------|
 * @link http://megatpl.com/                                            |
 * @copyright 2014.                                                     |
 * @author Eng Hossam Hamed <megatpl@gmail.com> <eng.h.hamed@gmail.com> |
 * @package Creative Gallery Manager                                    |
 * @version 2.0                                                         |
 * Link : http://codecanyon.net/item/creative-gallery-manager/7888458   |
//----------------------------------------------------------------------|
************************************************************************/
//----------------------------------------------------------------------|
if (!defined('IN_MEGATPL_CP') and !defined('IN_MEGATPL'))
{
	exit;
}

class admin_display
{
    /*---------------------------------------------------------------------------*/
    /* index.php                                                                 */
    /*---------------------------------------------------------------------------*/
    // Dashboard
    public function index_dashboard()
    {
        global $template, $db, $config, $token;
        
        $result     = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' ORDER BY modified DESC LIMIT 10");
        while ($row = $db->sql_fetchrow($result)) 
        {

            $gid = explode(',',$row['gid']);
            $numphotos = count($gid);
            $template->assign_block_vars('admin_loop_gallery', array( 
                'ID'            => $row['id'],
                'THUMBIMAGE'    => $row['thumbimage'],
                'TITLE'         => $row['title'], 
                'ORDERS'        => $row['orders'], 
                'STATUS'        => $row['status'], 
                'STATUSCOMMENT' => $row['statuscomment'], 
                'CATID'         => $row['idcat'],
                'VIEWS'         => $row['views'],
                'LIKE'          => $row['likes'],
                'GTYPE'         => $row['gallery_type'],
                'BY'            => get_user('username',$row['iduser']),
                'MODIFIED'      => date('Y/m/d',strtotime($row['modified'])),
                
                'NUMPHOTOS'     => $numphotos,
                
            ));
            
        }
        

        $result     = $db->sql_query("SELECT * FROM ".COMMENTS_TABLE." WHERE `status`='0' ORDER BY modified DESC");
        while ($row = $db->sql_fetchrow($result)) 
        {

            $lowercase     = strtolower($row['email']);
            $imageavatar  = md5( $lowercase );
            $template->assign_block_vars('admin_loop_comments', array( 
                'ID'              => $row['id'],
                'USERNAME'        => $row['username'], 
                'EMAIL'           => $row['email'],  
                'MODIFIED'        => date($config['dateformat'],$row['modified']), 
                'COMMENT'         => str_replace("\n","<br />",$row['comment']),
                'IP'              => $row['ip'],
                'PC'              => $row['pc'],
                'STATUS'          => $row['status'],
                'AVATAR'          => $imageavatar,
                'POST_TITLE'      => $this->gat_post('title',$row['pid']),
                'POST_ID'         => $this->gat_post('id',$row['pid']),
            ));
            
        }
        
        
        
        $template->assign_vars(array(
            'CLASS_DASHBOARD' => ' class="active"',
        ));
        page_header(get_admin_language('sidebar_dashboard'));
        $template->set_filename('dashboard.html');
        page_footer();
    
    }
    // system
    public function index_system()
    {
        global $template, $db, $config, $dbname, $con;
        $template->assign_vars(array(
            'CLASS_SYSTEM' => ' class="active"',
        ));
        $PHP_OS                   = php_uname('s')." (".php_uname('r').")";
        $PHP_SAPI                 = $_SERVER["SERVER_SOFTWARE"];//PHP_SAPI;
        $MYSQL_GET_SERVER_INFO    = mysql_get_server_info();
        $MEMORY_LIMIT             = ini_get('memory_limit');
        $SIZE_DB                  = CalcFullDatabaseSize($dbname, $con);
        $PHPVERSION               = phpversion();
        $gdinfo                   = gd_info();
        (ini_get('safe_mode'))? $safe_mode = 'On' : $safe_mode = 'Off';
        (ini_get('log_errors'))? $log_errors = 'On' : $log_errors = 'Off';
        (ini_get('register_globals'))? $reg_glob = 'On' : $reg_glob = 'Off';
        $post_max_size            = ini_get('post_max_size');
        $UPLOAD_MAX_FILESIZE       = ini_get('upload_max_filesize');
        
        $template->assign_vars(array(
            'PHP_OS'                    => $PHP_OS,
            'PHP_SAPI'                  => $PHP_SAPI,
            'MYSQL_GET_CLIENT_INFO'     => mysqli_get_client_info(),
            'MYSQL_GET_SERVER_INFO'     => $MYSQL_GET_SERVER_INFO,
            'MEMORY_LIMIT'              => $MEMORY_LIMIT,
            'SIZE_DB'                   => $SIZE_DB,
            'GET_SIZE_DISK'             => getSize(disk_free_space(".")),
            'PHPVERSION'                => $PHPVERSION,
            'GDINFO'                    => $gdinfo['GD Version'],
            'SAFEMODE'                  => $safe_mode,
            'LOGERRORS'                 => $log_errors,
            'REG_GLOB'                  => $reg_glob,
            'POSTS_MAX_SIZE'            => $post_max_size,
            'UPLOAD_MAX_FILESIZE'       => $UPLOAD_MAX_FILESIZE,
        ));
        
        page_header(get_admin_language('sidebar_sinfo'));
        $template->set_filename('system.html');
        page_footer();
    }
    // backup
    public function index_backup()
    {
        global $template, $db, $config, $token;
        $template->assign_vars(array(
            'CLASS_DB' => ' class="active"',
            'CLASS_DBB' => ' class="active"',
        ));
        
        
        
        if(isset($_POST['query']))
        {
            if($_POST['query'] == 'createbackup')
            {
                doBackup('',false);
            }
            if($_POST['query'] == 'restorebackup')
            {
                doRestore($_POST['backup_file']);
            }
        }
        if(isset($_GET['backupdelete']) && $_GET['backupdelete'] == "1")
        {
            $action = unlink('backups/'.sanitize($_GET['file']));
            redirect_to("index.php?mode=backup&backupdeleteok=1");
        }
        
            $html = '';
            $dir = 'backups/';
			  if (is_dir($dir)){
				  $getDir = dir($dir);
				  while (false !== ($file = $getDir->read())):
					  if ($file != "." && $file != ".." && $file != "index.php"):
						  if ($file == $config['backup']):
							  $html .= '<div class="db-backup new">';
							  $html .= '<span class="file-name">';
							  $html .= str_replace(".sql", "", $file) . '</span>';
							  $html .= '<a href="backups/' . $file . '" target="_blank" title="'.get_admin_language('gn_download').' '.$file.'" class="download">'.get_admin_language('gn_download').'</a>';
							  $html .= '<a href="index.php?mode=backup&backupdelete=1&file='.$file.'&token='.$token.'" title="'.get_admin_language('gn_delete').' '.$file.'" class="delete">'.get_admin_language('gn_delete').'</a>';
							  $html .= '</div>';
						  else:
							  $html .= '<div class="db-backup" id="item_' . $file . '">';
							  $html .= '<span class="file-name">' . str_replace(".sql", "", $file) . '</span>';
							  $html .= ' <a href="backups/' . $file . '" target="_blank" title="'.get_admin_language('gn_download').' '.$file.'" class="download">'.get_admin_language('gn_download').'</a>';
							  $html .= '<a href="index.php?mode=backup&backupdelete=1&file='.$file.'&token='.$token.'" title="'.get_admin_language('gn_delete').' '.$file.'" class="delete">'.get_admin_language('gn_delete').'</a>';
							  $html .= '</div>';
						  endif;
					  endif;
				  endwhile;
				  $getDir->close();
                
                }else{
                $html .='';
			  }
              
              
              
              if (is_dir($dir))
                    : $getDir = dir($dir);
        			$Restore_Backup = '&nbsp;&nbsp;<select name="backup_file" class="custombox" style="width:250px;margin-top: 9px;">';
                while (false !== ($file = $getDir->read()))
                    : if ($file != "." && $file != ".." && $file != "index.php"): 
                $Restore_Backup .= '<option value="' . $file . '">' . $file . '</option>';
                endif;
                endwhile;
        		$Restore_Backup .= '</select>';
                $getDir->close();
                endif;
        
        
        
        
        
        $template->assign_vars(array(
            'BUFILE' => $html,
            'RESTOREBACKUP' => $Restore_Backup,
            'BUNAME'        => 'MGM-'.date('d-M-Y_H-i-s').'',
        ));
        
        
        page_header(get_admin_language('sidebar_dbbu'));
        $template->set_filename('dbbackup.html');
        page_footer();
    }
    // dbtables
    public function index_dbtables()
    {
        global $template, $db, $config;
        $template->assign_vars(array(
            'CLASS_DB' => ' class="active"',
            'CLASS_DBT' => ' class="active"',
        ));
        $template->assign_vars(array(
            'ADMIN_OPTIMIZEDB'  => optimizeDb(),
        ));
        page_header(get_admin_language('sidebar_dbt'));
        $template->set_filename('dbtables.html');
        page_footer();
    }
    
    
    
    
    
    
    
    
    public function gat_post($field,$id)
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and `id`='".$id."'");
        $row = $db->sql_fetchrow($result);
        return $row[$field];
    }
    
    
}    



function securitytoken($length = '15',$num = false)
{
    if($num)
    {
        $chars = '0123456789';
    }
    else
    {
        $chars = 'abcdefghkmnopqrstuvwxyz0123456789';  
    }
    srand((double)microtime()*1000000);
    $str = '';
    for($i=0 ; $i <= $length ;$i++){
        $num = rand() % 33;
        $tmp = substr($chars,$num,1);
        $str = $str. $tmp;
    }
    return $str;
}


function watermark($name, $ext, $logo){
	if (preg_match("/jpg|jpeg/",$ext)){$src_img=imagecreatefromjpeg($name);}
	if (preg_match("/png/",$ext)){$src_img=imagecreatefrompng($name);}
	if (preg_match("/gif/",$ext)){$src_img=imagecreatefromgif($name);}
	$src_logo = imagecreatefrompng($logo);
    $bwidth  = imageSX($src_img);
    $bheight = imageSY($src_img);
    $lwidth  = imageSX($src_logo);
    $lheight = imageSY($src_logo);
	if ( $bwidth > 160 &&  $bheight > 130 ) {
        $src_x = $bwidth - ($lwidth + 5);
        $src_y = $bheight - ($lheight + 5);
        ImageAlphaBlending($src_img, true);
        ImageCopy($src_img,$src_logo,$src_x,$src_y,0,0,$lwidth,$lheight);
    	if (preg_match("/jpg|jpeg/",$ext)){imagejpeg($src_img, $name);}
    	if (preg_match("/png/",$ext)){imagepng($src_img, $name);}
    	if (preg_match("/gif/",$ext)){imagegif($src_img, $name);}
	}
	else
	{
	   return false;
	}

}










function get_user($filed,$id)
{
    global $db;
    $result = $db->sql_query("SELECT * FROM ".USERS_TABLE." WHERE `id`='".$id."'");
    $user   = $db->sql_fetchrow($result);
    $db->sql_freeresult($result);
    return $user[$filed];
}
















function pagination($query, $per_page = 10,$page = 1, $url = '?'){
    global $db;
	$query = "SELECT COUNT(*) as `num` FROM {$query}";
	$row   = mysql_fetch_array(mysql_query($query));
	$total = $row['num'];
    $adjacents = "2"; 
	$page = ($page == 0 ? 1 : $page);  
	$start = ($page - 1) * $per_page;								
	$prev = $page - 1;							
	$next = $page + 1;
    $lastpage = ceil($total/$per_page);
	$lpm1 = $lastpage - 1;
	$pagination = "";
	if($lastpage > 1)
	{	
		if ($lastpage < 7 + ($adjacents * 2))
		{	
			for ($counter = 1; $counter <= $lastpage; $counter++)
			{
				if ($counter == $page)
					$pagination.= "<li class='active'><a href='#'>$counter</a></li>";
				else
					$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
			}
		}
		elseif($lastpage > 5 + ($adjacents * 2))
		{
			if($page < 1 + ($adjacents * 2))		
			{
				for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
				{
					if ($counter == $page)
						$pagination.= "<li><a class='active'>$counter</a></li>";
					else
						$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
				}
				$pagination.= "<li class='dot'><a href='#' class='active'>...</a></li>";
				$pagination.= "<li><a href='{$url}page=$lpm1'>$lpm1</a></li>";
				$pagination.= "<li><a href='{$url}page=$lastpage'>$lastpage</a></li>";		
			}
			elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
			{
				$pagination.= "<li><a href='{$url}page=1'>1</a></li>";
				$pagination.= "<li><a href='{$url}page=2'>2</a></li>";
				$pagination.= "<li class='dot'><a href='#' class='active'>...</a></li>";
				for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
				{
					if ($counter == $page)
						$pagination.= "<li><a class='active'>$counter</a></li>";
					else
						$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
				}
				$pagination.= "<li><a href='{$url}page=$lpm1'>$lpm1</a></li>";
				$pagination.= "<li><a href='{$url}page=$lastpage'>$lastpage</a></li>";		
			}
			else
			{
				$pagination.= "<li><a href='{$url}page=1'>1</a></li>";
				$pagination.= "<li><a href='{$url}page=2'>2</a></li>";
				$pagination.= "<li class='dot'><a href='#' class='active'>...</a></li>";
				for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
				{
					if ($counter == $page)
						$pagination.= "<li><a class='active'>$counter</a></li>";
					else
						$pagination.= "<li><a href='{$url}page=$counter'>$counter</a></li>";					
				}
			}
		}		
	}
    return $pagination;
}





function get_status_post_js($type = 'photo')
{
    global $db,$template;
    $numall  = $db->sql_numrows("SELECT * FROM ".POST_TABLE."");
    $num     = $db->sql_numrows("SELECT * FROM ".POST_TABLE." WHERE `gallery_type`='".$type."'");
    if($num)
    {
        $n       = (($num/$numall)*100);
        $i       = round($n,2);
        return $i;
    }
    else
    {
        return '0';
    }
        
}


function get_status_comment_js($type = 'approved')
{
    global $db,$template;
    if($type == 'approved')
    {
        $status = '1';
    }
    else
    {
        $status = '0';
    }
    $numall  = $db->sql_numrows("SELECT * FROM ".COMMENTS_TABLE."");
    $num     = $db->sql_numrows("SELECT * FROM ".COMMENTS_TABLE." WHERE `status`='".$status."'");
    if($num)
    {
        $n       = (($num/$numall)*100);
        $i       = round($n,2);
        return $i;
    }
    else
    {
        return '0';
    }
}

function sanitize($string, $trim = false, $int = false, $str = false)
{
    $string = filter_var($string, FILTER_SANITIZE_STRING);
    $string = trim($string);
    $string = stripslashes($string);
    $string = strip_tags($string);
    $string = str_replace(array('‘', '’', '“', '”'), array("'", "'", '"', '"'), $string);
    if ($trim)
      $string = substr($string, 0, $trim);
    if ($int)
      $string = preg_replace("/[^0-9\s]/", "", $string);
    if ($str)
      $string = preg_replace("/[^a-zA-Z\s]/", "", $string);
      
    return $string;
}

function redirect_to($location)
{
  if (!headers_sent()) {
      header('Location: ' . $location);
	  exit;
  } else
      echo '<script type="text/javascript">';
      echo 'window.location.href="' . $location . '";';
      echo '</script>';
      echo '<noscript>';
      echo '<meta http-equiv="refresh" content="0;url=' . $location . '" />';
      echo '</noscript>';
}

function CalcFullDatabaseSize($database, $db)
{
    $tables = mysql_list_tables($database, $db);
    if (!$tables) { return -1; }
    $table_count = mysql_num_rows($tables);
    $size = 0;
    for ($i=0; $i < $table_count; $i++) {
        $tname = mysql_tablename($tables, $i);
        $r = mysql_query("SHOW TABLE STATUS FROM `".$database."` LIKE '".$tname."'");
        $data = mysql_fetch_array($r);
        $size += ($data['Index_length'] + $data['Data_length']);
    };
    $units = array(' Bytes', ' KB', ' MB', ' GB', ' TB');
    for ($i = 0; $size > 1024; $i++) { $size /= 1024; }
    return round($size, 2).$units[$i];
}

















function get_admin_language($phrase = '')
{
    global $db,$template,$config;
    if($phrase)
    {
        $sql    = "SELECT * FROM ".LANG_TABLE." WHERE `phrase`='".$phrase."'";
        $result = $db->sql_query($sql);
        $row    = $db->sql_fetchrow($result);
        
        return $row[$config['sitetlang']];
    }
    else
    {
        return false;
    }
}



function admin_language($sql, $keyvar)
{
    global $template, $db, $config;
    $result   = $db->sql_query($sql);
    while($row = $db->sql_fetchrow($result))
    {
        $template->assign_var(strtoupper($keyvar.$row['phrase']),$row[$config['sitetlang']]);
    }
    $db->sql_freeresult($result);
}

?>