<?php
//----------------------------------------------------------------------|
/***********************************************************************|
 * Project:      Creative Gallery Manager                               |
//----------------------------------------------------------------------|
 * @link http://megatpl.com/                                            |
 * @copyright 2014.                                                     |
 * @author Eng Hossam Hamed <megatpl@gmail.com> <eng.h.hamed@gmail.com> |
 * @package Creative Gallery Manager                                    |
 * @version 1.7                                                        |
//----------------------------------------------------------------------|
************************************************************************/
//----------------------------------------------------------------------|
if (!defined('IN_MEGATPL_CP') and !defined('IN_MEGATPL'))
{
	exit;
}
  define('nl', "\r\n");      

function getSize($size, $precision = 2, $long_name = false, $real_size = true)
{
  $base = $real_size ? 1024 : 1000;
  $pos = 0;
  while ($size > $base) {
      $size /= $base;
      $pos++;
  }
  $prefix = _getSizePrefix($pos);
  $size_name = $long_name ? $prefix . "bytes" : $prefix[0] . 'B';
  return round($size, $precision) . ' ' . ucfirst($size_name);
}

function _getSizePrefix($pos)
{
  switch ($pos) {
      case 00:
          return "";
      case 01:
          return "kilo";
      case 02:
          return "mega";
      case 03:
          return "giga";
      case 04:
          return "tera";
      default:
          return "?-";
  }
}

function optimizeDb()
{
  global $db,$dbname,$align2,$align1,$align3;
  $database = $dbname;
  
  $display = '';
  $display .= '<table class="table table-bordered data-table">';
  $display .= '<thead><tr>';
  $display .= '<th colspan="4">'.get_admin_language('sidebar_dbt').' '.$database.'</th>';
  $display .= '</tr>';
  $display .= '<tr>';
  $display .= '<th colspan="2">'.get_admin_language('db_rep').'</th>';
  $display .= '<th colspan="2">'.get_admin_language('db_opt').'</th>';
  $display .= '</tr></thead><tbody>';
  
  $sql = "SHOW TABLES FROM " . $database;
  $result2 = $db->sql_query($sql);
  while ($row = $db->sql_fetchrow($result2,true)) {
    
      $table = $row['0'];
      
      $display .= '<tr >';
      $display .= '<td>' . $table . '</td>';
      $display .= '<td style="width:30px;text-align:center;">';
      
      $sql = "REPAIR TABLE `" . $table . "`";
      $result = $db->sql_query($sql);
      if (!$result) {
          $db->error("mySQL Error on Query : " . $sql);
      } else
          {
            $display .= '<img src="assets/img/yes.png" title="Table ' . $table . ' Repaired" alt="Ok" />';
          }
		  
      $display .= '</td>';
      $display .= '<td>' . $table . '</td>';
      $display .= '<td style="width:30px;text-align:center;">';
      
      $sql = "OPTIMIZE TABLE `" . $table . "`";
      $result = $db->sql_query($sql);
      if (!$result) {
          $db->error("mySQL Error on Query : " . $sql);
      } else
          {
            $display .= '<img src="assets/img/yes.png" title="Table ' . $table . ' Optimized" alt="Ok"/>';
          }
  
        $display .= '</td></tr>';
  }
  $display .= '</tbody></table>';
  
  return $display;
}



function doBackup($fname = '', $gzip = true,$tables = '*')
{
  global $dbhost,$dbname,$dbuser,$dbpasswd,$align1,$align2,$align3;
  $link = mysql_connect($dbhost,$dbuser,$dbpasswd);
  mysql_select_db($dbname,$link);
  $savename = (!empty($_POST['name']) ? $fname . paranoia($_POST['name']) . '.sql' : $fname . 'MGM-' .date('d-M-Y_H-i-s').'.sql');
  $bname = !empty($_POST['name']) ? paranoia($_POST['name']) . '.sql' : 'MGM-' .date('d-M-Y_H-i-s').'.sql'; 
  //get all of the tables
  if($tables == '*')
  {
    $tables = array();
    $result = mysql_query('SHOW TABLES');
    while($row = mysql_fetch_row($result))
    {
        $tables[] = $row[0];
    }
  }
  else
  {
    $tables = is_array($tables) ? $tables : explode(',',$tables);
  }
  $dump  = '';
  $dump .= '-- --------------------------------------------------------------------------------' . nl;
  $dump .= '-- ' . nl;
  $dump .= '-- @version: ' . $dbname . '.sql ' . date('M j, Y') . ' ' . date('H:i') . ' gewa' . nl;
  $dump .= '-- @package Creative cms lite' . nl;
  $dump .= '-- @author megatpl.com.' . nl;
  $dump .= '-- @copy'.$align3.' 2013' . nl;
  $dump .= '-- ' . nl;
  $dump .= '-- --------------------------------------------------------------------------------' . nl;
  $dump .= '-- Host: ' . $dbhost . nl;
  $dump .= '-- Database: ' . $dbname . nl;
  $dump .= '-- Time: ' . date('M j, Y') . '-' . date('H:i') . nl;
  $dump .= '-- MySQL version: ' . mysql_get_server_info() . nl;
  $dump .= '-- PHP version: ' . phpversion() . nl;
  $dump .= '-- --------------------------------------------------------------------------------' . nl . nl;
  //cycle through
  foreach($tables as $table)
  {
    
    $dump .= nl."--".nl."-- Table structure for table `".$table."`".nl."--".nl."DROP TABLE IF EXISTS `".$table."`;";
    
    $result = mysql_query('SELECT * FROM '.$table);
    $num_fields = mysql_num_fields($result);
    $row2 = mysql_fetch_row(mysql_query('SHOW CREATE TABLE '.$table));
    

    $dump .= nl.$row2[1].";".nl.nl."--".nl."-- Dumping data for table `".$table."`".nl."--".nl.nl;
    
    for ($i = 0; $i < $num_fields; $i++) 
    {
      while($row = mysql_fetch_row($result))
      {
          
        
            $dump .= 'INSERT INTO '.$table.' VALUES(';
            for($j=0; $j<$num_fields; $j++) 
            {
              $row[$j] = addslashes($row[$j]);
              $row[$j] = str_replace(array("\x00", "\x0a", "\x0d", "\x1a"), array('\0', '\n', '\r', '\Z'), $row[$j]);
    		  $row[$j] = str_replace(array("\n", "\r", "\t"), array('\n', '\r', '\t'), $row[$j]);
    		  /*$row[$j] = str_replace('\\', '\\\\', $row[$j]);
    		  $row[$j] = str_replace('\'', '\\\'', $row[$j]);
    		  $row[$j] = str_replace('\\\n', '\n', $row[$j]);
    		  $row[$j] = str_replace('\\\r', '\r', $row[$j]);
    		  $row[$j] = str_replace('\\\t', '\t', $row[$j]);*/
              
              
              if (isset($row[$j])) { $dump .= "'".$row[$j]."'" ; } else { $dump .= "''"; }
              if ($j<($num_fields-1)) { $dump .= ','; }
            }
            $dump .= ");".nl;
        
            
      }
    }
    $dump .=nl."-- --------------------------------------------------------".nl;
  }
 
  //save file
  $handle = fopen('backups/'.$savename,'w+');
  fwrite($handle,$dump);
  fclose($handle);
  $data['backup'] = $bname;
      set_config('backup',$data['backup']);
  if (mysql_affected_rows()) {
          header("Location:index.php?mode=backup&backupok=1");
	  }
}

  
      
function doRestore($fname){
  global $db;
  
  $filename = 'backups/'.trim($fname);
  $templine = '';
  $lines = file($filename);
  foreach ($lines as $line_num => $line) {
	  if (substr($line, 0, 2) != '--' && $line != '') {
		  $templine .= $line;
		  if (substr(trim($line), -1, 1) == ';') {
			  if (!mysql_query($templine)) {
				  $msgError = false;
				  $msgError =  "<div class=\"qerror\">'".mysql_errno()." ".mysql_error()."' during the following query:</div> 
				  <div class=\"query\">{$templine} </div>";
			  }
			  $templine = '';
		  }
	  }
  }
  redirect_to("index.php?mode=backup&restore=1");
}







?>