<?php
//----------------------------------------------------------------------|
/***********************************************************************|
 * Project:      Creative Gallery Manager                               |
//----------------------------------------------------------------------|
 * @link http://megatpl.com/                                            |
 * @copyright 2014.                                                     |
 * @author Eng Hossam Hamed <megatpl@gmail.com> <eng.h.hamed@gmail.com> |
 * @package Creative Gallery Manager                                    |
 * @version 2.0                                                         |
 * Link : http://codecanyon.net/item/creative-gallery-manager/7888458   |
//----------------------------------------------------------------------|
************************************************************************/
//----------------------------------------------------------------------|
if (!defined('IN_MEGATPL_CP') and !defined('IN_MEGATPL'))
{
	exit;
}

class admin_comments
{
    /*---------------------------------------------------------------------------*/
    /* comments.php                                                             */
    /*---------------------------------------------------------------------------*/
    // comments
    public function index_comments($status = 'all')
    {
        global $template, $db, $config, $token;
        if($status == 'all')
        {
            $sql      = "SELECT * FROM ".COMMENTS_TABLE." ORDER BY modified DESC";
            $urlplus  = '';
            $template->assign_vars(array(
                'CLASS_COMMENTSI' => ' class="active"',
            ));
            $title = get_admin_language('com_allcomment');
        }
        elseif($status == 'approved')
        {
            $sql      = "SELECT * FROM ".COMMENTS_TABLE." WHERE `status`='1' ORDER BY modified DESC";
            $urlplus  = 'mode=approved&';
            $template->assign_vars(array(
                'CLASS_COMMENTSA' => ' class="active"',
            ));
            $title = get_admin_language('sidebar_approved');
        }
        elseif($status == 'unapproved')
        {
            $sql      = "SELECT * FROM ".COMMENTS_TABLE." WHERE `status`='0' ORDER BY modified DESC";
            $urlplus  = 'mode=unapproved&';
            $template->assign_vars(array(
                'CLASS_COMMENTSU' => ' class="active"',
            ));
            $title = get_admin_language('sidebar_uapproved');
        }
        elseif($status == 'post')
        {
            $postid   = intval($_GET['postid']);
            $sql      = "SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$postid."' ORDER BY modified DESC";
            
            $resultp = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `id`='".$postid."'");
            $rowp = $db->sql_fetchrow($resultp);
            
            $urlplus  = 'mode=post&postid='.$postid.'&';
            $template->assign_vars(array(
                'CLASS_COMMENTSI' => ' class="active"',
            ));
            $title = get_admin_language('com_postcomment').' <small>'.$rowp['title'].'</small>';
        }
        else
        {
            $sql      = "SELECT * FROM ".COMMENTS_TABLE." ORDER BY modified DESC";
            $urlplus  = '';
            $template->assign_vars(array(
                'CLASS_COMMENTSI' => ' class="active"',
            ));
            $title = get_admin_language('com_allcomment');
        }
        
        
        
        $page         = (int) (!isset($_GET["page"]) ? 1 : $_GET["page"]);
    	$limit        = 10;
    	$startpoint   = ($page * $limit) - $limit;
        $result       = $db->sql_query_limit($sql,$limit,$startpoint);
        $total        = $db->sql_numrows($sql);
        $lastpage     = ceil($total/$limit);
        if($total > $limit){$showpagination = true;}else{$showpagination = false;}
        
        
        
        while ($row = $db->sql_fetchrow($result)) 
        {

            $lowercase     = strtolower($row['email']);
            $imageavatar  = md5( $lowercase );
            $template->assign_block_vars('admin_loop_comments', array( 
                'ID'              => $row['id'],
                'USERNAME'        => $row['username'], 
                'EMAIL'           => $row['email'],  
                'MODIFIED'        => date($config['dateformat'],$row['modified']), 
                'COMMENT'         => str_replace("\n","<br />",$row['comment']),
                'IP'              => $row['ip'],
                'PC'              => $row['pc'],
                'STATUS'          => $row['status'],
                'AVATAR'          => $imageavatar,
                'URLPLUS'         => $urlplus,
                'POST_TITLE'      => $this->gat_post('title',$row['pid']),
                'POST_ID'         => $this->gat_post('id',$row['pid']),
            ));
            
        }
        $template->assign_vars(array(
            'CLASS_COMMENTS' => ' class="active"',
            'SHOW_PAGINATION'   => $showpagination,
            'PAGINATION'        => pagination(str_replace('SELECT * FROM ','',$sql),$limit,$page,'comments.php?'.$urlplus),
        ));
        page_header($title);
        $template->set_filename('comments.html');
        page_footer();
        
    }
    // active comments
    public function active_comments()
    {
        global $template, $db, $config;
        
        $get_status = $_REQUEST['status'];
        $id         = intval($_GET['id']);
        
        if($get_status == 'unapproved'){$status = 0;$_SESSION['action_token'] = get_admin_language('com_unapprovedmsg');}
        elseif($get_status == 'approved'){$status = 1;$_SESSION['action_token'] = get_admin_language('com_approvedmsg');}
        else {$get_status = 1;$_SESSION['action_token'] = 'none';}
        $result = $db->sql_query("UPDATE " . COMMENTS_TABLE . " SET `status`='".$status."' WHERE `id`='".$db->sql_escape($id)."'");
        $db->sql_freeresult($result);
        
        if(isset($_REQUEST['re']))
        {
            @header("Location:index.php");
        }
        else
        {
            if(isset($_REQUEST['mode']))
            {
                if(isset($_GET['postid']) && $_REQUEST['mode'] == 'post')
                {
                    @header("Location:".THIS_SCRIPT.'?mode=post&postid='.intval($_GET['postid']));
                }
                else
                {
                    @header("Location:".THIS_SCRIPT.'?mode='.$_REQUEST['mode']);
                }
            }
            else
            {
                @header("Location:".THIS_SCRIPT);
            }
        }
        
            
            
    }
    // delete comments
    public function delete_comments()
    {
        global $template, $db, $config;
        $id     = intval($_GET['id']);
        if($_REQUEST['token'] == $_SESSION['securitytoken'])
        {
            $result = $db->sql_query("DELETE FROM " . COMMENTS_TABLE . "  WHERE `id`='".$db->sql_escape($id)."'");
            $db->sql_freeresult($result);
            $_SESSION['action_token'] = get_admin_language('com_deletemsg');
        }
        else
        {
            
        }
        
        if(isset($_REQUEST['re']))
        {
            @header("Location:index.php");
        }
        else
        {
            
            if(isset($_REQUEST['mode']))
            {
                if(isset($_GET['postid']) && $_REQUEST['mode'] == 'post')
                {
                    @header("Location:".THIS_SCRIPT.'?mode=post&postid='.intval($_GET['postid']));
                }
                else
                {
                    @header("Location:".THIS_SCRIPT.'?mode='.$_REQUEST['mode']);
                }
            }
            else
            {
                @header("Location:".THIS_SCRIPT);
            }
        }
    }
    /*---------------------------------------------------------------------------*/
    /* .php                                                             */
    /*---------------------------------------------------------------------------*/
    public function get_total_comment($id,$status = 1)
    {
        global $db,$template,$config;
        if($status == 'all')
        {
            $total  = $db->sql_numrows("SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$id."'");
        }
        else
        {
            $total  = $db->sql_numrows("SELECT * FROM ".COMMENTS_TABLE." WHERE `pid`='".$id."' and `status`='".$status."'");
        }
        return $total;
    }
    
    public function gat_post($field,$id)
    {
        global $template, $db, $config;
        $result     = $db->sql_query("SELECT * FROM ".POST_TABLE." WHERE `post_type`='gallery' and `id`='".$id."'");
        $row = $db->sql_fetchrow($result);
        return $row[$field];
    }
    
    
}    






?>