<?php
//----------------------------------------------------------------------|
/***********************************************************************|
 * Project:      Creative Gallery Manager                               |
//----------------------------------------------------------------------|
 * @link http://megatpl.com/                                            |
 * @copyright 2014.                                                     |
 * @author Eng Hossam Hamed <megatpl@gmail.com> <eng.h.hamed@gmail.com> |
 * @package Creative Gallery Manager                                    |
 * @version 2.0                                                         |
//----------------------------------------------------------------------|
************************************************************************/
//----------------------------------------------------------------------|

ob_start();
require_once('./acp-load.php');
if( ! defined('IN_MEGATPL_CP')) exit();

$acp_session->get_session();


if(isset($_REQUEST['action']))
{
    if($_REQUEST['action'] == 'upload')
    {
        header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: no-store, no-cache, must-revalidate");
        header("Cache-Control: post-check=0, pre-check=0", false);
        header("Pragma: no-cache");
        $imagesname = preg_replace('/[^\w\._]+/', '_', $_FILES["file"]["name"]);
        $images = $imagesname;
        $type  = strrchr(strtolower($images) ,'.');
		$fileext  = str_replace(".","",$type);
		$fileext  =  strtolower($fileext);
        move_uploaded_file($_FILES['file']['tmp_name'], BASEPATH.'/upload/' . $images );
        
        if($config['watermark'])
        {
            watermark(BASEPATH ."/upload/".$images,$fileext,'../assets/watermark.png');
        }
        $imgname  = $imagesname;
        $imgname  = str_replace(".".$fileext,"",$imagesname);
        $imgurl   = @$config['siteurl'].'upload/'.$images;
        $imgsize  = $_FILES['file']['size'];
        $imgtype  = $_FILES['file']['type'];
        
        $default  = 1;
        $orders   = 1;
        
        
        $image_info = getimagesize('../upload/'.$images);
        $image_width = $image_info[0];
        $image_height = $image_info[1];
        $dimensions = ''.$image_width.' × '.$image_height.'';
        $sql_ins2 = array(
            'id'             => (int)'',
            'title'          => $imgname,
            'content'        => '',
            'url'            => $imgurl,
            'thumbimage'     => $imgurl,
           	'time'           => (int)time(), 
            'size'           => (int)$imgsize, 
            'type'           => $imgtype, 
            'dimensions'     => $dimensions,    
            'orders'         => (int)$orders,
            'status'         => (int)'1'
        );
        $sql     = 'INSERT INTO ' . ATTACHMENT_TABLE . ' ' . $db->sql_build_array('INSERT', $sql_ins2, true);
        $result  = $db->sql_query($sql);
        $db->sql_freeresult($result);
        $id = $db->sql_nextid();
        $new_file = BASEPATH.'/upload/' . $images;
        $stat = stat( dirname( $new_file ));
    	$perms = $stat['mode'] & 0000666;
    	@ chmod( $new_file, $perms );
    }
    else
    {
        $id = intval($_GET['id']);
        $result = mysql_query("SELECT * FROM ".ATTACHMENT_TABLE." WHERE `id`='".$id."'");
        $row = mysql_fetch_array($result);
    
        $changes = !empty($_REQUEST['history']) ? json_decode(unslash($_REQUEST['history'])) : null;
    	$url_img =  str_replace($config['siteurl'],'../',$row['url']);
        if ( $changes )
        {
            $img   = get_stream($url_img,$row['type'],true);
            $image = image_edit_apply_changes( $img, $changes );
            header( 'Content-Type: '.$row['type'] );
            if($row['type'] == 'image/png'){return imagepng( $image );}
            elseif($row['type'] == 'image/gif'){return imagegif( $image );}
            else{return imagejpeg( $image, null, 100 );}
        }
        else
        {
            
            $image = get_stream($url_img,$row['type'],false);
            header( 'Content-Type: '.$row['type'] );
            if($row['type'] == 'image/png'){return imagepng( $image );}
            elseif($row['type'] == 'image/gif'){return imagegif( $image );}
            else{return imagejpeg( $image, null, 100 );}
        }
        @mysql_free_result($result);
    }
        
}




function image_edit_apply_changes($image, $changes)
{
    if ( !is_array($changes) )
    {
        return $image;
    }
		
    
    foreach ( $changes as $key => $obj ) {
		if ( isset($obj->r) ) {
			$obj->type = 'rotate';
			$obj->angle = $obj->r;
			unset($obj->r);
		} elseif ( isset($obj->f) ) {
			$obj->type = 'flip';
			$obj->axis = $obj->f;
			unset($obj->f);
		} elseif ( isset($obj->c) ) {
			$obj->type = 'crop';
			$obj->sel = $obj->c;
			unset($obj->c);
		}
		$changes[$key] = $obj;
	}
    
    // combine operations
	if ( count($changes) > 1 ) {
		$filtered = array($changes[0]);
		for ( $i = 0, $j = 1; $j < count($changes); $j++ ) {
			$combined = false;
			if ( $filtered[$i]->type == $changes[$j]->type ) {
				switch ( $filtered[$i]->type ) {
					case 'rotate':
						$filtered[$i]->angle += $changes[$j]->angle;
						$combined = true;
						break;
					case 'flip':
						$filtered[$i]->axis ^= $changes[$j]->axis;
						$combined = true;
						break;
				}
			}
			if ( !$combined )
				$filtered[++$i] = $changes[$j];
		}
		$changes = $filtered;
		unset($filtered);
	}
    
    foreach ( $changes as $operation ) {
		switch ( $operation->type ) {
			case 'rotate':
				if ( $operation->angle != 0 ) {
						$image = rotate_image_resource( $image, $operation->angle );
				}
				break;
			case 'flip':
				if ( $operation->axis != 0 )
						$image = flip_image_resource( $image, ( $operation->axis & 1 ) != 0, ( $operation->axis & 2 ) != 0 );
				break;
			case 'crop':
				    $sel = $operation->sel;

					$scale = 1 / image_get_preview_ratio( imagesx( $image ), imagesy( $image ) ); // discard preview scaling
					$image = crop_image_resource( $image, $sel->x * $scale, $sel->y * $scale, $sel->w * $scale, $sel->h * $scale );
				
				break;
		}
	}

	return $image;
}



function rotate_image_resource($img, $angle) {

	if ( function_exists('imagerotate') ) {
		$rotated = imagerotate($img, $angle, 0);
		if ( is_resource($rotated) ) {
			imagedestroy($img);
			$img = $rotated;
		}
	}
	return $img;
}

function flip_image_resource($img, $horz, $vert) {

	$w = imagesx($img);
	$h = imagesy($img);
	$dst = get_imagecreatetruecolor($w, $h);
	if ( is_resource($dst) ) {
		$sx = $vert ? ($w - 1) : 0;
		$sy = $horz ? ($h - 1) : 0;
		$sw = $vert ? -$w : $w;
		$sh = $horz ? -$h : $h;

		if ( imagecopyresampled($dst, $img, 0, 0, $sx, $sy, $w, $h, $sw, $sh) ) {
			imagedestroy($img);
			$img = $dst;
		}
	}
	return $img;
}

function image_get_preview_ratio($w, $h) {
	$max = max($w, $h);
	return $max > 400 ? (400 / $max) : 1;
}


function crop_image_resource($img, $x, $y, $w, $h) {
	$dst = get_imagecreatetruecolor($w, $h);
	if ( is_resource($dst) ) {
		if ( imagecopy($dst, $img, 0, 0, $x, $y, $w, $h) ) {
			imagedestroy($img);
			$img = $dst;
		}
	}
	return $img;
}


function get_imagecreatetruecolor($width, $height) {
	$img = imagecreatetruecolor($width, $height);
	if ( is_resource($img) && function_exists('imagealphablending') && function_exists('imagesavealpha') ) {
		imagealphablending($img, false);
		imagesavealpha($img, true);
	}
	return $img;
}

function unslash($value) 
{
    if ( is_array($value) ) {
            $value = array_map('stripslashes_deep', $value);
    } elseif ( is_object($value) ) {
            $vars = get_object_vars( $value );
            foreach ($vars as $key=>$data) {
                    $value->{$key} = stripslashes_deep( $data );
            }
    } elseif ( is_string( $value ) ) {
            $value = stripslashes($value);
    }

    return $value;
}





function get_stream($url,$type,$resize = false)
{

    if($type == 'image/png')
    {
        if(@imagecreatefrompng($url))
        {
            $image = imagecreatefrompng($url);
        }
        else
        {
            $image = imagecreatefromjpeg($url);
        }
    }
    elseif($type == 'image/gif')
    {
        
        if(@imagecreatefromgif($url))
        {
            $image = imagecreatefromgif($url);
        }
        else
        {
            $image = imagecreatefromjpeg($url);
        }
        
    }
    else
    {
        $image = imagecreatefromjpeg($url);
    }
    
    
    if($resize)
    {
        $sizer = 1;   
    }
    else
    {
        $sizer = image_get_preview_ratio( imagesx( $image ), imagesy( $image ) );   
    }

    $scale           = 1 / $sizer;
    $thumb_width     = $sizer * imagesx( $image );
    $thumb_height    = $sizer * imagesy( $image ) ;
    $width           = imagesx($image);
    $height          = imagesy($image);
    $original_aspect = $width / $height;
    $thumb_aspect    = $thumb_width / $thumb_height;
    if ( $original_aspect >= $thumb_aspect )
    {
       $new_height = $thumb_height;
       $new_width = $width / ($height / $thumb_height);
    }
    else
    {
       $new_width = $thumb_width;
       $new_height = $height / ($width / $thumb_width);
    } 
    $thumb = imagecreatetruecolor( $thumb_width, $thumb_height );
    imagecopyresampled($thumb,$image,0 - ($new_width - $thumb_width) / 2,0 - ($new_height - $thumb_height) / 2,0, 0,$new_width, $new_height,$width, $height);
    
    return $thumb;
}

?>