<?php 
/**
 * Plugin Name: 82 Live Chat 
 * Plugin URI: http://www.82designs.co.uk
 * Description: 82 Live Chat is a live chat plugin for your website that will allow users to interact with a member of your team, whether it be a support issue, customer services, question or more. Fully supported admin area
 * Version:2.2
 * Text Domain: solivechat
 * Author: http://www.82designs.co.uk
 * Author URI: http://www.82designs.co.uk
 * License: Purchase license through CodeCanyon
 */



// ---------- ADDING A SHORT CODE
function addLiveChat() {
	
include('solivechat.php');
return $cdRet;
return $stylecss;

}
add_shortcode('livechat', 'addLiveChat'); 

// ----- Site wide checker

function solivechat_load_plugin_textdomain() {
	$domain = 'solivechat';
	$locale = apply_filters( 'plugin_locale', get_locale(), $domain );
	
	load_plugin_textdomain( $domain, FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}
add_action( 'init', 'solivechat_load_plugin_textdomain' );



// ----- color picker

add_action( 'admin_enqueue_scripts', 'wptuts_add_color_picker_chat' );
function wptuts_add_color_picker_chat( $hook ) {
 
    if( is_admin() ) { 
     
        // Add the color picker css file       
        wp_enqueue_style( 'wp-color-picker' ); 
         
        // Include our custom jQuery file with WordPress Color Picker dependency
        wp_enqueue_script( 'custom-script-handle', plugins_url( 'js/functions.js', __FILE__ ), array( 'wp-color-picker' ), false, true ); 
    }
}


function filter_plugin_updates_solive( $value ) {

  // Add references to plugins you want to disable update notices for in the $plugins array
  $plugins = array(
    'solivechat/index.php'
  );

  foreach( $plugins as $plugin ) {
    if ( isset( $value->response[$plugin] ) ) {
      unset( $value->response[$plugin] );
    }
  }

  return $value;

}
add_filter( 'site_transient_update_plugins', 'filter_plugin_updates_solive' );

// AJAX CALLS

add_action('template_redirect', 'chatbox_get_ajax');

add_action("wp_ajax_nopriv_chatboxstart", "chatboxstart");
add_action("wp_ajax_chatboxstart", "chatboxstart");

function chatboxstart(){
	    
    	global $wpdb;
		
	
		$user    =   htmlspecialchars(substr($_REQUEST['user'], 0, 25), ENT_QUOTES);
		$msg     =   htmlspecialchars($_REQUEST['question'], ENT_QUOTES);
		$ip      =   $_SERVER['REMOTE_ADDR'];
		if (empty($user)) {
			$user="Anonymous";
		}
		
        $wpdb->query("INSERT INTO `solivechat_session` (`ID`, `STATUS`, `NAME`, `TR`, `IP`, `TIMESTAMP`) 
		VALUES (NULL, '1', '$user', '', '$ip', CURRENT_TIMESTAMP)");
		
		$id      = $wpdb->insert_id;
		
		
			if (!empty($msg)) {
				$wpdb->query("INSERT INTO solivechat_messages (SID, `FROM`, MESSAGE) VALUES ('{$id}', '{$user}', '{$msg}')");
			}
			
			// return URL
			//echo site_url().'/wp-content/plugins/solivechat/chatbox.php?sid='.$id.'&name='.$user; 
			die();
		
		
     
}

function chatbox_get_ajax(){
	 wp_enqueue_script( 'jq', plugins_url( 'js/jquery.js', __FILE__ ), 'jquery', true);
	 wp_enqueue_script( 'function', plugins_url( 'js/functions.js', __FILE__ ), 'jquery', true);
	 wp_enqueue_script( 'function', plugins_url( 'chatbox.php', __FILE__ ), 'jquery', true);
	 wp_enqueue_script( 'function', plugins_url( 'tech_panel.php', __FILE__ ), 'jquery', true);
     wp_localize_script( 'function', 'my_ajax_script', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );

}

// UNINSTALL
function solivechatpluginUninstall() {

        global $wpdb;
        $table1 = "solivechat_messages";
		$table2 = "solivechat_options";
		$table3 = "solivechat_session";
		$table4 = "solivechat_text";

		$wpdb->query("DROP TABLE IF EXISTS $table1");
		$wpdb->query("DROP TABLE IF EXISTS $table2");
		$wpdb->query("DROP TABLE IF EXISTS $table3");
		$wpdb->query("DROP TABLE IF EXISTS $table4");

}
register_deactivation_hook( __FILE__, 'solivechatpluginUninstall' );

//-- Install to Database Hooks
include('functions.php');
register_activation_hook( __FILE__, 'solivechat_install' );
register_activation_hook( __FILE__, 'solivechat_installtwo' );
register_activation_hook( __FILE__, 'solivechat_installthree' );
register_activation_hook( __FILE__, 'solivechat_installfour' );
register_activation_hook( __FILE__, 'solivechat_installfive' );
register_activation_hook( __FILE__, 'solivechat_installsix' );
register_activation_hook( __FILE__, 'solivechat_installseven' );
register_activation_hook( __FILE__, 'solivechat_install_dataone' );
register_activation_hook( __FILE__, 'solivechat_install_datatwo' );



if (!defined('ABSPATH')) die('-1');

?>