CREATE TABLE IF NOT EXISTS {prefix}sites (
id int(11) NOT NULL,
  url varchar(100) CHARACTER SET utf8 NOT NULL,
  updated timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  score int(11) NOT NULL,
  pageSpeed int(11) NOT NULL,
  bounceRate int(11) NOT NULL,
  domainAuthority int(11) NOT NULL,
  metaTitle varchar(200) CHARACTER SET utf8 NOT NULL,
  metaDescription varchar(350) CHARACTER SET utf8 NOT NULL,
  metaKeywords varchar(350) CHARACTER SET utf8 NOT NULL,
  robots tinyint(1) NOT NULL DEFAULT '0',
  sitemap tinyint(1) NOT NULL DEFAULT '0',
  domainCreated datetime NOT NULL,
  domainCompany varchar(100) CHARACTER SET utf8 NOT NULL,
  uniqueVisitsDaily int(11) NOT NULL,
  pagesViewsDaily int(11) NOT NULL,
  IncomeDaily int(11) NOT NULL,
  googleIndex int(11) NOT NULL,
  yahooIndex int(11) NOT NULL,
  bingIndex int(11) NOT NULL,
  alexaLocal int(11) NOT NULL,
  alexaLocalCountry varchar(20) NOT NULL,
  alexaGlobal int(11) NOT NULL,
  registered datetime NOT NULL,
  worth int(11) NOT NULL,
  w3c int(11) NOT NULL,
  metaH1 int(11) NOT NULL,
  metaH2 int(11) NOT NULL,
  metaH3 int(11) NOT NULL,
  metaH4 int(11) NOT NULL,
  headers text CHARACTER SET utf8 NOT NULL,
  body MEDIUMTEXT CHARACTER SET utf8 NOT NULL,
  https tinyint(1) NOT NULL DEFAULT '0',
  google_safe tinyint(1) NOT NULL DEFAULT '0',
  favicon varchar(250) CHARACTER SET utf8 NOT NULL,
  links TEXT CHARACTER SET utf8 NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE {prefix}sites ADD PRIMARY KEY (id), ADD UNIQUE KEY url (url(25));
ALTER TABLE {prefix}sites MODIFY id int(11) NOT NULL AUTO_INCREMENT;
CREATE TABLE IF NOT EXISTS {prefix}technologies (
  url varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  icon varchar(100) NOT NULL,
  tag1 varchar(100) NOT NULL,
  tag2 varchar(100) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE {prefix}technologies ADD UNIQUE KEY url (url,`name`);
CREATE TABLE IF NOT EXISTS {prefix}bookmarks (
  idsite int(11) NOT NULL,
  iduser int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE {prefix}bookmarks ADD UNIQUE KEY idsite (idsite,iduser);
ALTER TABLE `{prefix}bookmarks` ADD `created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP AFTER `idsite`;
CREATE TABLE IF NOT EXISTS `{prefix}pages` (
`idpage` int(11) NOT NULL,
  `title` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `text` text NOT NULL,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE `{prefix}pages` ADD PRIMARY KEY (`idpage`);
ALTER TABLE `{prefix}pages` MODIFY `idpage` int(11) NOT NULL AUTO_INCREMENT;
INSERT IGNORE INTO `{prefix}settings` VALUES('update_inverval', '3', 'Update Stats Interval (Days)', 'For guest', 'numeric', '', '', '', 'website', 3);
INSERT IGNORE INTO `{prefix}settings` VALUES('update_inverval_registered', '0', 'Update Stats Interval (Days)', 'For registered users', 'numeric', '', '', '', 'website', 3);