<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pages_Manage extends CI_Controller {
	
	public function index(){
		
		if(!$this->session->userdata('is_admin_login')){
			redirect(base_url().'admin');
			exit;
		}
		
		$result = $this->contact_model->getAllPageContent();
			
		$data['title'] = SITE_NAME.': CMS';
		$data['msg'] = '';
		$data['result'] = $result;
		$this->load->view('admin/manage_cms', $data);
		return;
		
	}	
	
	public function edit($id){
		
		if(!$this->session->userdata('is_admin_login')){
			redirect(base_url().'admin');
			exit;
		}
		
		if(!$id){
			redirect(base_url().'admin/pages_manage');
			exit;
		}
		
		$content = $this->contact_model->getPageContent($id);
			
		$data['title'] = SITE_NAME.': CMS';
		$data['msg'] = '';
		$data['cms_id'] = $id;
		$data['content'] = $content->content;
		$this->load->view('admin/edit_cms_view', $data);
		return;
		
	}
	
	
	public function update_cms($id) {
		
		if(!$id){
			redirect(base_url().'admin/pages_manage');
			exit;
		}
		
		$contact_array = array(
								'content' => addslashes($this->input->post('editor1')),
		);
		
		$this->contact_model->update_content($id,$contact_array);
		$this->session->set_flashdata('msg', 'Content Updated Successfully.');
		redirect(base_url()."admin/pages_manage/edit/".$id);
	}
	
}
