<?php
if( !extension_loaded('mcrypt') ) {
	die( 'PHP Mcrypt extension not installed. Please install php5-mcrypt with apt.' );
}
	
require_once '../inc/cls/c.check.php';
$check = new check();
$params = $check->go();	

$data = $params[1];
$params = $params[0];

$html = file_get_contents('checkhtml.html');
preg_match_all( '/[0-9]+\s+{\n([\S+\n\r\s]+)\n}/U', $html, $match );

?>
<!DOCTYPE html>
<html>
<head>
	<title>Crypty Installation</title>
	
	<meta charset="UTF-8" />
	
	<link rel="stylesheet" type="text/css" href="../css/style.css" />
	<link href="https://fonts.googleapis.com/css?family=Montserrat:400,700" rel="stylesheet" type="text/css">
	<link href='https://fonts.googleapis.com/css?family=Lato:300,100' rel='stylesheet' type='text/css'>
	<link rel="stylesheet" type="text/css" href="../css/ionicons.css" />
	<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/font-hack/2.015/css/hack.min.css" />
	
</head>
<body>
	
	<div class="body">
		
		<div class="firstaid">
		<div class="wcol">
		<div class="w10 icon">
			<i class="ion ion-help-buoy"></i>
		</div>
		<div class="w65">
			<div class="content">Request free help from our First Aid support</div>
		</div>
		<div class="w25">
			<a href="http://support.cudevo.com/firstaid/crypty"><button>Get support</button></a>
		</div>
		</div>
		
		
	</div>
		
	<div class="process">
		<ul class="process__status wcol">
			<li class="step"><i class="ion-clipboard"></i><br>Introduction</li>
			<li class="step active"><i class="ion-clipboard"></i><br>Validation<br>Results</li>
			<li class="step"><i class="ion-checkmark-round"></i><br>Finished</li>
		</ul>
	</div>
	
	<h2><i class="ion-archive"></i> Crypty 2 Installation</h2>
	
	<div class="panel">
		
		<h2 style="text-align: left;"><span class="typo__red">Cudevo</span>Hosting <small>Reliable, fast, personal and effective</small></h2>
		
		<div class="wcol">
			<div class="w25">
				<h1><i class="ion-sad typo__red"></i> <span class="">Siiiggh!</span></h1><br>
				<div class="typo__center pdr20">
				<a href="http://cudevo.com/managed/crypty"><button class="btn btn-buy"><i class="ion-search"></i> Have a look<br><small style="font-size: 9px;">wihtout any engagement</small></button></a></div>
			</div>
			<div class="w75">
				Too many unmet requirements? Don't despair! Try our <strong class="typo__red">managed hosting</strong>! We'll set up everything for you and you only have to lean back. No unmet requirements, no nerdy stuff! Have a look at our website and see what cool things we got to offer!<br>
				<br>
				<small>No minimum contract duration, no additional fees, no hidden clauses, no cancelation periods.<br>
				We'll transfer all your sites to us for free! Various worldwide locations available.<br><strong>Highspeed webhosting on SSD cloudservers with nginx</strong></small>
			</div>
		</div>
		<br>
		<div class="seperator"></div><br>
		
		We have succefully checked your config. Please check and fix all requirements which are not met. For security reasons it's very important that everything is arranged correctly, that's why the script won't work until you fixed everything bellow. If you have no idea what these things mean, please contact your webhoster and send them a screenshot of this page.<br><br>
		<table>
			<tr>
				<td>Condition</td>
				<td>Solution</td>
			</tr>
			<?php
			if( !in_array(false, $params) ) {
				echo '<tr>';
				echo '<td><i class="typo__green ion-checkmark-circled"></i> Congrats! Everything' . "'" . 's okay!</td>';
				echo '<td></td>';
				echo '</tr>';
			}
				
			foreach( $params as $key => $param ) {
				
				if( !$param ):
				
				$matchhtml = $match[1][$key];
				
				preg_match('/\s+desc\s+{\n([\S+\n\r\s]+)\n\s+}/U', $matchhtml, $descm );
				preg_match('/\s+ok\s+{\n([\S+\n\r\s]+)\n\s+}/U', $matchhtml, $succm );
				preg_match('/\s+install\s+{\n([\S+\n\r\s]+)\n\s+}/U', $matchhtml, $instm );
				preg_match('/\s+fail\s+{\n([\S+\n\r\s]+)\n\s+}/U', $matchhtml, $eerrm );
				
				$c0 = preg_match_all( '/\$(.*)\$/U', $descm[1], $descmm, PREG_SET_ORDER );
				$c1 = preg_match_all( '/\$(.*)\$/U', $instm[1], $instmm, PREG_SET_ORDER );
				
				if($c0>0):
				foreach( $descmm as $dd ) {
					$descm[1] = str_replace($dd[0],$data[$key][$dd[1]],$descm[1]);
				}
				endif;
				
				if($c1>0):
				foreach( $instmm as $dd ) {
					$instm[1] = str_replace($dd[0],$data[$key][$dd[1]],$instm[1]);
				}
				endif;
				
				echo '<tr>';
				echo '<td><i class="typo__red ion-close-circled"></i> ' . $descm[1] . '</td>';
				echo '<td>' . $instm[1] . '</td>';
				echo '</tr>';
				
				endif;
				
			}	
			?>
		</table>
		<br>
		<?php
			$exc = $check->getexc();
			
			foreach( $exc as $key => $k )
				unset( $params[$k] );
				
			if( !in_array(false, $params) ) {
				echo '<a href="finish.php"><button class="btn btn-primary"><i class="ion-checkmark-circled"></i> Finish setup</button></a>';
			} else {
				echo 'You are not able to complete the setup unless all requirements are met.<br><button class="btn btn-primary" onclick="javascript:location.reload();">Recheck</button>';
			}
		?>
		
	</div>
	</div>