<?php
require_once '../inc/cls/c.random.php';
require_once '../inc/cls/c.check.php';

$check = new check(false);
$random = new random();

if( !extension_loaded('mcrypt') ) {
	die( 'PHP Mcrypt extension not installed. Please install php5-mcrypt with apt.' );
}
	
$cipher_list = mcrypt_list_algorithms();
$cipher_select = null;

foreach( $cipher_list as $key => $cipher ) {
	if(@mcrypt_module_open( $cipher, 'ctr' )!==false) {
		$cipher_select .= '<option ';
		$cipher_select .= (!in_array('serpent', $cipher_list)&&$cipher=='rijandel-256' ? 'selected' : '');
		$cipher_select .= ($cipher=='serpent' ? 'selected' : '');
		$cipher_select .= ' value="'.$key.'">' . $cipher . '</option>';
	}
}	

$modes_list = mcrypt_list_modes();
$mode_select = null;

foreach( $modes_list as $key => $mode ) {
	if( $mode!=='stream' ) {
		$mode_select .= '<option ';
		$mode_select .= (!in_array('cbc', $modes_list)&&$mode=='cbc' ? 'selected' : '');
		$mode_select .= ($mode=='ctr' ? 'selected' : '');
		$mode_select .= ' value="'.$mode.'">' . strtoupper($mode) . '</option>';
	}
}
?>
<!DOCTYPE html>
<html>
<head>
	<title>Crypty Installation</title>
	
	<meta charset="UTF-8" />
	
	<link rel="stylesheet" type="text/css" href="../css/style.css" />
	<link href="https://fonts.googleapis.com/css?family=Montserrat:400,700" rel="stylesheet" type="text/css">
	<link href='https://fonts.googleapis.com/css?family=Lato:300,100' rel='stylesheet' type='text/css'>
	<link rel="stylesheet" type="text/css" href="../css/ionicons.css" />
	<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/font-hack/2.015/css/hack.min.css" />
	
</head>
<body>
	
	<div class="body">
		
		<div class="firstaid">
		<div class="wcol">
		<div class="w10 icon">
			<i class="ion ion-help-buoy"></i>
		</div>
		<div class="w65">
			<div class="content">Request free help from our First Aid support</div>
		</div>
		<div class="w25">
			<a href="http://support.cudevo.com/firstaid/crypty"><button>Get support</button></a>
		</div>
		</div>
		
		
	</div>
		
	<div class="process">
		<ul class="process__status wcol">
			<li class="step"><i class="ion-clipboard"></i><br>Introduction</li>
			<li class="step active"><i class="ion-wrench"></i><br>Configuration</li>
			<li class="step"><i class="ion-checkmark-round"></i><br>Finished</li>
		</ul>
	</div>
	
	<h2><i class="ion-archive"></i> Crypty 2 Installation</h2>
	
	<div class="panel">
		
		<h2 style="text-align: left;"><span class="typo__red">Cudevo</span>Hosting <small>Reliable, fast, personal and effective</small></h2>
		<form method="post" action="configgen.php">
		<div class="wcol">
			<div class="w25">
				<h1><i class="ion-sad typo__red"></i> <span class="">Siiiggh!</span></h1><br>
				<div class="typo__center pdr20">
				<a href="http://cudevo.com/managed/crypty"><button class="btn btn-buy"><i class="ion-search"></i> Have a look<br><small style="font-size: 9px;">wihtout any engagement</small></button></a></div>
			</div>
			<div class="w75">
				That might be your reaction when having a look at all those options and things no one actually understands. But why don't you try out our <strong class="typo__red">managed hosting</strong>? We'll set up everything for you and you only have to lean back. Have a look at our website and see what cool things we got to offer!<br>
				<br>
				<small>No minimum contract duration, no additional fees, no hidden clauses, no cancelation periods.<br>
				We'll transfer all your sites to us for free! Various worldwide locations available.<br><strong>Highspeed webhosting on SSD cloudservers with nginx</strong></small>
			</div>
		</div>
		<br>
		<div class="seperator"></div>
		
		Now we'll configure everything. Usually all automatically provided setting details are correct and you don't need to change anything. So if you think everything's okay just hit the "Continue" button!
		
		<br><br><br>
		
		<h2 class="typo__left">General settings</h2>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>SITE TITLE</strong><br><span class="smaller">The title of your site as it will appear in the title tag, maybe something like MyWebsite Crypty. Choose whatever you want</span></small><br>
				<input type="text"  name="opt[25]" />
			</div>
			<div class="w50 pdl10">
				<small><strong>FALLBACK LANGUAGE</strong><br><span class="smaller">The language which should be used if none of the user selected languages are available. (ISO 3166-2 Code)</span></small><br>
				<input type="text" maxlength="2" name="opt[0]"  value="EN" />
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>DATE FORMAT</strong><br><span class="smaller">Your preferred date format. Please have a look at the documentation if you don't know what to enter here.</span></small><br>
				<input type="text" name="opt[1]"  value="m/d/Y" />
			</div>
			<div class="w50 pdl10">
				<small><strong>TIME FORMAT</strong><br><span class="smaller">Your preferred time format. Please have a look at the documentation if you don't know what to enter here.</span></small><br>
				<input type="text" name="opt[2]"  value="H.i" />
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>UPLOAD LIMIT</strong><br><span class="smaller">The maximum allowed size of uploaded files in bytes.<br>To get your desired value in bytes please use a converter such as <a href="http://www.matisse.net/bitcalc/">Bit Calculator</a></span></small><br>
				<input type="text" name="opt[3]"  value="<?= ($check->uploadsize());?>" />
			</div>
		</div>
		<br>
		<button class="btn btn-primary"><i class="ion-checkmark-circled"></i> Save and continue</button>
		
		<br><br>
		
		<h2 class="typo__left">Advanced settings<br><small>Please leave these settings as they are if you are not sure what exactly you need to enter here.</small></h2>
		
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>SITE LOCATION</strong><br><span class="smaller">The root location of your script (not the /install directory!).</span></small><br>
				<input name="opt[4]" type="text"  value="<?= str_replace('install/step1.php', '', $_SERVER["SCRIPT_FILENAME"]);?>" />
			</div>
			<div class="w50 pdl10">
				<small><strong>PROTOCOL</strong><br><span class="smaller">Your sites hyptertexttransfer protocol (either http:// or https://)</span></small><br>
				<input name="opt[5]" type="text"  value="<?= (isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https://' : 'http://');?>" />
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>SITE DOMAIN</strong><br><span class="smaller">Your sites domain (do not include the /install directory or the protocol!)</span></small><br>
				<input type="text" name="opt[6]" value="<?= $_SERVER['HTTP_HOST'];?>" />
			</div>
			<div class="w50 pdl10">
				<small><strong>FILE SUFFIX</strong><br><span class="smaller">The file suffix of your encrypted files (any string you want, shouldn't be that long)</span></small><br>
				<input type="text" name="opt[7]" value=".cry" />
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>SESSION EXPIRE</strong><br><span class="smaller">TTL of user sessions in seconds. (recommend value about 1800 seconds, hyper-secure sites should choose lower values)</span></small><br>
				<input type="text" name="opt[8]" value="1800" />
			</div>
			<div class="w50 pdl10">
				<small><strong>SESSION FILE EXPIRE</strong><br><span class="smaller">TTL of uploaded files awaiting encryption in seconds. (recommend value about 1800 seconds, hyper-secure sites should choose lower values)</span></small><br>
				<input type="text" name="opt[9]"  value="1800" />
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>ENCRYPTION FILES EXPIRE</strong><br><span class="smaller">TTL of encrypted files awaiting download in seconds. (recommend value about 1800 seconds, hyper-secure sites should choose lower values)</span></small><br>
				<input type="text" name="opt[10]" value="1800" />
			</div>
			<div class="w50 pdl10">
				<small><strong>DECRYPTION FILES EXPIRE</strong><br><span class="smaller">TTL of decrypted files awaiting download in seconds. (recommend value about 900 seconds, hyper-secure sites should choose lower values)</span></small><br>
				<input type="text" name="opt[11]" value="900" />
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>SESSION FILES PATH</strong><br><span class="smaller">The directory the cached files should be saved to. Please make sure that the directory exists and is writeable.</span></small><br>
				<input type="text" name="opt[12]" value="sess/" />
			</div>
			<div class="w50 pdl10">
				<small><strong>DECRYPTED FILES PATH</strong><br><span class="smaller">The directory the encrypted files should be saved to. Please make sure that the directory exists, contains the expires.json file and is writeable.</span></small><br>
				<input type="text" name="opt[13]" value="edwn/" />
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>DECRYPTED FILES PATH</strong><br><span class="smaller">The directory the decrypted files should be saved to. Please make sure that the directory exists, contains the expires.json file and is writeable.</span></small><br>
				<input type="text" name="opt[14]" value="ddwn/" />
			</div>
			<div class="w50 pdl10">
				<small><strong>MCRYPT DEFAULT ENCRYPTION MODE</strong><br><span class="smaller">The default encryption method which should be used if none of the user selected methods are available.</span></small><br>
				<select name="opt[22]"><?= $mode_select;?></select>
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>EXPRESS CIPHER</strong><br><span class="smaller">The cipher which should be used for express encrypting</span></small><br>
				<select name="opt[15]"><?= $cipher_select;?></select>
			</div>
			<div class="w50 pdl10">
				<small><strong>EXPRESS ENCRYPTION MODE</strong><br><span class="smaller">The encryption mode which should be used for express encrypting</span></small><br>
				<select name="opt[16]"><?= $mode_select;?></select>
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>CHECK CIPHER</strong></small><br>
				<select name="opt[17]"><?= $cipher_select;?></select>
			</div>
			<div class="w50 pdl10">
				<small><strong>CHECK ENCRYPTION MODE</strong></small><br>
				<select name="opt[18]"><?= $mode_select;?></select>
			</div>
		</div><br>
		
		<div class="wcol">
			<div class="w50 pdr10">
				<small><strong>SERVER CIPHER</strong></small><br>
				<select name="opt[19]"><?= $cipher_select;?></select>
			</div>
			<div class="w50 pdl10">
				<small><strong>SERVER ENCRYPTION MODE</strong></small><br>
				<select name="opt[20]"><?= $mode_select;?></select>
			</div>
		</div><br>
		
		<button type="submit" class="btn btn-primary"><i class="ion-checkmark-circled"></i> Save and continue</button>
		</form>
		
	</div>
	</div>