<?php
class hfilesubmit {
	
	private $mc;
	public function __construct() {
		
		require_once SCRIPT_PATH . 'inc/cls/c.random.php';
		
		require_once SCRIPT_PATH . 'inc/h/h-metasubmit.php';
		require_once SCRIPT_PATH . 'inc/h/h-fileencrypt.php';
		require_once SCRIPT_PATH . 'inc/cls/c.tools.php';
		
		$this->to = new tools();
		$this->ms = new hmetasubmit();
		$this->rn = new random();
		$this->hf = new hfileencrypt();
		
	}
	
	public function __conduct( $post, $files, $api=false, $expire=ENCR_FILE_EXPIRE ) {
		
		global $__pagenames;
		
		foreach( $files as $file ) {
			if( $file['size']>SCRIPT_UPLOAD_LIMIT ):
			
				if( !$api ) {
					$_SESSION['process']['error'] = 1;
					header( 'location: ' .SCRIPT_RELPATH. '/?p=' . $__pagenames[ 0 ] );
				} else {
					return false;
				}
				
				exit();
			endif;
		}
		
		if( $expire==null )
			$expire = ENCR_FILE_EXPIRE;
		
		do {
			$session_id = $this->rn->gen(64);
		} while( is_dir( SESSION_DIR . $session_id ) );
		
		mkdir( SESSION_DIR . $session_id );
		
		file_put_contents( SESSION_DIR . $session_id . '/meta.json', json_encode($files) );
		file_put_contents( SESSION_DIR . $session_id . '/index.html', '' );
		
		$expires = (array) json_decode(file_get_contents(SCRIPT_PATH . 'expire.json'));
		array_push( $expires, array('key'=>$session_id, 'expires' => time() + SESSION_EXPIRE) );
		
		file_put_contents( SCRIPT_PATH . 'expire.json', json_encode($expires) );
		
		foreach( $files as $key => $file ) {
			
			if( is_writable(SCRIPT_PATH . 'stats.json') ):
			$stats = json_decode(file_get_contents( SCRIPT_PATH . 'stats.json' ), true);
			$stats['files'] += 1;
			$stats['filessize'] += $file['size'];
			file_put_contents(SCRIPT_PATH . 'stats.json', json_encode( $stats ));
			endif;
			
			if($api===false) {
			move_uploaded_file( $file['tmp_name'], SESSION_DIR . $session_id . '/' . $key );
			} else {
			copy( $file['tmp_name'], SESSION_DIR . $session_id . '/' . $key );
			}
		}
	
		if(!$api)
		$_SESSION['session'][ 'key' ] = $session_id;
		
		if( $post['type']=='express' ) {
			
			$cipher = mcrypt_list_algorithms();
			$kkey = $this->rn->gen( mcrypt_get_key_size( $cipher[EXPRESS_DEFAULT_CIPHER], EXPRESS_DEFAULT_MODE ) );
			
			$data = array( 'cipher' => EXPRESS_DEFAULT_CIPHER, 'key' => $kkey, 'mode' => EXPRESS_DEFAULT_MODE );
			
			$filekey = $this->hf->__conduct( $session_id, $data, $expire );
			
			if( !$api ) {
				$_SESSION['download']['ticket'] = $filekey;
			}
			
			if( $api )
				return array( 'key' => $kkey, 'expire' => time() + $expire, 'downloadid' => $filekey );
			
			$_SESSION['process']['name'] = $filekey. FILE_SUFFIX;
			$_SESSION['process']['step'] = 2;
			$_SESSION['process']['key'] = $kkey;
			$_SESSION['process']['size'] = $this->to->humansize(filesize( ENCR_PATH . $filekey . FILE_SUFFIX ));
			$_SESSION['process']['downloadlink'] = SCRIPT_PROTOCOL . SCRIPT_URL . SCRIPT_RELPATH . '/download.php?id=' . $filekey;
			$_SESSION['process']['downloadexpire'] = date( TIME_FORMAT_HOURS, time() + $expire);
			
			header( 'location: ' .SCRIPT_RELPATH. '/?p=' . $__pagenames[2]);
			
		} else {
			
			$_SESSION['process']['step'] = 1;
			$_SESSION['process']['expiretime'] = date( TIME_FORMAT_HOURS, time() + SESSION_EXPIRE);
			
			if( !$api ) {
			header( 'location: ' .SCRIPT_RELPATH. '/?p=' . $__pagenames[ 1 ] );
			} else {
			return $session_id;
			}
			
		}
		
	}
	
}	
?>