<?php
class hfileencrypt {
	
	private $mc;
	public function __construct() {
		
		require_once SCRIPT_PATH . 'inc/cls/c.mcrypt.php';
		require_once SCRIPT_PATH . 'inc/cls/c.random.php';
		require_once SCRIPT_PATH . 'inc/cls/c.file.php';
		require_once SCRIPT_PATH . 'inc/cls/c.tools.php';
		
		$this->to = new tools();
		$this->fi = new file();
		$this->rn = new random();
		$this->mc = new mcrypt();
		
	}
	
	public function __conduct( $session, $data, $expire ) {
		
		$session_path = SESSION_DIR . $session . '/';
		$files = json_decode(file_get_contents( $session_path . 'meta.json' ), true);
		
		$farr = array();
		$finfo = finfo_open(FILEINFO_MIME_TYPE);
		
		foreach( $files as $key => $file ) {
			
			$filedir = $session_path . $key;
			
			$iv = ( isset($data['iv']) ? $data['iv'] : null );
			
			$hash = hash_file( 'sha256', $filedir );
			$farr[$key]['value'] = $this->mc->encrypt( file_get_contents( $filedir), $data['key'], $data['cipher'], $iv, $data['mode'] );
			$farr[$key]['meta']['name'] = $file['name'];
			$farr[$key]['meta']['key'] = $this->mc->encrypt(base64_encode('OK') , $data['key'], CHECK_CIPHER, CHECK_MODE );
			$farr[$key]['meta']['hash'] = $hash;
			$farr[$key]['meta']['cipher'] = $data['cipher'];
			$farr[$key]['meta']['filectime'] = filectime( $filedir );
			$farr[$key]['meta']['mime'] = finfo_file( $finfo, $filedir );
			$farr[$key]['meta']['size'] = $file['size'];
			$farr[$key]['meta']['mode'] = (isset($data['mode']) ? $data['mode'] : MCR_DEFAULT_MODE );
			
			
		}
		
		do {
			$filekey = $this->rn->gen(32);
			$filename = $filekey . FILE_SUFFIX;
		} while( file_exists( $filename ) );
		
		$_SESSION['session']['type'] = 1;
		$_SESSION['download']['type'] = 0;
		$_SESSION['download']['ticket'] = $filekey;
		
		file_put_contents( ENCR_PATH . $filename, $this->fi->create( $farr ) );
		
		$jexpire = json_decode( file_get_contents( ENCR_PATH . 'expire.json' ), true );
		$jexpire[$filekey.FILE_SUFFIX] = time() + $expire;
		file_put_contents( ENCR_PATH . 'expire.json', json_encode($jexpire) );
		
		$this->to->deldir($session_path);
		
		return $filekey;
		
	}
	
}	
?>