<?php
class tools {
	
	public function deldir( $dir ) {
		
		$files = array_diff( scandir($dir), array('.','..') );
		foreach( $files as $file ) {
			(is_dir("$dir/$file")) ? $this->deldir("$dir/$file") : unlink("$dir/$file"); 
		} 
		
		rmdir($dir);
		
	}
	
	public function getinputvalilist() {
		
		$data = array();
		
		$ciphers = mcrypt_list_algorithms();
		$modes = mcrypt_list_modes();
		
		$modes_exclude = unserialize(SCRIPT_MODE_EXCLUDE);
		$cipher_exclude = unserialize(SCRIPT_CIPHER_EXCLUDE);
		
		foreach( $ciphers as $ckey => $cipher ) {
				
			foreach( $modes as $cmode ) {
				
				if( !in_array( $cmode, $modes_exclude )&&!in_array( $cipher, $cipher_exclude ) ):
				$data[$ckey][$cmode]['iv']  = mcrypt_get_iv_size( $cipher, $cmode );
				$data[$ckey][$cmode]['key'] = mcrypt_get_key_size( $cipher, $cmode );
				endif;
				
			}
			
		}
		
		return $data;
		
	}
	
	public function humansize( $bytes ) {
		
		if( $bytes < 1024 ) {
			return $bytes . ' Bytes';
		} else if( $bytes < 1048576 ) {
			return round( $bytes/1024, 2 ) . ' KB';
		} else if( $bytes < 1073741824 ) {
			return round( $bytes/1048576, 2 ) . ' MB';
		} else if( $bytes < 1099511627776 ) {
			return round( $bytes/1073741824, 2 ) . ' GB';
		} else {
			return 'Too large';
		}
		
	}
	
}
?>