<?php
class template {
	
	static $html, $sto;
	private $ln;
	public function __construct() {
		
		require_once SCRIPT_PATH . 'inc/cls/c.language.php';
		
		$this->ln = new language();
		
		self::$sto = array();
	}
	
	public function load( $tmpl, $type='html' ) {
		
		global $__options;
		
		$dir = PHP_TEMPLATE_DIR . $tmpl . '.html';
		
		if( file_exists($dir) ):
		$html = file_get_contents( $dir );
		self::$html = $html;
		else:
		$this->load( '404' );
		endif;
		
	}
	
	public function getoption($key) {
		
		return ( isset(self::$sto[$key]) ? self::$sto[$key] : false );
		
	}
	
	public function process_meta( $type='html' ) {
		
		
		
	}
	
	public function process_raw( $html, $type='html' ) {
		
		global $__vars;
		global $__loop;
		global $__lang;
		global $__options;
		global $__cond;
		global $__args;
		
		$tags = array();
		
		$tags[0] = preg_match_all( '/:=(.*)=:/U', $html, $match0, PREG_SET_ORDER );
		$tags[1] = preg_match_all( '/:\?(.*)\?:/U', $html, $match1, PREG_SET_ORDER );
		$tags[2] = preg_match_all( '/:&(.*)&:/U', $html, $match2, PREG_SET_ORDER );
		$tags[3] = preg_match_all( '/:%(.*)%:/U', $html, $match3, PREG_SET_ORDER );
		$tags[4] = preg_match_all( '/:\$(.*)\$:/U', $html, $match4, PREG_SET_ORDER );
		$tags[5] = preg_match_all( '/if\s?+\(\s?+\$(.*)\s?+\)\s?+\{\n([\S+\n\r\s]+)\n}/U', $html, $match5, PREG_SET_ORDER );
		$tags[6] = preg_match_all( '/:§([0-9]*)§:/U', $html, $match6, PREG_SET_ORDER );
		$tags[7] = preg_match_all( '/pattern\[(.*)\]\s?+{\n([\S+\n\r\s]+)\n}/U', $html, $match7, PREG_SET_ORDER );
		
		foreach( $match4 as $tag ) {
			if( file_exists( SCRIPT_PATH . 'inc/php/' . $tag[1] ) ) {
				ob_start();
				require_once  SCRIPT_PATH . 'inc/php/' . $tag[1];
				$output = ob_get_contents();
				ob_end_clean();
				
				$output = $this->process_raw( $output );
				$html = str_replace( $tag[0], $output, $html );
			}
			
		}
		
		$i = 0;
		foreach( $tags as $tag ) {
			if( $tag==0 )
				$i++;
			if( $i==count($tags) )
				return $html;
		}
		
		foreach( $match5 as $tag ) {
			
			if( $__cond[$tag[1]] ) {
				$html = str_replace( $tag[0], $this->process_raw($tag[2]), $html );
			} else {
				$html = str_replace( $tag[0], null, $html );
			}
			
		}
		
		foreach( $match0 as $tag ) {
			if( file_exists( PHP_TEMPLATE_DIR . '/' . $tag[1] . '.html' ) )
			$html = str_replace( $tag[0], $this->process_raw(file_get_contents( PHP_TEMPLATE_DIR . '/' . $tag[1] . '.html' )), $html );	
		}
				
		foreach( $match2 as $tag ) {
			$ov=$__options[$tag[1]];
			if( $ov!=false )
			$html = ( str_replace( $tag[0], $ov, $html ) );
		}
		
		foreach ($match3 as $tag ) {
			$ph = $this->ln->getphrase( $__lang, $this->process_raw($tag[1]) );
			$ph = (strlen($ph)<1 ? null : $ph );
			$html = str_replace($tag[0], $ph, $html);
		}
		
		foreach( $match7 as $tag ) {
			
			$pattern_id = $tag[1];
			
			$tag_pattern = $this->process_raw($tag[2]);
			$tag_content = null;
			
			if( is_array($__loop[$pattern_id]) ) {
			foreach( $__loop[$pattern_id] as $key => $con ) {
				
				$tmp_content = $tag_pattern;
				$tag71 = preg_match_all( '/:#(.*)#:/U', $tag_pattern, $match71, PREG_SET_ORDER );
				
				foreach( $match71 as $tag71 ) {
					if( isset($con[$tag71[1]]) )
					$tmp_content = str_replace( $tag71[0], $con[$tag71[1]], $tmp_content );
				}
				
				$tag_content .= $this->process_raw($tmp_content);
				
			}
			} else {
			$tag_content = null;
			}
			
			$html = str_replace( $tag[0], $tag_content, $html );
			
		} 
		
		foreach( $match6 as $tag ) {
			
			if( isset($__args[$tag[1]]) ):
			$html = str_replace( $tag[0], $__args[$tag[1]], $html );
			else:
			$html = str_replace( $tag[0], null, $html );
			endif;
			
		}
		
		foreach( $match1 as $tag ) {
			if( isset($__vars[$tag[1]]) ) {
				$html = $this->process_raw(str_replace( $tag[0], $__vars[$tag[1]], $html ));
			} else {
				$html = str_replace( $tag[0], null, $html );
			}
		}
		
		return $html;
		
	}
	
	public function process( $type='html', $echo=true ) {
		
		$this->process_meta( $type );
		self::$html = $this->process_raw( self::$html, $type );
		
		if( $echo ):
		echo self::$html;
		else:
		return self::$html;
		endif;
		
	}
	
}

class template_tools {
	
	public function buildtable( $table_class, $data, $thead=null, $tdclass=null, $trclass=null ) {
		
		$html = '<table class="'.$table_class.'">';
		
		if( $thead!=null ) {
			$html .= '<thead>';
			foreach( $thead as $th ) {
				$html .= '<th>' . $th . '</th>';
			}
			$html .= '</thead>';
		}
		
		foreach( $data as $dat ) {
			$html .= '<tr';
			$html .= ( $trclass==null ? '>' : ' class="'.$trclass.'">' );
			foreach( $dat as $da ) {
				$html .= '<td';
				$html .= ( $tdclass==null ? '>' : ' class="'.$tdclass.'">' );
				$html .= $da;
				$html .= '</td>';
			}
			$html .= '</tr>';
		}
		
		$html .= '</table>';
		return $html;
		
	}
	
}