<?php
class mcrypt {
	
	static $ciphers, $modes;
	public function __construct() {
		
		self::$ciphers = mcrypt_list_algorithms();
		self::$modes = mcrypt_list_modes();
		
	}
	
	static function encrypt( $text, $key, $algo, $iv=null, $mode=null, $base64=true ) {
		
		$mode = ( in_array(strtolower($mode), self::$modes) ? $mode : MCR_DEFAULT_MODE );
		$algo = ( isset(self::$ciphers[$algo]) ? $algo : EXPRESS_DEFAULT_CIPHER );
		
		$mc = mcrypt_module_open( self::$ciphers[$algo], '', $mode, '' );
		
		$keys = mcrypt_enc_get_key_size($mc);
		$ivs = mcrypt_enc_get_iv_size($mc);
		
		$key = ( strlen($key)>$keys ? substr($key,0,$keys) : $key );
		
		# Using MCRYPT_DEV_RANDOM is very slow on some systems, that's why need to fallback to MCRYPT_DEV_URANDOM
		$iv = ( strlen($iv)!==$ivs ? mcrypt_create_iv($ivs, MCRYPT_DEV_URANDOM) : $iv );
		
		mcrypt_generic_init( $mc, $key, $iv );
		$en = mcrypt_generic( $mc, $text );
		mcrypt_generic_deinit( $mc );
		
		return ( $base64 ? base64_encode($iv.$en) : $iv.$en );
		
	}
	
	static function decrypt( $text, $key, $algo, $mode=null, $base64=true ) {
		
		$algo = ( isset(self::$ciphers[$algo]) ? $algo : false );
		
		$mode = ( in_array(strtolower($mode), self::$modes) ? $mode : MCR_DEFAULT_MODE );
		
		$encrypted = ( $base64 ? base64_decode($text) : $text );
		$mc = mcrypt_module_open( self::$ciphers[$algo], '', $mode, '' );
		
		if( $algo===false||$mode===false )
			return false;
		
		$keys = mcrypt_enc_get_key_size( $mc );
		$key = ( strlen($key)>$keys ? substr($key,0,$keys) : $key );
		
		$ivsize = mcrypt_enc_get_iv_size($mc);
		$iv = substr($encrypted, 0, $ivsize);
		$encrypted = substr($encrypted, $ivsize);
		
		mcrypt_generic_init( $mc, $key, $iv );
		$de = mdecrypt_generic( $mc, $encrypted );
		mcrypt_generic_deinit( $mc );
		
		return $de;
		
	}
	
}