<?php
class language {
	
	static $lang;
	static $clg;
	
	public function __construct() {
		
		$this->loadall();
		$this->chooselanguage();
		
	}
	
	public function getphrase( $lang, $phrase ) {
		
		$lang = $_SESSION['lang'];
		
		return ( @isset( self::$lang[$lang]['phrases'][$phrase] ) ? @self::$lang[$lang]['phrases'][$phrase] : @self::$lang[self::$clg]['phrases'][$phrase] );
		
	}
	
	public function loadall() {
		
		$drn = PHP_LANGUAGE_DIR;
		$dir = opendir( $drn );
		
		while (false !== ($entry = readdir($dir))) {
        
        	if( $entry!='.'&&$entry!='..' ) {
        		$file = $drn . '/' . $entry;
        		$xml  = @simplexml_load_file( $file );
        		
        		if( $xml!=false ) {
        			$options = ( $this->xparse( $xml, array('options','meta','option') ) );
        			$phrases = ( $this->xparse( $xml, array('phrases','phrase','id') ) );
        			
        			self::$lang[$options['iso']]['options'] = $options;
        			self::$lang[$options['iso']]['phrases'] = $phrases;
        		}
       		}
        
    	}
    	
		
	}
	
	public function xparse( $xml, $arr ) {
		
		$val = (array) $xml->{$arr[0]};
		$val = $val[$arr[1]];
		
		$pxml = [];
		
		$i = 0;
		foreach( $xml->{$arr[0]}->{$arr[1]} as $key => $vl ) {
			
			$attr = (array) $vl->attributes();
			$prop = $attr['@attributes'][$arr[2]];
			
			if( !isset($prop) )
			return false;
			
			$pxml[$prop] = $val[$i];
			
			$i++;
			
		}
		
		return $pxml;
		
	}
	
	public function languageselector() {
		
		$this->chooselanguage();
		
		$html = null;
		foreach( self::$lang as $key => $lang ) {
			
			if( $lang['options']['iso']=='EN' )
				$lang['options']['iso'] = 'GB';
			
			unset($active);
			if( $key == self::$clg ) {
			$active = 'active';
			}
			
			if( $key != self::$clg ) {
			$html .= ' <a href="' . SCRIPT_RELPATH . '/?l=' .$key.'">';
			}
			
			$html .= '<img src="inc/img/' . strtolower($lang['options']['iso']) . '.png">';
			
			if( $key != self::$clg ) {
			$html .= '</a> ';
			}
			
			
		}
		
		
		return $html;
		
	}
	
	public function getlanguagelist() {
		
		return array_keys( self::$lang );
		
	}
	
	public function languageidexists( $id ) {
		
		return ( isset(self::$lang[$id]) ? true : false );
				
	}
	
	public function chooselanguage() {
		
		$langl = $this->getlanguagelist();
		
		$langc = null;
		
		if( $this->languageidexists( $_SESSION['lang'] ) ):
		$langc = $_SESSION['lang'];
	
		else:
		$langu = $this->negotiatelang();
		foreach( $langu as $val ):
		
			if( is_array($val) ):
				foreach( $val as $va ) {
					if( $this->languageidexists( $va ) ) {
						$langc = $va;
						break 2;
					}
				}
			else:
				if( $this->languageidexists( $val ) ) {
					$langc = $val;
					break;
				}
			endif;
			
		endforeach;
		endif;
		
		if( $langc == null ) {
		$langc = PHP_FALLBACK_LANG;
		}
		self::$clg = $langc;
		
	}
	
	public function negotiatelang() {
		
		$user_lang = $_SERVER['HTTP_ACCEPT_LANGUAGE'] . ',';
		
		preg_match_all( '/(.*?);q=(.*?),/', $user_lang, $rxl, PREG_SET_ORDER );
		
		$priority = [];
		
		foreach( $rxl as $rx ):
		
			$pr = $rx[2] * 100;
			
			if( strpos($rx[1], ',')>0 ) {
				$items = explode( ',', $rx[1] );
				
				$priority[$pr] = [];
				$priority[$pr] = $items;
			} else if( isset( $priority[$pr] ) ) {
				array_push( $priority[$pr], $rx[1] );
			} else {
				$priority[$pr] = $rx[1];
			}
		
		endforeach;
		
		rsort( $priority );
		
		return $priority;
		
	}
	
}
?>