<?php
class file {
	
	private $mc;
	public function __construct() {
		
		$this->globalmeta = array(
			'version' => CR_FILE_VERSION,
			'url' => SCRIPT_URL,
			'created' => time()
		);
		
		require_once SCRIPT_PATH . 'inc/cls/c.mcrypt.php';
		require_once SCRIPT_PATH . 'inc/cls/c.random.php';
		require_once SCRIPT_PATH . 'inc/cls/c.tools.php';
		
		$this->ra = new random();
		$this->mc = new mcrypt();
		$this->to = new tools();
		
	}
	
	public function create( $files ) {
		
		$xml = new SimpleXMLElement('<encrypted></encrypted>');
		$metaenc = $this->mc->encrypt( base64_encode(json_encode($this->globalmeta)), SERVER_KEY, SERVER_CIPHER );
		
		$filemeta = $xml->addChild( 'filemeta', $metaenc );
		
		foreach( $files as $key => $file ) {
			
			$fileroot = $xml->addChild( 'file' );
			
			$metaenc = $this->mc->encrypt( base64_encode(json_encode($file['meta'])), SERVER_KEY, SERVER_CIPHER );
			$fileinfo = $fileroot->addChild( 'meta', $metaenc );
			
			$fileroot->addChild( 'value', $file['value'] );
			
		}
		
		return $xml->asXML();
		
	}
	
	public function checkmeta( $filemeta ) {
		
		$version = explode( '/', $filemeta['version'] );
		$tversion = explode( '/', $this->globalmeta['version'] );
		
		return ( $version[1]==$tversion[1] ? true : false );
		
	}
	
	public function analyse( $file, $human=true ) {
		
		$xml = simplexml_load_file( $file );
		
		$rootmeta = ($this->mc->decrypt( $xml->filemeta, SERVER_KEY, SERVER_CIPHER, SERVER_MODE ));
		$rootmeta = json_decode(base64_decode($rootmeta),true);
		
		$meta = array();
		
		if( $this->checkmeta($rootmeta) ) {
			
			$i = 0;
			foreach( $xml->file as $key => $file ) {
				$filemeta = json_decode(base64_decode($this->mc->decrypt( $file->meta, SERVER_KEY, SERVER_CIPHER, SERVER_MODE )), true);
				$meta[$i] = $filemeta;
				
				if( !is_array($filemeta) )
					return false; 
				
				if($human) {
					$meta[$i]['size'] = $this->to->humansize( $meta[$i]['size'] );
					$meta[$i]['filectime'] = date( TIME_FORMAT_DATE . ' ' . TIME_FORMAT_HOURS, $meta[$i]['filectime'] );
					$meta[0]['filecreated'] = date( TIME_FORMAT_DATE . ' ' . TIME_FORMAT_HOURS, $rootmeta['created'] );
				}
				
				$i++;
			
			}
			
		}
		
		return $meta;
		
	}
	
	public function read( $file, $key, $expire=DECR_FILE_EXPIRE ) {
		
		$xml = simplexml_load_file( $file );
		
		$rootmeta = ($this->mc->decrypt( $xml->filemeta, SERVER_KEY, SERVER_CIPHER, SERVER_MODE ));
		$rootmeta = json_decode(base64_decode($rootmeta),true);
		
		if( $this->checkmeta($rootmeta) ) {
			
			$zip = new ZipArchive();
				
			do {
				$zipgen = $this->ra->gen(32);
				$filename = $zipgen . '.zip';
			} while( file_exists( DECR_PATH . $filename ) );
				
			$zip->open( DECR_PATH . $filename , ZipArchive::CREATE );
			
			foreach( $xml->file as $file ) {
				
				$filemeta = json_decode(base64_decode($this->mc->decrypt( $file->meta, SERVER_KEY, SERVER_CIPHER, SERVER_MODE )), true);
				
				if( !is_array($filemeta) )
					return false;
				
				$dec = base64_decode($this->mc->decrypt($filemeta['key'], $key, CHECK_CIPHER, CHECK_MODE));
				
				if( $dec!=='OK' )
					return array(false, 0);
					
				$decrypt = $this->mc->decrypt( $file->value, $key, $filemeta['cipher'], $filemeta['mode'] );
				
				$zip->addFromString( $filemeta['name'], $decrypt );
				
			}
			
			$expire = json_decode(file_get_contents( DECR_PATH . 'expire.json'), true );
			$expire[$zipgen.'.zip'] = (time() + DECR_FILE_EXPIRE);
			file_put_contents( DECR_PATH . 'expire.json', json_encode($expire) );
			
			$zip->close();
			
			$_SESSION['download']['type'] = 1;
			$_SESSION['download']['ticket'] = $_SESSION['meta']['zipgen'] = $zipgen;
			
			$_SESSION['meta']['zipsize'] = $this->to->humansize(filesize( DECR_PATH . $zipgen . '.zip' ));
			$_SESSION['meta']['downloadexpire'] = date(TIME_FORMAT_HOURS, time() + DECR_FILE_EXPIRE);
			$_SESSION['meta']['downloadlink'] = SCRIPT_PROTOCOL . SCRIPT_URL . SCRIPT_RELPATH . '/download.php?id=' . $zipgen;
			
			
			return $zipgen;
			
		}
		
	}
	
	public function xparse( $xml, $arr ) {
		
		$val = (array) $xml->{$arr[0]};
		$val = $val[$arr[1]];
		
		$pxml = [];
		
		$i = 0;
		foreach( $xml->{$arr[0]}->{$arr[1]} as $key => $vl ) {
			
			$attr = (array) $vl->attributes();
			$prop = $attr['@attributes'][$arr[2]];
			
			if( !isset($prop) )
			return false;
			
			$pxml[$prop] = $val[$i];
			
			$i++;
			
		}
		
		return $pxml;
		
	}
	
}