DROP TABLE IF EXISTS `websites`;
CREATE TABLE IF NOT EXISTS `websites` (
  `id` int(20) NOT NULL auto_increment,
  `_name` varchar(100) NOT NULL,
  `_desc` text NOT NULL,
  `sitePath` varchar(255) NOT NULL,
  `rootPath` varchar(255) NOT NULL,
  `siteMapFolderName` varchar(255) NOT NULL,
  `maxUrlsCount` int(20) NOT NULL,
  `overWrite` int(1) NOT NULL,
  `createXML` int(1) NOT NULL,
  `createTXT` int(1) NOT NULL,
  `addToRobots` int(1) NOT NULL,
  `robotsContents` text NOT NULL,
  `gzXMLFile` int(1) NOT NULL,
  `reportMail` varchar(150) NOT NULL,
  `includeImages` int(1) NOT NULL,
  `searchForLinks` int(1) NOT NULL,
  `dateline` int(11) NOT NULL,
  `removed` int(1) NOT NULL,
  `manualURLS` longtext NOT NULL,
  `targetURLS` text NOT NULL,
  `sign` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `_name` (`_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `websites_databases`;
CREATE TABLE IF NOT EXISTS `websites_databases` (
  `id` int(20) NOT NULL auto_increment,
  `websiteID` int(20) NOT NULL,
  `databaseName` varchar(200) NOT NULL,
  `server` varchar(150) NOT NULL,
  `userName` varchar(255) NOT NULL,
  `passWord` varchar(255) NOT NULL,
  `activated` int(1) NOT NULL,
  `dateline` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `websites_databases_connections`;
CREATE TABLE IF NOT EXISTS `websites_databases_connections` (
  `id` bigint(100) NOT NULL auto_increment,
  `websiteID` int(20) NOT NULL,
  `databaseID` int(20) NOT NULL,
  `selectedFields` text NOT NULL,
  `tables` varchar(255) NOT NULL,
  `whereCase` text NOT NULL,
  `urlFormat` text NOT NULL,
  `priority` varchar(3) NOT NULL,
  `freq` varchar(10) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- v1.4.1
ALTER TABLE `websites_databases_connections` ADD `spaceReplacements` VARCHAR( 100 ) NOT NULL;

-- v1.5.0
ALTER TABLE `websites`
ADD COLUMN `specificImagesDirs`  text NOT NULL AFTER `includeImages`;