<?PHP
function showMessages()
{
    global $_errors, $_success, $_info, $_atten;
    if(count($_errors) > 0 || count($_success) > 0 || count($_info) > 0 || count($_atten) > 0)
    {
        if(count($_errors) > 0)
        {
            ?>
            <div class="error">
                <?
                if(count($_errors) == 1) echo $_errors[0];
                else
                {
                    ?><ul><?
                    foreach($_errors as $_msg)
                    {
                        ?>
                        <li><?=$_msg?></li>
                        <?
                    }
                    ?></ul><?
                }
                ?>
            </div>
            <?
        }
        
        if(count($_success) > 0)
        {
            ?>
            <div class="success">
                <?
                if(count($_success) == 1) echo $_success[0];
                else
                {
                    ?><ul><?
                    foreach($_success as $_msg)
                    {
                        ?>
                        <li><?=$_msg?></li>
                        <?
                    }
                    ?></ul><?
                }
                ?>
            </div>
            <?
        }
        if(count($_atten) > 0)
        {
            ?>
            <div class="warning">
                <?
                if(count($_atten) == 1) echo $_atten[0];
                else
                {
                    ?><ul><?
                    foreach($_atten as $_msg)
                    {
                        ?>
                        <li><?=$_msg?></li>
                        <?
                    }
                    ?></ul><?
                }
                ?>
            </div>
            <?
        }
        if(count($_info) > 0)
        {
            ?>
            <div class="info">
                <?
                if(count($_info) == 1) echo $_info[0];
                else
                {
                    ?><ul><?
                    foreach($_info as $_msg)
                    {
                        ?>
                        <li><?=$_msg?></li>
                        <?
                    }
                    ?></ul><?
                }
                ?>
            </div>
            <?
        }
    }
}

function redirect($url)
{
    global $_success, $_errors;
    if($_success && count($_success) > 0) $_SESSION['__success'] = $_success;
    if($_errors && count($_errors) > 0) $_SESSION['__errors'] = $_errors;
    header("location: ".$url);
    exit;
}

function ArrayToObject($data, $applayAll = TRUE)
{
    $return = new stdClass();
    if(is_array($data))
    {
        foreach($data as $k=>$v)
        {
            $return->$k = $applayAll && (is_object($data) || is_array($data)) ? ArrayToObject($v) : $v;
        }
    } else $return = $data;
    return $return;
}

function highlighting($text, $replacements = array(), $taging = FALSE, $splitter = "|")
{
    if($taging)
    {        
        foreach($replacements as $k=>$v)
        {
            $dataK = explode($splitter, $k);
            $dataV = explode($splitter, $v);
            
            $code["/".pregSlashes($dataK[0])."(.*?)".pregSlashes($dataK[1])."/is"] = $dataV[0].'{$1}'.$dataV[1];
        }
       
        return preg_replace(array_keys($code), array_values($code), $text);         
    } else return str_replace(array_keys($replacements), array_values($replacements), $text);
}

function pregSlashes($str)
{
    $replacements['['] = '\[';
    $replacements[']'] = '\]';
    $replacements['{'] = '\{';
    $replacements['}'] = '\}';
    $replacements['/'] = '\/';
    $replacements['('] = '\(';
    $replacements[')'] = '\)';
    $replacements['>'] = '\>';
    $replacements['<'] = '\<';
    $replacements['"'] = '\"';
    $replacements['"'] = "\'";
    $replacements['#'] = "\#";
    return str_replace(array_keys($replacements), array_values($replacements), $str);
}
function highlight_SQL($query)
{
    $replacements['SELECT'] = '<span style="font-weight: bold;color: #204362">SELECT</span>';
    $replacements['FROM'] = '<span style="font-weight: bold;color: #204362">FROM</span>';
    $replacements['WHERE'] = '<span style="font-weight: bold;color: #204362">WHERE</span>';
    return highlighting($query, $replacements);
}
function tagsConverter($text, $returnBack = FALSE)
{
   $tag['<'] = '&lt;';
   $tag['>'] = '&gt;';
   if(!$returnBack)
   {
        return str_replace(array_keys($tag), array_values($tag), $text);
   }
   else
   {
        return str_replace(array_values($tag), array_keys($tag), $text);
   }
}

function sizeMode($bytes)
{
    $bytes = (int)$bytes;
    $type = "b";
    $types = array('kb', 'mb', 'gb', 'tb');
    foreach($types as $b)
    {
        if($bytes > 1024)
        {
            $bytes /= 1024;
            $type = $b;
        }
    }
    return round($bytes, 2)." ".$type;
}

function checkVals($obj)
{
    if((is_object($obj) || is_array($obj)) && count($obj) > 0) return true;
    else if($obj) return true;
    else return false;
}

function check($obj, $index = NULL, $checkWithValue = FALSE)
{
    if(isset($obj))
    {
        if(is_object($obj) && $index != NULL)
        {
            if(property_exists($obj, $index)) 
            {
                if($checkWithValue && checkVals($obj->$index)) return TRUE;
                elseif(!$checkWithValue) return TRUE;
                else return FALSE;
            }
            else return FALSE;
        }
        elseif(is_array($obj) && $index != NULL)
        {
            
            if(array_key_exists($index, $obj)) 
            {
                if($checkWithValue && checkVals($obj[$index])) return TRUE;
                elseif(!$checkWithValue) return TRUE;
                else return FALSE;
            }
            else return FALSE;
        } 
        else
        {
            if($checkWithValue)
            {
                if(is_string($obj) && strlen($obj) > 0) return TRUE;
                elseif(is_numeric($obj) && $obj > 0) return TRUE;
                elseif($obj) return TRUE;
                else return FALSE;
            }
            else return TRUE;
        }
    } 
    else return FALSE;
}

function loadFile($filePath, $load = true, $canLoadAgain = false)
{
    $path = str_replace(".", "/", $filePath).".php";
    $className = str_replace(".", "_", $filePath);
  
    if(file_exists(libPath.$path))
    {        
        if(!$canLoadAgain) include_once libPath.$path;
        else include libPath.$path;
        return TRUE;
    }
    return FALSE;
}

function getTable($tableNames)
{
    $tableNames_ar = explode(",", $tableNames);
    $name = "";
    if(!defined('_prefix')) define('_prefix', '');
    foreach($tableNames_ar as $tableName)
    {
        if($name != "") $name .= ", "; 
        $name .= _prefix.trim($tableName);
    }
    return $name;
}

function installCodesGitNews()
{
    $sql = 'CREATE TABLE IF NOT EXISTS `'.getTable('codesgit_news').'` (
  `id` int(20) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `dateline` int(11) NOT NULL,
  `contentID` int(20) NOT NULL,
  `contentType` int(2) NOT NULL,
  `hasRead` int(1) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `contentID` (`contentID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;';
    global $db;
    $db->query($sql);
}

function getNews()
{
    if(!isset($_SESSION['news_'.scriptName]) || $_SESSION['news_'.scriptName] <= time() - (60*60)) //1 hour
    {
        global $db, $__Product;
        installCodesGitNews();
        $_SESSION['news_'.scriptName] = time();
        loadFile('codesGit.files.manager');
        $files = new codesGit_files_manager;
        $lastResv = $db->fetchF(getTable('codesgit_news'), '1 order by contentID desc', 'contentID');
        if(count($lastResv) == 0) $lastResv = (object) array("contentID"=>0);
        $url = 'http://feeds.codesgit.com/index.php?version='.$__Product->version.'&lastResv='.$lastResv->contentID.'&productID='.$__Product->id;        
        $response = $files->get(str_replace(" ", "_", $url));        
        if($response && $response != '' && substr($response, 0, 1) == '{' && substr($response, strlen($response) - 1, 1) == '}')
        {
            $json = json_decode($response);
            if($json->founds > 0)
            {
                foreach($json->msgs as $msg)
                {                    
                    $db->ins(getTable('codesgit_news'), $msg);
                }
            }
        }
    }
}

function attenUpdate()
{
    global $_atten, $db;
    
    if(isset($_GET['dismiss']))
    {
        $db->updt(getTable('codesgit_news'), array('hasRead'=>1), "id='".$_GET['dismiss']."' ");    
        redirect(isset($_GET['url']) ? $_GET['url'] : 'index.php?p=dashboard');
    }
    
    installCodesGitNews();
    $sql = $db->get(getTable('codesgit_news'), 'hasRead=0 and contentType=2', 'id, title, url');
    while($rs = $db->fetch($sql))
    {
        $_atten[] = $rs->title.'... <a href="'.$rs->url.'" target="_blank">read more</a> - <a href="index.php?p=dashboard&dismiss='.$rs->id.'&url='.urlencode($_SERVER['REQUEST_URI']).'">Dismiss</a>';
    }
}
?>