<?PHP
/*
 * Powered by Ahmed Elkadrey
 * www.elkadrey.me
 * version: 2.1.0
 * support: 
 */
class codesGit_sitemap_creator
{
    public $sitePath        = "";
    public $rootPath        = "";
    public $siteMap         = "sitemap";    
    public $maxUrlsCount    = 30000;
    public $overWrite       = True;
    public $createXML       = True;
    public $createTXT       = True;
    public $addToRobots     = True;
    public $gzXMLFile       = False;    
    public $includeImages   = False;
    public $specificImagesDirs   = array();
    public $addToRobot   = False;
    public $reportMail      = "";
    public $robotsContents  = "";
    public $sitemapID       = 0;
    
    protected $file;    
    private $currentXMLFile;
    private $currentTXTFile;
    private $logFile        = "";
    private $classRootPath  = "";    
    private $startingTime;
    private $startingMicroTime;
    private $oldFilesCount  = 0;
    
    public function codesGit_sitemap_creator($options = Array())
    {
        $this->startingMicroTime = microtime(true);
        $this->startingTime = time();
        if(!is_array($options)) $options = array();
        set_time_limit(0);
        
        $this->sitePath = $options['sitePath'] ? $options['sitePath'] : ($this->sitePath === "" ? $_SERVER['HTTP_HOST'] : $this->sitePath);  
        if(substr($this->sitePath, strlen($this->sitePath) - 1, 1) != "/" && $this->sitePath) $this->sitePath .= "/";
        
        $this->rootPath = $options['root'] ? $options['root'] : $this->rootPath;        
        $this->siteMap = isset($options['saveAs']) ? $options['saveAs'] : $this->siteMap;
        $this->maxUrlsCount = is_numeric($options['maxUrlsCount']) && $options['maxUrlsCount'] > 0 ? $options['maxUrlsCount'] : $this->maxUrlsCount;
        $this->createXML = isset($options['createXML']) ? $options['createXML'] : $this->createXML;
        $this->createTXT = isset($options['createTXT']) ? $options['createTXT'] : $this->createTXT;
        $this->addToRobot = isset($options['addToRobot']) ? $options['addToRobot'] : $this->addToRobot;
        $this->gzXMLFile = isset($options['gzXMLFile']) ? $options['gzXMLFile'] : $this->gzXMLFile;
        $this->reportMail = isset($options['reportMail']) ? $options['reportMail'] : $this->reportMail;
        $this->overWrite = isset($options['overWrite']) ? $options['overWrite'] : $this->overWrite;
        $this->includeImages = isset($options['includeImages']) ? $options['includeImages'] : $this->includeImages;
        $this->specificImagesDirs = isset($options['specificImagesDirs']) ? $options['specificImagesDirs'] : $this->specificImagesDirs;
        $this->addToRobots = isset($options['addToRobots']) ? $options['addToRobots'] : $this->addToRobots;
        $this->sitemapID = isset($options['id']) ? $options['id'] : $this->sitemapID;
        $this->robotsContents = $options['robotsContents'] ? $options['robotsContents'] : $this->robotsContents;
        
        $classRootPath = str_replace("\\", "/", substr(__FILE__, 0, (strlen(__FILE__) - strlen(basename(__FILE__)))));
        $this->classRootPath = substr($classRootPath, 0, strlen($classRootPath) - 21);
        
        
        //Start
        loadFile('codesGit.files.manager');
        $this->file = new codesGit_files_manager;
        
        $log = $this->classRootPath.'_temp/sitemap/'.($this->sitemapID > 0 ? $this->sitemapID : (str_replace(array("http:", "/"), "", $this->sitePath)))."_sitemapLog.txt";
        
        if(!file_exists($this->getPath()."index.html"))
        {
            @$this->file->createDir($this->getPath());
            @$this->file->save($this->getPath()."index.html", "", TRUE);
        }
        
        $this->logFile = @file_exists($log) ? json_decode($this->file->get($log)) : NULL;
        if(!isset($this->logFile)) $this->logFile = new stdClass ();
        if(!check($this->logFile, 'xmlFiles')) $this->logFile->xmlFiles = array();
        if(!check($this->logFile, 'txtFiles')) $this->logFile->txtFiles = array();
        $this->oldFilesCount = $this->logFile->xmlFiles ? count($this->logFile->xmlFiles) : 0;
        $this->oldFilesCount += $this->logFile->txtFiles ? count($this->logFile->txtFiles) : 0;
        $this->logFile->newFilesFounds = array();
        
        $this->clear();
        $this->openFile();
    }
    
    public function addToFile($url, $changefreq = 'never', $priority = "0.1", $lastmod='')
    {
        $chk = explode(":", $url);
        if(count($chk) > 1 && ($chk[0] != 'http' && $chk[0] != 'https' && $chk[0] != 'ssl' && $chk[0] != 'ssls'))  return false;

        if($this->logFile->lastLineID >= $this->maxUrlsCount) $this->generateNewFile();
        
        if($this->createXML) 
        {
            $this->writeToFile("<url>", "xml");
            $this->writeToFile('<loc><![CDATA['.$this->sitePath.$url.']]></loc>', "xml");            
            $this->writeToFile('<lastmod>'.($lastmod ? (is_numeric($lastmod) ? date("Y-m-d", $lastmod) : $lastmod) : date("Y-m-d", time())).'</lastmod>', "xml");
            $this->writeToFile('<changefreq>'.$changefreq.'</changefreq>', "xml"); //settings ==> always | hourly | daily | weekly | monthly | yearly | never
            $this->writeToFile('<priority>'.($priority > 1 ? "1.0" : $priority).'</priority>', "xml");
            if($this->includeImages)
            {
                $imagesFounds = @$this->file->searchInHTML($this->sitePath.$url, 'img', 'src');
                foreach($imagesFounds as $imgSrc)
                {           
                    foreach($this->specificImagesDirs as $dir)
                    {
                        if(!empty($dir))
                        {
                            $img = @$this->file->serverPath($imgSrc, $this->sitePath, $this->sitePath.$url);     
                            if(!empty($img) && substr($img, 0, strlen($dir)) === $dir)
                            {                                                        
                                $this->writeToFile("<image:image>", "xml");
                                $this->writeToFile("<image:loc><![CDATA[".$img."]]></image:loc>", "xml");
                                $this->writeToFile("</image:image>", "xml");
                            }
                        }
                    }
                }
            }
            $this->writeToFile("</url>", "xml");
        }
        
        if($this->createTXT) $this->writeToFile($this->sitePath.$url, "txt"); 
        
        $this->logFile->lastLineID++;
    }
 
    protected function getPath()
    {        
        if(substr($this->rootPath, strlen($this->rootPath) - 1, 1) != "/" && $this->rootPath) $this->rootPath .= "/";
        if(substr($this->siteMap, strlen($this->siteMap) - 1, 1) != "/" && $this->siteMap) $this->siteMap .= "/";
        return $this->rootPath.$this->siteMap;
    }
    
    protected function clear($force = false)
    {
        if($this->overWrite == TRUE || $force == TRUE)
        {
            $url = $this->getPath();
            @$this->file->delete($url, array('txt', 'xml', 'gz'));
            if(count($this->logFile->xmlFiles) > 0 && !$this->robotsContents)
            {
                @$Robots = $this->file->get($this->rootPath."robots.txt");
                $RobotsAr = array();
                foreach($this->logFile->xmlFiles as $file)
                {
                    $RobotsAr[] = "\r\nSitemap: ".$file->url."";
                    $RobotsAr[] = "Sitemap: ".$file->url."";
                }
                @$this->file->save($this->rootPath."robots.txt", str_replace($RobotsAr, "", $Robots), TRUE);
            }
            $this->logFile->xmlFiles = array();
            $this->logFile->txtFiles = array();
            $this->logFile->lastFileID = $this->logFile->lastLineID = 0;
        }
    }
    private function writeToFile($contents, $type)
    {
        switch($type)
        {
            case 'xml':
                if($this->currentXMLFile)
                {
                    if($this->gzXMLFile == TRUE) @gzwrite($this->currentXMLFile, $contents."\r\n");
                    else @fputs($this->currentXMLFile, $contents."\r\n");
                }
            break;
            case 'txt':
                if($this->currentTXTFile) @fputs($this->currentTXTFile, $contents."\r\n"); 
            break;
        }
    }
    
    private function openFile()
    {
        if($this->overWrite == FALSE && $this->logFile->lastFileID > 0)
        {
            if($this->createXML) 
            {
                $xmlPath = $this->getPath().'sitemap_'.$this->logFile->lastFileID.'.xml';
                if($this->gzXMLFile) $this->generateNewFile();                
                else
                {                    
                    @$this->file->save($xmlPath, str_replace("</urlset>", "", $this->file->get($xmlPath)));
                    @$this->currentXMLFile = fopen($xmlPath, "a+");
                }
            }
            if($this->createTXT) $this->currentTXTFile = fopen($this->getPath().'sitemap_'.$this->logFile->lastFileID.'.txt', "a+");
        }   
        else 
        {
            $this->logFile->lastFileID = 0;
            $this->generateNewFile();                
        }
    }
    
    private function generateNewFile()
    {
        if(!$this->logFile->lastFileID) $this->logFile->lastFileID = 0;
        else 
        {
            if($this->currentXMLFile) 
            {
                $selectedXMLFileID = count($this->logFile->xmlFiles) - 1; 
                $this->logFile->xmlFiles[$selectedXMLFileID] = new stdClass();
                $this->logFile->xmlFiles[$selectedXMLFileID]->links = $this->logFile->lastLineID;
                $this->logFile->xmlFiles[$selectedXMLFileID]->lastUpdate = time(); 
            }
             
            if($this->currentTXTFile)
            {
                $selectedTXTFileID = count($this->logFile->txtFiles) - 1;
                $this->logFile->txtFiles[$selectedTXTFileID] = new stdClass();
                $this->logFile->txtFiles[$selectedTXTFileID]->links = $this->logFile->lastLineID;
                $this->logFile->txtFiles[$selectedTXTFileID]->lastUpdate = time(); 
            }
                        
            $_lastFileID = $this->logFile->lastFileID;
             
            
            
        }
        $this->logFile->lastFileID++;
        $this->logFile->lastLineID = 0;
                
        
        
        if($this->currentXMLFile) 
        {
            $fileName = 'sitemap_'.$_lastFileID.'.xml';
            $this->writeToFile("</urlset>", "xml");
            
            if($this->gzXMLFile) 
            {
                $fileName .= '.gz';
                gzclose($this->currentXMLFile);
            }
            else fclose ($this->currentXMLFile);                      
            $this->logFile->xmlFiles[$selectedXMLFileID]->size = @filesize($this->getPath().$fileName);             
        }
        if($this->currentTXTFile) 
        {
            $this->logFile->txtFiles[$selectedTXTFileID]->size = @filesize($this->getPath().'sitemap_'.$_lastFileID.'.txt'); 
            fclose($this->currentTXTFile);
        }
        
        //xml
        if($this->createXML) 
        {
            $xmlPath = 'sitemap_'.$this->logFile->lastFileID.'.xml';
            if($this->gzXMLFile) 
            {
                $xmlPath .= '.gz';
                $this->currentXMLFile = @gzopen($this->getPath().$xmlPath, 'w9');
            }
            else $this->currentXMLFile = fopen($this->getPath().$xmlPath, "a+");
            $xmlID = count($this->logFile->xmlFiles);
            $this->logFile->xmlFiles[$xmlID] = new stdClass();
            $this->logFile->xmlFiles[$xmlID]->url = $this->sitePath.$this->siteMap.$xmlPath;
            $this->logFile->xmlFiles[$xmlID]->created = time();
            
            $this->writeToFile('<?xml version="1.0" encoding="UTF-8"?>
<urlset
        xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
        http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd"        
        xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
        xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">'."\r\n", "xml");
            
            if($this->oldFilesCount < $this->logFile->lastFileID) $this->logFile->newFilesFounds[] = $this->sitePath.$this->siteMap.$xmlPath;
        }
        
        if($this->createTXT) 
        {
            $txtID = count($this->logFile->txtFiles);
            if(!isset($this->logFile->txtFiles[$txtID])) $this->logFile->txtFiles[$txtID] = new stdClass();
            $this->logFile->txtFiles[$txtID]->url = $this->sitePath.$this->siteMap.'sitemap_'.$this->logFile->lastFileID.'.txt';
            $this->logFile->txtFiles[$txtID]->created = time();
            
            $this->currentTXTFile = fopen($this->getPath().'sitemap_'.$this->logFile->lastFileID.'.txt', "a+");
            if($this->oldFilesCount < $this->logFile->lastFileID) $this->logFile->newFilesFounds[] = $this->sitePath.$this->siteMap.'sitemap_'.$this->logFile->lastFileID.'.txt';
        }
        
    }
    
    public function __destruct() 
    {               
        
        //robots
        if((count($this->logFile->xmlFiles) > 0 && $this->addToRobots == true) || $this->robotsContents)
        {
            if(file_exists($this->rootPath."robots.txt")) $robotsPath = $this->rootPath."robots.txt";
            else
            {
                @$founds = $this->file->search("robots.txt", $this->getPath(), FALSE);
                if(count($founds) > 0) $robotsPath = $founds[0]->fullPath;
                else
                {
                    @$founds = $this->file->search($this->classRootPath, $this->getPath(), FALSE);
                    if(count($founds) > 0) $robotsPath = $founds[0]->fullPath;
                    else if(is_dir($this->rootPath)) $robotsPath = $this->rootPath."robots.txt";     //create new in root       
                }
            }
            
            if($robotsPath)
            {
                $content = $this->robotsContents ? $this->robotsContents : "";
                if(count($this->logFile->xmlFiles) > 0 && $this->addToRobots == true)
                {
                    foreach($this->logFile->xmlFiles as $file)
                    {
                        $content .= "\r\nSitemap: ".$file->url;
                    }
                }
                @$this->file->save($robotsPath, $content, $this->robotsContents ? TRUE : FALSE);
            }
        }        
        
        $this->logFile->saveAs = $this->getPath();
              
        if($this->currentXMLFile) 
        {
            $fileName = 'sitemap_'.$this->logFile->lastFileID.'.xml';
            $this->writeToFile("</urlset>", "xml");
            
            if($this->gzXMLFile) 
            {
                $fileName .= '.gz';
                gzclose($this->currentXMLFile);
            }
            else fclose ($this->currentXMLFile);
            if(!$this->logFile->xmlFiles[count($this->logFile->xmlFiles) - 1]) $this->logFile->xmlFiles[count($this->logFile->xmlFiles) - 1] = new stdClass();
            $this->logFile->xmlFiles[count($this->logFile->xmlFiles) - 1]->links = $this->logFile->lastLineID;
            $this->logFile->xmlFiles[count($this->logFile->xmlFiles) - 1]->lastUpdate = time();                          
            $this->logFile->xmlFiles[count($this->logFile->xmlFiles) - 1]->size = @filesize($this->getPath().$fileName);  
        }
        if($this->currentTXTFile) 
        {
            if(!$this->logFile->txtFiles[count($this->logFile->txtFiles) - 1]) $this->logFile->txtFiles[count($this->logFile->txtFiles) - 1] = new stdClass();
            $this->logFile->txtFiles[count($this->logFile->txtFiles) - 1]->links = $this->logFile->lastLineID;
            $this->logFile->txtFiles[count($this->logFile->txtFiles) - 1]->lastUpdate = time();                          
            $this->logFile->txtFiles[count($this->logFile->txtFiles) - 1]->size = @filesize($this->getPath().'sitemap_'.$this->logFile->lastFileID.'.txt');
            fclose($this->currentTXTFile);
        }
        
        $endTime = time();
        $endMicroTime = microtime(true);
        
        $this->logFile->time->from = $this->startingTime;
        $this->logFile->time->to = $endTime;
        $this->logFile->time->spend = $endMicroTime - $this->startingMicroTime;
        
        $this->file->save($this->classRootPath.'_temp/sitemap/'.($this->sitemapID > 0 ? $this->sitemapID : (str_replace(array("http:", "/"), "", $this->sitePath)))."_sitemapLog.txt", json_encode($this->logFile), true);
        
        
        if($this->reportMail)
        {
            $message = "Dear Mr\r\n";
            $message .= "Sitemap has been generated succesfully, The details are below:\r\n";
            $message .= "Time From: ".date("d-m-Y H:i:s", $this->startingTime)."  to :".date("d-m-Y H:i:s", $endTime)." | Spend ".  round($this->logFile->time->spend, 3)." Sec.\r\n";
            if(count($this->logFile->newFilesFounds) > 0)
            {
                $message .= "New Files has been added:\r\n";
                foreach($this->logFile->newFilesFounds as $file)
                {
                    $message .= "\t\t- ".$file."\r\n";
                }
            }
            
            @mail($this->reportMail, "Sitemap has been generated succesfully @ ".date("d-m-Y H:i:s", $endTime), $message, "FROM: noreplay@".$this->file->baseDomain($_SERVER['HTTP_HOST']));
        }
        echo 'Generator is complete.';
    }
}

?>