<?PHP
/*
 * Powered by Ahmed Elkadrey
 * www.elkadrey.me
 * class: File Class
 * version: 1.0.1
 * last update:  2014-02-03
 */
class codesGit_files_manager
{
    var $codesGit_files_manager = NULL;
    
    function get($filePath)
    {
        if(function_exists('file_get_contents')) return @file_get_contents($filePath);
        else
        {
            $this->files = @fopen($filePath, "r");
            
            $data = "";
            if($this->files)
            {
                while(!feof($this->files))
                {
                    $data .= fgets($this->files);
                }
                fclose($this->files);
            }            
            return $data;
        }
    }
    
    function save($filePath, $content = "", $overWrite = FALSE)
    {
        if(function_exists('file_put_contents') && $overWrite == TRUE) file_put_contents($filePath, $content);
        else
        {            
            $this->files = fopen($filePath, ($overWrite == TRUE ? "w+" : "a+"));
            fputs($this->files, $content);
            fclose($this->files);
            $this->files = NULL;
        }
    }
    
    function createDir($fullPath)
    {
        $fullPath = str_replace("\\", "/", $fullPath);
        $dirs = explode("/", $fullPath);
        $createdDir = "";
        foreach($dirs as $dir)
        {
            if($dir)
            {
                $createdDir .= $dir."/";
                @mkdir($createdDir);
            }
        }
        return $createdDir;
    }
    
    function getExt($filePath)
    {
        $file = explode(".", $filePath);
        return strtolower(end($file));
    }
    
    function search($searchFor, $fullPath = "", $getAll = false, $searchType = "parent", $founds = array()) //Search Type: child ==> search in child directories (!! NOT RECOMMENDED) | parent ==> search in parent directories
    {
        if($fullPath) $fullPath = str_replace("\\", "/", $fullPath);
        else $fullPath = str_replace("\\", "/", substr(__FILE__, 0, (strlen(__FILE__) - strlen(basename(__FILE__)))));
        
        if(substr($fullPath, strlen($fullPath) -1, 1) != "/") $fullPath .= "/";
        
        $dir = opendir($fullPath);
        while(($fileName = readdir($dir)) !== false)
        {
            if(is_file($fullPath.$fileName) && $searchFor == $fileName && ($getAll || (!$getAll && count($founds) == 0))) 
            {
                $i = count($founds);
                $founds[$i]->dir = $fullPath;
                $founds[$i]->fullPath = $fullPath.$fileName;
                if(!$getAll) break;
            }
            elseif(is_dir($fullPath.$fileName) && !in_array($fileName, array(".", "..", "")) && !is_file($fullPath.$fileName) && ($getAll || (!$getAll && count($founds) == 0))) $folders[] = $fileName;
        }
         
        if($getAll || (!$getAll && count($founds) == 0))
        {
            switch($searchType)
            {
                case 'child':
                    if(count($folders) > 0)
                    {
                        foreach($folders as $folder)
                        {
                            $founds = $this->search($searchFor, $fullPath.$folder, $getAll, $searchType, $founds);
                            if((!$getAll && count($founds) > 0)) break;
                        }
                    }
                break;
                case 'parent':
                default:
                    $currentDirs = explode("/", substr($fullPath, 0, strlen($fullPath) - 1));
                    while(!$currentDirs[count($currentDirs) - 1])
                    {
                        unset($currentDirs[count($currentDirs) - 1]);
                    }
                    unset($currentDirs[count($currentDirs) - 1]);
                    $parentDir = implode("/", $currentDirs);                    
                    if($parentDir) $founds = $this->search($searchFor, $parentDir, $getAll, $searchType, $founds);                            
                break;
            }
        }
        
        return $founds;
    }
    
    function searchInHTML($html, $searchFor, $attr = "text")
    {        
        loadFile('codesGit.files.html');
        $data = new codesGit_files_html($html);
        switch($attr)
        {
            case 'text':
                return $data->html($searchFor);
                break;
            default;
                return $data->attr($searchFor, $attr);
        }        
    }
    
    function serverPath($file, $serverPath, $pagePath = "")
    {
        if(substr($file, 0, 4) == 'http') return $file;
        elseif(substr($file, 0, 1) == '/') return (substr($serverPath, strlen($serverPath) - 1, 1) == "/" ? substr($serverPath, 0, strlen($serverPath) - 1) : $serverPath).$file;
        elseif($pagePath) return $pagePath.(substr($pagePath, strlen($pagePath) - 1, 1) != "/" ? "/" : "").$file;
        else return $serverPath.(substr($serverPath, strlen($serverPath) - 1, 1) == "/" ? "" : "/").$file;
    }
    
    function delete($url, $files = NULL)
    {
        $dir = @opendir($url);
        if($dir)
        {
            while(($fileName = readdir($dir)) !== false)
            {                
                 if(is_file($url.$fileName) && (!$files || (is_array($files) && in_array($this->getExt($fileName), $files)))) @unlink ($url.$fileName);
            }
            return TRUE;
        }
        else return false;
    }
    
    function baseDomain($url, $cut = 1)
    {
        $names = explode("/", $url);
        $startFrom = 0;
        if(strtolower(substr($names[0], 0, 4)) == 'http') unset($names[0]);   
        $selectedDomain = reset($names);
        while(!$selectedDomain)
        {                        
            unset($names[array_search(reset($names), $names)]);
            if(count($names) == 0)
            {
                break;
                return NULL;
            }
            $selectedDomain = reset($names);
        }
        
        $domain = explode(".", $selectedDomain);
        for($i = 0; $i < $cut; $i++)
        {
            if(count($domain) > 1) unset($domain[$i]);
        }
        return implode(".", $domain);
    }
}
?>