<?PHP
/*
 * HTML Reader v1.0.0 beta
 * powered by Ahmed Elkadrey <elkadrey@gmail.com>
 */
class codesGit_files_html
{   
    private $activated = FALSE;
    private $html = "";
    public function __construct($htmlData) 
    {        
        $this->open($htmlData);
    }
    
    public function open($htmlData)
    {       
        $this->html = "";
        $this->activated = FALSE;
        if($htmlData)
        {
            if(substr($htmlData, 0, 4) == 'http' || substr($htmlData, 0, 3) == 'ssl') 
            {
                $ext = explode(".", str_replace(dirname($htmlData), "", $htmlData));
                $avoid = array('jpg', 'png', 'bmp', 'pmb', 'jpeg', 'gif', 'pdf', 'zip', 'gz', 'gzip', 'rar', 'doc', 'docx', 'xls', 'xlsx', 'db', 'mht', 'mp3', 'mp4', 
                    'wmv', 'wma', 'avi', 'htaccess', 'htpassword', 'rmvb', 'vb', 'ram', '3gb', 'amr', 'fla', 'swf', '7zip');
                
                if(count($ext) == 1 || (count($ext) > 1 && !in_array(strtolower(end($ext)), $avoid)))
                {
                    $contents = trim(@implode("", @file($htmlData)));                
                    if(!$contents) $htmlData = NULL;
                    elseif($contents == "" && strtoupper(substr($contents, 0, 9)) != '<!DOCTYPE' && strtoupper(substr($contents, 0, 6)) != '<!HTML') $htmlData = NULL;
                    elseif(ereg('404 Not Found', $contents)) $htmlData = NULL;
                    else $htmlData = $contents;            
                }
                else $htmlData = NULL;
            }
            
            if($htmlData)
            {                
                $this->html = $htmlData;
                $this->activated = TRUE;
            }
        }        
    }
    public function html($tagName)
    {
        $pattern = '/<'.strtolower($tagName).' .*?>(.*?)<\/'.strtolower($tagName).'>/i';
        preg_match_all($pattern, strtolower($this->html), $matches);
        return $matches[1];
    }
    
    public function attr($tagName, $attr)
    {
        $pattern = '/< *'.strtolower($tagName).'[^>]*'.strtolower($attr).' *= *["\']?([^"\']*)/i';
        preg_match_all($pattern, strtolower($this->html), $matches);
        return $matches[1];
    }
    
    public function value($tagName)
    {
        return $this->attr($tagName, 'value');
    }
    
}
?>