<?PHP
/*
 * Database tables Class version 1.2.0
 * auther: Ahmed Hassan Elkadrey
 * Email: elkadrey@gmail.com
 * lastUpdate: 2014-01-08
 */

 /* updates    
################################# 2014-01-08 v1.2.0
  * Update function show
  * Add new function fetch
  * Add new function cols
  * Add new function colsF
################################# 2012-12-18 v1.1.0
  * Add new function isExsits
###########################################
 */
class codesGit_database_tables
{
    var $codesGit_database_tables = NULL;
    
    function create($source)
    {
        if($source->this && $source->this->isConnecting)
        {
            $details = $source->data;
            $query = "";

            $tableName = str_replace(array("\r\n", "\n", " "), "_", strtolower($details->name)) ;

            if($details->deleteExists) $source->this->query('DROP TABLE IF EXISTS `'.$tableName.'`;');

            if(!$details->deleteExists) $query .= 'CREATE TABLE IF NOT EXISTS `'.$tableName.'` (';
            else $query .= 'CREATE TABLE `'.$tableName.'` (';


            if(is_object($details->cols))
            {
                foreach($details->cols as $name=>$col)
                {
                    switch($col->type)
                    {
                        case 'int':
                        default;
                              $type = ' int ('.($col->len ? $col->len : 10).') '.($col->null ? 'NULL' : 'NOT NULL').($col->auto ? ' auto_increment' : '');
                        break;
                        case 'bigint':
                        default;
                              $type = ' BIGINT ('.($col->len ? $col->len : 20).') '.($col->null ? 'NULL' : 'NOT NULL').($col->auto ? ' auto_increment' : '');
                        break;
                        case 'varchar':
                        default;
                              $type = ' varchar ('.($col->len ? $col->len : 255).') '.($col->null ? 'NULL' : 'NOT NULL');
                        break;
                    }

                    if($col->prm)
                    {
                        if($addtionalQueries) $addtionalQueries .= ', ';
                        $addtionalQueries .= 'PRIMARY KEY  (`'.$name.'`)';
                    }
                    if($cols) $cols .= ", ";
                    $cols .= $name.$type;
                }

                if(is_object($details->unique))
                {
                    if($addtionalQueries) $addtionalQueries .= ', ';
                    $addtionalQueries .= 'UNIQUE KEY `'.$details->unique->name.'` ('.$details->unique->cols.')';
                }
            }
            $query .= $cols.($addtionalQueries ? ', '.$addtionalQueries : '');
            $query .= ') ENGINE='.($details->type ? $details->type : 'MyISAM').' DEFAULT CHARSET='.($details->charset ? $details->charset : 'utf8').' AUTO_INCREMENT=1 ;';

            $run = $source->this->query($query);

            if($run) return true;
        }
    }

    function isExists($source)
    {        
        $tableName = $source->data;
        $tablesExists = $source->this->query("show tables like'".$tableName."' ");
        return $source->this->count($tablesExists) > 0 ? true : false;
    }

    function delete($source)
    {
        if($source->this && $source->this->isConnecting)
        {
             $query = 'DROP TABLE IF EXISTS `'.$source->data.'`;';
             $run = $source->this->query($query);
            if($run) return true;
        }
    }

    function clear($source)
    {
        if($source->this && $source->this->isConnecting)
        {
             $query = 'TRUNCATE TABLE `'.$source->data.'`;';
             $run   = $source->this->query($query);
            if($run) return true;
        }
    }

    function show($source)
    {
        if($source->this && $source->this->isConnecting)
        {
            $tables = array();
            $tablesSQL = $source->this->query("show tables");
            while($tableRS = $source->this->fetch($tablesSQL))
            {                 
                foreach($tableRS as $key) break;                
                $tables[] = $key;
            }
            
            return $tables;
        }
    }
    
    function fetch($source)
    {
        $tables = @codesGit_database_tables::show($source);
        foreach($tables as $k=>$table)
        {
            $source->data = $table;
            $tableContents->$table = @codesGit_database_tables::colsF($source);
        }
        
        return $tableContents;
    }
    
    function cols($source)
    {
        if($source->this && $source->this->isConnecting)
        {
            $tableName = $source->data;
            $tableSQL = $source->this->query("DESCRIBE ".$tableName);
            $cols = array();
            while($col = $source->this->fetch($tableSQL))
            {                     
                $cols[] = $source->fieldOnly ? $col->Field : $col;
            }
            return $cols;
        }
    }
    
    function colsF($source)
    {
        $source->fieldOnly = true;
        return @codesGit_database_tables::cols($source);
    }
}
?>