<?PHP
/*
 * Database Class version 1.2.3
 * auther: Ahmed Hassan Elkadrey
 * Email: elkadrey@gmail.com
 * lastUpdate: 2014-02-02
####################### 2014-02-02
 * Fix Undefined propreties
####################### 2014-01-07
 * Additional options for updt function
####################### 2013-11-13
 * sleeping time during trying to reconnect in case of fail to connect
 * change Password var to password
 * can create error logs
####################### 2013-11-04
 * Update Query with direct string like field1=string1,field2=string2
 * Insert Query with direct string like field1=string1,field2=string2
#########################################################
####################### 2013-01-03
Reconnect option if database lost
##########################################################
####################### 2012-12-30
fix error message during show it on fetching object queries
add (<h3>Database Error:</h3>'.$this->error().' on fetching object)
##########################################################
 */

 class codesGit_database_mysqli
 {
        var         $isConnecting       = false;
        var         $error              = NULL;
        var         $reConnectTimes     = 0;
        protected   $connection         = NULL;
        protected   $closeOnError       = true;
        private     $connectingTrying   = 0;
        private     $sleepingTime       = 0;
        public      $errorLog           = false;
        public      $errorLogPath       = "";
        protected   $databaseConfig     = NULL;
                
        function __construct($obj = NULL, $times = 3, $sleepingTime = 0)
        {
              global $_config;
              $this->reConnectTimes = $times;
              $this->sleepingTime = $sleepingTime;
              if(!$obj) $obj = (object) '';
              if(!property_exists( $obj, 'userName')) $obj->userName = false;
              if(!property_exists( $obj, 'security')) $obj->security = false;
              
              if(isset($_config) && is_object($_config) && $_config->database->technicalSupportMail && $_config->database->technicalSupportMail !== "") $this->technicalSupportMail = $_config->database->technicalSupportMail;
              if(is_object($obj) && $obj->security == true)
              {
                  $obj->server    = $obj->server ? $obj->server : $_config->database->server;
                  $obj->port      = $obj->port ? $obj->port : $_config->database->port;
                  $obj->userName  = $obj->userName ? $obj->userName : $_config->database->userName;
                  $obj->password  = $this->secureing($obj->password ? $obj->password : $_config->database->password);
                  
              }
              elseif(!is_object($obj) || !$obj->userName)
              {
                  $obj->server    = $_config->database->server;
                  $obj->port      = $_config->database->port;
                  $obj->userName  = $_config->database->userName;
                  $obj->password  = $_config->database->password;
              }
              
              if(isset($obj->closeOnError)) $this->closeOnError = $obj->closeOnError;              
              $obj->dbName = !property_exists($obj, 'dbName') ? $_config->database->name : $obj->dbName;
              $this->databaseConfig = $obj;
              return $this->connectToDatabase($obj);
        }

        function connectToDatabase($obj)
        {
              if(!property_exists($obj, 'denyDB')) $obj->denyDB = false;
              $this->connection = @mysqli_connect($obj->server, $obj->userName, $obj->password, (!$obj->denyDB && $obj->dbName ? $obj->dbName : NULL));
              if($this->connection)
              {
                    $this->isConnecting = true;
                    if(!$obj->denyDB && $obj->dbName)
                    {
                      $this->query('SET CHARACTER SET utf8');
                      $this->query("SET NAMES 'utf8'");
                    }
                    return true;
              }
              elseif($this->reConnectTimes > 0 && $this->connectingTrying < $this->reConnectTimes)
              {
                   $this->close();
                   $this->connectingTrying++;
                   if($this->sleepingTime > 0) sleep($this->sleepingTime);
                   
                   return $this->connectToDatabase($obj);
              }
              else  return $this->showError('<h3>Database Error:</h3> Can`t connect to MYSQL'.($this->connectingTrying > 0 ? ' after trying '.$this->connectingTrying.' times' : ''));
        }

        function selectDatabase($databaseName)
        {
            $selectDB = @mysqli_select_db($this->connection, $databaseName);
            if($selectDB)
            {
                $this->query('SET CHARACTER SET utf8');
                $this->query("SET NAMES 'utf8'");
            }
            else return $this->showError('<h3>Database Error:</h3>'.$this->error());
        }

        function query($sql, $closeAfterQuery = false)
        {
            $qry = @mysqli_query($this->connection,$sql);
            if($qry)
            {
                  if($closeAfterQuery) $this->close();
                  return $qry;
            }
            else return $this->showError('<h3>Database Error:</h3>'.$this->error().'<br /><h3>Qeury:</h3>'.highlight_SQL($sql));
        }



        function fetch($sql, $obj = true, $closeAfterQuery = false)
        {
            $rs = @mysqli_fetch_object($sql);
            if(!$rs && !$sql) return $this->showError('<h3>Database Error:</h3>'.$this->error().' on fetching object');
            else
            {
                if($closeAfterQuery) $this->close();
                if($obj && is_array($rs))
                {
                    foreach($rs as $k=>$v)
                    {
                         $rss->$k = $v;
                    }
                    $rs = $rss;
                }
                return $rs;
            }
        }
        
        private function escape($str)
        {
            /*if(function_exists('mysql_real_escape_string')) return mysql_real_escape_string($str);
            elseif(function_exists('mysql_escape_string')) return mysql_escape_string($str);
            else */ return mysqli_escape_string($this->connection, $str);
        }
        
        function ins($TABLE, $data_ar, $additional = NULL)
        {
            if(!$additional) $additional = (object) 'additionalOptions';
            if(!property_exists($additional, 'ignore')) $additional->ignore = false;
            if(!property_exists($additional, 'overWrite')) $additional->overWrite = false;
            
            $TABLE = $this->getTabelName($TABLE);
            if((is_array($data_ar) || is_object($data_ar)) && $TABLE)
            {
                $ky = $val = "";
                foreach($data_ar as $key=>$value)
                {
                    if($ky != '')
                    {
                        $ky .= ", ";
                        $val .= ", ";
                    }
                     $ky .= "`".$key."`";
                     $val .= "'".$this->escape($value)."'";
                }

                $this->query("INSERT ".($additional && $additional->ignore ? 'IGNORE' : '')." INTO ".$TABLE." (".$ky.")VALUES(".$val.")".($additional && $additional->overWrite ? 'ON DUPLICATE KEY UPDATE '.$additional->overWrite : '').";");
                return mysqli_insert_id($this->connection);
            }
        }

        function effects()
        {
            return mysqli_affected_rows($this->connection);
        }

        function updt($TABLE, $data_ar, $WHERE = "", $additional = NULL, $returnBoolean = FALSE)
        {
            if(!$additional) $additional = (object) 'additionalOptions';
            if(!property_exists($additional, 'ignore')) $additional->ignore = false;
            
            $TABLE = $this->getTabelName($TABLE);
            if((is_array($data_ar) || is_object($data_ar)) && $TABLE)
            {

                if(is_string($data_ar))
                {
                    $data = explode(",", $data_ar);                    
                    $data_ar = array();
                    foreach($data as $line)
                    {
                        $str = explode("=", $line);
                        if(substr($str[1], 0, 1) == '"') $str[1] = substr ($str[1], 1);
                        if(substr($str[1], strlen($str[1])-1, 1) == '"') $str[1] = substr ($str[1], 0, strlen($str[1])-1);
                        $data_ar[trim($str[0])] = $str[1];
                    }
                }
                
                $val = "";
                if(is_array($data_ar) || is_object($data_ar))
                {
                    foreach($data_ar as $key=>$value)
                    {
                        if($val != "") $val .= ", ";
                          $val .= "`".$key."`='".$this->escape($value)."'";
                    }
                
                    if($WHERE)
                    {
                        $WHERE = " WHERE ".$WHERE;
                    }
                    $error = $this->closeOnError;
                    if($additional->ignore) $this->closeOnError = FALSE;
                    $runQuery = @$this->query("UPDATE ".$TABLE." SET ".$val.$WHERE);
                    $this->closeOnError = $error;
                    return !$returnBoolean ? $this->effects() : ($runQuery ? TRUE : FALSE);
                }                
            }
        }

        function del($TABLE, $WHERE)
        {
            $TABLE = $this->getTabelName($TABLE);
            if($WHERE)
            {
                $WHERE = " WHERE ".$WHERE;
            }

            $this->query("DELETE FROM ".$TABLE." ".$WHERE) ;
            return $this->effects();
        }

        function get($tbl, $where='', $query='*', $other='')
        {
            $tbl = $this->getTabelName($tbl);
            if($where)
            {
                $where = " WHERE ".$where;
            }
            
            $sql = $this->query("SELECT ".$query." FROM ".$tbl.$where.' '.$other);
            return $sql;
        }

        function fetchArray($sql)
        {
            $rs = @mysqli_fetch_array($sql);
            if(!$rs && !$sql) return $this->showError('<h3>Database Error:</h3>'.$this->error());
            else return $rs;
        }

        function count($source)
        {
            $counts = @mysqli_num_rows($source);
            return $counts ? $counts : 0;
        }

        function fetchF($tbl, $where='', $query='*', $other='')
        {
            $sql = $this->get($tbl, $where, $query, $other);
            $fetch =  @mysqli_fetch_object($sql);
            if($fetch) return $fetch;
            else return array();
        }

        function fetchQuery($query)
        {
             $returns = array();
             $sql = $this->query($query);
             while($rs = $this->fetch($sql))
             {
                 @$returns[] = $rs;
             }

             return $returns;
        }

        function fetchGet($tbl, $where='', $query='*', $other='')
        {
             $returns = array();
             $sql = $this->get($tbl, $where, $query, $other);
             while($rs = $this->fetch($sql))
             {
                 @$returns[] = $rs;
             }

             return $returns;
        }

        function close()
        {
            if($this->connection) @mysqli_close($this->connection);
            $this->connection   = NULL;
            $this->isConnecting = false;
        }


        function table($func, $data = NULL)
        {
            include_once "tables.php";
            $obj = new stdClass();
            $obj->this = $this;
            $obj->databaseConfig = $this->databaseConfig;
            if($data) $obj->data = $data;
            return @codesGit_database_tables::$func($obj);
        }


        protected function getTabelName($name)
        {
            $names = explode(",", $name);
            $tables = "";
            foreach($names as $table)
            {
                if($tables) $tables .= ", ";
                $tables .= "`".  trim($table)."`";
            }

            return $tables;
        }

        protected function error()
        {
            return mysqli_error($this->connection);
        }

        protected function showError($template)
        {
            $this->error = $template;

            //if($this->technicalSupportMail)  @mail($this->technicalSupportMail, "Database Error on System ".($_SERVER['HTTP_HOST'] | $_SERVER['SERVER_NAME']), "Hi Sir,\nSystem found the following database error at ".date("d M Y h:i A")."\n".$template);

            if ($this->errorLog)
            {
                $filLog = fopen($this->errorLogPath."database.log", "a+");
                fputs($filLog, "[".date("d M Y h:i A")."] ".  strip_tags(str_replace(array("<br>", "<br />"), " | ", $template))." @ ".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'].($_POST && count($_POST) > 0 ? " | POST: ".getArrToStr($_POST) : "").($_POST && count($_GET) > 0 ? " | GET: ".getArrToStr($_GET) : "")."\r\n");
                fclose($filLog);
            }
            if($this->closeOnError)
            {
                $this->close();
                echo $this->error;
                exit;
            }
            else return false;
        }
        
        protected function secureing($data)
        {
            return md5(md5($data));
        }
        
        function __destruct()
        {
            $this->close();
        }
 }

 ?>