/*
 * Borwse v1.0.0
 * Ahmed Elkadrey <elkadrey@gmail.com>
 */
$.fn.browse = function(saveTarget, serverPath, options)
{
    var me = this;
    
    if(!serverPath) serverPath = "";
    else if(serverPath != "" && serverPath.substr(serverPath.length - 1, 1) != "/") serverPath += "/";
    
    var config = {
                    root:           "",
                    fileName:       "index.php",
                    images:         "images/",
                    returnFullName: true,
                    showFiles:  false,
                    onLoad:   null
    }
    
    if(options) $.extend(config, options)
    if(config.root != "" && (config.root).substr((config.root).length - 1, 1) != "/") config.root += "/";
    
    function brwstester()
    {
        var doc = {};
        doc.scrollTop = $(document).scrollTop();            
        return doc;
    }
    
    function clear()
    {
        $("body").css("overflow", "auto");
        $("#browseFrame").remove();
        $("#browseMasks").fadeOut("slow", function()
        {
            $(this).remove();                        
        });
        
    }
    
    function create(callBack)
    {
        clear();
        $("body").append('<div id="browseMasks" style="background-color: #000;display: none;position: absolute;z-index: 5000;"></div>');
        $("body").append('<div id="browseFrame" style="background-color: #f7f7f7;border: 3px solid #000;display: none;position: absolute;z-index: 5001;"></div>');        
        $("body").css("overflow", "hidden");
        var contents = '<div style="padding: 5px 5px 5px 20px;font-size: 15px;font-weight: bold;"> <img title="Home" id="browseHome" style="cursor: pointer;float: right;margin-right: 10px;" src="' + config.images +'/home.png" width="20" />&nbsp; <img title="Up Level" id="browseUpLevel" style="cursor: pointer;float: right;margin-right: 10px;" src="' + config.images +'/up.png" /> &nbsp;&nbsp; Current Path: <span id="browseTitle">&nbsp;</span></div><div style="background: #fff;color: #222;width: 98%;margin: auto;border: 1px solid #000;height: ' + (screen.height - (screen.height / 2)) + 'px;" id="browseContent"></div>';        
        contents += '<input type="text" id="theFullPathBrowse" style="width: 98%;margin: 5px auto 0;display: block;border: 1px solid #000" readonly value="" />'; 
        contents += '<div style="padding-top: 5px;"><input type="button" id="selectBrowseBtn" style="margin-left: 1%;" class="btn btn-deactive" value="Select" />';
        contents += '<input type="button" style="margin-left: 1%;" id="cancelBrowseBtn" class="btn btn-primary" value="Cancel" /></div>';
        $("#browseMasks").css({top: 0, left: 0, width: $(document).width(), height: $(document).height()}).fadeTo("slow", 0.4, function()
        {
            $("#browseFrame").css({width: ($(document).width() - ($(document).width() / 4)), left: ($(document).width() / 8), 
                top: (brwstester().scrollTop + 50), height: (screen.height - (screen.height / 3))}).fadeIn().html(contents);
            
            $("#browseFrame").find("#cancelBrowseBtn").click(function()
            {
                clear();
            });
            $("#browseFrame").find("#selectBrowseBtn").click(function()
            {
                if($(this).hasClass('btn-success') && $("#browseFrame").find("#theFullPathBrowse").val() != "")
                {
                    $(saveTarget).val($("#browseFrame").find("#theFullPathBrowse").val());
                    $(saveTarget).html($("#browseFrame").find("#theFullPathBrowse").val());
                    clear();
                }
            });
            
            $("#browseFrame").find("#browseUpLevel").click(function()
            {
                loadDir("", "up");
            });
            $("#browseFrame").find("#browseHome").click(function()
            {
                loadDir("", "home");
            });
            
            var rootPath = "";           
            if(config.onLoad) rootPath = config.onLoad();   
            
            loadDir(rootPath);
            
        }).click(function()
        {
            clear();
        });
        
        
        
    }
    
    function loadDir(dirPath, options)
    {        
        $("#browseFrame").find("#selectBrowseBtn").removeClass('btn-success').addClass('btn-deactive');
        $("#browseFrame").find("#theFullPathBrowse").val('');
        $("#browseFrame").find("#browseTitle").html('Loading...');
        $("#browseFrame").find("#browseContent").html('<center><img style="margin-top: 20px;" src="' + config.images +'/ajax-loader.gif" /></center>').css("overflow", "auto");
        var oldRoot = config.root;
        if(dirPath) config.root += dirPath;
        
        $.post(serverPath + config.fileName + "?browse=1" + (config.showFiles ? "&showFiles=1" : "") + "&rootPath=" + config.root + (options ? "&options=" + options : ""), "", function(res)
        {
            if(res && res.substr(0, 1) == "{" && res.substr(res.length - 1, 1) == "}")
            {
                var data = JSON.parse(res);
                $("#browseFrame").find("#browseTitle").html(data.path);
                $("#browseFrame").find("#browseContent").html('');
                config.root = data.path;
                for(var i in data.dirs)
                {
                    $("#browseFrame").find("#browseContent").append('<div thePath="' + data.dirs[i] + '" class="browseDires" style="padding: 3px;border-bottom: 1px solid #ddd;cursor: pointer;"><img src="' + config.images +'/dir.png" /> ' + data.dirs[i] + '</div>');
                }
                for(var i in data.files)
                {
                    $("#browseFrame").find("#browseContent").append('<div thePath="' + data.files[i] + '" class="browseFiles" style="padding: 3px;border-bottom: 1px solid #ddd;cursor: pointer;"><img src="' + config.images +'/unknown.png" /> ' + data.files[i] + '</div>');
                }
                
                $(".browseDires, .browseFiles").click(function()
                {
                    $("#browseFrame").find("#theFullPathBrowse").val((config.returnFullName ? config.root : "") + $(this).attr('thePath'));
                    $("#browseFrame").find("#selectBrowseBtn").removeClass('btn-deactive').addClass('btn-success');
                });
                $(".browseDires").dblclick(function()
                {
                    loadDir($(this).attr('thePath'));                  
                });
                
                
                
                var selectedDir = (config.root).split("/");
                $("#browseFrame").find("#theFullPathBrowse").val((config.returnFullName ? config.root : selectedDir(selectedDir.length - 1)));
                $("#browseFrame").find("#selectBrowseBtn").removeClass('btn-deactive').addClass('btn-success');
                
            }
            else
            {
                config.root = oldRoot;
                loadDir();
            }
        });
    }
    
    $(me).click(function()
    {
        create();
    });
}