<?php
include_once("config.php");
include_once("functions.php");

include_once("lang/" . $config->lang . "/main.lang.php");

$action = $_REQUEST["action"];

/****
* SINGLE: send download information after upload [+]
****/
if ($action == "sendFileInfo") {
    $u_key = $_REQUEST["u_key"];
    $DownLink = $_REQUEST["DownLink"];
    $DelLink = $_REQUEST["DelLink"];
    $mailFrom = $_REQUEST["mailFrom"];
    $mailTo = $_REQUEST["mailTo"];
    $message = trim(strip_tags($_REQUEST["message"]));
    $show_message = $_REQUEST["show_message"];

    //filechecks - prevent from spaming
    //shortened???
    if (preg_match('|^http://bit\.ly/|',$DownLink)) {
      $pinfo = pathinfo(BitlyShortener($DownLink,"expand"));
    } elseif (preg_match('|^http://adf\.ly/|',$DownLink)) {
      $pinfo = pathinfo(AdflyShortener($DownLink,"expand"));
    } elseif (preg_match('|^http://goo\.gl/|',$DownLink)) {
      $pinfo = pathinfo(GoogleShortener($DownLink,"expand"));
    } else {
      $pinfo = pathinfo($DownLink);
    }
    $finfo = getFileInfos($pinfo["filename"]);
    if (!$finfo) exit(lang("error_file_failure"));
   	
    if (!is_email($mailFrom)) exit(lang("error_from_address_failure"));

    if (!$mailTo) exit(lang("error_both_fields_required"));
    else {
      $mailToErrors = array();
      $mailToAddresses = explode(",",$mailTo);
      foreach ($mailToAddresses as $addr) {
        $addr = trim(strtolower($addr));
        if ($addr) {
          if (!is_email($addr)) $mailToErrors[] = $addr;
          else $sendToAddr[] = $addr;
        }
      }
    }
    if ($mailToErrors) exit(sprintf(lang("error_mailto_troubles"),implode(", ",$mailToErrors)));
    if (!$sendToAddr) exit(lang("error_mailto_none_valid"));

    //number of maximum recipientsexceeded?
    $sendToAddrCnt = count($sendToAddr);
    if ($sendToAddrCnt > $config->maxRcpt) {
      exit (sprintf(lang($sendToAddrCnt == 1 ? "error_mailto_max_one" : "error_mailto_max_X"),$config->maxRcpt));
    }


    //Password protected file
    if ($finfo->pwd_protected && $finfo->pwd) $PasswordLine = sprintf(lang("password_line_mailings"),$finfo->pwd) . "<br /><br />";

    $toSenderBody = file_get_contents("lang/" . $config->lang . "/to.sender.mail.html");
    $toRcptBody = file_get_contents("lang/" . $config->lang . "/to.recipient.mail.html");
    
    if ($show_message) {
      $sql = "replace into `" . $config->tablePrefix . "messages` set u_key = " . dbquote($u_key) . ", message = " . dbquote($message);
      dbquery($sql);
    }
    if ($message) $message = "-----<br />" . nl2br($message) . "<br />-----<br /><br />";


    if ($finfo->descr_long) $fileDescription = lang("mail_file_description") . ":<br />" . $finfo->descr_long . "<br /><br />";

    $find = array("[mailFrom]","[mailTo]","[fileName]","[fileSize]","[DownLink]","[DelLink]","[siteName]","[PasswordLine]","[message]","[delDays]","[FileDescription]");
    foreach ($sendToAddr as $addr) {
      $repl = array($mailFrom,$addr,$finfo->descr,fsize($finfo->fsize),$DownLink,$DelLink,$config->siteName,$PasswordLine,$message,$config->delDays,$fileDescription);
      mail($addr,UTF8subject(sprintf(lang("subject_download_information"),$config->siteName)),str_replace($find,$repl,$toRcptBody),$config->mailHeaders,$config->mailParams);
    }
    $repl = array($mailFrom,implode(", ",$sendToAddr),$finfo->descr,fsize($finfo->fsize),$DownLink,$DelLink,$config->siteName,$PasswordLine,$message,$config->delDays,$fileDescription);
    $toSenderBody = str_replace($find,$repl,$toSenderBody);
    mail($mailFrom,UTF8subject(sprintf(lang("subject_upload_information"),$config->siteName)),$toSenderBody,$config->mailHeaders,$config->mailParams);
  
    exit("OK");
  }
/****
* SINGLE: send download information after upload [-]
****/

/****
* MULTI: send download information after upload [+]
****/
if ($action == "sendMultiFileInfo") {
    $u_key = $_REQUEST["u_key"];
    $mailFrom = $_REQUEST["mailFrom"];
    $mailTo = $_REQUEST["mailTo"];
    $message = trim(strip_tags($_REQUEST["message"]));
    $show_message = $_REQUEST["show_message"];

    //filechecks - prevent from spaming
    $fileInfos = getFileInfos($u_key,"upload");
    if (!$fileInfos) exit(lang("error_file_failure"));
    
    if (!is_email($mailFrom)) exit(lang("error_from_address_failure"));

    if (!$mailTo) exit(lang("error_both_fields_required"));
    else {
      $mailToErrors = array();
      $mailToAddresses = explode(",",$mailTo);
      foreach ($mailToAddresses as $addr) {
        $addr = trim(strtolower($addr));
        if ($addr) {
          if (!is_email($addr)) $mailToErrors[] = $addr;
          else $sendToAddr[] = $addr;
        }
      }
    }
    if ($mailToErrors) exit(sprintf(lang("error_mailto_troubles"),implode(", ",$mailToErrors)));
    if (!$sendToAddr) exit(lang("error_mailto_none_valid"));

    //number of maximum recipientsexceeded?
    $sendToAddrCnt = count($sendToAddr);
    if ($sendToAddrCnt > $config->maxRcpt) {
      exit (sprintf(lang($sendToAddrCnt == 1 ? "error_mailto_max_one" : "error_mailto_max_X"),$config->maxRcpt));
    }

    //Password protected file
    if ($fileInfos->pwd_protected && $fileInfos->pwd) $PasswordLine = "<br />" . sprintf(lang("password_line_mailings"),$fileInfos->pwd) . "<br />";

    $toSenderBody = file_get_contents("lang/" . $config->lang . "/to.sender.multi.mail.html");
    $toRcptBody = file_get_contents("lang/" . $config->lang . "/to.recipient.multi.mail.html");

    preg_match_all('/\[filesList\](.*)\[\/filesList\]/s',$toRcptBody,$flistArr);
    $flistBlockR = $flistArr[1][0];
    preg_match_all('/\[filesList\](.*)\[\/filesList\]/s',$toSenderBody,$flistArr);
    $flistBlockS = $flistArr[1][0];

    //get all files
    $i=0;
    $sql = "select * from `" . $config->tablePrefix . "files` where u_key = " . dbquote($u_key);
    $res = dbquery($sql);
    $numFiles = mysqli_num_rows($res);
    while ($row = mysqli_fetch_object($res)) {
      list($fileKey,$delFileKey) = genFileKeys($row->id);
      unset($fileDescription);
      if ($row->descr_long) $fileDescription = lang("mail_file_description") . ": " . $row->descr_long . "<br />";
      $find = array("[Number]","[Name]","[Size]","[DownLink]","[DelLink]","[FileDescription]");
      $repl = array("#".++$i,$row->descr,fsize($row->fsize),$config->baseDownloadUrl . $fileKey . ".html",$config->baseDeleteUrl . $delFileKey . ".html",$fileDescription);
      $filesListR .= str_replace($find,$repl,$flistBlockR);
      $filesListS .= str_replace($find,$repl,$flistBlockS);
    }

    $toRcptBody = preg_replace('/\[filesList\].*\[\/filesList\]/s',$filesListR,$toRcptBody);
    $toSenderBody = preg_replace('/\[filesList\].*\[\/filesList\]/s',$filesListS,$toSenderBody);

    if ($show_message) {
      $sql = "replace into `" . $config->tablePrefix . "messages` set u_key = " . dbquote($u_key) . ", message = " . dbquote($message);
      dbquery($sql);
    }
    if ($message) $message = "-----<br />" . nl2br($message) . "<br />-----<br /><br />";

    $find = array("[mailFrom]","[mailTo]","[numFiles]","[siteName]","[PasswordLine]","[message]","[delDays]","[groupLink]");
    foreach ($sendToAddr as $addr) {
      $repl = array($mailFrom,$addr,$numFiles,$config->siteName,$PasswordLine,$message,$config->delDays,$config->baseGroupUrl . $u_key . ".html");
      mail($addr,UTF8subject(sprintf(lang("subject_download_information_multi"),$numFiles,$config->siteName)),str_replace($find,$repl,$toRcptBody),$config->mailHeaders,$config->mailParams);
    }
    $repl = array($mailFrom,implode(", ",$sendToAddr),$numFiles,$config->siteName,$PasswordLine,$message,$config->delDays,$config->baseGroupUrl . $u_key . ".html");
    $toSenderBody = str_replace($find,$repl,$toSenderBody);
    mail($mailFrom,UTF8subject(sprintf(lang("subject_upload_information"),$config->siteName)),$toSenderBody,$config->mailHeaders,$config->mailParams);
  
    exit("OK");
  }
/****
* MULTI: send download information after upload [-]
****/


/****
* Contact [+]
****/
if ($action == "contact") {
    $name = trim(stripslashes($_POST['name']));
    $email = trim(strtolower($_POST['email']));
    $tel = trim(stripslashes($_POST['tel']));
    $message = trim(stripslashes($_POST['message']));
    $captcha = trim(strtolower($_POST['captcha']));

    $error = array();
    if(!$name) $error[] = lang("error_noname");
    if(!$email) $error[] = lang("error_noemail");
    elseif (!is_email($email)) $error[] = lang("error_email_failure");
    if(!$message) $error[] = lang("error_nomessage");
    if ($config->captchaContact) {
      if (!$captcha) $error[] = lang("error_nocaptcha");
      elseif ($_SESSION['captcha'] != $captcha) $error[] = lang("error_wrongcaptcha");
    }
    if(!$error) {
      $mailmess = "Name: $name\nEmail: $email\nTel: $tel\nIP: " . $_SERVER["REMOTE_ADDR"] . "\n\n--\n$message";
      mail($config->contact_mail, strip_tags($config->siteName) . " WebForm", $mailmess,
         "From: ".$name." <".$email.">\r\n"
        ."Reply-To: ".$email."\r\n"
        ."Content-Type: text/plain; charset=utf-8\r\n"
        ."X-Mailer: PHP/" . phpversion(),$config->mailParams);
      if (!$in_site) echo "OK";
      $success = lang("success_mess_sent");
    } else {
      $error = '<div class="alert alert-danger">' . implode("<br />",$error) . '</div>';
      if (!$in_site) echo $error;
    }
}
/****
* Contact [-]
****/


/****
* Report File [+]
****/
if ($action == "abuse") {
    $name = trim(stripslashes($_POST['name']));
    $email = trim(strtolower($_POST['email']));
    $message = trim(stripslashes($_POST['message']));
    $key = trim(stripslashes($_POST['dk']));
    $captcha = trim(strtolower($_POST['captcha']));

    $error = array();
    if(!$name) $error[] = lang("error_noname");
    if(!$email) $error[] = lang("error_noemail");
    elseif (!is_email($email)) $error[] = lang("error_email_failure");
    if(!$message) $error[] = lang("error_nomessage");
    $finfo = getFileInfos($key);
    if (!$finfo) exit(lang("error_file_failure"));
    if ($config->captchaContact) {
      if (!$captcha) $error[] = lang("error_nocaptcha");
      elseif ($_SESSION['captcha'] != $captcha) $error[] = lang("error_wrongcaptcha");
    }
    if(!$error) {
      list($fkey,$delkey) = genFileKeys($finfo->id);
      $mailmess = "Name: $name\nEmail: $email\n\nIP: " . $_SERVER["REMOTE_ADDR"] . "\n" .
        "File Name: " . $finfo->descr . "\nFile Size: " . fsize($finfo->fsize) . "\nDownload URL: " . $config->baseDownloadUrl . $key . ".html\n" .
        "Delete URL: " . $config->baseDeleteUrl . $delkey . ".html\n\n--\n$message";
      mail($config->contact_mail, strip_tags($config->siteName) . " - File reported", $mailmess,
         "From: ".$name." <".$email.">\r\n"
        ."Reply-To: ".$email."\r\n"
        ."Content-Type: text/plain; charset=utf-8\r\n"
        ."X-Mailer: PHP/" . phpversion(),$config->mailParams);
      if (!$in_site) echo "OK";
      $success = lang("success_mess_sent");
    } else {
      $error = '<div class="alert alert-danger">' . implode("<br />",$error) . '</div>';
      if (!$in_site) echo $error;
    }
}
/****
* Report File [-]
****/


/****
* Authenticated Admins only [+]
****/

if ($sfs_auth) {

  //delete file
  if ($action == "delFile") {
    $fid = intval($_REQUEST["fid"]);
    if (!$fid) $error = "Insufficient data provided.";
    if (!$error) {
      $sql = "select * from `" . $config->tablePrefix . "files` where id = '$fid' and uid = '0'";
      $res = dbquery($sql);
      if (!mysqli_num_rows($res)) $error = "File cannot be found.";
    }
    if (!$error) {  
      $row = mysqli_fetch_object($res);
      $sql = "delete from `" . $config->tablePrefix . "files` where id = '$fid' and uid = '0'";
      dbquery($sql);
      $file_path = $config->uploadDir . $row->uid . "/" . $fid;
      if (file_exists($file_path)) xrmdir($file_path);
      $success = "The file was removed successfully.";
    }
    if (!$in_site) exit ($error?$error:"OK");
  }

  //(un)lock file
  if ($action == "handleFileLock") {
    $fid = intval($_REQUEST["fid"]);
    $lockAction = $_REQUEST["lockAction"];
    if (!$fid) $error = "Insufficient data provided.";
    if (!$error) {
      $sql = "select * from `" . $config->tablePrefix . "files` where id = '$fid' and uid = '0'";
      $res = dbquery($sql);
      if (!mysqli_num_rows($res)) $error = "File cannot be found.";
    }
    if (!$error) {
      $sql = "update `" . $config->tablePrefix . "files` set locked = '" . ($lockAction == "lockFile" ? 1 : 0) . "' where id = '$fid' and uid = '0'";
      dbquery($sql);
    }
    if (!$in_site) exit ($error?$error:"OK");
  }

}
/****
* Admins only [-]
****/


/****
* SINGLE: Password protect shared files [+]
****/
if ($action == "pwdProtection") {
  $downloadLink = $_REQUEST["downloadLink"];
  $pwd_protected = $_REQUEST["protection"]=="true"?1:0;

  if (preg_match('|^http://bit\.ly/|',$downloadLink)) $downloadLink = BitlyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://adf\.ly/|',$downloadLink)) $downloadLink = AdflyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://goo\.gl/|',$downloadLink)) $downloadLink = GoogleShortener($downloadLink,"expand");

  preg_match('/^.*\/([0-9a-z]+)\.html$/',$downloadLink,$d_data);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key);
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    if (!$fileInfos->pwd) {
      $pwd = $pwd = genPwd(8,1);
      $sql = "update `" . $config->tablePrefix . "files` set pwd = " . dbquote($pwd) . ", pwd_protected = '$pwd_protected' where id = '" . $fileInfos->id . "'";
      dbquery($sql);
    } else {
      $pwd = $fileInfos->pwd;
      $sql = "update `" . $config->tablePrefix . "files` set pwd_protected = '$pwd_protected' where id = '" . $fileInfos->id . "'";
      dbquery($sql);
    }    
    if ($pwd_protected) $statmess = sprintf(lang("password_protection_ON"),$pwd);
    else $statmess = lang("password_protection_OFF");
  }

  echo json_encode(array("protection" => $pwd_protected, "statmess" => $statmess, "error" => $error));

}
/****
* SINGLE: Password protect shared files [-]
****/

/****
* MULTI: Password protect shared files [+]
****/
if ($action == "pwdProtectionMulti") {
  $u_key = $_REQUEST["u_key"];
  $pwd_protected = $_REQUEST["protection"]=="true"?1:0;
  $fileInfos = getFileInfos($u_key,"upload");
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    if (!$fileInfos->pwd) {
      $pwd = $pwd = genPwd(8,1);
      $sql = "update `" . $config->tablePrefix . "files` set pwd = " . dbquote($pwd) . ", pwd_protected = '$pwd_protected' where u_key = " . dbquote($u_key);
      dbquery($sql);
    } else {
      $pwd = $fileInfos->pwd;
      $sql = "update `" . $config->tablePrefix . "files` set pwd_protected = '$pwd_protected' where u_key = " . dbquote($u_key);
      dbquery($sql);
    }    
    if ($pwd_protected) $statmess = sprintf(lang("password_protection_ON"),$pwd);
    else $statmess = lang("password_protection_OFF");
  }

  echo json_encode(array("protection" => $pwd_protected, "statmess" => $statmess, "error" => $error));

}
/****
* MULTI: Password protect shared files [-]
****/


/****
* SINGLE: set autodelete after x days by uploader [+]
****/
if ($action == "setDelXdays") {
  $downloadLink = $_REQUEST["downloadLink"];
  $delXdays = intval($_REQUEST["delXdays"]);
  if ($delXdays > $config->delDays || $delXdays < -1) $delXdays = -1;

  if (preg_match('|^http://bit\.ly/|',$downloadLink)) $downloadLink = BitlyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://adf\.ly/|',$downloadLink)) $downloadLink = AdflyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://goo\.gl/|',$downloadLink)) $downloadLink = GoogleShortener($downloadLink,"expand");

  preg_match('/^.*\/([0-9a-z]+)\.html$/',$downloadLink,$d_data);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key);
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_days = '$delXdays' where id = '" . $fileInfos->id . "'";
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));

}
/****
* SINGLE: set autodelete after x days by uploader  [-]
****/


/****
* MULTI: set autodelete after x days by uploader [+]
****/
if ($action == "setDelXdaysMulti") {
  $u_key = $_REQUEST["u_key"];
  $delXdays = intval($_REQUEST["delXdays"]);
  if ($delXdays > $config->delDays || $delXdays < -1) $delXdays = -1;
  $fileInfos = getFileInfos($u_key,"upload");
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_days = '$delXdays' where u_key = " . dbquote($u_key);
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));

}
/****
* MULTI: set autodelete after x days by uploader [-]
****/


/****
* SINGLE: set autodelete after x downloads by uploader [+]
****/
if ($action == "setDelXdownloads") {
  $downloadLink = $_REQUEST["downloadLink"];
  $delXdownloads = intval($_REQUEST["delXdownloads"]);

  if (preg_match('|^http://bit\.ly/|',$downloadLink)) $downloadLink = BitlyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://adf\.ly/|',$downloadLink)) $downloadLink = AdflyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://goo\.gl/|',$downloadLink)) $downloadLink = GoogleShortener($downloadLink,"expand");
  
  preg_match('/^.*\/([0-9a-z]+)\.html$/',$downloadLink,$d_data);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key);
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_downloads = '$delXdownloads' where id = '" . $fileInfos->id . "'";
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));
}
/****
* SINGLE: set autodelete after x downloads by uploader  [-]
****/


/****
* MULTI: set autodelete after x downloads by uploader [+]
****/
if ($action == "setDelXdownloadsMulti") {
  $u_key = $_REQUEST["u_key"];
  $delXdownloads = intval($_REQUEST["delXdownloads"]);
  $fileInfos = getFileInfos($u_key,"upload");
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_downloads = '$delXdownloads' where u_key = " . dbquote($u_key);
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));

}
/****
* MULTI: set autodelete after x downloads by uploader [-]
****/


/****
* Password verification [+]
****/
if ($action == "verifyPwd") {
  $error = $verified = false;
  $downloadLink = $_REQUEST["downloadLink"];
  $pwd = $_REQUEST["pwd"];
  preg_match('/^.*\/([0-9a-z]+)\..*$/',$downloadLink,$d_data);
  $downloadLink = print_r($d_data,true);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key,"file");
  if (!$fileInfos) $error = lang("error_file_failure");
  //protected????
  if (!$error && $config->passwordProtection && $fileInfos->pwd_protected && $fileInfos->pwd) {
    $sql = "select id from `" . $config->tablePrefix . "files` where pwd = " . dbquote($pwd) . " and id = '" . $fileInfos->id . "'";
    $res = dbquery($sql);
    if (!mysqli_num_rows($res)) $error = lang("error_wrong_password");
    else $_SESSION["pwdVerified"][$fileInfos->id] = true;
  }
  echo json_encode(array("error" => $error, "verified" => $error?0:1));

}
/****
* Password verification [-]
****/


/****
* Short URL Generator (Bitly/Adfly/Google) [+]
****/
if ($action == "shortenURL") {
  if ($config->shortURLS == "bitly") {
    $error = $bitly_error = array();
    $url = trim($_POST["url"]); //post to prevent of illegal usage
    if (!$url) $error[] = lang("error_shortener_no_url"); //shouldn't happen
    $shortURL = BitlyShortener($url);
    if (!$shortURL) $error[] = lang("error_shortener_failure");
  } elseif ($config->shortURLS == "adfly") {
    $error = $adfly_error = array();
    $url = trim($_POST["url"]); //post to prevent of illegal usage
    if (!$url) $error[] = lang("error_shortener_no_url"); //shouldn't happen
    $shortURL = AdflyShortener($url);
    if (!$shortURL) $error[] = lang("error_shortener_failure");
  } elseif ($config->shortURLS == "google") {
    $error = $google_error = array();
    $url = trim($_POST["url"]); //post to prevent of illegal usage
    if (!$url) $error[] = lang("error_shortener_no_url"); //shouldn't happen
    $shortURL = GoogleShortener($url);
    if (!$shortURL) $error[] = lang("error_shortener_failure");
  }
  echo json_encode(array("error" => $error ? implode("<br />",$error) : false, "shortURL" => $shortURL));
}


/****
* save short description to uploaded file [+]
****/
if ($action == "updateFileDescription") {
  $success = false;
  $downloadLink = $_REQUEST["downloadLink"];
  $descr_long = trim(strip_tags($_REQUEST["fileDescription"]));
  // $descr_long = str_replace(array('&','"'),array("&amp;","&quot;"),trim(strip_tags($_REQUEST["fileDescription"])));

  if (preg_match('|^http://bit\.ly/|',$downloadLink)) $downloadLink = BitlyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://adf\.ly/|',$downloadLink)) $downloadLink = AdflyShortener($downloadLink,"expand");
  elseif (preg_match('|^http://goo\.gl/|',$downloadLink)) $downloadLink = GoogleShortener($downloadLink,"expand");

  preg_match('/^.*\/([0-9a-z]+)\.html$/',$downloadLink,$d_data);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key);
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set descr_long = " . dbquote($descr_long) . " where id = '" . $fileInfos->id . "'";
    dbquery($sql);
    $success = true;
  }
  echo json_encode(array("success" => $success, "error" => $error, "descr_long" => $descr_long));
}
/****
* save short description to uploaded file [-]
****/


/****
* just to validate email (tagsinput) [+]
****/
if ($action == "validateEmail") {
  $email = strtolower(trim($_REQUEST["email"]));
  echo json_encode(array("email" => $email, "isValid" => is_email($email)));
}
/****
* just to validate email (tagsinput) [-]
****/



?>