<?php
error_reporting(E_ALL ^ E_NOTICE);

//List of supported Timezones: http://www.php.net/manual/en/timezones.php
date_default_timezone_set('Europe/Vienna');


$config = new stdClass();

//absolute installation directory
$config->instDir = dirname($_SERVER["SCRIPT_NAME"]);

#replace eventually occurring of backslashes on windows servers with simple slashes
$config->instDir = str_replace("\\","/",$config->instDir);

if ($config->instDir == "/") unset($config->instDir);

//in the installation directory
$config->uploadDir = dirname(__FILE__) . "/data/";

//I suggest to use a directory outside the www-directory's root path
//absolute with trailng slash, smthg. like: /home/mac/www/files.envato.net/data/
//$config->uploadDir = "..........";

$config->projecturl = "http://" . $_SERVER["HTTP_HOST"];

//URLPrefixes...will be calculated autmatically
$config->baseDownloadUrl = $config->projecturl . $config->instDir . "/download/";
$config->baseDeleteUrl = $config->projecturl . $config->instDir . "/delete/";
$config->baseFilesUrl = $config->projecturl . $config->instDir . "/files/";
$config->baseGroupUrl = $config->projecturl . $config->instDir . "/filesgroup/";

//database settings
$config->db_host = "localhost";                             //change!!
$config->db_user = "DBUSER";                               //change!!
$config->db_pass = "DBPASS";                               //change!!
$config->db_name = "DBNAME";                               //change!!
//prefix for the genereated tables
$config->tablePrefix = "SFS_";
//$config->tablePrefix = "";

//database timezone fix, if needed please use values with this syntax +HH:MM or -HH:MM, HH...hours, MM...minutes
//first complete the settings in this config including the correct timezone at the top of this config file
//second call tz.php from you SFS installation directory in your browser to verify the different time outputs and get details to correct if needed
//update value below if there are diffences and suggested - verify with reloading tz.php
$config->db_timezoneCorrection = false;
// $config->db_timezoneCorrection = "-09:00";


//name of your project
$config->siteName = "Simple<wbr />File<wbr />Sharer";

//some mail and web addresses
$config->admin_mail = "admin@yourdomain.com";     		//administrator's mail for Debug messages (DB-Errors, not existing language keys, other issues)
$config->automaileraddr = "no-reply@yourdomain.com";	
$config->contact_mail = "office@yourdomain.com";

//secret key for crypting/enrypting the URLs
//should be changed once and will be used to create an encoded strings for the uploaded files
$config->secretKey = "TGZlAhwB0fGR7Y0L";

//maximum file size in MB
//will be recalculated depending on post_max_size and upload_max_filesize ... see a few lines below
$config->maxFileSize = 15;

/**
 * recalculations of maximum upload size [+]
 **/
$maxFileSizeByte = $config->maxFileSize * 1024 * 1024;

$pms = ini_get("post_max_size");
//considerations for K, M and G values instead of the recommended integer in Byte
//http://php.net/manual/en/ini.core.php#ini.post-max-size
//Kilo
if (preg_match('/k$/i',$pms)) $pms = intval($pms) * 1024;
//mega
elseif (preg_match('/m$/i',$pms)) $pms = intval($pms) * 1024 * 1024;
//giga
elseif (preg_match('/g$/i',$pms)) $pms = intval($pms) * 1024 * 1024 * 1024;
//integer
else $pms = intval($pms);
if ($maxFileSizeByte > $pms) $maxFileSizeByte = $pms - 1024*1024;	//reduce by 1 MB

//considerations for K, M and G values instead of the recommended integer in Byte
//http://php.net/manual/en/ini.core.php#ini.upload-max-filesize
$umf = ini_get("upload_max_filesize");
//Kilo
if (preg_match('/k$/i',$umf)) $umf = intval($umf) * 1024;
//mega
elseif (preg_match('/m$/i',$umf)) $umf = intval($umf) * 1024 * 1024;
//giga
elseif (preg_match('/g$/i',$umf)) $umf = intval($umf) * 1024 * 1024 * 1024;
//integer
else $umf = intval($umf);
if ($maxFileSizeByte > $umf) $maxFileSizeByte = $umf - 1024*1024;	//reduce by 1 MB

$config->maxFileSize = $maxFileSizeByte/1024/1024;
/**
 * recalculations of maximum upload size [-]
 **/

//multiple uploads
//if enabled users will be able to upload more files by drag and drop or file select button
//true ... enabled
//false ... disabled
$config->multiUpload = true;

//maximum number of allowed files to upload at once, has to be a positive integer
$config->maxMultiFiles = 3;

//add files to current upload session after first upload(s) finished??
//if enabled uploaders have the possibility to add files to their current upload session
//true ... enabled
//false ... disabled
// $config->addAnotherFiles = false;
$config->addAnotherFiles = true;

//expiration days (int)
//if set to 0 it's approximately within one day
//if set to -1 files won't be deleted automatically
$config->delDays = 14;

//deletion depending on - if there's a deletion set
//download ... datetime of last download
//upload ..... datetime of upload (default)
$config->delOn = "download";	//download/upload

//enable deletion settings by uploader
//two options (number of downloads, age of uploaded file ... as long as the values are lower than the $config->delDays
//if $config->delDays are set to a value lower 2 the deletion days cannot be set by the uploader 
//true ... enabled
//false ... disabled
$config->delSettingsByUploader = true;
//a list (array) of possible values for the maximum amount of downloads before autodeletion happens
$config->delDownloadsNumbers = array_merge(range(1,10),array(15,20,30,50,100));

//mailheaders
$config->mailHeaders = "From: " . strip_tags($config->siteName) . " <" . $config->automaileraddr . ">\r\n";
$config->mailHeaders .= "X-Sender:  " . strip_tags($config->siteName) . " <" . $config->automaileraddr . ">\r\n"; 
$config->mailHeaders .= "X-Mailer: PHP\r\n";
$config->mailHeaders .= "Return-Path: " . $config->automaileraddr . "\r\n";
$config->mailHeaders .= "Reply-To: " . $config->automaileraddr . "\r\n";
$config->mailHeaders .= "Mime-Version: 1.0\r\n";
$config->mailHeaders .= "Content-Type: text/html; charset=UTF-8\r\n";
$config->mailHeaders .= "Content-Transfer-Encoding: 8bit\r\n";

//additional Mail Parameters - if applicable or needed: http://php.net/manual/en/function.mail.php
// $config->mailParams = "-f " . $config->automaileraddr;
$config->mailParams = false;

//number of (max) possible email recipients for one sending process when sending download information
// $config->maxRcpt = 1;	
$config->maxRcpt = 3;

//direct download protection (false, "IP", "SESSION")
$config->downloadProtection = false;
// $config->downloadProtection = "IP";
// $config->downloadProtection = "SESSION";

//enable password protected files
//if enabled, the downloaderswill be prompted to give the correct password
//the password will be set automatically
$config->passwordProtection = true;	

//extensions denied to upload - has to be an array
$config->extDenied = array("exe");
//$config->extDenied = array();	//no extension denied

//extensions allowed to upload, if set only these extensions are allowed to upload
$config->extAllowed = array();
//$config->extAllowed = array("jpeg","jpg","png","gif"); //just image extensions
//$config->extAllowed = array(); //all extensions

//seconds before download should be possible after calling download link?
//disabled if empty, 0 or false
$config->downloadSeconds = 10;

//auto preview of uploaded images (GD Library required)
//true .... enabled
//false ... disabled
$config->imagePreview = true;
//width and height of the preview image
$config->prevWidth = 400;
$config->prevHeight = 300;

//using XSendFile if apache module is enabled
//possibility to turn of if it's not configured well
//if you got an earlier version of XSendFile (<=0.9) you could add XSendFileAllowAbove On into your .htaccess
//in versions 0.10++ yiu have to set the XSendFilePath in the config of your virtual host (can't be done in the .htaccess)
//more information here: https://tn123.org/mod_xsendfile/
//set this value to true if it works and downloadsize is higher than 0 bytes
//will be disabled if bandwidth throtteling is enabled
//!!!!! you have to uncomment the setenv line in the .htaccess too to enable XSendFile
$config->XSendFile = false;

//DOWNLOAD bandwidth throtteling
//if the value is higher as 0 this value will be used as kilobyte per second
//0, false disables bandwidth throtteling
//the calculation result is not exact and can be different from server to server, you've to play around to get the values for your server,
$config->kbps = 0;

//captcha protection for contact and abuse form?
$config->captchaContact = true;

//enable shortURLs
$config->shortURLS = false; //"bitly","adfly","google" to enable, false to disable, when using google, CURL has to be activated
// $config->shortURLS = "google";
//$config->shortURLS = "bitly";
//$config->shortURLS = "adfly";

//Bitly
$config->bitlyUser = ""; //if you're using bitly: your bitly username, free registering on https://bitly.com/
$config->bitlyKey = ""; //if you're using bitly: your personal bitly API Key, you should get it here when logged in: https://bitly.com/a/your_api_key

//Adfly
$config->adflyUid = ""; //if you're using adfly: your adfly userid, free registering on https://adf.ly - get it from after logged in on https://adf.ly/publisher/tools#tools-api
$config->adflyKey = ""; //if you're using adfly: your personal adfly API Key, you should get it here when logged in: https://adf.ly/publisher/tools#tools-api
$config->adflyAdvertType = "int";	//"banner" or "int", banner is not that aggressive, more on https://adf.ly/publisher/tools#tools-api
//$config->adflyAdvertType = "banner";

//Google
$config->googleApiKey = ""; //if you're using google Url Shortener: GOOGLE Shortener can be activated here: http://code.google.com/apis/console/ -> and Information on generating SERVER API Key can be found here: http://wp2x.com/sign-goo-gl-api-key/

//either curl or allow_url_fopen is needed
$config->connectionMethod = "auto"; //you can use curl, url_fopen or auto -  when using google, CURL has to be activated and will be used


//themes for SFS - default bootstrap 3.3.6 and bootswatch themes
// $config->bootstrapTheme = "default";
$config->bootstrapTheme = "default-themed";
// $config->bootstrapTheme = "cerulean";
// $config->bootstrapTheme = "cosmo";
// $config->bootstrapTheme = "darkly";
// $config->bootstrapTheme = "flatly";
// $config->bootstrapTheme = "journal";
// $config->bootstrapTheme = "lumen";
// $config->bootstrapTheme = "paper";
// $config->bootstrapTheme = "readable";
// $config->bootstrapTheme = "sandstone";
// $config->bootstrapTheme = "simplex";
// $config->bootstrapTheme = "slate";
// $config->bootstrapTheme = "spacelab";
// $config->bootstrapTheme = "superhero";
// $config->bootstrapTheme = "united";
// $config->bootstrapTheme = "yeti";

//these are the automatically set navbar styles, depending on used bootstrap theme
$config->navbar_style =  "navbar-inverse";
if (in_array($config->bootstrapTheme,array("darkly","flatly","cerulean","cosmo","lumen","paper","sandstone","slate","superhero","united"))) $config->navbar_style = "navbar-default";


//Simple File Sharer admin credentials
$config->user = "admin";
$config->pass = "pass";

//only allow Simple File Sharer admin to upload - causing showing a login form on upload page (index.php by default) - but you could rename it :)
$config->adminOnlyUploads = false;			//everyone will be able to upload
// $config->adminOnlyUploads = true;	//only admin will be able to upload

$config->version = "2.27";

$LANG = array();
$faqs = array();


/*****
 * auto setup block [+]
 * can be removed after setup succeeded
 *****/
if (preg_match('~/setup\.php$~',$_SERVER["SCRIPT_NAME"])) $onSetupPage = true;
if (file_exists("setup.php") && !$onSetupPage) {
  header("location: " . $config->instDir . "/setup.php");
  exit;
}
/*****
 * auto setup block [-]
 * can be removed after setup succeeded
 *****/

//reset multiUpload 
// - for Safari on Windows platforms
// - files lower than 2
if ($config->multiUpload && ($config->maxMultiFiles < 2 || (stripos($_SERVER["HTTP_USER_AGENT"],"chrome") === false && preg_match('/windows.*safari/i',$_SERVER["HTTP_USER_AGENT"])))) $config->multiUpload = false;

//drag and dropable? just for displaying informations
$config->dragndrop = true;
if (preg_match_all('/msie\s+(\d+)/i',$_SERVER["HTTP_USER_AGENT"],$ddarr)){
	if (is_numeric($ddarr[1][0]) && $ddarr[1][0] < 10) $config->dragndrop = false;
}

// if ($_REQUEST["sid"]) session_id($_REQUEST["sid"]);
ini_set("session.gc_maxlifetime",84600);
@session_start();
$sfs_auth = $_SESSION["sfs_auth"];

$db = @mysqli_connect($config->db_host, $config->db_user, $config->db_pass) or $error[] = "<b>Database-connection failed</b>,<br>please use the correct data for your database in the config.php.";
if (!$error) {
  @mysqli_select_db($db,$config->db_name) or $error[] = "Database <code>" . $config->db_name . "</code> not found or no rights for access.";
}


//Microsoft Internet Explorer checks and resets [+]
$config->isMSIE = false;
$config->MSIE_version = 0;
if (preg_match('/msie \d{1,2}/i',$_SERVER['HTTP_USER_AGENT']) || preg_match('/trident\/\d.*rv:\d{2}/i',$_SERVER['HTTP_USER_AGENT'])) {
	$config->isMSIE = true;
	preg_match('/msie (\d{1,2})/i',$_SERVER['HTTP_USER_AGENT'],$matches);
	$config->MSIE_version = intval($matches[1]);
	if (!$config->MSIE_version) {
		preg_match('/trident\/\d.*rv:(\d{2})/i',$_SERVER['HTTP_USER_AGENT'],$matches);
		$config->MSIE_version = intval($matches[1]);
	}
	if ($config->MSIE_version < 10) {
		$config->multiUpload = false;
	}
}
//Microsoft Internet Explorer checks and resets [-]



//language parts incl. language switcher
$config->defaultLanguage = "en"; //the default language, if none is selected
//for the language dropdown - if not needed, just set it to false - dropdown itself can be found in includes/header.php
//key => Description, where key is the exact name of the directory inside the lang-folder
// $config->languages = false;
$config->languages = array("en" => "English",
													 "de-Du" => "Deutsch (Du)",	//the familiar German version - you should just use one German version and remove (Sie) or (Du) from the description
													 "de-Sie" => "Deutsch (Sie)",	//the formal German version - you should just use one German version and remove (Sie) or (Du) from the description
													 );

//don't modify lines below
$config->lang = $_SESSION["sfsLang"];
if ($_REQUEST["setLang"] && file_exists("lang/" . $_REQUEST["setLang"] . "/main.lang.php")) {
	$config->lang = $_SESSION["sfsLang"] = $_REQUEST["setLang"];
}
//default language
if (!$config->lang) $config->lang = $config->defaultLanguage;

?>