<?php $__env->startSection('seo_title'); ?>
Cart - <?php echo \App\Options::get_option('seo_title'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid container-white">
	<div class="container add-paddings">
		<div class="col-xs-12 col-xs-offset-0 col-md-8 col-md-offset-2">
			<div class="text-center">
				<h1 class="inner-title"><i class="glyphicon glyphicon-shopping-cart"></i> Your Cart</h1>
				<hr />
			</div>

			<?php if( session()->has('message') AND session()->has('message_type') ): ?>
			<script>
			swal({ title: "<?php echo e(session()->get('message')); ?>", type: "<?php echo e(session()->get('message_type')); ?>" });
			</script>
			<?php endif; ?>

			<table class="table table-hover">
            <thead>
                <tr>
                    <th>Domain</th>
                    <th class="text-center">Price</th>
                    <th>Remove</th>
                </tr>
            </thead>
			<?php if( \Cart::count() ): ?>
			<tbody>
				<?php foreach( $cart as $domain ): ?>
	                <tr>
	                    <td class="text-primary">
	                    	<a href="/info/<?php echo $domain->id; ?>"><?php echo e($domain->name); ?></a>
	                    </td>
	                    <td class="text-center">$<?php echo e(number_format($domain->price)); ?></td>
	                    <td>
	                    	<a href="/cart/remove/<?php echo $domain->rowid; ?>" class="cart-remove">
	                    		<i class="glyphicon glyphicon-remove"></i>
	                    	</a>
	                    </td>
	                </tr>
				<?php endforeach; ?>
				<tr>
                    <td></td>
                    <td><h3>Total</h3></td>
                    <td class="text-right"><h3><strong>$<?php echo e(number_format(\Cart::total())); ?></strong></h3></td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                    	<h4>&nbsp;</h4>
                        <a href="/domains" class="btn btn-default">
                            <span class="glyphicon glyphicon-shopping-cart"></span> Continue Shopping
                        </a>
                    </td>
                    <td>
                    <h4>Checkout</h4> 
                    <a href="/checkout/credit-card" class="btn btn-primary">Credit Card</a>
                    <a href="/checkout/paypal" class="btn btn-warning paypalSubmit">PayPal</a>
                    </td>
                </tr>
                </tbody>
			<?php else: ?>
				<tr>
                    <td></td>
                    <td><h3>Your Cart is Empty</h3></td>
                    <td class="text-right"><h3><strong>$0.00</strong></h3></td>
                </tr>
			<?php endif; ?>
			</table>


		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('inner', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>