<?php $__env->startSection('section_title'); ?>
	<strong>Order Content <a href="/admin" class="btn btn-default btn-xs">Back to Dashboard</a></strong>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_top'); ?>

<div class="row">
	<div class="col-xs-12 col-md-4">
		<div class="box">
			<div class="box-header with-border"><strong>Order Contact</strong></div>
			<div class="box-body">

			<dl>
			<dt>Customer Name:</dt>
				<dd><?php echo e($order->customer); ?></dd>
			<dt>Customer Email:</dt>
			<dd>
				<a href="mailto:<?php echo e($order->email); ?>?subject=Order #<?php echo e($order->id); ?>">
					<?php echo e($order->email); ?>

				</a>
			</dd>
			</dl>

			</div>
		</div>
	</div>
	<div class="col-xs-12 col-md-8">
		<div class="box">
			<div class="box-header with-border"><strong>Order Info</strong></div>
			<div class="box-body">
			
			<div class="row">
				<div class="col-xs-6">
					<dl>
					<dt>Order Status</dt>
						<dd><?php echo e($order->order_status); ?></dd>
					<dt>Total</dt>
						<dd>$<?php echo e(number_format( $order->total, 0 )); ?></dd>
					</dl>
				</div><!-- ./col-xs-6 -->
				<div class="col-xs-6">
					<dl>
					<dt>Order Date</dt>
						<dd><?php echo e(date( 'jS F Y H:i', strtotime( $order->order_date ) )); ?></dd>
					<dt>Payment Type</dt>
						<dd><?php echo e($order->payment_type); ?></dd>
					</dl>
				</div><!-- ./col-xs-6 -->
			</div><!-- ./row -->

			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('section_body'); ?>

	<table class="table dataTable">
	<thead>
		<tr>
			<th>Domain ID</th>
			<th>Domain Name</th>
			<th>Price</th>
		</tr>
	</thead>
	<tbody>
	<?php foreach( $order_content as $o ): ?>

	<tr>
		<td><?php echo $o->id; ?></td>
		<td><?php echo e($o->name); ?></td>
		<td>$<?php echo e(number_format($o->price,0)); ?></td>
	</tr>

	<?php endforeach; ?>
	</tbody>
	</table>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.base', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>