<?php echo $__env->make('partials/header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<div class="homepage-img">
<div class="container">
	<div class="col-xs-4">
		<h1 class="brand"><a href="/"><?php echo App\Options::brand_name(); ?></a></h1>
	</div><!-- ./col-xs-4 -->

	<div class="col-xs-8">
		<ul class="nav navbar-nav navtop">
			<?php foreach( $navi as $nav_item ): ?>
	          <li><a href="<?php echo e($nav_item->url); ?>" target="<?php echo e($nav_item->target); ?>"><?php echo e($nav_item->title); ?></a></li>
	        <?php endforeach; ?>
		</ul>
	</div><!-- ./col-xs-8 -->

	<div class="col-xs-12 col-home">

		<h1><?php echo e(\App\Options::get_option( 'homepage_headline' )); ?></h1>

		<?php echo nl2br( \App\Options::get_option( 'homepage_intro' ) ); ?>

		<br />

		<a href="/domains" class="btn btn-primary btn-lg call-to-action">DOMAINS FOR SALE</a>
	</div><!-- ./col-xs-12 .col-home -->

</div><!-- ./container -->
</div><!-- ./homepage-img -->

<div class="container add-paddings">
		<div class="text-center">
			<h1>Currently Available Domains for Sale</h1>
			Pick the desired domains you want to purchase and add them to your cart. 
			When you're ready simply checkout!
		</div><!-- ./text-center -->

		<br/><br/>

		<div class="row">
		<?php $i = 0; ?>
		<?php foreach( $domains as $d ): ?>
			<?php $i++; ?>
			<div class="col-xs-12 col-md-4">
			<div class="col-listings">
				<h3 class="pull-left"><a href="/info/<?php echo $d->id; ?>"><?php echo e($d->domain); ?></a></h3>
				<div class="domain-age">
					<i class="glyphicon glyphicon-calendar"></i> 
					<?php if( $d->domain_age != 0 ): ?> 
						<?php echo e($d->domain_age); ?> Years Old Domain
					<?php else: ?> 
						Less than 1 Year Old
					<?php endif; ?>
				</div>

				<hr style="clear:both;" />
				
				<p>
				<?php echo e($d->short_description); ?>

				</p>

				<hr />

				<div class="pull-left">
					<h4 class="domain-price">$<?php echo e(number_format($d->pricing)); ?></h4>
				</div>
				
				<div class="pull-right">
					<a href="/ajax/add-to-cart/<?php echo $d->id; ?>" class="add-to-cart">
						<i class="glyphicon glyphicon-shopping-cart"></i> BUY
					</a>
					<a href="/info/<?php echo $d->id; ?>" class="more-info">
						<i class="glyphicon glyphicon-list"></i> INFO
					</a>
				</div>

				<div style="clear:both;"></div>


			</div><!-- ./col-listings -->
			</div><!-- .col-xs-6 .col-md-4 -->
			<?php if( $i %3 == 0): ?> 
			<div style="clear:both;"></div>
			<?php endif; ?>
		<?php endforeach; ?>
		</div><!-- ./row -->
</div><!-- ./container .add-paddings -->

<div class="container">

<div class="col-xs-12 col-xs-offset-0 col-md-4 col-md-offset-4">
	<a href="/domains" class="btn btn-default btn-block">
		<i class="glyphicon glyphicon-menu-right"></i> VIEW ALL DOMAINS
	</a>
</div>

<br /><br /><br /><br />

</div><!-- ./container -->

<div class="container-fluid container-white">
<div class="container footer">
	<div class="text-center">
		<h1 class="brand brand-footer"><a name="about">About.<span class="sub-brand">Us</span></a></h1>
	</div>

		Lorem ipsum dolor sit amet, consectetur adipisicing elit. Temporibus architecto similique iste corporis dignissimos perspiciatis sint, qui inventore fuga totam? Necessitatibus veniam id vel repellat, at perferendis possimus, quis quidem.

		<br /><br />

		Lorem ipsum dolor sit amet, consectetur adipisicing elit. Temporibus architecto similique iste corporis dignissimos perspiciatis sint, qui inventore fuga totam? Necessitatibus veniam id vel repellat, at perferendis possimus, quis quidem.

</div>
</div><!-- ./about -->

<?php echo $__env->make('partials/footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>