<?php $__env->startSection('section_title'); ?>
	<strong>Domains Overview</strong>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('section_body'); ?>

<a class="btn btn-primary" href="/admin/add-domain">Add New Domain</a>
<hr />

<?php if($domains): ?>
	<table class="table table-striped table-bordered table-responsive dataTable">
	<thead>
	<tr>
		<th>ID</th>
		<th>Domain</th>
		<th>Registrar</th>
		<th>Age</th>
		<th>Price</th>
		<th>Status</th>
		<th>Actions</th>
	</tr>
	</thead>
	<tbody>
		<?php foreach( $domains as $d ): ?>
		<tr>
			<td>
				<?php echo $d->id; ?>

			</td>
			<td>
				<?php echo e($d->domain); ?>

			</td>
			<td>
				<?php echo e($d->registrar); ?>

			</td>
			<td>
				<?php echo e($d->domain_age); ?>

			</td>
			<td>
				$<?php echo e(number_format($d->pricing, 0)); ?>

			</td>
			<td>
				<?php echo e($d->domain_status); ?>

			</td>
			<td>
				 <div class="btn-group">
				 	<a class="btn btn-primary btn-xs" href="/admin/manage-domain/<?php echo $d->id; ?>">
				 		<i class="glyphicon glyphicon-pencil"></i>
				 	</a>
    				<a href="/admin/domains?remove=<?php echo $d->id; ?>" onclick="return confirm('Are you sure you want to remove this domain from database?');" class="btn btn-danger btn-xs">
						<i class="glyphicon glyphicon-remove"></i>
					</a>
				</div>
			</td>
		</tr>
		<?php endforeach; ?>
	</tbody>
	</table>
<?php else: ?>
	No domains in database.
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.base', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>