<?php $__env->startSection('section_title'); ?>
	<strong>Orders Overview</strong>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_top'); ?>
<div class="row">
<div class="col-lg-3 col-xs-6">
  <!-- small box -->
  <div class="small-box bg-yellow">
    <div class="inner">
      <h3><?php echo e($mtd_count); ?></h3>
      <p>Month to Date Orders</p>
    </div>
    <div class="icon">
      <i class="ion ion-pie-graph"></i>
    </div>
  </div>
</div>
<div class="col-lg-3 col-xs-6">
  <!-- small box -->
  <div class="small-box bg-red">
    <div class="inner">
      <h3>$<?php echo e(number_format( $earnings_mtd, 0)); ?></h3>
      <p>Month to Date Earnings</p>
    </div>
    <div class="icon">
      <i class="fa fa-money"></i>
    </div>
  </div>
</div>

<div class="col-lg-3 col-xs-6">
  <!-- small box -->
  <div class="small-box bg-aqua">
    <div class="inner">
      <h3><?php echo e($all_time_sales); ?></h3>
      <p>Total Orders</p>
    </div>
    <div class="icon">
      <i class="fa fa-shopping-cart"></i>
    </div>
  </div>
</div>
<div class="col-lg-3 col-xs-6">
  <!-- small box -->
  <div class="small-box bg-green">
    <div class="inner">
      <h3>$<?php echo e(number_format( $all_time_earnings ,0)); ?></h3>
      <p>Total Earnings</p>
    </div>
    <div class="icon">
      <i class="fa fa-money"></i>
    </div>
  </div>
</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<div class="box">
			<div class="box-header with-border"><strong>Past 30 Days</strong></div>
			<div class="box-body">
				<!-- LINE CHART -->
				<div class="chart-responsive">
				  <div class="chart" id="past-30-days" style="height: 300px;"></div>

				  <script>
				  new Morris.Line({
					  // ID of the element in which to draw the chart.
					  element: 'past-30-days',
					  // Chart data records -- each entry in this array corresponds to a point on
					  // the chart.
					  data: [
					  	<?php if( $earnings_30_days ): ?>
					  		<?php foreach( $earnings_30_days as $date => $earnings ): ?>
								{ date: '<?php echo e($date); ?>', value: <?php echo e($earnings); ?> },
						    <?php endforeach; ?>
					    <?php else: ?>
					    	{ date: '<?php echo e(date( 'jS F Y' )); ?>', value: 0 }
					    <?php endif; ?>
					  ],
					  // The name of the data record attribute that contains x-values.
					  xkey: 'date',
					  // A list of names of data record attributes that contain y-values.
					  ykeys: ['value'],
					  // Labels for the ykeys -- will be displayed when you hover over the
					  // chart.
					  labels: ['Earnings']
				  });
				  </script>

				</div>
			</div>		
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('section_body'); ?>
<?php if($orders): ?>
	<table class="table table-striped table-bordered table-responsive dataTable">
	<thead>
	<tr>
		<th>ID</th>
		<th>Customer</th>
		<th>Email</th>
		<th>Total</th>
		<th>Date</th>
		<th>Status</th>
		<th>Actions</th>
	</tr>
	</thead>
	<tbody>
		<?php foreach( $orders as $o ): ?>
		<tr>
			<td>
				<a href="/admin/view-order/<?php echo $o->id; ?>"><?php echo $o->id; ?></a>
			</td>
			<td>
				<a href="/admin/view-order/<?php echo $o->id; ?>"><?php echo e($o->customer); ?></a>
			</td>
			<td>
				<?php echo e($o->email); ?>

			</td>
			<td>
				$<?php echo e(number_format($o->total, 0)); ?>

			</td>
			<td>
				<?php echo e(date('jS F Y', strtotime($o->order_date) )); ?>

				<br />
				<?php echo e(date('H:i', strtotime($o->order_date) )); ?>

			</td>
			<td>
				<?php echo e($o->order_status); ?> <br />
				<small><em>via</em> <?php echo e($o->payment_type); ?></small>
			</td>
			<td>
				 <div class="btn-group">
				 	<a class="btn btn-warning btn-xs" href="/admin/view-order/<?php echo $o->id; ?>">
				 		<i class="glyphicon glyphicon-eye-open"></i>
				 	</a>
    				<a href="/admin?remove=<?php echo $o->id; ?>" onclick="return confirm('Are you sure you want to remove this order from database?');" class="btn btn-danger btn-xs">
						<i class="glyphicon glyphicon-remove"></i>
					</a>
				</div>
			</td>
		</tr>
		<?php endforeach; ?>
	</tbody>
	</table>
<?php else: ?>
	No domains in database.
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.base', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>