@extends('inner')

@section('seo_title')
{{ ucfirst($domain->domain) }} - {!! \App\Options::get_option('seo_title') !!}
@endsection

@section('content')
<div class="container-fluid container-white">
<div class="container add-paddings">
	
	<div class="col-xs-12 col-xs-offset-0 col-md-8 col-md-offset-2">
		<div class="row">
		<div class="col-xs-8">
			<h1 class="inner-title">{{ $domain->domain }}</h1>
			@if( $domain->domain_age != 0 ) 
				- {{ $domain->domain_age }} Years Old Domain - 
			@else 
				- Less than 1 Year Old  -
			@endif
		</div>
		<div class="col-xs-4">
			<a href="/ajax/add-to-cart/{!! $domain->id !!}" class="add-to-cart add-to-cart-inner">
				<i class="glyphicon glyphicon-shopping-cart"></i> Buy Now <br /> ${{ number_format($domain->pricing, 0) }}
			</a>
		</div>
		</div>
		
		<br />

		<table class="table table-bordered">
		<tr>
			<td class="theading">Registered On</td>
			<td>{{ date('jS F Y', strtotime($domain->reg_date) ) }}</td>

			<td class="theading">Expires On</td>
			<td>{{ date('jS F Y', strtotime($domain->exp_date) ) }}</td>

			<td class="theading">Registrar</td>
			<td>{{ $domain->registrar }}</td>
		</tr>
		</table>

		{!! $domain->description !!}
		
	</div><!--./cols -->

</div><!-- ./container -->
</div><!-- ./container-white -->
@endsection