@extends('inner')

@section('seo_title')
Cart - {!! \App\Options::get_option('seo_title') !!}
@endsection

@section('content')
<div class="container-fluid container-white">
	<div class="container add-paddings">
		<div class="col-xs-12 col-xs-offset-0 col-md-8 col-md-offset-2">
			<div class="text-center">
				<h1 class="inner-title"><i class="glyphicon glyphicon-shopping-cart"></i> Your Cart</h1>
				<hr />
			</div>

			@if( session()->has('message') AND session()->has('message_type') )
			<script>
			swal({ title: "{{ session()->get('message')}}", type: "{{ session()->get('message_type') }}" });
			</script>
			@endif

			<table class="table table-hover">
            <thead>
                <tr>
                    <th>Domain</th>
                    <th class="text-center">Price</th>
                    <th>Remove</th>
                </tr>
            </thead>
			@if( \Cart::count() )
			<tbody>
				@foreach( $cart as $domain )
	                <tr>
	                    <td class="text-primary">
	                    	<a href="/info/{!! $domain->id !!}">{{ $domain->name }}</a>
	                    </td>
	                    <td class="text-center">${{ number_format($domain->price)}}</td>
	                    <td>
	                    	<a href="/cart/remove/{!! $domain->rowid !!}" class="cart-remove">
	                    		<i class="glyphicon glyphicon-remove"></i>
	                    	</a>
	                    </td>
	                </tr>
				@endforeach
				<tr>
                    <td></td>
                    <td><h3>Total</h3></td>
                    <td class="text-right"><h3><strong>${{ number_format(\Cart::total()) }}</strong></h3></td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                    	<h4>&nbsp;</h4>
                        <a href="/domains" class="btn btn-default">
                            <span class="glyphicon glyphicon-shopping-cart"></span> Continue Shopping
                        </a>
                    </td>
                    <td>
                    <h4>Checkout</h4> 
                    <a href="/checkout/credit-card" class="btn btn-primary">Credit Card</a>
                    <a href="/checkout/paypal" class="btn btn-warning paypalSubmit">PayPal</a>
                    </td>
                </tr>
                </tbody>
			@else
				<tr>
                    <td></td>
                    <td><h3>Your Cart is Empty</h3></td>
                    <td class="text-right"><h3><strong>$0.00</strong></h3></td>
                </tr>
			@endif
			</table>


		</div>
	</div>
</div>
@endsection