@extends('inner')

@section('seo_title')
Domains List - {!! \App\Options::get_option('seo_title') !!}
@endsection

@section('content')

<div class="container add-paddings">
	<div class="text-center">
		<h2>Currently available domains for sale</h2>
	</div>	
		<br />
		
		<div class="row">
			<div class="col-xs-12 col-md-8 col-xs-offset-0 col-md-offset-2 col-filters col-filter-active col-filter-extension">
				@foreach( $tlds as $tld )
				<a href="#{{ $tld }}" class="btn btn-default btn-filter btn-tld" data-filter-tld="{{ $tld }}">.{{ $tld }}</a>
				@endforeach
			</div>
			<div class="col-xs-12 col-md-8 col-xs-offset-0 col-md-offset-2 col-filters col-filter-price">
				<a href="#upto1k" class="btn btn-default btn-filter btn-price" data-filter-price="999">Up To 1K</a>
				<a href="#1k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="1000">1K+</a>
				<a href="#2k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="2000">2K+</a>
				<a href="#3k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="3000">3K+</a>
				<a href="#4k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="4000">4K+</a>
				<a href="#5k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="5000">5K+</a>
				<a href="#10k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="10000">10K+</a>
				<a href="#20k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="20000">20K+</a>
				<a href="#30k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="30000">30K+</a>
				<a href="#50k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="50000">50K+</a>
				<a href="#100k-plus" class="btn btn-default btn-filter btn-price" data-filter-price="100000">100K+</a>
			</div>
			<div class="col-xs-12 col-md-8 col-xs-offset-0 col-md-offset-2 col-filters col-filter-age">
				<a href="#under-1-yr" class="btn btn-default btn-filter btn-age" data-filter-age="0">
					Less than 1 Year
				</a>
				<a href="#1-plus-yr" class="btn btn-default btn-filter btn-age" data-filter-age="1">
					1+ Year
				</a>
				<a href="#2-plus-yr" class="btn btn-default btn-filter btn-age" data-filter-age="2">
					2+ Years
				</a>
				<a href="#3-plus-yr" class="btn btn-default btn-filter btn-age" data-filter-age="3">
					3+ Years
				</a>
				<a href="#4-plus-yr" class="btn btn-default btn-filter btn-age" data-filter-age="4">
					4+ Years
				</a>
				<a href="#5-plus-yr" class="btn btn-default btn-filter btn-age" data-filter-age="5">
					5+ Years
				</a>
				<a href="#10-plus-yr" class="btn btn-default btn-filter btn-age" data-filter-age="10">
					10+ Years
				</a>
				
			</div>
			<div class="col-xs-12 col-md-8 col-xs-offset-0 col-md-offset-2 col-filters col-filter-digits">
				<a href="#1-character" class="btn btn-default btn-filter btn-character" data-filter-character="1">
					1 character
				</a>
				<a href="#2-character" class="btn btn-default btn-filter btn-character" data-filter-character="2">
					2 characters
				</a>
				<a href="#3-character" class="btn btn-default btn-filter btn-character" data-filter-character="3">
					3 characters
				</a>
				<a href="#4-character" class="btn btn-default btn-filter btn-character" data-filter-character="4">
					4 characters
				</a>
				<a href="#5-character" class="btn btn-default btn-filter btn-character" data-filter-character="5">
					5 characters
				</a>
				<a href="#6-character" class="btn btn-default btn-filter btn-character" data-filter-character="6">
					6 characters
				</a>
				<a href="#7-character" class="btn btn-default btn-filter btn-character" data-filter-character="7">
					7 characters
				</a>
				<a href="#8-character" class="btn btn-default btn-filter btn-character" data-filter-character="8">
					8 characters
				</a>
				<a href="#9-character" class="btn btn-default btn-filter btn-character" data-filter-character="9">
					9 characters
				</a>
				<a href="#10-character" class="btn btn-default btn-filter btn-character" data-filter-character="10">
					10+ characters
				</a>
				
			</div>
			<div class="col-xs-12 col-md-2">
			
			<!-- Filter Switcher -->
			<div class="btn-group">
			  <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
			    <i class="glyphicon glyphicon-list"></i> Filter By <span class="caret"></span>
			  </button>
			  <ul class="dropdown-menu">
			    <li><a href="#filter-ext" class="filter-switcher" data-filter="extension">TLD Extension</a></li>
			    <li><a href="#filter-digits" class="filter-switcher" data-filter="digits">Characters Count</a></li>
			    <li><a href="#filter-price" class="filter-switcher" data-filter="price">Pricing</a></li>
			    <li><a href="#filter-age" class="filter-switcher" data-filter="age">Age</a></li>
			  </ul>
			</div>	
			
			</div>
		</div>

		<hr />

		<div class="row">
		@foreach( $domains as $d )
			<div class="col-xs-12 col-md-4 col-listing" data-age="{!! $d->domain_age !!}" data-tld="{!! pathinfo( $d->domain, PATHINFO_EXTENSION ) !!}" data-price="{{ $d->pricing }}" data-character-count="{!! \App\Domain::getCharacterCount( $d->domain ) !!}">
			<div class="col-listings">
				<h3 class="pull-left"><a href="/info/{!! $d->id !!}">{{ $d->domain }}</a></h3>
				<div class="domain-age">
					<i class="glyphicon glyphicon-calendar"></i>
					@if( $d->domain_age != 0 ) 
						{{ $d->domain_age }} Years Old Domain 
					@else 
						Less than 1 Year Old
					@endif
				</div>

				<hr style="clear:both;" />
				
				<p>
				{{ $d->short_description }}
				</p>

				<hr />

				<div class="pull-left">
					<h4 class="domain-price">${{ number_format($d->pricing) }}</h4>
				</div>
				
				<div class="pull-right">
					<a href="/ajax/add-to-cart/{!! $d->id !!}" class="add-to-cart">
						<i class="glyphicon glyphicon-shopping-cart"></i> BUY
					</a>
					<a href="/info/{!! $d->id !!}" class="more-info">
						<i class="glyphicon glyphicon-list"></i> INFO
					</a>
				</div>
			</div><!-- ./col-listings -->
			</div><!-- .col-xs-6 .col-md-4 -->

		@endforeach
		</div><!-- ./row -->
</div><!-- .container .add-paddings -->

@endsection