@extends('admin.base')

@section('section_title')
<strong>Manage Domain: {{ $d->domain }}</strong>
<br /><br />
<a href="/admin/domains" class="btn btn-default btn-xs">Back to Domains Overview</a>
@endsection

@section('section_body')
<form method="POST">
{{ csrf_field() }}

<div class="col-xs-12 col-md-12">
<label>Domain Name</label><br />
<input type="text" name="domain" value="{{ $d->domain }}" class="form-control"><br />
</div>

<div class="col-xs-12 col-md-6">
<label>Status</label><br />
<select name="domain_status" class="form-control">
	<option @if($d->domain_status == 'AVAILABLE') selected @endif>AVAILABLE</option>
	<option @if($d->domain_status == 'SOLD') selected @endif>SOLD</option>
</select>
<br />
</div>

<div class="col-xs-12 col-md-6">
<label>Price</label><br />
<input type="text" name="pricing" value="{{ $d->pricing }}" class="form-control"><br />
</div>

<div class="col-xs-12 col-md-4">
<label>Registrar</label><br />
<input type="text" name="registrar" value="{{ $d->registrar }}" class="form-control"><br />
</div>

<div class="col-xs-12 col-md-4">
<label>Registration Date (day-month-year)</label><br />
<input type="text" name="reg_date" value="{{ $d->reg_date }}" class="form-control"><br />
</div>

<div class="col-xs-12 col-md-4">
<label>Expiration Date (day-month-year)</label><br />
<input type="text" name="exp_date" value="{{ $d->exp_date }}" class="form-control"><br />
</div>

<div class="col-xs-12 col-md-12">
<label>Short description</label><br />
<textarea name="short_description" class="form-control" rows="4">{{ $d->short_description }}</textarea><br />
</div>

<div class="col-xs-12 col-md-12">
<label>Full description</label><br />
<textarea name="description" class="form-control textarea" rows="8">{{ $d->description }}</textarea>
<br />
</div>

<div class="col-xs-12 col-md-6 col-xs-offset-0 col-md-offset-3">
<input type="submit" name="sb" value="Save" class="btn btn-primary btn-block">
</div>

</form>

@endsection
