@extends('admin.base')

@section('section_title')
<strong>General Configuration</strong>
@endsection

@section('section_body')
Here you can setup general aspects of your website.
@endsection

@section('extra_bottom')
<div class="row">
	<form method="POST" enctype="multipart/form-data">
	{!! csrf_field() !!}
	<div class="col-xs-12 col-md-6">
		<div class="box">
			<div class="box-header with-border"><strong>SEO</strong></div>
			<div class="box-body">
			<dl>
			<dt>SEO Title Tag</dt>
			<dd><input type="text" name="seo_title" value="{{ App\Options::get_option('seo_title') }}" class="form-control"></dd>
			<dt>SEO Description Tag</dt>
			<dd><input type="text" name="seo_desc" value="{{ App\Options::get_option('seo_desc') }}" class="form-control"></dd>
			<dt>SEO Keywords</dt>
			<dd><input type="text" name="seo_keys" value="{{ App\Options::get_option('seo_keys') }}" class="form-control"></dd>
			<dt>Site Title (appears in navigation bar)</dt>
			<dd><input type="text" name="site_title" value="{{ App\Options::get_option('site_title') }}" class="form-control"></dd>
			<dt>Homepage Header Image</dt>
			<dd><input type="file" name="homepage_header_image" class="form-control"></dd>
			<dt>Extra Javascript (added before closing {{ '<head>' }} tag. Ie. Analytics,etc.)</dt>
			<dd><textarea name="extra_js" class="form-control" rows="5">{{ App\Options::get_option('extra_js') }}</textarea></dd>
			<dt>Contact Email</dt>
				<dd>
					<input type="text" name="contact_email" value="{{ App\Options::get_option('contact_email') }}" class="form-control">
				</dd>
			</dl>
			</div>
		</div>
	</div><!-- col-md<->xs -->

	<div class="col-xs-12 col-md-6">
		<div class="box">
			<div class="box-header with-border"><strong>Homepage Headlines</strong></div>
			<div class="box-body">
			<dl>
				<dt>Homepage Headline</dt>
				<dd>
					<input type="text" name="homepage_headline" value="{{ App\Options::get_option('homepage_headline') }}" class="form-control">
				</dd>
				<dt>Homepage Introductory Text</dt>
				<dd>
					<textarea name="homepage_intro" class="form-control" rows="5">{!! App\Options::get_option('homepage_intro') !!}</textarea>
				</dd>
			</dl>
			</div><!-- BODY FONT_COLOR -->
		</div>
	</div><!-- color setup -->

	<div class="col-xs-6">
		<input type="submit" name="sb_settings" value="Save" class="btn btn-block btn-primary">	
	</div>

	</form>

</div><!-- ./row -->
@endsection