$(document).ready(function() {



	var $form = $('#payment-form');


	$form.submit(function(event) {
	    // Disable the submit button to prevent repeated clicks:
	    $form.find('.submit').prop('disabled', true);

	    // Request a token from Stripe:
	    Stripe.createToken({
	        number: $('.card-number').val(),
	        cvc: $('.card-cvc').val(),
	        exp_month: $('.card-expiry-month').val(),
	        exp_year: $('.card-expiry-year').val()
      }, stripeResponseHandler);
	    //Stripe.card.createToken($form, stripeResponseHandler);

	    // Prevent the form from being submitted:
	    return false;
	});

	function stripeResponseHandler(status, response) {
	  var $form = $('#payment-form');

	  if (response.error) {
	    // Show the errors on the form

	    //$form.find('.payment-errors').text(response.error.message);
	    $form.find('button').prop('disabled', false);

	    sweetAlert("Oops...", response.error.message, "error");

	  } else {

	    // response contains id and card, which contains additional card details
	    var token = response.id;
	    var customer = $('.name-on-card').val();
	    var email = $('.email-address').val();

	    // append values we need!
	    $form.append($('<input type="hidden" name="stripeToken" />').val(token));
	    $form.append($('<input type="hidden" name="customer" />').val(customer));
	    $form.append($('<input type="hidden" name="email" />').val(email));

	    // and submit
	    $form.get(0).submit();
	  }

	}

	
	// add to cart buttons ( home + inner )
	$('.add-to-cart, .add-to-cart-inner').click(function(ev) {

		ev.preventDefault();

		var uri = $(this).attr('href');

		$.get( uri, function( r ) {

			swal({
				title: "Domain added to cart!",   
				text: r + "You can Checkout or Continue Shopping",   
				showCancelButton: true,   
				confirmButtonColor: "#DD6B55",   
				confirmButtonText: "Checkout",   
				cancelButtonText: "Continue Shopping",   
				closeOnConfirm: true,   
				closeOnCancel: true, 
				imageUrl: '/resources/assets/images/cart.png' ,
				html: true
			}, function(isConfirm) {   
				if (isConfirm) {     
					document.location.href = '/checkout';
				} 
			});

		}).fail(function(xhr, status, error) {
		    swal({ title: 'woops', text: error, type: "warning",  }); // or whatever
		});

		return false;

	});


	// remove from cart
	$('.cart-remove').click(function(ev) {
		ev.preventDefault();

		var removeUri = $(this).attr('href');

		swal({ 
			title: "Are you sure?", 
			type: "warning",   
			showCancelButton: true,   
			confirmButtonColor: "#DD6B55",   
			confirmButtonText: "Yes, remove it!",   
			closeOnConfirm: false 
		}, function(){   
			document.location.href = removeUri;
		});

		return false;
	});


	$('.paypalSubmit').click(function() {
		swal({   
			title: "Redirecting you to PayPal...", 
			text: 'It takes just a few seconds.',
			timer: 10000,   
			showConfirmButton: false, 
			imageUrl: '/resources/assets/images/ajax.gif'
		});
	});

	$('.filter-switcher').click(function(ev) {
		//ev.preventDefault();

		var filterType = $(this).data('filter');

		$('.col-filters').hide();
		$('.col-filter-' + filterType).show();
		$('.col-filter-' + filterType).addClass('.col-filter-active');

		//return false;
	});

	$('.btn-age').click(function(ev) {
		ev.preventDefault();

		var seekAge = parseInt($(this).data('filter-age'));

		$('.col-listing').each(function() {

			if( seekAge == 0 ) {
				if( $(this).data('age') > seekAge ) {
					$(this).hide('slow');
				} else {
					$(this).show('slow');
				}
			}else{
				if( $(this).data('age') < seekAge ) {
					$(this).hide('slow');
				} else {
					$(this).show('slow');
				}
			}

		});

		return false;
	});

	$('.btn-tld').click(function(ev) {
		ev.preventDefault();

		var seekTld = $(this).data('filter-tld');

		$('.col-listing').each(function() {
			if( $(this).data('tld') == seekTld ) {
				$(this).show('slow');
			} else {
				$(this).hide('slow');
			}
		});

		return false;
	});

	$('.btn-price').click(function(ev) {
		ev.preventDefault();

		var seekPrice = parseInt($(this).data('filter-price'));

		$('.col-listing').each(function() {

			if( seekPrice == 999 ) {
				if( $(this).data('price') < 1000 ) {
					$(this).show('slow');
				}else{
					$(this).hide('slow');
				}
			}else{
				if( $(this).data('price') >= seekPrice ) {
					$(this).show('slow');
				} else {
					$(this).hide('slow');
				}
			}
		});

		return false;
	});

	$('.btn-character').click(function(ev) {
		ev.preventDefault();

		var seekCount = parseInt($(this).data('filter-character'));

		$('.col-listing').each(function() {
			if( $(this).data('character-count') == seekCount ) {
				$(this).show('slow');
			} else {
				$(this).hide('slow');
			}
		});

		return false;
	});



});