<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Domains extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('domains', function (Blueprint $table) {
            $table->increments('id');
            $table->string('domain');
            $table->integer('pricing');
            $table->string('registrar');
            $table->string('reg_date');
            $table->string('exp_date');
            $table->integer('domain_age');
            $table->string('short_description');
            $table->text('description');
            $table->enum('domain_status', ['AVAILABLE', 'SOLD']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('domains');
    }
}
