<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        // pass navigation to all views
        $navi_order = \App\Options::get_option('navi_order');

        if( !empty($navi_order) )
            $navi = \App\Navi::orderByRaw("FIELD(id, $navi_order)")->get();
        else
            $navi = [];

        view()->share('navi', $navi);

    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
